/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.client;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import org.reldb.rel.client.Heading;
import org.reldb.rel.client.InvalidValueException;
import org.reldb.rel.client.NullTuple;
import org.reldb.rel.client.Tuple;
import org.reldb.rel.client.Value;

public class Tuples
extends Value
implements Iterable<Tuple> {
    private ArrayBlockingQueue<Tuple> tuples = new ArrayBlockingQueue(250);
    private Heading heading = null;
    private String typeName = null;
    private LinkedList<Tuple> cache = null;
    private boolean done = false;

    public Tuples(String typeName) {
        this.typeName = typeName;
    }

    public Tuples(Heading heading) {
        this.heading = heading;
    }

    void insertNullTuple() {
        this.addValue(new NullTuple(), false);
    }

    @Override
    void addValue(Value value, boolean b) {
        try {
            this.tuples.put((Tuple)value);
        }
        catch (InterruptedException e) {
            System.out.println("Tuples: tuple write interrupted.");
        }
    }

    public Heading getHeading() {
        return this.heading;
    }

    @Override
    public int toInt() throws InvalidValueException, NumberFormatException {
        throw new InvalidValueException("Tuples can't be cast to int.");
    }

    @Override
    public long toLong() throws InvalidValueException, NumberFormatException {
        throw new InvalidValueException("Tuples can't be cast to long.");
    }

    @Override
    public double toDouble() throws InvalidValueException, NumberFormatException {
        throw new InvalidValueException("Tuples can't be cast to double.");
    }

    @Override
    public float toFloat() throws InvalidValueException, NumberFormatException {
        throw new InvalidValueException("Tuples can't be cast to float.");
    }

    @Override
    public boolean toBoolean() throws InvalidValueException {
        throw new InvalidValueException("Tuples can't be cast to boolean.");
    }

    @Override
    public String toString(int depth) {
        String lines = "";
        for (Tuple tuple : this) {
            lines = String.valueOf(lines) + (lines.length() > 0 ? ",\n" : "") + "\t" + tuple.toString(depth + 1);
        }
        return (this.heading != null ? this.heading : this.typeName) + " {\n" + lines + "}";
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public Iterator<Tuple> iterator() {
        if (this.cache != null) {
            return this.cache.iterator();
        }
        this.cache = new LinkedList();
        return new Iterator<Tuple>(){
            Tuple tuple = null;

            @Override
            public boolean hasNext() {
                if (Tuples.this.done) {
                    return false;
                }
                if (this.tuple == null) {
                    do {
                        try {
                            this.tuple = (Tuple)Tuples.this.tuples.take();
                        }
                        catch (InterruptedException e) {
                            return false;
                        }
                    } while (this.tuple == null);
                    if (this.tuple.isNull()) {
                        Tuples.this.done = true;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Tuple next() {
                if (!this.hasNext()) {
                    return null;
                }
                try {
                    if (Tuples.this.cache != null) {
                        Tuples.this.cache.add(this.tuple);
                    }
                    Tuple tuple = this.tuple;
                    return tuple;
                }
                finally {
                    this.tuple = null;
                }
            }

            @Override
            public void remove() {
            }
        };
    }
}

