/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.client.connection.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.reldb.rel.Rel;
import org.reldb.rel.client.connection.CrashHandler;
import org.reldb.rel.client.connection.stream.ClientConnection;
import org.reldb.rel.client.utilities.ClassPathHack;
import org.reldb.rel.exceptions.DatabaseFormatVersionException;

public class ClientLocalConnection
extends ClientConnection {
    private Rel rel;
    protected CrashHandler errorHandler;

    public ClientLocalConnection(String databaseDir, boolean createDbAllowed, CrashHandler errorHandler, String[] additionalJars) throws IOException, DatabaseFormatVersionException {
        ClassPathHack.addFile("RelDBMS.jar");
        this.rel = new Rel(databaseDir, createDbAllowed, additionalJars);
        this.errorHandler = errorHandler;
        this.obtainInitialServerResponse();
        errorHandler.setInitialServerResponse(this.initialServerResponse.toString());
    }

    @Override
    public InputStream getServerResponseInputStream() throws IOException {
        return this.rel.getServerResponseInputStream();
    }

    @Override
    public void sendEvaluate(String source) {
        try {
            this.rel.sendEvaluate(source);
        }
        catch (Throwable t) {
            this.rel.reset();
            this.errorHandler.process(t, source);
        }
    }

    @Override
    public void sendExecute(String source) {
        try {
            this.rel.sendExecute(source);
        }
        catch (Throwable t) {
            this.rel.reset();
            this.errorHandler.process(t, source);
        }
    }

    @Override
    public void close() throws IOException {
        this.rel.close();
    }

    @Override
    public void reset() throws IOException {
        this.rel.reset();
    }

    public static void convertToLatestFormat(String dbURL, PrintStream conversionOutput, String[] additionalJars) throws DatabaseFormatVersionException, IOException {
        Rel.convertToLatestFormat((String)dbURL, (PrintStream)conversionOutput, (String[])additionalJars);
    }
}

