/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.client.connection.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import org.reldb.rel.client.connection.stream.ClientConnection;

public class ClientNetworkConnection
extends ClientConnection {
    private Socket socket;
    private PrintStream outputToServer;

    public ClientNetworkConnection(String serverName, int port) throws IOException {
        this.socket = new Socket(serverName, port);
        this.outputToServer = new PrintStream(this.socket.getOutputStream());
        this.obtainInitialServerResponse();
    }

    @Override
    public InputStream getServerResponseInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    private void send(String src) throws IOException {
        this.outputToServer.println(src);
        this.outputToServer.flush();
        if (this.outputToServer.checkError()) {
            throw new IOException("Lost connection to server.");
        }
    }

    @Override
    public void reset() throws IOException {
        this.send("R<EOT>");
    }

    @Override
    public void sendEvaluate(String source) throws IOException {
        this.send(String.valueOf('E') + source + "<EOT>");
    }

    @Override
    public void sendExecute(String source) throws IOException {
        this.send(String.valueOf('X') + source + "<EOT>");
    }

    @Override
    public void close() throws IOException {
        this.outputToServer.close();
        this.socket.close();
    }
}

