/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.client.connection.stream;

import java.io.IOException;
import java.io.InputStream;

public abstract class InputStreamInterceptor
extends InputStream {
    private InputStream inputStream;

    public InputStreamInterceptor(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public abstract void interceptedRead(int var1);

    @Override
    public int read() throws IOException {
        int r = this.inputStream.read();
        this.interceptedRead(r);
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = this.inputStream.read(b);
        byte[] byArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            byte x = byArray[n2];
            this.interceptedRead(x);
            ++n2;
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.inputStream.read(b, off, len);
        int c = 0;
        int i = off;
        while (c < len) {
            this.interceptedRead(b[i]);
            ++i;
            ++c;
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }
}

