/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.client.connection.string;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.LinkedBlockingQueue;
import org.reldb.rel.client.connection.CrashHandler;
import org.reldb.rel.client.connection.stream.ClientLocalConnection;
import org.reldb.rel.client.connection.string.StringReceiverClient;
import org.reldb.rel.exceptions.DatabaseFormatVersionException;

public class ClientLocal
implements StringReceiverClient {
    private ClientLocalConnection connection;
    private LinkedBlockingQueue<String> outputStringQueue = new LinkedBlockingQueue();
    private boolean receiverRunning;

    public ClientLocal(String databaseDir, boolean createDbAllowed, CrashHandler crashHandler, String[] additionalJars) throws IOException, DatabaseFormatVersionException {
        this.connection = new ClientLocalConnection(databaseDir, createDbAllowed, crashHandler, additionalJars);
        final BufferedReader input = new BufferedReader(new InputStreamReader(this.connection.getServerResponseInputStream()));
        Thread receiver = new Thread(){

            @Override
            public void run() {
                ClientLocal.this.receiverRunning = true;
                while (ClientLocal.this.receiverRunning) {
                    try {
                        String received = input.readLine();
                        if (received == null) continue;
                        ClientLocal.this.outputStringQueue.add(received);
                    }
                    catch (IOException ioe) {
                        if (!ioe.getMessage().equals("Write end dead") && !ioe.getMessage().equals("Pipe broken")) {
                            System.out.println("ClientLocal: " + ioe.getMessage());
                        }
                        try {
                            1.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        receiver.setDaemon(true);
        receiver.start();
    }

    @Override
    public String receive() throws IOException {
        String received = null;
        try {
            received = this.outputStringQueue.take();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (received.equals("<EOT>")) {
            return null;
        }
        return received;
    }

    @Override
    public void sendEvaluate(String source) throws IOException {
        this.connection.sendEvaluate(source);
    }

    @Override
    public void sendExecute(String source) throws IOException {
        this.connection.sendExecute(source);
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
        this.receiverRunning = false;
    }

    @Override
    public void reset() throws IOException {
        this.connection.reset();
    }

    @Override
    public String getServerAnnouncement() throws IOException {
        return this.connection.getServerAnnouncement();
    }
}

