/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.client.connection.string;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.reldb.rel.client.connection.stream.ClientNetworkConnection;
import org.reldb.rel.client.connection.string.StringReceiverClient;

public class ClientNetwork
implements StringReceiverClient {
    private BufferedReader input;
    private ClientNetworkConnection connection;

    public ClientNetwork(String serverName, int port) throws IOException {
        this.connection = new ClientNetworkConnection(serverName, port);
        this.input = new BufferedReader(new InputStreamReader(this.connection.getServerResponseInputStream()));
    }

    @Override
    public String receive() throws IOException {
        String received = this.input.readLine();
        if (received == null) {
            return null;
        }
        if (received.equals("<EOT>")) {
            return null;
        }
        return received;
    }

    @Override
    public void sendEvaluate(String source) throws IOException {
        this.connection.sendEvaluate(source);
    }

    @Override
    public void sendExecute(String source) throws IOException {
        this.connection.sendExecute(source);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
        this.connection.close();
    }

    @Override
    public void reset() throws IOException {
        this.connection.reset();
    }

    @Override
    public String getServerAnnouncement() throws IOException {
        return this.connection.getServerAnnouncement();
    }
}

