/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.client.parser;

import java.io.InputStream;
import org.reldb.rel.client.Heading;
import org.reldb.rel.client.parser.ResponseProcessor;

public abstract class ResponseToHTML
extends ResponseProcessor {
    private boolean emitHeadings = true;
    private boolean emitHeadingTypes = true;
    private boolean headingDisplayed = false;

    public static String textToHTML(String s) {
        return s.replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<br>").replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    public ResponseToHTML(InputStream input) {
        super(input);
    }

    public ResponseToHTML(String input) {
        super(input);
    }

    public void setEmitHeadings(boolean isShowHeadings) {
        this.emitHeadings = isShowHeadings;
    }

    public void setEmitHeadingTypes(boolean isShowHeadingTypes) {
        this.emitHeadingTypes = isShowHeadingTypes;
    }

    public abstract void emitHTML(String var1);

    @Override
    public void beginAttributeSpec() {
        if (!this.emitHeadings) {
            return;
        }
        this.emitHTML("<th valign=\"top\">");
    }

    @Override
    public void attributeName(String name) {
        this.emitHTML(String.valueOf(name) + "<br>");
    }

    @Override
    public void typeReference(String name) {
        if (this.emitHeadingTypes) {
            this.emitHTML("<font size=\"1\"><i>" + name + "</i></font>");
        }
    }

    @Override
    public void endAttributeSpec() {
        if (!this.emitHeadings) {
            return;
        }
        this.emitHTML("</th>");
    }

    @Override
    public void beginTupleDefinition() {
        if (this.isEmitHeadingTypes()) {
            this.emitHTML("<font size=\"1\"><i>TUPLE</i></font>");
        }
        this.emitHTML("<table cellpadding=\"1\" cellspacing=\"0\" width=\"100%\">");
    }

    @Override
    public void endTupleDefinition() {
        this.emitHTML("</table>");
    }

    @Override
    public void beginContainerDefinition() {
        if (this.isEmitHeadingTypes()) {
            this.emitHTML("<font size=\"1\"><i>RELATION</i></font>");
        }
        this.emitHTML("<table cellpadding=\"1\" cellspacing=\"0\" width=\"100%\">");
    }

    @Override
    public void endContainerDefinition() {
        this.emitHTML("</table>");
    }

    @Override
    public void beginHeading(String typeName) {
        if (!this.emitHeadings) {
            return;
        }
        this.emitHTML("<tr>");
        this.headingDisplayed = true;
    }

    @Override
    public Heading endHeading() {
        if (!this.emitHeadings) {
            return null;
        }
        this.emitHTML("</tr>");
        return null;
    }

    @Override
    public void beginContainer(int depth) {
        if (depth == 0) {
            this.emitHTML("<table id=\"table\" cellpadding=\"1\" cellspacing=\"0\">");
        } else {
            this.emitHTML("<td valign=\"top\"><table cellpadding=\"1\" cellspacing=\"0\" width=\"100%\">");
        }
    }

    @Override
    public void endContainer(int depth) {
        this.emitHTML("</table>");
        if (depth > 0) {
            this.emitHTML("</td>");
        }
    }

    @Override
    public void beginTuple(int depth) {
        if (this.headingDisplayed && depth == 1) {
            this.emitHTML("<td valign=\"top\">");
        }
        if (depth != 2) {
            if (depth == 1) {
                this.emitHTML("<table cellpadding=\"1\" cellspacing=\"0\" width=\"100%\">");
            } else {
                this.emitHTML("<table cellpadding=\"1\" cellspacing=\"0\">");
            }
        }
        this.emitHTML("<tr>");
    }

    @Override
    public void endTuple(int depth) {
        this.emitHTML("</tr>");
        if (depth != 2) {
            this.emitHTML("</table>");
        }
        if (this.headingDisplayed && depth == 1) {
            this.emitHTML("</td>");
        }
    }

    @Override
    public void attributeNameInTuple(int depth, String name) {
        if (!this.headingDisplayed) {
            this.emitHTML("<td valign=\"top\">");
            if (this.isEmitHeading()) {
                this.emitHTML("<i>" + name + "</i> ");
            }
        }
    }

    @Override
    public void beginScalar(int depth) {
        if (depth == 0) {
            this.emitHTML("<br>");
        } else if (this.headingDisplayed) {
            this.emitHTML("<td valign=\"top\">");
        }
    }

    @Override
    public void endScalar(int depth) {
        if (depth != 0 && this.headingDisplayed) {
            this.emitHTML("</td>");
        }
    }

    @Override
    public void beginPossrep(String name) {
        this.emitHTML(String.valueOf(name) + "(");
    }

    @Override
    public void endPossrep() {
        this.emitHTML(")");
    }

    @Override
    public void separatePossrepComponent() {
        this.emitHTML(", ");
    }

    @Override
    public void primitive(String value, boolean quoted) {
        this.emitHTML(ResponseToHTML.textToHTML(value));
    }

    @Override
    public void beginOperatorDefinition() {
        this.emitHTML("<font size=\"1\">OPERATOR </font>");
    }

    @Override
    public void beginOperatorDefinitionParameters() {
        this.emitHTML("<font size=\"1\">(</font>");
    }

    @Override
    public void beginOperatorParameter() {
    }

    @Override
    public void endOperatorParameter() {
    }

    @Override
    public void emitOperatorParameterSeparator() {
        this.emitHTML("<font size=\"1\">, </font>");
    }

    @Override
    public void endOperatorDefinitionParameters() {
        this.emitHTML("<font size=\"1\">)</font>");
    }

    @Override
    public void beginOperatorReturnType() {
        this.emitHTML("<font size=\"1\"> RETURNS </font>");
    }

    @Override
    public void endOperatorReturnType() {
    }

    @Override
    public void endOperatorDefinition() {
    }
}

