/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.utilities;

public class StringUtils {
    public static String nospaces(String s) {
        return s.replace(' ', '_');
    }

    public static String quote(String s) {
        char[] in = s.toCharArray();
        int n = in.length;
        StringBuffer out = new StringBuffer(n);
        int i = 0;
        while (i < n) {
            switch (in[i]) {
                case '\n': {
                    out.append("\\n");
                    break;
                }
                case '\t': {
                    out.append("\\t");
                    break;
                }
                case '\b': {
                    out.append("\\b");
                    break;
                }
                case '\r': {
                    out.append("\\r");
                    break;
                }
                case '\f': {
                    out.append("\\f");
                    break;
                }
                case '\\': {
                    out.append("\\\\");
                    break;
                }
                case '\'': {
                    out.append("\\'");
                    break;
                }
                case '\"': {
                    out.append("\\\"");
                    break;
                }
                default: {
                    out.append(new String(in, i, 1));
                }
            }
            ++i;
        }
        return out.toString();
    }

    public static String unquote(String s) {
        char[] in = s.toCharArray();
        char[] out = new char[in.length];
        boolean inEscape = false;
        int k = 0;
        int n = in.length;
        int i = 0;
        while (i < n) {
            if (inEscape) {
                switch (in[i]) {
                    case 'n': {
                        out[k++] = 10;
                        break;
                    }
                    case 't': {
                        out[k++] = 9;
                        break;
                    }
                    case 'b': {
                        out[k++] = 8;
                        break;
                    }
                    case 'r': {
                        out[k++] = 13;
                        break;
                    }
                    case 'f': {
                        out[k++] = 12;
                        break;
                    }
                    case '\\': {
                        out[k++] = 92;
                        break;
                    }
                    case '\'': {
                        out[k++] = 39;
                        break;
                    }
                    case '\"': {
                        out[k++] = 34;
                        break;
                    }
                    default: {
                        out[k++] = 92;
                        out[k++] = in[i];
                    }
                }
                inEscape = false;
            } else if (in[i] == '\\') {
                inEscape = true;
            } else {
                out[k++] = in[i];
            }
            ++i;
        }
        return new String(out, 0, k);
    }
}

