# coding: utf-8

"""
    API Endpoints

    Deliver monetary rewards and incentives to employees, customers, survey participants, and more through the Tremendous API. For organizational tasks, like managing your organization and it's members within Tremendous, please see the Tremendous Organizational API.

    The version of the OpenAPI document: 2
    Contact: developers@tremendous.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class DeliveryStatus(str, Enum):
    """
    Current status of the delivery of the reward:  * `SCHEDULED` - Reward is scheduled for delivery and will be delivered soon. * `FAILED` - Delivery of reward failed (e.g. email bounced). * `SUCCEEDED` - Reward was successfully delivered (email or text message delivered or reward link opened). * `PENDING` - Delivery is pending but not yet scheduled. 
    """

    """
    allowed enum values
    """
    SCHEDULED = 'SCHEDULED'
    FAILED = 'FAILED'
    SUCCEEDED = 'SUCCEEDED'
    PENDING = 'PENDING'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DeliveryStatus from a JSON string"""
        return cls(json.loads(json_str))


