# coding: utf-8

"""
    API Endpoints

    Deliver monetary rewards and incentives to employees, customers, survey participants, and more through the Tremendous API. For organizational tasks, like managing your organization and it's members within Tremendous, please see the Tremendous Organizational API.

    The version of the OpenAPI document: 2
    Contact: developers@tremendous.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class FraudRulesListItem(BaseModel):
    """
    An active fraud rule
    """ # noqa: E501
    rule_type: Optional[StrictStr] = Field(default=None, description="* `review_country` - Flags when the recipient's IP country matches the criteria in the rule * `review_ip` - Flags when recipient's IP matches one in the list * `review_email` - Flags when the recipient's email matches one in the list * `review_redeemed_rewards_count` - Flags when the recipient redeemed more than the number of rewards specified in the config * `review_redeemed_rewards_amount` - Flags when the recipient redeemed more than the total amount specified in the config * `review_multiple_emails` - Flags when recipient's device or account has multiple emails associated * `review_vpn` - Flags when VPN is suspected * `review_tremendous_flag_list` - Flags rewards when redemption attributes match at least one criteria defined by the Tremendous flag list * `review_previously_blocked_recipients` - Flags rewards when the recipient has been blocked before * `allow_ip` - Releases a reward when a recipient's IP matches one in the list * `allow_email` - Releases a reward when the recipient's email matches one in the list ")
    config: Optional[Dict[str, Any]] = Field(default=None, description="The configuration associated with the rule. The properties allowed depend on the type of rule. This property is only present for rules that require configuration. ")
    __properties: ClassVar[List[str]] = ["rule_type", "config"]

    @field_validator('rule_type')
    def rule_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['review_country', 'review_ip', 'review_email', 'review_redeemed_rewards_count', 'review_redeemed_rewards_amount', 'review_multiple_emails', 'review_vpn', 'review_tremendous_flag_list', 'review_previously_blocked_recipients', 'allow_ip', 'allow_email']):
            raise ValueError("must be one of enum values ('review_country', 'review_ip', 'review_email', 'review_redeemed_rewards_count', 'review_redeemed_rewards_amount', 'review_multiple_emails', 'review_vpn', 'review_tremendous_flag_list', 'review_previously_blocked_recipients', 'allow_ip', 'allow_email')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FraudRulesListItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if config (nullable) is None
        # and model_fields_set contains the field
        if self.config is None and "config" in self.model_fields_set:
            _dict['config'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FraudRulesListItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "rule_type": obj.get("rule_type"),
            "config": obj.get("config")
        })
        return _obj


