# flake8: noqa

"""
    University Student API

     This API exposes identity information about university students. The purpose of this API is to give access to basic identity information about university students for use by downstream systems, therefore the data exposed is limited to basic information about who a student is and which institutions they are affiliated with.  This API uses the following identifiers to link people to person-records held within different systems:  * `person.v1.student-records.university.identifiers.cam.ac.uk` - the university student (ust) identifier of this person -   also referred to as USN * `person.v1.student-records.university.identifiers.cam.ac.uk` - the common registration scheme identifier (CRSid) of   this person  Additionally this API uses the following identifiers to link people to institutions or entities which a person may have an affiliation to:  * `institution.v1.student-records.university.identifiers.cam.ac.uk` - the university student (ust) institution identifier.     This encompasses colleges, departments and faculties. The     [CamSIS Coding Manual](https://www.camsis.cam.ac.uk/technical/camsis-coding-manual)     lists the available values for this affiliation (under A01 and M01). * `academic-plan.v1.student-records.university.identifiers.cam.ac.uk` - the university student (ust) academic plan     identifier. The     [CamSIS Coding Manual](https://www.camsis.cam.ac.uk/technical/camsis-coding-manual)     lists the available values for this affiliation (under D07).  Both affiliations provide a `status` field which indicate a student's status within an affiliated entity. This `status` field is the short representation of the academic career field held in CamSIS. The [CamSIS Coding Manual](https://www.camsis.cam.ac.uk/technical/camsis-coding-manual) lists the available values for the `status` field (under D05).  This API is currently backed by data from CamSIS, exposing a view of data that is refreshed nightly.    # noqa: E501

    The version of the OpenAPI document: v1alpha2
    Generated by: https://openapi-generator.tech
"""


__version__ = "1.0.0"

# import ApiClient
from identitylib.student_client.api_client import ApiClient

# import Configuration
from identitylib.student_client.configuration import Configuration

# import exceptions
from identitylib.student_client.exceptions import OpenApiException
from identitylib.student_client.exceptions import ApiAttributeError
from identitylib.student_client.exceptions import ApiTypeError
from identitylib.student_client.exceptions import ApiValueError
from identitylib.student_client.exceptions import ApiKeyError
from identitylib.student_client.exceptions import ApiException
