""" Code is generated by ucloud-model, DO NOT EDIT IT. """

from ucloud.core.typesystem import schema, fields
from ucloud.services.pathx.schemas import models

""" PathX API Schema
"""


"""
API: BindPathXSSL

绑定PathX SSL证书
"""


class BindPathXSSLRequestSchema(schema.RequestSchema):
    """BindPathXSSL - 绑定PathX SSL证书"""

    fields = {
        "Port": fields.List(fields.Int()),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "SSLId": fields.Str(required=True, dump_to="SSLId"),
        "UGAId": fields.Str(required=True, dump_to="UGAId"),
    }


class BindPathXSSLResponseSchema(schema.ResponseSchema):
    """BindPathXSSL - 绑定PathX SSL证书"""

    fields = {}


"""
API: CreateGlobalSSHInstance

创建GlobalSSH实例
"""


class CreateGlobalSSHInstanceRequestSchema(schema.RequestSchema):
    """CreateGlobalSSHInstance - 创建GlobalSSH实例"""

    fields = {
        "Area": fields.Str(required=True, dump_to="Area"),
        "AreaCode": fields.Str(required=True, dump_to="AreaCode"),
        "BandwidthPackage": fields.Int(
            required=False, dump_to="BandwidthPackage"
        ),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "ForwardRegion": fields.Str(required=False, dump_to="ForwardRegion"),
        "InstanceType": fields.Str(required=False, dump_to="InstanceType"),
        "Port": fields.Int(required=True, dump_to="Port"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "TargetIP": fields.Str(required=True, dump_to="TargetIP"),
    }


class CreateGlobalSSHInstanceResponseSchema(schema.ResponseSchema):
    """CreateGlobalSSHInstance - 创建GlobalSSH实例"""

    fields = {
        "AcceleratingDomain": fields.Str(
            required=False, load_from="AcceleratingDomain"
        ),
        "InstanceId": fields.Str(required=True, load_from="InstanceId"),
        "Message": fields.Str(
            required=False, load_from="Message"
        ),  # Deprecated, will be removed at 1.0
    }


"""
API: CreatePathXSSL

创建SSL证书，可以把整个 Pem 证书内容传到SSLContent，或者把证书、私钥、CA证书分别传过来
"""


class CreatePathXSSLRequestSchema(schema.RequestSchema):
    """CreatePathXSSL - 创建SSL证书，可以把整个 Pem 证书内容传到SSLContent，或者把证书、私钥、CA证书分别传过来"""

    fields = {
        "CACert": fields.Str(required=False, dump_to="CACert"),
        "PrivateKey": fields.Str(required=False, dump_to="PrivateKey"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "SSLContent": fields.Str(required=False, dump_to="SSLContent"),
        "SSLName": fields.Str(required=True, dump_to="SSLName"),
        "SSLType": fields.Str(required=False, dump_to="SSLType"),
        "UserCert": fields.Str(required=False, dump_to="UserCert"),
    }


class CreatePathXSSLResponseSchema(schema.ResponseSchema):
    """CreatePathXSSL - 创建SSL证书，可以把整个 Pem 证书内容传到SSLContent，或者把证书、私钥、CA证书分别传过来"""

    fields = {
        "SSLId": fields.Str(required=True, load_from="SSLId"),
    }


"""
API: CreateUGA3Instance


"""


class CreateUGA3InstanceRequestSchema(schema.RequestSchema):
    """CreateUGA3Instance -"""

    fields = {
        "AccelerationArea": fields.Str(
            required=False, dump_to="AccelerationArea"
        ),
        "AreaCode": fields.Str(required=False, dump_to="AreaCode"),
        "Bandwidth": fields.Int(required=True, dump_to="Bandwidth"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "OriginDomain": fields.Str(required=False, dump_to="OriginDomain"),
        "OriginIPList": fields.Str(required=False, dump_to="OriginIPList"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
    }


class CreateUGA3InstanceResponseSchema(schema.ResponseSchema):
    """CreateUGA3Instance -"""

    fields = {
        "CName": fields.Str(required=False, load_from="CName"),
        "InstanceId": fields.Str(required=True, load_from="InstanceId"),
    }


"""
API: CreateUGA3Port


"""


class CreateUGA3PortRequestSchema(schema.RequestSchema):
    """CreateUGA3Port -"""

    fields = {
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "TCP": fields.List(fields.Int()),
        "TCPRS": fields.List(fields.Int()),
    }


class CreateUGA3PortResponseSchema(schema.ResponseSchema):
    """CreateUGA3Port -"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: CreateUGAForwarder

创建加速实例转发器，支持HTTPS接入HTTPS回源、HTTPS接入HTTP回源、HTTP接入HTTP回源、TCP接入TCP回源、UDP接入UDP回源、 支持WSS接入WSS回源、WSS接入WS回源、WS接入WS回源
"""


class CreateUGAForwarderRequestSchema(schema.RequestSchema):
    """CreateUGAForwarder - 创建加速实例转发器，支持HTTPS接入HTTPS回源、HTTPS接入HTTP回源、HTTP接入HTTP回源、TCP接入TCP回源、UDP接入UDP回源、 支持WSS接入WSS回源、WSS接入WS回源、WS接入WS回源"""

    fields = {
        "HTTPHTTP": fields.List(fields.Int()),
        "HTTPHTTPRS": fields.List(fields.Int()),
        "HTTPSHTTP": fields.List(fields.Int()),
        "HTTPSHTTPRS": fields.List(fields.Int()),
        "HTTPSHTTPS": fields.List(fields.Int()),
        "HTTPSHTTPSRS": fields.List(fields.Int()),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "TCP": fields.List(fields.Int()),
        "TCPRS": fields.List(fields.Int()),
        "UDP": fields.List(fields.Int()),
        "UDPRS": fields.List(fields.Int()),
        "UGAId": fields.Str(required=True, dump_to="UGAId"),
        "WSSWS": fields.List(fields.Int()),
        "WSSWSRS": fields.List(fields.Int()),
        "WSSWSS": fields.List(fields.Int()),
        "WSSWSSRS": fields.List(fields.Int()),
        "WSWS": fields.List(fields.Int()),
        "WSWSRS": fields.List(fields.Int()),
    }


class CreateUGAForwarderResponseSchema(schema.ResponseSchema):
    """CreateUGAForwarder - 创建加速实例转发器，支持HTTPS接入HTTPS回源、HTTPS接入HTTP回源、HTTP接入HTTP回源、TCP接入TCP回源、UDP接入UDP回源、 支持WSS接入WSS回源、WSS接入WS回源、WS接入WS回源"""

    fields = {
        "Message": fields.Str(
            required=True, load_from="Message"
        ),  # Deprecated, will be removed at 1.0
    }


"""
API: CreateUGAInstance

创建全球加速配置项
"""


class CreateUGAInstanceRequestSchema(schema.RequestSchema):
    """CreateUGAInstance - 创建全球加速配置项"""

    fields = {
        "Domain": fields.Str(required=False, dump_to="Domain"),
        "IPList": fields.Str(required=False, dump_to="IPList"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "TCP": fields.List(fields.Str()),
        "UDP": fields.List(fields.Str()),
    }


class CreateUGAInstanceResponseSchema(schema.ResponseSchema):
    """CreateUGAInstance - 创建全球加速配置项"""

    fields = {
        "CName": fields.Str(required=False, load_from="CName"),
        "Message": fields.Str(required=False, load_from="Message"),
        "UGAId": fields.Str(required=True, load_from="UGAId"),
    }


"""
API: CreateUPath

创建UPath
"""


class CreateUPathRequestSchema(schema.RequestSchema):
    """CreateUPath - 创建UPath"""

    fields = {
        "Bandwidth": fields.Int(required=True, dump_to="Bandwidth"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "LineId": fields.Str(required=True, dump_to="LineId"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "PathType": fields.Str(required=False, dump_to="PathType"),
        "PostPaid": fields.Bool(required=False, dump_to="PostPaid"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
    }


class CreateUPathResponseSchema(schema.ResponseSchema):
    """CreateUPath - 创建UPath"""

    fields = {
        "PathId": fields.Str(required=True, load_from="PathId"),
        "UPathId": fields.Str(
            required=True, load_from="UPathId"
        ),  # Deprecated, will be removed at 1.0
    }


"""
API: DeleteGlobalSSHInstance

删除GlobalSSH实例
"""


class DeleteGlobalSSHInstanceRequestSchema(schema.RequestSchema):
    """DeleteGlobalSSHInstance - 删除GlobalSSH实例"""

    fields = {
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
    }


class DeleteGlobalSSHInstanceResponseSchema(schema.ResponseSchema):
    """DeleteGlobalSSHInstance - 删除GlobalSSH实例"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: DeletePathXSSL

删除PathX SSL证书
"""


class DeletePathXSSLRequestSchema(schema.RequestSchema):
    """DeletePathXSSL - 删除PathX SSL证书"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "SSLId": fields.Str(required=True, dump_to="SSLId"),
    }


class DeletePathXSSLResponseSchema(schema.ResponseSchema):
    """DeletePathXSSL - 删除PathX SSL证书"""

    fields = {}


"""
API: DeleteUGA3Instance


"""


class DeleteUGA3InstanceRequestSchema(schema.RequestSchema):
    """DeleteUGA3Instance -"""

    fields = {
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
    }


class DeleteUGA3InstanceResponseSchema(schema.ResponseSchema):
    """DeleteUGA3Instance -"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: DeleteUGA3Port


"""


class DeleteUGA3PortRequestSchema(schema.RequestSchema):
    """DeleteUGA3Port -"""

    fields = {
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "TCP": fields.List(fields.Int()),
    }


class DeleteUGA3PortResponseSchema(schema.ResponseSchema):
    """DeleteUGA3Port -"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteUGAForwarder

删除加速实例转发器 按接入端口删除
"""


class DeleteUGAForwarderRequestSchema(schema.RequestSchema):
    """DeleteUGAForwarder - 删除加速实例转发器 按接入端口删除"""

    fields = {
        "HTTPHTTP": fields.List(fields.Int()),
        "HTTPSHTTP": fields.List(fields.Int()),
        "HTTPSHTTPS": fields.List(fields.Int()),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "TCP": fields.List(fields.Int()),
        "UDP": fields.List(fields.Int()),
        "UGAId": fields.Str(required=True, dump_to="UGAId"),
        "WSSWS": fields.List(fields.Int()),
        "WSSWSS": fields.List(fields.Int()),
        "WSWS": fields.List(fields.Int()),
    }


class DeleteUGAForwarderResponseSchema(schema.ResponseSchema):
    """DeleteUGAForwarder - 删除加速实例转发器 按接入端口删除"""

    fields = {
        "Message": fields.Str(
            required=True, load_from="Message"
        ),  # Deprecated, will be removed at 1.0
    }


"""
API: DeleteUGAInstance

删除全球加速服务加速配置
"""


class DeleteUGAInstanceRequestSchema(schema.RequestSchema):
    """DeleteUGAInstance - 删除全球加速服务加速配置"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UGAId": fields.Str(required=True, dump_to="UGAId"),
    }


class DeleteUGAInstanceResponseSchema(schema.ResponseSchema):
    """DeleteUGAInstance - 删除全球加速服务加速配置"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: DeleteUPath

删除UPath
"""


class DeleteUPathRequestSchema(schema.RequestSchema):
    """DeleteUPath - 删除UPath"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UPathId": fields.Str(required=True, dump_to="UPathId"),
    }


class DeleteUPathResponseSchema(schema.ResponseSchema):
    """DeleteUPath - 删除UPath"""

    fields = {}


"""
API: DescribeGlobalSSHArea


"""


class DescribeGlobalSSHAreaRequestSchema(schema.RequestSchema):
    """DescribeGlobalSSHArea -"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=False, dump_to="Region"),
    }


class DescribeGlobalSSHAreaResponseSchema(schema.ResponseSchema):
    """DescribeGlobalSSHArea -"""

    fields = {
        "AreaSet": fields.List(
            models.GlobalSSHAreaSchema(), required=False, load_from="AreaSet"
        ),
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: DescribeGlobalSSHInstance

获取GlobalSSH实例列表（传实例ID获取单个实例信息，不传获取项目下全部实例）
"""


class DescribeGlobalSSHInstanceRequestSchema(schema.RequestSchema):
    """DescribeGlobalSSHInstance - 获取GlobalSSH实例列表（传实例ID获取单个实例信息，不传获取项目下全部实例）"""

    fields = {
        "InstanceId": fields.Str(required=False, dump_to="InstanceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
    }


class DescribeGlobalSSHInstanceResponseSchema(schema.ResponseSchema):
    """DescribeGlobalSSHInstance - 获取GlobalSSH实例列表（传实例ID获取单个实例信息，不传获取项目下全部实例）"""

    fields = {
        "InstanceSet": fields.List(
            models.GlobalSSHInfoSchema(),
            required=False,
            load_from="InstanceSet",
        ),
    }


"""
API: DescribePathXLineConfig

获取全球加速线路信息
"""


class DescribePathXLineConfigRequestSchema(schema.RequestSchema):
    """DescribePathXLineConfig - 获取全球加速线路信息"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
    }


class DescribePathXLineConfigResponseSchema(schema.ResponseSchema):
    """DescribePathXLineConfig - 获取全球加速线路信息"""

    fields = {
        "LineSet": fields.List(
            models.UGAALineSchema(), required=False, load_from="LineSet"
        ),
    }


"""
API: DescribePathXSSL

获取SSL证书信息,支持分页，支持按证书名称 证书域名模糊搜索
"""


class DescribePathXSSLRequestSchema(schema.RequestSchema):
    """DescribePathXSSL - 获取SSL证书信息,支持分页，支持按证书名称 证书域名模糊搜索"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "SSLId": fields.Str(required=False, dump_to="SSLId"),
        "SearchValue": fields.Str(required=False, dump_to="SearchValue"),
    }


class DescribePathXSSLResponseSchema(schema.ResponseSchema):
    """DescribePathXSSL - 获取SSL证书信息,支持分页，支持按证书名称 证书域名模糊搜索"""

    fields = {
        "DataSet": fields.List(
            models.PathXSSLSetSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeUGA3Area


"""


class DescribeUGA3AreaRequestSchema(schema.RequestSchema):
    """DescribeUGA3Area -"""

    fields = {
        "Domain": fields.Str(required=False, dump_to="Domain"),
        "IPList": fields.Str(required=False, dump_to="IPList"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
    }


class DescribeUGA3AreaResponseSchema(schema.ResponseSchema):
    """DescribeUGA3Area -"""

    fields = {
        "AreaSet": fields.List(
            models.ForwardAreaSchema(), required=False, load_from="AreaSet"
        ),
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: DescribeUGA3Instance


"""


class DescribeUGA3InstanceRequestSchema(schema.RequestSchema):
    """DescribeUGA3Instance -"""

    fields = {
        "InstanceId": fields.Str(required=False, dump_to="InstanceId"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
    }


class DescribeUGA3InstanceResponseSchema(schema.ResponseSchema):
    """DescribeUGA3Instance -"""

    fields = {
        "ForwardInstanceInfos": fields.List(
            models.ForwardInfoSchema(),
            required=False,
            load_from="ForwardInstanceInfos",
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeUGA3Optimization


"""


class DescribeUGA3OptimizationRequestSchema(schema.RequestSchema):
    """DescribeUGA3Optimization -"""

    fields = {
        "AccelerationArea": fields.Str(
            required=False, dump_to="AccelerationArea"
        ),
        "AreaCode": fields.Str(required=True, dump_to="AreaCode"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "TimeRange": fields.Str(required=False, dump_to="TimeRange"),
    }


class DescribeUGA3OptimizationResponseSchema(schema.ResponseSchema):
    """DescribeUGA3Optimization -"""

    fields = {
        "AccelerationInfos": fields.List(
            models.AccelerationInfoSchema(),
            required=False,
            load_from="AccelerationInfos",
        ),
    }


"""
API: DescribeUGAInstance

获取全球加速服务加速配置信息，指定实例ID返回单个实例。未指定实例ID时 指定分页参数 则按创建时间降序 返回记录
"""


class DescribeUGAInstanceRequestSchema(schema.RequestSchema):
    """DescribeUGAInstance - 获取全球加速服务加速配置信息，指定实例ID返回单个实例。未指定实例ID时 指定分页参数 则按创建时间降序 返回记录"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UGAId": fields.Str(required=False, dump_to="UGAId"),
    }


class DescribeUGAInstanceResponseSchema(schema.ResponseSchema):
    """DescribeUGAInstance - 获取全球加速服务加速配置信息，指定实例ID返回单个实例。未指定实例ID时 指定分页参数 则按创建时间降序 返回记录"""

    fields = {
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
        "UGAList": fields.List(
            models.UGAAInfoSchema(), required=False, load_from="UGAList"
        ),
    }


"""
API: DescribeUPath

获取加速线路信息
"""


class DescribeUPathRequestSchema(schema.RequestSchema):
    """DescribeUPath - 获取加速线路信息"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UPathId": fields.Str(required=False, dump_to="UPathId"),
    }


class DescribeUPathResponseSchema(schema.ResponseSchema):
    """DescribeUPath - 获取加速线路信息"""

    fields = {
        "UPathSet": fields.List(
            models.UPathInfoSchema(), required=True, load_from="UPathSet"
        ),
    }


"""
API: DescribeUPathTemplate

查询UPath的监控模板
"""


class DescribeUPathTemplateRequestSchema(schema.RequestSchema):
    """DescribeUPathTemplate - 查询UPath的监控模板"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UPathId": fields.Str(required=True, dump_to="UPathId"),
    }


class DescribeUPathTemplateResponseSchema(schema.ResponseSchema):
    """DescribeUPathTemplate - 查询UPath的监控模板"""

    fields = {
        "DataSet": fields.List(
            models.AlarmRulerSchema(), required=True, load_from="DataSet"
        ),
    }


"""
API: GetGlobalSSHPrice

获取GlobalSSH价格
"""


class GetGlobalSSHPriceRequestSchema(schema.RequestSchema):
    """GetGlobalSSHPrice - 获取GlobalSSH价格"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "InstanceType": fields.Str(required=False, dump_to="InstanceType"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
    }


class GetGlobalSSHPriceResponseSchema(schema.ResponseSchema):
    """GetGlobalSSHPrice - 获取GlobalSSH价格"""

    fields = {
        "Price": fields.Float(required=False, load_from="Price"),
    }


"""
API: GetGlobalSSHTraffic

获取GlobalSSH流量统计数据
"""


class GetGlobalSSHTrafficRequestSchema(schema.RequestSchema):
    """GetGlobalSSHTraffic - 获取GlobalSSH流量统计数据"""

    fields = {
        "BeginTime": fields.Int(required=True, dump_to="BeginTime"),
        "EndTime": fields.Int(required=True, dump_to="EndTime"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UGAId": fields.Str(required=True, dump_to="UGAId"),
    }


class GetGlobalSSHTrafficResponseSchema(schema.ResponseSchema):
    """GetGlobalSSHTraffic - 获取GlobalSSH流量统计数据"""

    fields = {
        "DataSet": fields.List(
            models.TrafficDailySchema(), required=True, load_from="DataSet"
        ),
        "TrafficDailyRecently": fields.List(
            models.TrafficDailyRecentlySchema(),
            required=False,
            load_from="TrafficDailyRecently",
        ),
        "UGAId": fields.Str(required=True, load_from="UGAId"),
    }


"""
API: GetGlobalSSHUpdatePrice

获取GlobalSSH升级价格
"""


class GetGlobalSSHUpdatePriceRequestSchema(schema.RequestSchema):
    """GetGlobalSSHUpdatePrice - 获取GlobalSSH升级价格"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "InstanceId": fields.Str(required=False, dump_to="InstanceId"),
        "InstanceType": fields.Str(required=True, dump_to="InstanceType"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
    }


class GetGlobalSSHUpdatePriceResponseSchema(schema.ResponseSchema):
    """GetGlobalSSHUpdatePrice - 获取GlobalSSH升级价格"""

    fields = {
        "Price": fields.Float(required=False, load_from="Price"),
    }


"""
API: GetPathXMetric

获取全球加速监控信息
"""


class GetPathXMetricRequestSchema(schema.RequestSchema):
    """GetPathXMetric - 获取全球加速监控信息"""

    fields = {
        "BeginTime": fields.Int(required=True, dump_to="BeginTime"),
        "EndTime": fields.Int(required=True, dump_to="EndTime"),
        "LineId": fields.Str(required=True, dump_to="LineId"),
        "MetricName": fields.List(fields.Str()),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "ResourceId": fields.Str(required=True, dump_to="ResourceId"),
        "ResourceType": fields.Str(required=True, dump_to="ResourceType"),
    }


class GetPathXMetricResponseSchema(schema.ResponseSchema):
    """GetPathXMetric - 获取全球加速监控信息"""

    fields = {
        "DataSet": models.MetricPeriodSchema(),
    }


"""
API: GetUGA3Metric


"""


class GetUGA3MetricRequestSchema(schema.RequestSchema):
    """GetUGA3Metric -"""

    fields = {
        "AreaCode": fields.Str(required=False, dump_to="AreaCode"),
        "BeginTime": fields.Int(required=True, dump_to="BeginTime"),
        "EndTime": fields.Int(required=True, dump_to="EndTime"),
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "IsSubline": fields.Bool(required=False, dump_to="IsSubline"),
        "MetricName": fields.List(fields.Str()),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
    }


class GetUGA3MetricResponseSchema(schema.ResponseSchema):
    """GetUGA3Metric -"""

    fields = {
        "DataSet": models.UGA3MetricSchema(required=False, load_from="DataSet"),
    }


"""
API: GetUGA3Price


"""


class GetUGA3PriceRequestSchema(schema.RequestSchema):
    """GetUGA3Price -"""

    fields = {
        "AccelerationArea": fields.Str(
            required=False, dump_to="AccelerationArea"
        ),
        "AreaCode": fields.Str(required=True, dump_to="AreaCode"),
        "Bandwidth": fields.Int(required=True, dump_to="Bandwidth"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
    }


class GetUGA3PriceResponseSchema(schema.ResponseSchema):
    """GetUGA3Price -"""

    fields = {
        "UGA3Price": fields.List(
            models.UGA3PriceSchema(), required=True, load_from="UGA3Price"
        ),
    }


"""
API: GetUGA3UpdatePrice


"""


class GetUGA3UpdatePriceRequestSchema(schema.RequestSchema):
    """GetUGA3UpdatePrice -"""

    fields = {
        "AccelerationArea": fields.Str(
            required=False, dump_to="AccelerationArea"
        ),
        "AreaCode": fields.Str(required=False, dump_to="AreaCode"),
        "Bandwidth": fields.Int(required=False, dump_to="Bandwidth"),
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
    }


class GetUGA3UpdatePriceResponseSchema(schema.ResponseSchema):
    """GetUGA3UpdatePrice -"""

    fields = {
        "Price": fields.Float(required=True, load_from="Price"),
    }


"""
API: ModifyGlobalSSHOriginInfo

修改GlobalSSH 源站信息
"""


class ModifyGlobalSSHOriginInfoRequestSchema(schema.RequestSchema):
    """ModifyGlobalSSHOriginInfo - 修改GlobalSSH 源站信息"""

    fields = {
        "Area": fields.Str(required=False, dump_to="Area"),
        "AreaCode": fields.Str(required=False, dump_to="AreaCode"),
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "InstanceType": fields.Str(required=True, dump_to="InstanceType"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "RsIP": fields.Str(required=True, dump_to="RsIP"),
    }


class ModifyGlobalSSHOriginInfoResponseSchema(schema.ResponseSchema):
    """ModifyGlobalSSHOriginInfo - 修改GlobalSSH 源站信息"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: ModifyGlobalSSHPort

修改GlobalSSH端口
"""


class ModifyGlobalSSHPortRequestSchema(schema.RequestSchema):
    """ModifyGlobalSSHPort - 修改GlobalSSH端口"""

    fields = {
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "Port": fields.Int(required=True, dump_to="Port"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
    }


class ModifyGlobalSSHPortResponseSchema(schema.ResponseSchema):
    """ModifyGlobalSSHPort - 修改GlobalSSH端口"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: ModifyGlobalSSHRemark

修改GlobalSSH备注
"""


class ModifyGlobalSSHRemarkRequestSchema(schema.RequestSchema):
    """ModifyGlobalSSHRemark - 修改GlobalSSH备注"""

    fields = {
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
    }


class ModifyGlobalSSHRemarkResponseSchema(schema.ResponseSchema):
    """ModifyGlobalSSHRemark - 修改GlobalSSH备注"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: ModifyGlobalSSHType

修改GlobalSSH实例类型，仅支持低版本升级到高版本，不支持高版本降级到低版本
"""


class ModifyGlobalSSHTypeRequestSchema(schema.RequestSchema):
    """ModifyGlobalSSHType - 修改GlobalSSH实例类型，仅支持低版本升级到高版本，不支持高版本降级到低版本"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "InstanceType": fields.Str(required=True, dump_to="InstanceType"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Quantity": fields.Str(required=False, dump_to="Quantity"),
    }


class ModifyGlobalSSHTypeResponseSchema(schema.ResponseSchema):
    """ModifyGlobalSSHType - 修改GlobalSSH实例类型，仅支持低版本升级到高版本，不支持高版本降级到低版本"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: ModifyUGA3Bandwidth


"""


class ModifyUGA3BandwidthRequestSchema(schema.RequestSchema):
    """ModifyUGA3Bandwidth -"""

    fields = {
        "Bandwidth": fields.Int(required=False, dump_to="Bandwidth"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
    }


class ModifyUGA3BandwidthResponseSchema(schema.ResponseSchema):
    """ModifyUGA3Bandwidth -"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: ModifyUGA3Instance


"""


class ModifyUGA3InstanceRequestSchema(schema.RequestSchema):
    """ModifyUGA3Instance -"""

    fields = {
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
    }


class ModifyUGA3InstanceResponseSchema(schema.ResponseSchema):
    """ModifyUGA3Instance -"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: ModifyUGA3OriginInfo


"""


class ModifyUGA3OriginInfoRequestSchema(schema.RequestSchema):
    """ModifyUGA3OriginInfo -"""

    fields = {
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "OriginDomain": fields.Str(required=True, dump_to="OriginDomain"),
        "OriginIPList": fields.Str(required=True, dump_to="OriginIPList"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
    }


class ModifyUGA3OriginInfoResponseSchema(schema.ResponseSchema):
    """ModifyUGA3OriginInfo -"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: ModifyUGA3Port


"""


class ModifyUGA3PortRequestSchema(schema.RequestSchema):
    """ModifyUGA3Port -"""

    fields = {
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "TCP": fields.List(fields.Int()),
        "TCPRS": fields.List(fields.Int()),
    }


class ModifyUGA3PortResponseSchema(schema.ResponseSchema):
    """ModifyUGA3Port -"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: ModifyUPathBandwidth

修改加速线路带宽
"""


class ModifyUPathBandwidthRequestSchema(schema.RequestSchema):
    """ModifyUPathBandwidth - 修改加速线路带宽"""

    fields = {
        "Bandwidth": fields.Int(required=True, dump_to="Bandwidth"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UPathId": fields.Str(required=True, dump_to="UPathId"),
    }


class ModifyUPathBandwidthResponseSchema(schema.ResponseSchema):
    """ModifyUPathBandwidth - 修改加速线路带宽"""

    fields = {}


"""
API: ModifyUPathTemplate

修改UPath监控告警项
"""


class ModifyUPathTemplateRequestSchema(schema.RequestSchema):
    """ModifyUPathTemplate - 修改UPath监控告警项"""

    fields = {
        "AlarmFrequency": fields.List(fields.Int()),
        "AlarmStrategy": fields.List(fields.Str()),
        "Compare": fields.List(fields.Str()),
        "ContactGroupId": fields.List(fields.Int()),
        "MetricName": fields.List(fields.Str()),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Threshold": fields.List(fields.Int()),
        "TriggerCount": fields.List(fields.Int()),
        "UPathId": fields.Str(required=True, dump_to="UPathId"),
    }


class ModifyUPathTemplateResponseSchema(schema.ResponseSchema):
    """ModifyUPathTemplate - 修改UPath监控告警项"""

    fields = {}


"""
API: UGABindUPath

UGA绑定UPath
"""


class UGABindUPathRequestSchema(schema.RequestSchema):
    """UGABindUPath - UGA绑定UPath"""

    fields = {
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UGAId": fields.Str(required=True, dump_to="UGAId"),
        "UPathId": fields.Str(required=True, dump_to="UPathId"),
    }


class UGABindUPathResponseSchema(schema.ResponseSchema):
    """UGABindUPath - UGA绑定UPath"""

    fields = {}


"""
API: UGAUnBindUPath

UGA与UPath解绑
"""


class UGAUnBindUPathRequestSchema(schema.RequestSchema):
    """UGAUnBindUPath - UGA与UPath解绑"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UGAId": fields.Str(required=True, dump_to="UGAId"),
        "UPathId": fields.Str(required=True, dump_to="UPathId"),
    }


class UGAUnBindUPathResponseSchema(schema.ResponseSchema):
    """UGAUnBindUPath - UGA与UPath解绑"""

    fields = {}


"""
API: UnBindPathXSSL

解绑PathX SSL 证书
"""


class UnBindPathXSSLRequestSchema(schema.RequestSchema):
    """UnBindPathXSSL - 解绑PathX SSL 证书"""

    fields = {
        "Port": fields.List(fields.Int()),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "SSLId": fields.Str(required=True, dump_to="SSLId"),
        "UGAId": fields.Str(required=True, dump_to="UGAId"),
    }


class UnBindPathXSSLResponseSchema(schema.ResponseSchema):
    """UnBindPathXSSL - 解绑PathX SSL 证书"""

    fields = {}


"""
API: UpdatePathXWhitelist

更新入口白名单,仅限GlobalSSH 实例使用。其他uga-实例不生效
"""


class UpdatePathXWhitelistRequestSchema(schema.RequestSchema):
    """UpdatePathXWhitelist - 更新入口白名单,仅限GlobalSSH 实例使用。其他uga-实例不生效"""

    fields = {
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Whitelist": fields.List(fields.Str()),
    }


class UpdatePathXWhitelistResponseSchema(schema.ResponseSchema):
    """UpdatePathXWhitelist - 更新入口白名单,仅限GlobalSSH 实例使用。其他uga-实例不生效"""

    fields = {}
