""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.sts.schemas import apis


class STSClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(STSClient, self).__init__(config, transport, middleware, logger)

    def assume_role(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """AssumeRole - 获取扮演角色的临时身份凭证

        **Request**

        - **RoleSessionName** (str) - (Required) 角色会话名称。
        - **RoleUrn** (str) - (Required) 要扮演的RAM角色URN。
        - **DurationSeconds** (int) - Token有效期。
        - **Policy** (str) - 为STS Token额外添加的一个权限策略，进一步限制STS Token的权限。

        **Response**

        - **Credentials** (dict) - 见 **Credentials** 模型定义

        **Response Model**

        **Credentials**
        - **AccessKeyId** (str) - 密钥ID。
        - **AccessKeySecret** (str) - 密钥Secret。
        - **Expiration** (str) - Token到期失效时间（UTC时间）。
        - **SecurityToken** (str) - 安全令牌。


        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.AssumeRoleRequestSchema().dumps(d)

        resp = self.invoke("AssumeRole", d, **kwargs)
        return apis.AssumeRoleResponseSchema().loads(resp)
