""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.udi.schemas import apis


class UDIClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(UDIClient, self).__init__(config, transport, middleware, logger)

    def create_function_template(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateFunctionTemplate - 创建功能参数模板

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **ContainerFormat** (str) - (Required) 文件输出格式
        - **EncodeFormat** (str) - (Required) 编码格式
        - **Function** (str) - (Required) 功能名称
        - **ProjectName** (str) - (Required) 项目名称
        - **TemplateName** (str) - (Required) 模板名称
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **AudioBitRate** (str) - 音频比特率
        - **AudioBitRateCustom** (str) - 自定义音频比特率
        - **AudioChannel** (str) - 音频声道
        - **AudioSampleRate** (str) - 音频采样率
        - **CRF** (str) - CRF压缩率
        - **CRFCustom** (str) - 自定义CRF压缩率
        - **FrameRate** (str) - 帧率
        - **FrameRateCustom** (str) - 自定义帧率
        - **Resolution** (str) - 分辨率
        - **ResolutionHeight** (str) - 分辨率高
        - **ResolutionWidth** (str) - 分辨率宽
        - **VideoBitRate** (str) - 视频比特率
        - **VideoBitRateCustom** (str) - 自定义视频比特率

        **Response**

        - **TemplateId** (str) - 创建的模板ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateFunctionTemplateRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateFunctionTemplate", d, **kwargs)
        return apis.CreateFunctionTemplateResponseSchema().loads(resp)

    def create_media_task(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateMediaTask - 创建一个多媒体任务

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Bucket** (str) - (Required) Bucket名称
        - **DstKey** (str) - (Required) 目标生成文件
        - **Function** (str) - (Required) 功能名称：例VideoTranscode
        - **FunctionParamTemplateId** (str) - (Required) 功能的参数模板ID，需要事先创建模板才可用，也可以使用预设模板，详细可通过DescribeFunctionTemplate接口查询
        - **SrcKey** (str) - (Required) 源文件
        - **StorageBackend** (str) - (Required) 存储源
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **TaskId** (str) - 任务ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateMediaTaskRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateMediaTask", d, **kwargs)
        return apis.CreateMediaTaskResponseSchema().loads(resp)

    def delete_function_template(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteFunctionTemplate - 删除功能模板

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **TemplateId** (str) - (Required) 要删除的模板ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DeleteFunctionTemplateRequestSchema().dumps(d)

        resp = self.invoke("DeleteFunctionTemplate", d, **kwargs)
        return apis.DeleteFunctionTemplateResponseSchema().loads(resp)

    def describe_function_template(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeFunctionTemplate - 获取功能模板

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Type** (str) - 功能模板类型：预设（preset）自定义（custom），为空则获取两种类型

        **Response**

        - **Templates** (list) - 见 **FunctionTemplate** 模型定义

        **Response Model**

        **FunctionTemplate**
        - **FunctionName** (str) -
        - **Id** (str) -
        - **Name** (str) -


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeFunctionTemplateRequestSchema().dumps(d)

        resp = self.invoke("DescribeFunctionTemplate", d, **kwargs)
        return apis.DescribeFunctionTemplateResponseSchema().loads(resp)

    def describe_media_functions(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeMediaFunctions - 描述当前支持的多媒体功能以及对应功能需要的参数信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Function** (str) - 要查询的Function名称，为空则返回所有支持的Function

        **Response**

        - **Functions** (list) - 见 **Function** 模型定义

        **Response Model**

        **Function**
        - **DisplayName** (str) -
        - **FunctionName** (str) -
        - **InputType** (str) -
        - **OutputType** (str) -
        - **SupportParams** (list) - 见 **ParamOption** 模型定义


        **ParamOption**
        - **DisplayName** (str) -
        - **OptionalValues** (list) -
        - **ParamName** (str) -
        - **Required** (bool) -
        - **WhenValueCustom** (list) - 见 **ParamCustom** 模型定义


        **ParamCustom**
        - **Max** (int) -
        - **Min** (int) -
        - **ParamName** (str) -
        - **ParamType** (str) -


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeMediaFunctionsRequestSchema().dumps(d)

        resp = self.invoke("DescribeMediaFunctions", d, **kwargs)
        return apis.DescribeMediaFunctionsResponseSchema().loads(resp)

    def describe_media_task(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeMediaTask - 查询任务状态

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **TaskId** (str) - 要查询的任务ID，为空则查询所有

        **Response**

        - **Tasks** (list) - 见 **MediaTask** 模型定义

        **Response Model**

        **MediaTask**
        - **Function** (str) -
        - **Id** (str) -
        - **Status** (str) -


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeMediaTaskRequestSchema().dumps(d)

        resp = self.invoke("DescribeMediaTask", d, **kwargs)
        return apis.DescribeMediaTaskResponseSchema().loads(resp)
