""" Code is generated by ucloud-model, DO NOT EDIT IT. """

from ucloud.core.typesystem import schema, fields
from ucloud.services.ugn.schemas import models

""" UGN API Schema
"""


"""
API: AttachUGNInstance

实例加入云联网
"""


class AttachUGNInstanceRequestSchema(schema.RequestSchema):
    """AttachUGNInstance - 实例加入云联网"""

    fields = {
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "InstanceProjectId": fields.Str(
            required=True, dump_to="InstanceProjectId"
        ),
        "InstanceRegion": fields.Str(required=True, dump_to="InstanceRegion"),
        "InstanceType": fields.Str(required=True, dump_to="InstanceType"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UGNId": fields.Str(required=True, dump_to="UGNId"),
    }


class AttachUGNInstanceResponseSchema(schema.ResponseSchema):
    """AttachUGNInstance - 实例加入云联网"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: BatchDetachUGNInstance

批量移除云联网中实例
"""


class BatchDetachUGNInstanceRequestSchema(schema.RequestSchema):
    """BatchDetachUGNInstance - 批量移除云联网中实例"""

    fields = {
        "InstanceIds": fields.List(fields.Str()),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UGNId": fields.Str(required=True, dump_to="UGNId"),
    }


class BatchDetachUGNInstanceResponseSchema(schema.ResponseSchema):
    """BatchDetachUGNInstance - 批量移除云联网中实例"""

    fields = {
        "InstanceIds": fields.List(
            fields.Str(), required=True, load_from="InstanceIds"
        ),
    }


"""
API: CreateInterRegionBandwidth

购买跨域带宽
"""


class CreateInterRegionBandwidthRequestSchema(schema.RequestSchema):
    """CreateInterRegionBandwidth - 购买跨域带宽"""

    fields = {
        "Bandwidth": fields.Int(required=True, dump_to="Bandwidth"),
        "ChargeType": fields.Str(required=True, dump_to="ChargeType"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "PayMode": fields.Str(required=True, dump_to="PayMode"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Quantity": fields.Int(required=True, dump_to="Quantity"),
        "Region0": fields.Str(required=True, dump_to="Region0"),
        "Region1": fields.Str(required=True, dump_to="Region1"),
        "UGNId": fields.Str(required=True, dump_to="UGNId"),
    }


class CreateInterRegionBandwidthResponseSchema(schema.ResponseSchema):
    """CreateInterRegionBandwidth - 购买跨域带宽"""

    fields = {
        "InterRegionBandwidthId": fields.Str(
            required=True, load_from="InterRegionBandwidthId"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: CreateUGN


"""


class CreateUGNRequestSchema(schema.RequestSchema):
    """CreateUGN -"""

    fields = {
        "Name": fields.Str(required=False, dump_to="Name"),
        "Networks": fields.List(fields.Str()),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
    }


class CreateUGNResponseSchema(schema.ResponseSchema):
    """CreateUGN -"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
        "UGNID": fields.Str(required=False, load_from="UGNID"),
    }


"""
API: DeleteInterRegionBandwidth

删除跨域带宽
"""


class DeleteInterRegionBandwidthRequestSchema(schema.RequestSchema):
    """DeleteInterRegionBandwidth - 删除跨域带宽"""

    fields = {
        "InterRegionBandwidthId": fields.Str(
            required=True, dump_to="InterRegionBandwidthId"
        ),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UGNId": fields.Str(required=True, dump_to="UGNId"),
    }


class DeleteInterRegionBandwidthResponseSchema(schema.ResponseSchema):
    """DeleteInterRegionBandwidth - 删除跨域带宽"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteUGN

删除云联网
"""


class DeleteUGNRequestSchema(schema.RequestSchema):
    """DeleteUGN - 删除云联网"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UGNId": fields.Str(required=True, dump_to="UGNId"),
    }


class DeleteUGNResponseSchema(schema.ResponseSchema):
    """DeleteUGN - 删除云联网"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DescribeInterRegionBandwidth

查询跨域带宽
"""


class DescribeInterRegionBandwidthRequestSchema(schema.RequestSchema):
    """DescribeInterRegionBandwidth - 查询跨域带宽"""

    fields = {
        "InterRegionBandwidthIds": fields.List(fields.Str()),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UGNId": fields.Str(required=True, dump_to="UGNId"),
    }


class DescribeInterRegionBandwidthResponseSchema(schema.ResponseSchema):
    """DescribeInterRegionBandwidth - 查询跨域带宽"""

    fields = {
        "InterRegionBandwidths": fields.List(
            models.InterRegionBandwidthSchema(),
            required=True,
            load_from="InterRegionBandwidths",
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeSimpleUGN

获取简洁版UGN详情
"""


class DescribeSimpleUGNRequestSchema(schema.RequestSchema):
    """DescribeSimpleUGN - 获取简洁版UGN详情"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UGNID": fields.Str(required=True, dump_to="UGNID"),
    }


class DescribeSimpleUGNResponseSchema(schema.ResponseSchema):
    """DescribeSimpleUGN - 获取简洁版UGN详情"""

    fields = {
        "BwPackages": fields.List(
            models.SimpleBwPackageSchema(),
            required=True,
            load_from="BwPackages",
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "Networks": fields.List(
            models.SimpleNetworkSchema(), required=True, load_from="Networks"
        ),
        "Routes": fields.List(
            models.SimpleRouteSchema(), required=True, load_from="Routes"
        ),
        "UGN": models.UGNSchema(),
    }


"""
API: DescribeUGNInstance

查询云联网实例
"""


class DescribeUGNInstanceRequestSchema(schema.RequestSchema):
    """DescribeUGNInstance - 查询云联网实例"""

    fields = {
        "InstanceIds": fields.List(fields.Str()),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UGNId": fields.Str(required=True, dump_to="UGNId"),
    }


class DescribeUGNInstanceResponseSchema(schema.ResponseSchema):
    """DescribeUGNInstance - 查询云联网实例"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
        "UGNInstances": fields.List(
            models.InstanceSchema(), required=False, load_from="UGNInstances"
        ),
    }


"""
API: DescribeUGNRegionList

获取ugn支持的地域
"""


class DescribeUGNRegionListRequestSchema(schema.RequestSchema):
    """DescribeUGNRegionList - 获取ugn支持的地域"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
    }


class DescribeUGNRegionListResponseSchema(schema.ResponseSchema):
    """DescribeUGNRegionList - 获取ugn支持的地域"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
        "RegionList": fields.List(
            fields.Str(), required=True, load_from="RegionList"
        ),
    }


"""
API: DescribeUGNRouteRule

查询路由规则
"""


class DescribeUGNRouteRuleRequestSchema(schema.RequestSchema):
    """DescribeUGNRouteRule - 查询路由规则"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "RouteRuleIds": fields.List(fields.Str()),
        "UGNId": fields.Str(required=True, dump_to="UGNId"),
    }


class DescribeUGNRouteRuleResponseSchema(schema.ResponseSchema):
    """DescribeUGNRouteRule - 查询路由规则"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
        "UGNRouteRules": fields.List(
            models.RouteRuleSchema(), required=False, load_from="UGNRouteRules"
        ),
    }


"""
API: DetachUGNInstance

实例退出云联网
"""


class DetachUGNInstanceRequestSchema(schema.RequestSchema):
    """DetachUGNInstance - 实例退出云联网"""

    fields = {
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "InstanceType": fields.Str(required=True, dump_to="InstanceType"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UGNId": fields.Str(required=True, dump_to="UGNId"),
    }


class DetachUGNInstanceResponseSchema(schema.ResponseSchema):
    """DetachUGNInstance - 实例退出云联网"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: GetSimpleUGNBwPackages

获取指定云联网内的带宽包
"""


class GetSimpleUGNBwPackagesRequestSchema(schema.RequestSchema):
    """GetSimpleUGNBwPackages - 获取指定云联网内的带宽包"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UGNID": fields.Str(required=True, dump_to="UGNID"),
    }


class GetSimpleUGNBwPackagesResponseSchema(schema.ResponseSchema):
    """GetSimpleUGNBwPackages - 获取指定云联网内的带宽包"""

    fields = {
        "BwPackages": fields.List(
            models.SimpleBwPackageSchema(),
            required=True,
            load_from="BwPackages",
        ),
        "Limit": fields.Int(required=True, load_from="Limit"),
        "Message": fields.Str(required=True, load_from="Message"),
        "Offset": fields.Int(required=True, load_from="Offset"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: ListSimpleBwPackage

获取当前项目下的带宽包列表
"""


class ListSimpleBwPackageRequestSchema(schema.RequestSchema):
    """ListSimpleBwPackage - 获取当前项目下的带宽包列表"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
    }


class ListSimpleBwPackageResponseSchema(schema.ResponseSchema):
    """ListSimpleBwPackage - 获取当前项目下的带宽包列表"""

    fields = {
        "BwPackages": fields.List(
            models.SimpleBwPackageSchema(),
            required=True,
            load_from="BwPackages",
        ),
        "Limit": fields.Int(required=True, load_from="Limit"),
        "Offset": fields.Int(required=True, load_from="Offset"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: ListUGN

获取当前项目下所有云联网资源
"""


class ListUGNRequestSchema(schema.RequestSchema):
    """ListUGN - 获取当前项目下所有云联网资源"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
    }


class ListUGNResponseSchema(schema.ResponseSchema):
    """ListUGN - 获取当前项目下所有云联网资源"""

    fields = {
        "Limit": fields.Int(required=False, load_from="Limit"),
        "Message": fields.Str(required=True, load_from="Message"),
        "Offset": fields.Int(required=False, load_from="Offset"),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
        "UGNs": fields.List(
            models.UGNSchema(), required=True, load_from="UGNs"
        ),
    }


"""
API: ModifyInterRegionBandwidth

修改跨域带宽
"""


class ModifyInterRegionBandwidthRequestSchema(schema.RequestSchema):
    """ModifyInterRegionBandwidth - 修改跨域带宽"""

    fields = {
        "Bandwidth": fields.Str(required=True, dump_to="Bandwidth"),
        "InterRegionBandwidthId": fields.Str(
            required=True, dump_to="InterRegionBandwidthId"
        ),
        "PayMode": fields.Str(required=False, dump_to="PayMode"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UGNId": fields.Str(required=True, dump_to="UGNId"),
    }


class ModifyInterRegionBandwidthResponseSchema(schema.ResponseSchema):
    """ModifyInterRegionBandwidth - 修改跨域带宽"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: ModifyUGNAttribute

修改云联网属性
"""


class ModifyUGNAttributeRequestSchema(schema.RequestSchema):
    """ModifyUGNAttribute - 修改云联网属性"""

    fields = {
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "UGNId": fields.Str(required=True, dump_to="UGNId"),
    }


class ModifyUGNAttributeResponseSchema(schema.ResponseSchema):
    """ModifyUGNAttribute - 修改云联网属性"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: ModifyUGNBandwidth

修改云联网带宽大小
"""


class ModifyUGNBandwidthRequestSchema(schema.RequestSchema):
    """ModifyUGNBandwidth - 修改云联网带宽大小"""

    fields = {
        "BandWidth": fields.Int(required=True, dump_to="BandWidth"),
        "PackageID": fields.Str(required=True, dump_to="PackageID"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UGNID": fields.Str(required=True, dump_to="UGNID"),
    }


class ModifyUGNBandwidthResponseSchema(schema.ResponseSchema):
    """ModifyUGNBandwidth - 修改云联网带宽大小"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: PublishUGNRouteRule

发布云联网路由规则
"""


class PublishUGNRouteRuleRequestSchema(schema.RequestSchema):
    """PublishUGNRouteRule - 发布云联网路由规则"""

    fields = {
        "DeriveRouteRuleId": fields.Str(
            required=True, dump_to="DeriveRouteRuleId"
        ),
        "DeriveRouteTableId": fields.Str(
            required=True, dump_to="DeriveRouteTableId"
        ),
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UGNId": fields.Str(required=True, dump_to="UGNId"),
    }


class PublishUGNRouteRuleResponseSchema(schema.ResponseSchema):
    """PublishUGNRouteRule - 发布云联网路由规则"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "RouteRuleId": fields.Str(required=False, load_from="RouteRuleId"),
    }


"""
API: SDescribeUGN

获取简洁版UGN详情
"""


class SDescribeUGNRequestSchema(schema.RequestSchema):
    """SDescribeUGN - 获取简洁版UGN详情"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UGNID": fields.Str(required=True, dump_to="UGNID"),
    }


class SDescribeUGNResponseSchema(schema.ResponseSchema):
    """SDescribeUGN - 获取简洁版UGN详情"""

    fields = {
        "BwPackages": fields.List(
            models.SBwPackageSchema(), required=True, load_from="BwPackages"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "Networks": fields.List(
            models.SNetworkSchema(), required=True, load_from="Networks"
        ),
        "Policies": fields.List(
            fields.Str(), required=True, load_from="Policies"
        ),
        "Routes": fields.List(
            models.RouteSchema(), required=True, load_from="Routes"
        ),
        "UGN": models.UGNSchema(),
    }


"""
API: UnpublishUGNRouteRule

取消发布云联网路由规则
"""


class UnpublishUGNRouteRuleRequestSchema(schema.RequestSchema):
    """UnpublishUGNRouteRule - 取消发布云联网路由规则"""

    fields = {
        "DeriveRouteRuleId": fields.Str(
            required=True, dump_to="DeriveRouteRuleId"
        ),
        "DeriveRouteTableId": fields.Str(
            required=True, dump_to="DeriveRouteTableId"
        ),
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "UGNId": fields.Str(required=True, dump_to="UGNId"),
    }


class UnpublishUGNRouteRuleResponseSchema(schema.ResponseSchema):
    """UnpublishUGNRouteRule - 取消发布云联网路由规则"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: UpdateUGNBwPackage


"""


class UpdateUGNBwPackageRequestSchema(schema.RequestSchema):
    """UpdateUGNBwPackage -"""

    fields = {
        "BwBidRate": fields.Float(required=True, dump_to="BwBidRate"),
        "BwULRate": fields.Float(required=True, dump_to="BwULRate"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "Coupon": fields.Str(required=False, dump_to="Coupon"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "PackageID": fields.Str(required=True, dump_to="PackageID"),
        "Path": fields.Str(required=True, dump_to="Path"),
        "PayMode": fields.Str(required=True, dump_to="PayMode"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Qos": fields.Str(required=True, dump_to="Qos"),
        "Quantity": fields.Str(required=False, dump_to="Quantity"),
        "RegionA": fields.Str(required=True, dump_to="RegionA"),
        "RegionABwMax": fields.Int(required=True, dump_to="RegionABwMax"),
        "RegionABwMin": fields.Int(required=True, dump_to="RegionABwMin"),
        "RegionB": fields.Str(required=True, dump_to="RegionB"),
        "RegionBBwMax": fields.Int(required=True, dump_to="RegionBBwMax"),
        "RegionBBwMin": fields.Int(required=True, dump_to="RegionBBwMin"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "UGNID": fields.Str(required=True, dump_to="UGNID"),
    }


class UpdateUGNBwPackageResponseSchema(schema.ResponseSchema):
    """UpdateUGNBwPackage -"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }
