""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.upfs.schemas import apis


class UPFSClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(UPFSClient, self).__init__(config, transport, middleware, logger)

    def create_upfs_volume(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateUPFSVolume - 创建UPFS文件系统

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **ProtocolType** (str) - (Required) 文件系统协议，目前仅支持POSIX
        - **Size** (int) - (Required) 文件系统大小，单位为GB，必须为100的整数倍，Size最小为500GB
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **ChargeType** (str) - 计费模式，枚举值为： Year，按年付费； Month，按月付费
        - **CouponId** (str) - 使用的代金券id
        - **Quantity** (int) - 购买时长 默认: 1
        - **Remark** (str) - 备注
        - **Tag** (str) - 文件系统所属业务组
        - **VolumeName** (str) - 文件系统名称

        **Response**

        - **VolumeId** (str) - UPFS文件系统ID
        - **VolumeName** (str) - UPFS文件系统名称

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateUPFSVolumeRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateUPFSVolume", d, **kwargs)
        return apis.CreateUPFSVolumeResponseSchema().loads(resp)

    def describe_upfs_volume(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUPFSVolume - 获取UPFS文件系统列表

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Limit** (int) - 文件列表长度
        - **Offset** (int) - 文件列表起始
        - **VolumeId** (str) - 文件系统ID

        **Response**

        - **DataSet** (list) - 见 **UPFSVolumeInfo** 模型定义
        - **TotalCount** (int) - UPFS文件系统总数

        **Response Model**

        **UPFSVolumeInfo**
        - **ChargeType** (str) - 计费类型
        - **CreateTime** (int) - 文件系统创建时间（unix时间戳）
        - **ExpiredTime** (int) - 文件系统过期时间（unix时间戳）
        - **IsExpired** (str) - 是否过期
        - **MountAddress** (str) - 文件系统挂载地址
        - **MountStatus** (int) - 文件系统挂载状态
        - **ProtocolType** (str) - 文件系统协议类型
        - **Remark** (str) - 文件系统备注信息
        - **Size** (int) - 文件系统大小，单位GB
        - **Tag** (str) - 文件系统所属业务组
        - **VolumeId** (str) - 文件系统ID
        - **VolumeName** (str) - 文件系统名称
        - **Zone** (str) - 可用区名字


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUPFSVolumeRequestSchema().dumps(d)

        resp = self.invoke("DescribeUPFSVolume", d, **kwargs)
        return apis.DescribeUPFSVolumeResponseSchema().loads(resp)

    def describe_upfs_volume_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUPFSVolumePrice - 获取UPFS文件系统价格

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Size** (int) - (Required) 文件系统大小，单位为GB，新架构容量型最小容量为500GB，以100GB递增，最大不超过100TB。
        - **ChargeType** (str) - Year， Month默认: Month
        - **Quantity** (int) - 购买UPFS的时长， 默认为1
        - **VolumeId** (str) - UPFS文件系统id，第一次创建文件系统时不需要传这个参数

        **Response**

        - **DataSet** (list) - 见 **UPFSPriceDataSet** 模型定义

        **Response Model**

        **UPFSPriceDataSet**
        - **ChargeName** (str) - “upfs”
        - **ChargeType** (str) - Year， Month
        - **OriginalPrice** (float) - 原价格 (单位: 分)
        - **Price** (float) - 价格 (单位: 分)


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUPFSVolumePriceRequestSchema().dumps(d)

        resp = self.invoke("DescribeUPFSVolumePrice", d, **kwargs)
        return apis.DescribeUPFSVolumePriceResponseSchema().loads(resp)

    def describe_upfs_volume_upgrade_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUPFSVolumeUpgradePrice - UPFS文件系统扩容价格

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Size** (str) - (Required) 文件系统大小
        - **VolumeId** (str) - (Required) 文件系统ID

        **Response**

        - **OriginalPrice** (float) - 原价格（单位：分）
        - **Price** (float) - 价格（单位：分）

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUPFSVolumeUpgradePriceRequestSchema().dumps(d)

        resp = self.invoke("DescribeUPFSVolumeUpgradePrice", d, **kwargs)
        return apis.DescribeUPFSVolumeUpgradePriceResponseSchema().loads(resp)

    def extend_upfs_volume(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ExtendUPFSVolume - UPFS文件系统扩容

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Size** (int) - (Required) 文件系统大小，单位为GB，最大不超过20T，香港容量型必须为100的整数倍，Size最小为500GB，北京，上海，广州的容量型必须为1024的整数倍，Size最小为1024GB。性能型文件系统Size最小为100GB
        - **VolumeId** (str) - (Required) 文件系统ID

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ExtendUPFSVolumeRequestSchema().dumps(d)

        resp = self.invoke("ExtendUPFSVolume", d, **kwargs)
        return apis.ExtendUPFSVolumeResponseSchema().loads(resp)

    def remove_upfs_volume(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """RemoveUPFSVolume - 删除UPFS文件系统

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **VolumeId** (str) - (Required) 文件系统ID

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.RemoveUPFSVolumeRequestSchema().dumps(d)

        resp = self.invoke("RemoveUPFSVolume", d, **kwargs)
        return apis.RemoveUPFSVolumeResponseSchema().loads(resp)

    def update_upfs_volume_info(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """UpdateUPFSVolumeInfo - 更改UPFS文件系统相关信息（名称／备注）

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **VolumeId** (str) - (Required) UPFS文件系统ID
        - **Remark** (str) - UPFS文件系统备注（文件系统名称／备注至少传入其中一个）
        - **VolumeName** (str) - UPFS文件系统名称（文件系统名称／备注至少传入其中一个）

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.UpdateUPFSVolumeInfoRequestSchema().dumps(d)

        resp = self.invoke("UpdateUPFSVolumeInfo", d, **kwargs)
        return apis.UpdateUPFSVolumeInfoResponseSchema().loads(resp)
