""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.utsdb.schemas import apis


class UTSDBClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(UTSDBClient, self).__init__(config, transport, middleware, logger)

    def check_uinfluxdb_allowance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CheckUInfluxdbAllowance - 检查UInfluxdb剩余资源

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Count** (int) - (Required) 创建实例的数量，[1-10]
        - **CpuLimit** (int) - (Required) 核数 单位：个，范围［2C8G, 4C16G, 8C32G, 16C64G, 32C128G］
        - **MemoryLimit** (int) - (Required) 内存限制 单位：G 范围 [2C8G, 4C16G, 8C32G, 16C64G, 32C128G］
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **Count** (int) - 可创建的数量

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CheckUInfluxdbAllowanceRequestSchema().dumps(d)

        resp = self.invoke("CheckUInfluxdbAllowance", d, **kwargs)
        return apis.CheckUInfluxdbAllowanceResponseSchema().loads(resp)

    def create_uinfluxdb_database(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateUInfluxdbDatabase - 创建Influxdb数据库

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **DatabaseName** (str) - (Required) Influxdb创建的数据库的名称
        - **UInfluxdbId** (str) - (Required) 实例ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **AccoutName** (str) - Influxdb数据库账号
        - **Description** (str) - Influxdb数据库的描述
        - **RetentionPolicy** (str) - 数据保留策略，以天为单位，比如（1d，2d，3d等，inf为永久保留策略，默认为inf）

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateUInfluxdbDatabaseRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateUInfluxdbDatabase", d, **kwargs)
        return apis.CreateUInfluxdbDatabaseResponseSchema().loads(resp)

    def create_uinfluxdb_database_rp(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateUInfluxdbDatabaseRP - 给指定的database创建一个保留策略，最多可以创建10个RP

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **DatabaseName** (str) - (Required) 要创建RP的数据库
        - **RetentionPolicy** (str) - (Required) 数据保留策略，以天为单位，比如（1d，2d，3d等，inf为永久保留策略，默认为inf）
        - **RetentionPolicyName** (str) - (Required) 保留策略名
        - **UInfluxdbId** (str) - (Required) 实例ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **Message** (str) - 如果执行失败, 失败的错误消息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateUInfluxdbDatabaseRPRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateUInfluxdbDatabaseRP", d, **kwargs)
        return apis.CreateUInfluxdbDatabaseRPResponseSchema().loads(resp)

    def create_uinfluxdb_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateUInfluxdbInstance - 创建UInfluxdb实例

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **AccountName** (str) - (Required) 默认账户
        - **ChargeType** (str) - (Required) 付费类型，后付费阶段固定为：后付费（PostPaid）
        - **CpuLimit** (int) - (Required) 核数 单位：个，范围［2C8G, 4C16G, 8C32G, 16C64G, 32C128G］
        - **DatabaseName** (str) - (Required) 数据库名称
        - **MemoryLimit** (int) - (Required) 内存限制 单位：G 范围 [2C8G, 4C16G, 8C32G, 16C64G, 32C128G］
        - **Name** (str) - (Required) 实例名称，长度(6<=size<=63)
        - **Password** (str) - (Required) 默认账户的密码，需要 base64 编码
        - **Quantity** (int) - (Required) 购买时长，默认值1
        - **SubnetId** (str) - (Required) 子网 id
        - **VPCId** (str) - (Required) VPC id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **CouponId** (str) - 使用的代金券id
        - **Tag** (str) - 业务组名称

        **Response**

        - **UInfluxdbId** (str) - 返回的实例id

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateUInfluxdbInstanceRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateUInfluxdbInstance", d, **kwargs)
        return apis.CreateUInfluxdbInstanceResponseSchema().loads(resp)

    def delete_uinfluxdb_database(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteUInfluxdbDatabase - 删除Influxdb实例的数据库

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **DatabaseName** (str) - (Required) 数据库名称
        - **UInfluxdbId** (str) - (Required) 实例id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DeleteUInfluxdbDatabaseRequestSchema().dumps(d)

        resp = self.invoke("DeleteUInfluxdbDatabase", d, **kwargs)
        return apis.DeleteUInfluxdbDatabaseResponseSchema().loads(resp)

    def delete_uinfluxdb_database_rp(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteUInfluxdbDatabaseRP - 删除指定数据库下面的一个数据保留策略

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **DatabaseName** (str) - (Required) 要删除的RP所在数据库
        - **RetentionPolicyName** (str) - (Required) 要删除的保留策略
        - **UInfluxdbId** (str) - (Required) 实例ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **Message** (str) - 如果执行失败, 失败的错误消息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DeleteUInfluxdbDatabaseRPRequestSchema().dumps(d)

        resp = self.invoke("DeleteUInfluxdbDatabaseRP", d, **kwargs)
        return apis.DeleteUInfluxdbDatabaseRPResponseSchema().loads(resp)

    def delete_uinfluxdb_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteUInfluxdbInstance - 删除UInfluxdb实例

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UInfluxdbId** (str) - (Required) UInfluxdb 实例id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DeleteUInfluxdbInstanceRequestSchema().dumps(d)

        resp = self.invoke("DeleteUInfluxdbInstance", d, **kwargs)
        return apis.DeleteUInfluxdbInstanceResponseSchema().loads(resp)

    def describe_uinfluxdb_database(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUInfluxdbDatabase - 描述UInfluxdb数据库

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UInfluxdbId** (str) - (Required)
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **DatabaseName** (str) -
        - **Limit** (int) -
        - **Offset** (int) -

        **Response**

        - **DatabaseInfo** (list) - 见 **DatabaseInfo** 模型定义

        **Response Model**

        **AccountInfo**
        - **Account** (str) - 账户名
        - **Password** (str) - 密码
        - **Privilege** (str) - 权限


        **DatabaseInfo**
        - **AccountInfo** (list) - 见 **AccountInfo** 模型定义
        - **DatabaseName** (str) - 数据库名
        - **Description** (str) - 数据库描述
        - **RetentionPolicy** (str) - 保留策略
        - **State** (str) - 数据库状态


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUInfluxdbDatabaseRequestSchema().dumps(d)

        resp = self.invoke("DescribeUInfluxdbDatabase", d, **kwargs)
        return apis.DescribeUInfluxdbDatabaseResponseSchema().loads(resp)

    def describe_uinfluxdb_database_rp(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUInfluxdbDatabaseRP - 获取指定数据库下面的所有保留策略

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **DatabaseName** (str) - (Required) 数据库名称
        - **UInfluxdbId** (str) - (Required) 实例ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **DataSet** (list) - 见 **RpData** 模型定义
        - **Message** (str) - 如果执行失败, 失败的错误消息

        **Response Model**

        **RpData**
        - **Policy** (str) - 保留策略
        - **RetentionPolicyName** (str) - 保留策略名


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUInfluxdbDatabaseRPRequestSchema().dumps(d)

        resp = self.invoke("DescribeUInfluxdbDatabaseRP", d, **kwargs)
        return apis.DescribeUInfluxdbDatabaseRPResponseSchema().loads(resp)

    def describe_uinfluxdb_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUInfluxdbInstance - 拉取UInfluxdb实例列表

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Limit** (int) - 分页显示数量，列表操作则指定
        - **Offset** (int) - 分页显示起始偏移位置，列表操作则指定
        - **UInfluxdbId** (str) - 指定id的话，会拉取该实例信息，否则拉取该帐号所有信息

        **Response**

        - **DataSet** (list) - 见 **UInfluxdbDataSet** 模型定义

        **Response Model**

        **UInfluxdbDataSet**
        - **AccountName** (str) - 账户名
        - **CPULimit** (int) - 实例核数
        - **ChargeType** (str) - 付费类型，可选值如下: Year: 按年付费 Month: 按月付费 Dynamic: 按需付费(单位: 小时) Trial: 免费试用
        - **CreateTime** (int) - 创建时间
        - **ExpiredTime** (int) - 修改时间
        - **MemoryLimit** (int) - 实例内存
        - **Name** (str) - 实例名称
        - **Port** (int) - 实例端口
        - **State** (str) - 实例状态
        - **SubnetId** (str) - 子网ID
        - **Tag** (str) - 业务组信息
        - **UInfluxdbId** (str) - 实例id
        - **UsedSize** (int) - 硬盘使用量
        - **VPCId** (str) - VPC的ID
        - **VirtualIP** (str) - 实例ip
        - **Zone** (str) - UInfluxdb实例所在可用区


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUInfluxdbInstanceRequestSchema().dumps(d)

        resp = self.invoke("DescribeUInfluxdbInstance", d, **kwargs)
        return apis.DescribeUInfluxdbInstanceResponseSchema().loads(resp)

    def describe_uinfluxdb_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUInfluxdbPrice - 获取UInfluxdb价格

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **CpuLimit** (int) - (Required) 核数 单位：个，规格［2C8G, 4C16G, 8C32G, 16C64G, 32C128G］
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **ChargeType** (str) - 付费类型，后付费。填：PostPaid (后付费)
        - **MemoryLimit** (int) - 内存限制 单位：G 规格 [2C8G, 4C16G, 8C32G, 16C64G, 32C128G］
        - **Quantity** (int) - 付费周期数量

        **Response**

        - **OriginalPrice** (float) - 原价
        - **Price** (float) - 价格

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUInfluxdbPriceRequestSchema().dumps(d)

        resp = self.invoke("DescribeUInfluxdbPrice", d, **kwargs)
        return apis.DescribeUInfluxdbPriceResponseSchema().loads(resp)

    def describe_uinfluxdb_upgrade_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUInfluxdbUpgradePrice - 获取UIfluxdb升降级价格

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **CpuLimit** (int) - (Required) 核数
        - **MemoryLimit** (int) - (Required) 容量，单位GB
        - **UInfluxdbId** (str) - (Required) UInfluxdb 实例id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **OriginalPrice** (float) - 原价
        - **TotalPrice** (float) - 升降级价格

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUInfluxdbUpgradePriceRequestSchema().dumps(d)

        resp = self.invoke("DescribeUInfluxdbUpgradePrice", d, **kwargs)
        return apis.DescribeUInfluxdbUpgradePriceResponseSchema().loads(resp)

    def modify_uinfluxdb_database_policy(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyUInfluxdbDatabasePolicy - 更改UInfluxdb实例数据库数据保留策略

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **DatabaseName** (str) - (Required) 数据库名
        - **RetentionPolicy** (str) - (Required) 数据库数据保留策略。自定义格式如：10d（即10天），2w（即两周），
        - **UInfluxdbId** (str) - (Required) Influxdb实例id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ModifyUInfluxdbDatabasePolicyRequestSchema().dumps(d)

        resp = self.invoke("ModifyUInfluxdbDatabasePolicy", d, **kwargs)
        return apis.ModifyUInfluxdbDatabasePolicyResponseSchema().loads(resp)

    def reboot_uinfluxdb_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """RebootUInfluxdbInstance - 重启UInfluxdb实例

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UInfluxdbId** (str) - (Required) UInfluxdb实例id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.RebootUInfluxdbInstanceRequestSchema().dumps(d)

        resp = self.invoke("RebootUInfluxdbInstance", d, **kwargs)
        return apis.RebootUInfluxdbInstanceResponseSchema().loads(resp)

    def reset_uinfluxdb_instance_name(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ResetUInfluxdbInstanceName - 更改UIfluxdb实例名称

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **NewName** (str) - (Required) 实例的新名字, 长度要求为6~63位
        - **UInfluxdbId** (str) - (Required) UInfluxdb实例id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ResetUInfluxdbInstanceNameRequestSchema().dumps(d)

        resp = self.invoke("ResetUInfluxdbInstanceName", d, **kwargs)
        return apis.ResetUInfluxdbInstanceNameResponseSchema().loads(resp)

    def start_uinfluxdb_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """StartUInfluxdbInstance - 启动UInfluxdb实例

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UInfluxdbId** (str) - (Required) UInfluxdb实例id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.StartUInfluxdbInstanceRequestSchema().dumps(d)

        resp = self.invoke("StartUInfluxdbInstance", d, **kwargs)
        return apis.StartUInfluxdbInstanceResponseSchema().loads(resp)

    def stop_uinfluxdb_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """StopUInfluxdbInstance - 关闭UInfluxdb实例

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UInfluxdbId** (str) - (Required) UInfluxdb实例id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.StopUInfluxdbInstanceRequestSchema().dumps(d)

        resp = self.invoke("StopUInfluxdbInstance", d, **kwargs)
        return apis.StopUInfluxdbInstanceResponseSchema().loads(resp)

    def upgrade_uinfluxdb_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """UpgradeUInfluxdbInstance - UInfluxdb实例配置升降级

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **CpuLimit** (int) - (Required) UInfluxdb 实例 新的核数，单位个
        - **MemoryLimit** (int) - (Required) UInfluxdb 实例 新的内存
        - **UInfluxdbId** (str) - (Required) 实例ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.UpgradeUInfluxdbInstanceRequestSchema().dumps(d)

        resp = self.invoke("UpgradeUInfluxdbInstance", d, **kwargs)
        return apis.UpgradeUInfluxdbInstanceResponseSchema().loads(resp)
