# WARNING THIS FILE IS AUTOGENERATED
#
# Databricks CLI
# Copyright 2017 Databricks, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"), except
# that the use of services to which certain application programming
# interfaces (each, an "API") connect requires that the user first obtain
# a license for the use of the APIs from Databricks, Inc. ("Databricks"),
# by creating an account at www.databricks.com and agreeing to either (a)
# the Community Edition Terms of Service, (b) the Databricks Terms of
# Service, or (c) another written agreement between Licensee and Databricks
# for the use of the APIs.
#
# You may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
class JobsService(object):
    def __init__(self, client):
        self.client = client

    def create_job(self, name=None, existing_cluster_id=None, new_cluster=None, libraries=None,
                   email_notifications=None, timeout_seconds=None, max_retries=None,
                   min_retry_interval_millis=None, retry_on_timeout=None, schedule=None,
                   notebook_task=None, spark_jar_task=None, spark_python_task=None,
                   spark_submit_task=None, max_concurrent_runs=None):
        _data = {}
        if name is not None:
            _data['name'] = name
        if existing_cluster_id is not None:
            _data['existing_cluster_id'] = existing_cluster_id
        if new_cluster is not None:
            _data['new_cluster'] = new_cluster
            if not isinstance(new_cluster, dict):
                raise TypeError('Expected databricks.NewCluster() or dict for field new_cluster')
        if libraries is not None:
            _data['libraries'] = libraries
        if email_notifications is not None:
            _data['email_notifications'] = email_notifications
            if not isinstance(email_notifications, dict):
                raise TypeError('Expected databricks.JobEmailNotifications() or dict for field email_notifications')
        if timeout_seconds is not None:
            _data['timeout_seconds'] = timeout_seconds
        if max_retries is not None:
            _data['max_retries'] = max_retries
        if min_retry_interval_millis is not None:
            _data['min_retry_interval_millis'] = min_retry_interval_millis
        if retry_on_timeout is not None:
            _data['retry_on_timeout'] = retry_on_timeout
        if schedule is not None:
            _data['schedule'] = schedule
            if not isinstance(schedule, dict):
                raise TypeError('Expected databricks.CronSchedule() or dict for field schedule')
        if notebook_task is not None:
            _data['notebook_task'] = notebook_task
            if not isinstance(notebook_task, dict):
                raise TypeError('Expected databricks.NotebookTask() or dict for field notebook_task')
        if spark_jar_task is not None:
            _data['spark_jar_task'] = spark_jar_task
            if not isinstance(spark_jar_task, dict):
                raise TypeError('Expected databricks.SparkJarTask() or dict for field spark_jar_task')
        if spark_python_task is not None:
            _data['spark_python_task'] = spark_python_task
            if not isinstance(spark_python_task, dict):
                raise TypeError('Expected databricks.SparkPythonTask() or dict for field spark_python_task')
        if spark_submit_task is not None:
            _data['spark_submit_task'] = spark_submit_task
            if not isinstance(spark_submit_task, dict):
                raise TypeError('Expected databricks.SparkSubmitTask() or dict for field spark_submit_task')
        if max_concurrent_runs is not None:
            _data['max_concurrent_runs'] = max_concurrent_runs
        return self.client.perform_query('POST', '/jobs/create', data=_data)
    
    def submit_run(self, run_name=None, existing_cluster_id=None, new_cluster=None, libraries=None,
                   notebook_task=None, spark_jar_task=None, spark_python_task=None,
                   spark_submit_task=None, timeout_seconds=None):
        _data = {}
        if run_name is not None:
            _data['run_name'] = run_name
        if existing_cluster_id is not None:
            _data['existing_cluster_id'] = existing_cluster_id
        if new_cluster is not None:
            _data['new_cluster'] = new_cluster
            if not isinstance(new_cluster, dict):
                raise TypeError('Expected databricks.NewCluster() or dict for field new_cluster')
        if libraries is not None:
            _data['libraries'] = libraries
        if notebook_task is not None:
            _data['notebook_task'] = notebook_task
            if not isinstance(notebook_task, dict):
                raise TypeError('Expected databricks.NotebookTask() or dict for field notebook_task')
        if spark_jar_task is not None:
            _data['spark_jar_task'] = spark_jar_task
            if not isinstance(spark_jar_task, dict):
                raise TypeError('Expected databricks.SparkJarTask() or dict for field spark_jar_task')
        if spark_python_task is not None:
            _data['spark_python_task'] = spark_python_task
            if not isinstance(spark_python_task, dict):
                raise TypeError('Expected databricks.SparkPythonTask() or dict for field spark_python_task')
        if spark_submit_task is not None:
            _data['spark_submit_task'] = spark_submit_task
            if not isinstance(spark_submit_task, dict):
                raise TypeError('Expected databricks.SparkSubmitTask() or dict for field spark_submit_task')
        if timeout_seconds is not None:
            _data['timeout_seconds'] = timeout_seconds
        return self.client.perform_query('POST', '/jobs/runs/submit', data=_data)
    
    def reset_job(self, job_id, new_settings):
        _data = {}
        if job_id is not None:
            _data['job_id'] = job_id
        if new_settings is not None:
            _data['new_settings'] = new_settings
            if not isinstance(new_settings, dict):
                raise TypeError('Expected databricks.JobSettings() or dict for field new_settings')
        return self.client.perform_query('POST', '/jobs/reset', data=_data)
    
    def delete_job(self, job_id):
        _data = {}
        if job_id is not None:
            _data['job_id'] = job_id
        return self.client.perform_query('POST', '/jobs/delete', data=_data)
    
    def get_job(self, job_id):
        _data = {}
        if job_id is not None:
            _data['job_id'] = job_id
        return self.client.perform_query('GET', '/jobs/get', data=_data)
    
    def list_jobs(self):
        _data = {}
    
        return self.client.perform_query('GET', '/jobs/list', data=_data)
    
    def run_now(self, job_id=None, jar_params=None, notebook_params=None, python_params=None,
                spark_submit_params=None):
        _data = {}
        if job_id is not None:
            _data['job_id'] = job_id
        if jar_params is not None:
            _data['jar_params'] = jar_params
        if notebook_params is not None:
            _data['notebook_params'] = notebook_params
        if python_params is not None:
            _data['python_params'] = python_params
        if spark_submit_params is not None:
            _data['spark_submit_params'] = spark_submit_params
        return self.client.perform_query('POST', '/jobs/run-now', data=_data)
    
    def list_runs(self, job_id=None, active_only=None, completed_only=None, offset=None,
                  limit=None):
        _data = {}
        if job_id is not None:
            _data['job_id'] = job_id
        if active_only is not None:
            _data['active_only'] = active_only
        if completed_only is not None:
            _data['completed_only'] = completed_only
        if offset is not None:
            _data['offset'] = offset
        if limit is not None:
            _data['limit'] = limit
        return self.client.perform_query('GET', '/jobs/runs/list', data=_data)
    
    def get_run(self, run_id=None):
        _data = {}
        if run_id is not None:
            _data['run_id'] = run_id
        return self.client.perform_query('GET', '/jobs/runs/get', data=_data)
    
    def delete_run(self, run_id=None):
        _data = {}
        if run_id is not None:
            _data['run_id'] = run_id
        return self.client.perform_query('POST', '/jobs/runs/delete', data=_data)
    
    def cancel_run(self, run_id):
        _data = {}
        if run_id is not None:
            _data['run_id'] = run_id
        return self.client.perform_query('POST', '/jobs/runs/cancel', data=_data)
    
    def get_run_output(self, run_id):
        _data = {}
        if run_id is not None:
            _data['run_id'] = run_id
        return self.client.perform_query('GET', '/jobs/runs/get-output', data=_data)
    
    def export_run(self, run_id, views_to_export=None):
        _data = {}
        if run_id is not None:
            _data['run_id'] = run_id
        if views_to_export is not None:
            _data['views_to_export'] = views_to_export
        return self.client.perform_query('GET', '/jobs/runs/export', data=_data)
     

class ClusterService(object):
    def __init__(self, client):
        self.client = client

    def list_clusters(self):
        _data = {}
    
        return self.client.perform_query('GET', '/clusters/list', data=_data)
    
    def create_cluster(self, num_workers=None, autoscale=None, cluster_name=None, spark_version=None,
                       spark_conf=None, aws_attributes=None, node_type_id=None,
                       driver_node_type_id=None, ssh_public_keys=None, custom_tags=None,
                       cluster_log_conf=None, spark_env_vars=None, autotermination_minutes=None,
                       enable_elastic_disk=None, cluster_source=None):
        _data = {}
        if num_workers is not None:
            _data['num_workers'] = num_workers
        if autoscale is not None:
            _data['autoscale'] = autoscale
            if not isinstance(autoscale, dict):
                raise TypeError('Expected databricks.AutoScale() or dict for field autoscale')
        if cluster_name is not None:
            _data['cluster_name'] = cluster_name
        if spark_version is not None:
            _data['spark_version'] = spark_version
        if spark_conf is not None:
            _data['spark_conf'] = spark_conf
        if aws_attributes is not None:
            _data['aws_attributes'] = aws_attributes
            if not isinstance(aws_attributes, dict):
                raise TypeError('Expected databricks.AwsAttributes() or dict for field aws_attributes')
        if node_type_id is not None:
            _data['node_type_id'] = node_type_id
        if driver_node_type_id is not None:
            _data['driver_node_type_id'] = driver_node_type_id
        if ssh_public_keys is not None:
            _data['ssh_public_keys'] = ssh_public_keys
        if custom_tags is not None:
            _data['custom_tags'] = custom_tags
        if cluster_log_conf is not None:
            _data['cluster_log_conf'] = cluster_log_conf
            if not isinstance(cluster_log_conf, dict):
                raise TypeError('Expected databricks.ClusterLogConf() or dict for field cluster_log_conf')
        if spark_env_vars is not None:
            _data['spark_env_vars'] = spark_env_vars
        if autotermination_minutes is not None:
            _data['autotermination_minutes'] = autotermination_minutes
        if enable_elastic_disk is not None:
            _data['enable_elastic_disk'] = enable_elastic_disk
        if cluster_source is not None:
            _data['cluster_source'] = cluster_source
        return self.client.perform_query('POST', '/clusters/create', data=_data)
    
    def start_cluster(self, cluster_id):
        _data = {}
        if cluster_id is not None:
            _data['cluster_id'] = cluster_id
        return self.client.perform_query('POST', '/clusters/start', data=_data)
    
    def list_spark_versions(self):
        _data = {}
    
        return self.client.perform_query('GET', '/clusters/spark-versions', data=_data)
    
    def delete_cluster(self, cluster_id):
        _data = {}
        if cluster_id is not None:
            _data['cluster_id'] = cluster_id
        return self.client.perform_query('POST', '/clusters/delete', data=_data)
    
    def restart_cluster(self, cluster_id):
        _data = {}
        if cluster_id is not None:
            _data['cluster_id'] = cluster_id
        return self.client.perform_query('POST', '/clusters/restart', data=_data)
    
    def resize_cluster(self, cluster_id, num_workers=None, autoscale=None):
        _data = {}
        if cluster_id is not None:
            _data['cluster_id'] = cluster_id
        if num_workers is not None:
            _data['num_workers'] = num_workers
        if autoscale is not None:
            _data['autoscale'] = autoscale
            if not isinstance(autoscale, dict):
                raise TypeError('Expected databricks.AutoScale() or dict for field autoscale')
        return self.client.perform_query('POST', '/clusters/resize', data=_data)
    
    def edit_cluster(self, cluster_id, num_workers=None, autoscale=None, cluster_name=None,
                     spark_version=None, spark_conf=None, aws_attributes=None, node_type_id=None,
                     driver_node_type_id=None, ssh_public_keys=None, custom_tags=None,
                     cluster_log_conf=None, spark_env_vars=None, autotermination_minutes=None,
                     enable_elastic_disk=None, cluster_source=None):
        _data = {}
        if cluster_id is not None:
            _data['cluster_id'] = cluster_id
        if num_workers is not None:
            _data['num_workers'] = num_workers
        if autoscale is not None:
            _data['autoscale'] = autoscale
            if not isinstance(autoscale, dict):
                raise TypeError('Expected databricks.AutoScale() or dict for field autoscale')
        if cluster_name is not None:
            _data['cluster_name'] = cluster_name
        if spark_version is not None:
            _data['spark_version'] = spark_version
        if spark_conf is not None:
            _data['spark_conf'] = spark_conf
        if aws_attributes is not None:
            _data['aws_attributes'] = aws_attributes
            if not isinstance(aws_attributes, dict):
                raise TypeError('Expected databricks.AwsAttributes() or dict for field aws_attributes')
        if node_type_id is not None:
            _data['node_type_id'] = node_type_id
        if driver_node_type_id is not None:
            _data['driver_node_type_id'] = driver_node_type_id
        if ssh_public_keys is not None:
            _data['ssh_public_keys'] = ssh_public_keys
        if custom_tags is not None:
            _data['custom_tags'] = custom_tags
        if cluster_log_conf is not None:
            _data['cluster_log_conf'] = cluster_log_conf
            if not isinstance(cluster_log_conf, dict):
                raise TypeError('Expected databricks.ClusterLogConf() or dict for field cluster_log_conf')
        if spark_env_vars is not None:
            _data['spark_env_vars'] = spark_env_vars
        if autotermination_minutes is not None:
            _data['autotermination_minutes'] = autotermination_minutes
        if enable_elastic_disk is not None:
            _data['enable_elastic_disk'] = enable_elastic_disk
        if cluster_source is not None:
            _data['cluster_source'] = cluster_source
        return self.client.perform_query('POST', '/clusters/edit', data=_data)
    
    def get_cluster(self, cluster_id):
        _data = {}
        if cluster_id is not None:
            _data['cluster_id'] = cluster_id
        return self.client.perform_query('GET', '/clusters/get', data=_data)
    
    def list_node_types(self):
        _data = {}
    
        return self.client.perform_query('GET', '/clusters/list-node-types', data=_data)
    
    def list_available_zones(self):
        _data = {}
    
        return self.client.perform_query('GET', '/clusters/list-zones', data=_data)


class ManagedLibraryService(object):
    def __init__(self, client):
        self.client = client

    def cluster_status(self, cluster_id):
        _data = {}
        if cluster_id is not None:
            _data['cluster_id'] = cluster_id
        return self.client.perform_query('GET', '/libraries/cluster-status', data=_data)
    
    def all_cluster_statuses(self):
        _data = {}
    
        return self.client.perform_query('GET', '/libraries/all-cluster-statuses', data=_data)
    
    def install_libraries(self, cluster_id, libraries=None):
        _data = {}
        if cluster_id is not None:
            _data['cluster_id'] = cluster_id
        if libraries is not None:
            _data['libraries'] = libraries
        return self.client.perform_query('POST', '/libraries/install', data=_data)
    
    def uninstall_libraries(self, cluster_id, libraries=None):
        _data = {}
        if cluster_id is not None:
            _data['cluster_id'] = cluster_id
        if libraries is not None:
            _data['libraries'] = libraries
        return self.client.perform_query('POST', '/libraries/uninstall', data=_data)
     

class DbfsService(object):
    def __init__(self, client):
        self.client = client

    def read(self, path, offset=None, length=None):
        _data = {}
        if path is not None:
            _data['path'] = path
        if offset is not None:
            _data['offset'] = offset
        if length is not None:
            _data['length'] = length
        return self.client.perform_query('GET', '/dbfs/read', data=_data)
    
    def get_status(self, path):
        _data = {}
        if path is not None:
            _data['path'] = path
        return self.client.perform_query('GET', '/dbfs/get-status', data=_data)
    
    def list(self, path):
        _data = {}
        if path is not None:
            _data['path'] = path
        return self.client.perform_query('GET', '/dbfs/list', data=_data)
    
    def put(self, path, contents=None, overwrite=None):
        _data = {}
        if path is not None:
            _data['path'] = path
        if contents is not None:
            _data['contents'] = contents
        if overwrite is not None:
            _data['overwrite'] = overwrite
        return self.client.perform_query('POST', '/dbfs/put', data=_data)
    
    def mkdirs(self, path):
        _data = {}
        if path is not None:
            _data['path'] = path
        return self.client.perform_query('POST', '/dbfs/mkdirs', data=_data)
    
    def move(self, source_path, destination_path):
        _data = {}
        if source_path is not None:
            _data['source_path'] = source_path
        if destination_path is not None:
            _data['destination_path'] = destination_path
        return self.client.perform_query('POST', '/dbfs/move', data=_data)
    
    def delete(self, path, recursive=None):
        _data = {}
        if path is not None:
            _data['path'] = path
        if recursive is not None:
            _data['recursive'] = recursive
        return self.client.perform_query('POST', '/dbfs/delete', data=_data)
    
    def create(self, path, overwrite=None):
        _data = {}
        if path is not None:
            _data['path'] = path
        if overwrite is not None:
            _data['overwrite'] = overwrite
        return self.client.perform_query('POST', '/dbfs/create', data=_data)
    
    def add_block(self, handle, data):
        _data = {}
        if handle is not None:
            _data['handle'] = handle
        if data is not None:
            _data['data'] = data
        return self.client.perform_query('POST', '/dbfs/add-block', data=_data)
    
    def close(self, handle):
        _data = {}
        if handle is not None:
            _data['handle'] = handle
        return self.client.perform_query('POST', '/dbfs/close', data=_data)
     

class WorkspaceService(object):
    def __init__(self, client):
        self.client = client

    def mkdirs(self, path):
        _data = {}
        if path is not None:
            _data['path'] = path
        return self.client.perform_query('POST', '/workspace/mkdirs', data=_data)
    
    def list(self, path):
        _data = {}
        if path is not None:
            _data['path'] = path
        return self.client.perform_query('GET', '/workspace/list', data=_data)
    
    def import_workspace(self, path, format=None, language=None, content=None, overwrite=None):
        _data = {}
        if path is not None:
            _data['path'] = path
        if format is not None:
            _data['format'] = format
        if language is not None:
            _data['language'] = language
        if content is not None:
            _data['content'] = content
        if overwrite is not None:
            _data['overwrite'] = overwrite
        return self.client.perform_query('POST', '/workspace/import', data=_data)
    
    def export_workspace(self, path, format=None, direct_download=None):
        _data = {}
        if path is not None:
            _data['path'] = path
        if format is not None:
            _data['format'] = format
        if direct_download is not None:
            _data['direct_download'] = direct_download
        return self.client.perform_query('GET', '/workspace/export', data=_data)
    
    def delete(self, path, recursive=None):
        _data = {}
        if path is not None:
            _data['path'] = path
        if recursive is not None:
            _data['recursive'] = recursive
        return self.client.perform_query('POST', '/workspace/delete', data=_data)
    
    def get_status(self, path):
        _data = {}
        if path is not None:
            _data['path'] = path
        return self.client.perform_query('GET', '/workspace/get-status', data=_data)
     

class SecretService(object):
    def __init__(self, client):
        self.client = client

    def create_scope(self, scope, initial_manage_principal=None):
        _data = {}
        if scope is not None:
            _data['scope'] = scope
        if initial_manage_principal is not None:
            _data['initial_manage_principal'] = initial_manage_principal
        return self.client.perform_query('POST', '/secret/scopes/create', data=_data)
    
    def delete_scope(self, scope):
        _data = {}
        if scope is not None:
            _data['scope'] = scope
        return self.client.perform_query('POST', '/secret/scopes/delete', data=_data)
    
    def list_scopes(self):
        _data = {}
    
        return self.client.perform_query('GET', '/secret/scopes/list', data=_data)
    
    def write_secret(self, scope, key, string_value=None, bytes_value=None):
        _data = {}
        if scope is not None:
            _data['scope'] = scope
        if key is not None:
            _data['key'] = key
        if string_value is not None:
            _data['string_value'] = string_value
        if bytes_value is not None:
            _data['bytes_value'] = bytes_value
        return self.client.perform_query('POST', '/secret/secrets/write', data=_data)
    
    def delete_secret(self, scope, key):
        _data = {}
        if scope is not None:
            _data['scope'] = scope
        if key is not None:
            _data['key'] = key
        return self.client.perform_query('POST', '/secret/secrets/delete', data=_data)
    
    def list_secrets(self, scope):
        _data = {}
        if scope is not None:
            _data['scope'] = scope
        return self.client.perform_query('GET', '/secret/secrets/list', data=_data)
    
    def write_acl(self, scope, principal, permission):
        _data = {}
        if scope is not None:
            _data['scope'] = scope
        if principal is not None:
            _data['principal'] = principal
        if permission is not None:
            _data['permission'] = permission
        return self.client.perform_query('POST', '/secret/acls/write', data=_data)
    
    def delete_acl(self, scope, principal):
        _data = {}
        if scope is not None:
            _data['scope'] = scope
        if principal is not None:
            _data['principal'] = principal
        return self.client.perform_query('POST', '/secret/acls/delete', data=_data)
    
    def list_acls(self, scope):
        _data = {}
        if scope is not None:
            _data['scope'] = scope
        return self.client.perform_query('GET', '/secret/acls/list', data=_data)
    
    def get_acl(self, scope, principal):
        _data = {}
        if scope is not None:
            _data['scope'] = scope
        if principal is not None:
            _data['principal'] = principal
        return self.client.perform_query('GET', '/secret/acls/get', data=_data)
