"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncryptedFileSystem = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_efs_1 = require("aws-cdk-lib/aws-efs");
const aws_kms_1 = require("aws-cdk-lib/aws-kms");
const constructs_1 = require("constructs");
/**
 * An EncryptedFileSystem.
 */
class EncryptedFileSystem extends constructs_1.Construct {
    /**
     * Creates a new EncryptedFileSystem.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param props - The configuration properties for this construct.
     */
    constructor(scope, id, props) {
        super(scope, id);
        const { removalPolicy } = props;
        const key = props.kmsKey ??
            new aws_kms_1.Key(this, "Key", {
                description: `Created by ${this.node.path}`,
                removalPolicy,
            });
        const fileSystem = new aws_efs_1.FileSystem(this, "FileSystem", {
            ...props,
            encrypted: true,
            kmsKey: key,
            removalPolicy,
        });
        this.key = key;
        this.fileSystem = fileSystem;
    }
}
exports.EncryptedFileSystem = EncryptedFileSystem;
_a = JSII_RTTI_SYMBOL_1;
EncryptedFileSystem[_a] = { fqn: "shady-island.EncryptedFileSystem", version: "0.1.51" };
//# sourceMappingURL=data:application/json;base64,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