import { AutoScalingGroup, AutoScalingGroupProps } from "aws-cdk-lib/aws-autoscaling";
import { Connections, ISecurityGroup, LaunchTemplate, LaunchTemplateProps } from "aws-cdk-lib/aws-ec2";
import { Construct } from "constructs";
import { INetworkInterface } from "./network-interface";
/**
 * Constructor properties for SingletonLaunchTemplate.
 */
export interface SingletonLaunchTemplateProps extends LaunchTemplateProps {
    /**
     * The Elastic Network Interface to use.
     */
    readonly networkInterface: INetworkInterface;
}
/**
 * A launch template bound to a single Elastic Network Interface.
 */
export declare class SingletonLaunchTemplate extends LaunchTemplate {
    /**
     * The network interface used by this launch template.
     */
    readonly networkInterface: INetworkInterface;
    /**
     * Creates a new SingletonLaunchTemplate.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param props - Initialization properties for this construct.
     */
    constructor(scope: Construct, id: string, props: SingletonLaunchTemplateProps);
    get connections(): Connections;
    addSecurityGroup(securityGroup: ISecurityGroup): void;
    /**
     * Creates an auto-scaling group for this launch template.
     *
     * The following properties are ignored (if specified): `launchTemplate`,
     * `minCapacity`, and `maxCapacity`.
     *
     * @param id - The ID of the auto-scaling group.
     * @param props - Constructor properties of the AutoScalingGroup.
     * @returns A new auto-scaling group
     */
    createAutoScalingGroup(id: string, props: AutoScalingGroupProps): AutoScalingGroup;
}
