"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseJsonArrayFromEnv = parseJsonArrayFromEnv;
exports.fetchSecret = fetchSecret;
exports.fetchAllSecrets = fetchAllSecrets;
exports.readRemote = readRemote;
const https = require("https");
// eslint-disable-next-line import/no-extraneous-dependencies
const client_secrets_manager_1 = require("@aws-sdk/client-secrets-manager");
function parseJsonArrayFromEnv(variableName) {
    if (!Object.keys(process.env).includes(variableName)) {
        return [];
    }
    const hydrated = JSON.parse(process.env[variableName]);
    if (!Array.isArray(hydrated)) {
        throw new Error(`The ${variableName} environment variable must be a JSON array`);
    }
    return hydrated;
}
async function fetchSecret(arn, client) {
    console.log(`Requesting decoded secret from Secrets Manager: ${arn}`);
    const output = await client.send(new client_secrets_manager_1.GetSecretValueCommand({ SecretId: arn }));
    return output.SecretString ? JSON.parse(output.SecretString) : {};
}
async function fetchAllSecrets(arns, client) {
    if (arns.length === 0) {
        return [];
    }
    return Promise.all(arns.map((a) => fetchSecret(a, client)));
}
/**
 * Reads an HTTPS resource into a string.
 *
 * We need this function since newer RDS CA certificates aren't in Lambda.
 *
 * @see https://github.com/aws/aws-lambda-base-images/issues/123
 */
function readRemote(url, options) {
    return new Promise((resolve, reject) => {
        https
            .get(url, options || {}, (res) => {
            const data = [];
            res.on("data", (d) => data.push(d));
            res.on("end", () => resolve(Buffer.concat(data)));
        })
            .on("error", (e) => reject(e));
    });
}
//# sourceMappingURL=data:application/json;base64,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