# Copyright (c) 2024, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0
#
# This code was automatically generated across versions from 11.0.3 to 12.4.1. Do not modify it directly.
# This layer exposes the C header to Cython as-is.

from libc.stdint cimport int64_t, uint64_t
from libc.stdio cimport FILE

from .cycublas cimport cublasStatus_t, cublasComputeType_t, CUBLAS_POINTER_MODE_HOST, CUBLAS_POINTER_MODE_DEVICE


###############################################################################
# Types (structs, enums, ...)
###############################################################################

# enums
ctypedef enum cublasLtMatmulTile_t "cublasLtMatmulTile_t":
    CUBLASLT_MATMUL_TILE_UNDEFINED "CUBLASLT_MATMUL_TILE_UNDEFINED" = 0
    CUBLASLT_MATMUL_TILE_8x8 "CUBLASLT_MATMUL_TILE_8x8" = 1
    CUBLASLT_MATMUL_TILE_8x16 "CUBLASLT_MATMUL_TILE_8x16" = 2
    CUBLASLT_MATMUL_TILE_16x8 "CUBLASLT_MATMUL_TILE_16x8" = 3
    CUBLASLT_MATMUL_TILE_8x32 "CUBLASLT_MATMUL_TILE_8x32" = 4
    CUBLASLT_MATMUL_TILE_16x16 "CUBLASLT_MATMUL_TILE_16x16" = 5
    CUBLASLT_MATMUL_TILE_32x8 "CUBLASLT_MATMUL_TILE_32x8" = 6
    CUBLASLT_MATMUL_TILE_8x64 "CUBLASLT_MATMUL_TILE_8x64" = 7
    CUBLASLT_MATMUL_TILE_16x32 "CUBLASLT_MATMUL_TILE_16x32" = 8
    CUBLASLT_MATMUL_TILE_32x16 "CUBLASLT_MATMUL_TILE_32x16" = 9
    CUBLASLT_MATMUL_TILE_64x8 "CUBLASLT_MATMUL_TILE_64x8" = 10
    CUBLASLT_MATMUL_TILE_32x32 "CUBLASLT_MATMUL_TILE_32x32" = 11
    CUBLASLT_MATMUL_TILE_32x64 "CUBLASLT_MATMUL_TILE_32x64" = 12
    CUBLASLT_MATMUL_TILE_64x32 "CUBLASLT_MATMUL_TILE_64x32" = 13
    CUBLASLT_MATMUL_TILE_32x128 "CUBLASLT_MATMUL_TILE_32x128" = 14
    CUBLASLT_MATMUL_TILE_64x64 "CUBLASLT_MATMUL_TILE_64x64" = 15
    CUBLASLT_MATMUL_TILE_128x32 "CUBLASLT_MATMUL_TILE_128x32" = 16
    CUBLASLT_MATMUL_TILE_64x128 "CUBLASLT_MATMUL_TILE_64x128" = 17
    CUBLASLT_MATMUL_TILE_128x64 "CUBLASLT_MATMUL_TILE_128x64" = 18
    CUBLASLT_MATMUL_TILE_64x256 "CUBLASLT_MATMUL_TILE_64x256" = 19
    CUBLASLT_MATMUL_TILE_128x128 "CUBLASLT_MATMUL_TILE_128x128" = 20
    CUBLASLT_MATMUL_TILE_256x64 "CUBLASLT_MATMUL_TILE_256x64" = 21
    CUBLASLT_MATMUL_TILE_64x512 "CUBLASLT_MATMUL_TILE_64x512" = 22
    CUBLASLT_MATMUL_TILE_128x256 "CUBLASLT_MATMUL_TILE_128x256" = 23
    CUBLASLT_MATMUL_TILE_256x128 "CUBLASLT_MATMUL_TILE_256x128" = 24
    CUBLASLT_MATMUL_TILE_512x64 "CUBLASLT_MATMUL_TILE_512x64" = 25
    CUBLASLT_MATMUL_TILE_64x96 "CUBLASLT_MATMUL_TILE_64x96" = 26
    CUBLASLT_MATMUL_TILE_96x64 "CUBLASLT_MATMUL_TILE_96x64" = 27
    CUBLASLT_MATMUL_TILE_96x128 "CUBLASLT_MATMUL_TILE_96x128" = 28
    CUBLASLT_MATMUL_TILE_128x160 "CUBLASLT_MATMUL_TILE_128x160" = 29
    CUBLASLT_MATMUL_TILE_160x128 "CUBLASLT_MATMUL_TILE_160x128" = 30
    CUBLASLT_MATMUL_TILE_192x128 "CUBLASLT_MATMUL_TILE_192x128" = 31
    CUBLASLT_MATMUL_TILE_128x192 "CUBLASLT_MATMUL_TILE_128x192" = 32
    CUBLASLT_MATMUL_TILE_128x96 "CUBLASLT_MATMUL_TILE_128x96" = 33
    CUBLASLT_MATMUL_TILE_32x256 "CUBLASLT_MATMUL_TILE_32x256" = 34
    CUBLASLT_MATMUL_TILE_256x32 "CUBLASLT_MATMUL_TILE_256x32" = 35

ctypedef enum cublasLtMatmulStages_t "cublasLtMatmulStages_t":
    CUBLASLT_MATMUL_STAGES_UNDEFINED "CUBLASLT_MATMUL_STAGES_UNDEFINED" = 0
    CUBLASLT_MATMUL_STAGES_16x1 "CUBLASLT_MATMUL_STAGES_16x1" = 1
    CUBLASLT_MATMUL_STAGES_16x2 "CUBLASLT_MATMUL_STAGES_16x2" = 2
    CUBLASLT_MATMUL_STAGES_16x3 "CUBLASLT_MATMUL_STAGES_16x3" = 3
    CUBLASLT_MATMUL_STAGES_16x4 "CUBLASLT_MATMUL_STAGES_16x4" = 4
    CUBLASLT_MATMUL_STAGES_16x5 "CUBLASLT_MATMUL_STAGES_16x5" = 5
    CUBLASLT_MATMUL_STAGES_16x6 "CUBLASLT_MATMUL_STAGES_16x6" = 6
    CUBLASLT_MATMUL_STAGES_32x1 "CUBLASLT_MATMUL_STAGES_32x1" = 7
    CUBLASLT_MATMUL_STAGES_32x2 "CUBLASLT_MATMUL_STAGES_32x2" = 8
    CUBLASLT_MATMUL_STAGES_32x3 "CUBLASLT_MATMUL_STAGES_32x3" = 9
    CUBLASLT_MATMUL_STAGES_32x4 "CUBLASLT_MATMUL_STAGES_32x4" = 10
    CUBLASLT_MATMUL_STAGES_32x5 "CUBLASLT_MATMUL_STAGES_32x5" = 11
    CUBLASLT_MATMUL_STAGES_32x6 "CUBLASLT_MATMUL_STAGES_32x6" = 12
    CUBLASLT_MATMUL_STAGES_64x1 "CUBLASLT_MATMUL_STAGES_64x1" = 13
    CUBLASLT_MATMUL_STAGES_64x2 "CUBLASLT_MATMUL_STAGES_64x2" = 14
    CUBLASLT_MATMUL_STAGES_64x3 "CUBLASLT_MATMUL_STAGES_64x3" = 15
    CUBLASLT_MATMUL_STAGES_64x4 "CUBLASLT_MATMUL_STAGES_64x4" = 16
    CUBLASLT_MATMUL_STAGES_64x5 "CUBLASLT_MATMUL_STAGES_64x5" = 17
    CUBLASLT_MATMUL_STAGES_64x6 "CUBLASLT_MATMUL_STAGES_64x6" = 18
    CUBLASLT_MATMUL_STAGES_128x1 "CUBLASLT_MATMUL_STAGES_128x1" = 19
    CUBLASLT_MATMUL_STAGES_128x2 "CUBLASLT_MATMUL_STAGES_128x2" = 20
    CUBLASLT_MATMUL_STAGES_128x3 "CUBLASLT_MATMUL_STAGES_128x3" = 21
    CUBLASLT_MATMUL_STAGES_128x4 "CUBLASLT_MATMUL_STAGES_128x4" = 22
    CUBLASLT_MATMUL_STAGES_128x5 "CUBLASLT_MATMUL_STAGES_128x5" = 23
    CUBLASLT_MATMUL_STAGES_128x6 "CUBLASLT_MATMUL_STAGES_128x6" = 24
    CUBLASLT_MATMUL_STAGES_32x10 "CUBLASLT_MATMUL_STAGES_32x10" = 25
    CUBLASLT_MATMUL_STAGES_8x4 "CUBLASLT_MATMUL_STAGES_8x4" = 26
    CUBLASLT_MATMUL_STAGES_16x10 "CUBLASLT_MATMUL_STAGES_16x10" = 27
    CUBLASLT_MATMUL_STAGES_8x5 "CUBLASLT_MATMUL_STAGES_8x5" = 28
    CUBLASLT_MATMUL_STAGES_8x3 "CUBLASLT_MATMUL_STAGES_8x3" = 31
    CUBLASLT_MATMUL_STAGES_8xAUTO "CUBLASLT_MATMUL_STAGES_8xAUTO" = 32
    CUBLASLT_MATMUL_STAGES_16xAUTO "CUBLASLT_MATMUL_STAGES_16xAUTO" = 33
    CUBLASLT_MATMUL_STAGES_32xAUTO "CUBLASLT_MATMUL_STAGES_32xAUTO" = 34
    CUBLASLT_MATMUL_STAGES_64xAUTO "CUBLASLT_MATMUL_STAGES_64xAUTO" = 35
    CUBLASLT_MATMUL_STAGES_128xAUTO "CUBLASLT_MATMUL_STAGES_128xAUTO" = 36
    CUBLASLT_MATMUL_STAGES_16x80 "CUBLASLT_MATMUL_STAGES_16x80" = 29
    CUBLASLT_MATMUL_STAGES_64x80 "CUBLASLT_MATMUL_STAGES_64x80" = 30

ctypedef enum cublasLtPointerMode_t "cublasLtPointerMode_t":
    CUBLASLT_POINTER_MODE_HOST "CUBLASLT_POINTER_MODE_HOST" = CUBLAS_POINTER_MODE_HOST
    CUBLASLT_POINTER_MODE_DEVICE "CUBLASLT_POINTER_MODE_DEVICE" = CUBLAS_POINTER_MODE_DEVICE
    CUBLASLT_POINTER_MODE_DEVICE_VECTOR "CUBLASLT_POINTER_MODE_DEVICE_VECTOR" = 2
    CUBLASLT_POINTER_MODE_ALPHA_DEVICE_VECTOR_BETA_ZERO "CUBLASLT_POINTER_MODE_ALPHA_DEVICE_VECTOR_BETA_ZERO" = 3
    CUBLASLT_POINTER_MODE_ALPHA_DEVICE_VECTOR_BETA_HOST "CUBLASLT_POINTER_MODE_ALPHA_DEVICE_VECTOR_BETA_HOST" = 4

ctypedef enum cublasLtPointerModeMask_t "cublasLtPointerModeMask_t":
    CUBLASLT_POINTER_MODE_MASK_HOST "CUBLASLT_POINTER_MODE_MASK_HOST" = 1
    CUBLASLT_POINTER_MODE_MASK_DEVICE "CUBLASLT_POINTER_MODE_MASK_DEVICE" = 2
    CUBLASLT_POINTER_MODE_MASK_DEVICE_VECTOR "CUBLASLT_POINTER_MODE_MASK_DEVICE_VECTOR" = 4
    CUBLASLT_POINTER_MODE_MASK_ALPHA_DEVICE_VECTOR_BETA_ZERO "CUBLASLT_POINTER_MODE_MASK_ALPHA_DEVICE_VECTOR_BETA_ZERO" = 8
    CUBLASLT_POINTER_MODE_MASK_ALPHA_DEVICE_VECTOR_BETA_HOST "CUBLASLT_POINTER_MODE_MASK_ALPHA_DEVICE_VECTOR_BETA_HOST" = 16
    CUBLASLT_POINTER_MODE_MASK_NO_FILTERING "CUBLASLT_POINTER_MODE_MASK_NO_FILTERING" = 0

ctypedef enum cublasLtOrder_t "cublasLtOrder_t":
    CUBLASLT_ORDER_COL "CUBLASLT_ORDER_COL" = 0
    CUBLASLT_ORDER_ROW "CUBLASLT_ORDER_ROW" = 1
    CUBLASLT_ORDER_COL32 "CUBLASLT_ORDER_COL32" = 2
    CUBLASLT_ORDER_COL4_4R2_8C "CUBLASLT_ORDER_COL4_4R2_8C" = 3
    CUBLASLT_ORDER_COL32_2R_4R4 "CUBLASLT_ORDER_COL32_2R_4R4" = 4

ctypedef enum cublasLtMatrixLayoutAttribute_t "cublasLtMatrixLayoutAttribute_t":
    CUBLASLT_MATRIX_LAYOUT_TYPE "CUBLASLT_MATRIX_LAYOUT_TYPE" = 0
    CUBLASLT_MATRIX_LAYOUT_ORDER "CUBLASLT_MATRIX_LAYOUT_ORDER" = 1
    CUBLASLT_MATRIX_LAYOUT_ROWS "CUBLASLT_MATRIX_LAYOUT_ROWS" = 2
    CUBLASLT_MATRIX_LAYOUT_COLS "CUBLASLT_MATRIX_LAYOUT_COLS" = 3
    CUBLASLT_MATRIX_LAYOUT_LD "CUBLASLT_MATRIX_LAYOUT_LD" = 4
    CUBLASLT_MATRIX_LAYOUT_BATCH_COUNT "CUBLASLT_MATRIX_LAYOUT_BATCH_COUNT" = 5
    CUBLASLT_MATRIX_LAYOUT_STRIDED_BATCH_OFFSET "CUBLASLT_MATRIX_LAYOUT_STRIDED_BATCH_OFFSET" = 6
    CUBLASLT_MATRIX_LAYOUT_PLANE_OFFSET "CUBLASLT_MATRIX_LAYOUT_PLANE_OFFSET" = 7

ctypedef enum cublasLtMatmulDescAttributes_t "cublasLtMatmulDescAttributes_t":
    CUBLASLT_MATMUL_DESC_COMPUTE_TYPE "CUBLASLT_MATMUL_DESC_COMPUTE_TYPE" = 0
    CUBLASLT_MATMUL_DESC_SCALE_TYPE "CUBLASLT_MATMUL_DESC_SCALE_TYPE" = 1
    CUBLASLT_MATMUL_DESC_POINTER_MODE "CUBLASLT_MATMUL_DESC_POINTER_MODE" = 2
    CUBLASLT_MATMUL_DESC_TRANSA "CUBLASLT_MATMUL_DESC_TRANSA" = 3
    CUBLASLT_MATMUL_DESC_TRANSB "CUBLASLT_MATMUL_DESC_TRANSB" = 4
    CUBLASLT_MATMUL_DESC_TRANSC "CUBLASLT_MATMUL_DESC_TRANSC" = 5
    CUBLASLT_MATMUL_DESC_FILL_MODE "CUBLASLT_MATMUL_DESC_FILL_MODE" = 6
    CUBLASLT_MATMUL_DESC_EPILOGUE "CUBLASLT_MATMUL_DESC_EPILOGUE" = 7
    CUBLASLT_MATMUL_DESC_BIAS_POINTER "CUBLASLT_MATMUL_DESC_BIAS_POINTER" = 8
    CUBLASLT_MATMUL_DESC_BIAS_BATCH_STRIDE "CUBLASLT_MATMUL_DESC_BIAS_BATCH_STRIDE" = 10
    CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_POINTER "CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_POINTER" = 11
    CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_LD "CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_LD" = 12
    CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_BATCH_STRIDE "CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_BATCH_STRIDE" = 13
    CUBLASLT_MATMUL_DESC_ALPHA_VECTOR_BATCH_STRIDE "CUBLASLT_MATMUL_DESC_ALPHA_VECTOR_BATCH_STRIDE" = 14
    CUBLASLT_MATMUL_DESC_SM_COUNT_TARGET "CUBLASLT_MATMUL_DESC_SM_COUNT_TARGET" = 15
    CUBLASLT_MATMUL_DESC_A_SCALE_POINTER "CUBLASLT_MATMUL_DESC_A_SCALE_POINTER" = 17
    CUBLASLT_MATMUL_DESC_B_SCALE_POINTER "CUBLASLT_MATMUL_DESC_B_SCALE_POINTER" = 18
    CUBLASLT_MATMUL_DESC_C_SCALE_POINTER "CUBLASLT_MATMUL_DESC_C_SCALE_POINTER" = 19
    CUBLASLT_MATMUL_DESC_D_SCALE_POINTER "CUBLASLT_MATMUL_DESC_D_SCALE_POINTER" = 20
    CUBLASLT_MATMUL_DESC_AMAX_D_POINTER "CUBLASLT_MATMUL_DESC_AMAX_D_POINTER" = 21
    CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_DATA_TYPE "CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_DATA_TYPE" = 22
    CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_SCALE_POINTER "CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_SCALE_POINTER" = 23
    CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_AMAX_POINTER "CUBLASLT_MATMUL_DESC_EPILOGUE_AUX_AMAX_POINTER" = 24
    CUBLASLT_MATMUL_DESC_FAST_ACCUM "CUBLASLT_MATMUL_DESC_FAST_ACCUM" = 25
    CUBLASLT_MATMUL_DESC_BIAS_DATA_TYPE "CUBLASLT_MATMUL_DESC_BIAS_DATA_TYPE" = 26
    CUBLASLT_MATMUL_DESC_ATOMIC_SYNC_NUM_CHUNKS_D_ROWS "CUBLASLT_MATMUL_DESC_ATOMIC_SYNC_NUM_CHUNKS_D_ROWS" = 27
    CUBLASLT_MATMUL_DESC_ATOMIC_SYNC_NUM_CHUNKS_D_COLS "CUBLASLT_MATMUL_DESC_ATOMIC_SYNC_NUM_CHUNKS_D_COLS" = 28
    CUBLASLT_MATMUL_DESC_ATOMIC_SYNC_IN_COUNTERS_POINTER "CUBLASLT_MATMUL_DESC_ATOMIC_SYNC_IN_COUNTERS_POINTER" = 29
    CUBLASLT_MATMUL_DESC_ATOMIC_SYNC_OUT_COUNTERS_POINTER "CUBLASLT_MATMUL_DESC_ATOMIC_SYNC_OUT_COUNTERS_POINTER" = 30

ctypedef enum cublasLtMatrixTransformDescAttributes_t "cublasLtMatrixTransformDescAttributes_t":
    CUBLASLT_MATRIX_TRANSFORM_DESC_SCALE_TYPE "CUBLASLT_MATRIX_TRANSFORM_DESC_SCALE_TYPE"
    CUBLASLT_MATRIX_TRANSFORM_DESC_POINTER_MODE "CUBLASLT_MATRIX_TRANSFORM_DESC_POINTER_MODE"
    CUBLASLT_MATRIX_TRANSFORM_DESC_TRANSA "CUBLASLT_MATRIX_TRANSFORM_DESC_TRANSA"
    CUBLASLT_MATRIX_TRANSFORM_DESC_TRANSB "CUBLASLT_MATRIX_TRANSFORM_DESC_TRANSB"

ctypedef enum cublasLtReductionScheme_t "cublasLtReductionScheme_t":
    CUBLASLT_REDUCTION_SCHEME_NONE "CUBLASLT_REDUCTION_SCHEME_NONE" = 0
    CUBLASLT_REDUCTION_SCHEME_INPLACE "CUBLASLT_REDUCTION_SCHEME_INPLACE" = 1
    CUBLASLT_REDUCTION_SCHEME_COMPUTE_TYPE "CUBLASLT_REDUCTION_SCHEME_COMPUTE_TYPE" = 2
    CUBLASLT_REDUCTION_SCHEME_OUTPUT_TYPE "CUBLASLT_REDUCTION_SCHEME_OUTPUT_TYPE" = 4
    CUBLASLT_REDUCTION_SCHEME_MASK "CUBLASLT_REDUCTION_SCHEME_MASK" = 0x7

ctypedef enum cublasLtEpilogue_t "cublasLtEpilogue_t":
    CUBLASLT_EPILOGUE_DEFAULT "CUBLASLT_EPILOGUE_DEFAULT" = 1
    CUBLASLT_EPILOGUE_RELU "CUBLASLT_EPILOGUE_RELU" = 2
    CUBLASLT_EPILOGUE_RELU_AUX "CUBLASLT_EPILOGUE_RELU_AUX" = CUBLASLT_EPILOGUE_RELU | 128
    CUBLASLT_EPILOGUE_BIAS "CUBLASLT_EPILOGUE_BIAS" = 4
    CUBLASLT_EPILOGUE_RELU_BIAS "CUBLASLT_EPILOGUE_RELU_BIAS" = CUBLASLT_EPILOGUE_RELU | CUBLASLT_EPILOGUE_BIAS
    CUBLASLT_EPILOGUE_RELU_AUX_BIAS "CUBLASLT_EPILOGUE_RELU_AUX_BIAS" = CUBLASLT_EPILOGUE_RELU_AUX | CUBLASLT_EPILOGUE_BIAS
    CUBLASLT_EPILOGUE_DRELU "CUBLASLT_EPILOGUE_DRELU" = 8 | 128
    CUBLASLT_EPILOGUE_DRELU_BGRAD "CUBLASLT_EPILOGUE_DRELU_BGRAD" = CUBLASLT_EPILOGUE_DRELU | 16
    CUBLASLT_EPILOGUE_GELU "CUBLASLT_EPILOGUE_GELU" = 32
    CUBLASLT_EPILOGUE_GELU_AUX "CUBLASLT_EPILOGUE_GELU_AUX" = CUBLASLT_EPILOGUE_GELU | 128
    CUBLASLT_EPILOGUE_GELU_BIAS "CUBLASLT_EPILOGUE_GELU_BIAS" = CUBLASLT_EPILOGUE_GELU | CUBLASLT_EPILOGUE_BIAS
    CUBLASLT_EPILOGUE_GELU_AUX_BIAS "CUBLASLT_EPILOGUE_GELU_AUX_BIAS" = CUBLASLT_EPILOGUE_GELU_AUX | CUBLASLT_EPILOGUE_BIAS
    CUBLASLT_EPILOGUE_DGELU "CUBLASLT_EPILOGUE_DGELU" = 64 | 128
    CUBLASLT_EPILOGUE_DGELU_BGRAD "CUBLASLT_EPILOGUE_DGELU_BGRAD" = CUBLASLT_EPILOGUE_DGELU | 16
    CUBLASLT_EPILOGUE_BGRADA "CUBLASLT_EPILOGUE_BGRADA" = 256
    CUBLASLT_EPILOGUE_BGRADB "CUBLASLT_EPILOGUE_BGRADB" = 512

ctypedef enum cublasLtMatmulSearch_t "cublasLtMatmulSearch_t":
    CUBLASLT_SEARCH_BEST_FIT "CUBLASLT_SEARCH_BEST_FIT" = 0
    CUBLASLT_SEARCH_LIMITED_BY_ALGO_ID "CUBLASLT_SEARCH_LIMITED_BY_ALGO_ID" = 1
    CUBLASLT_SEARCH_RESERVED_02 "CUBLASLT_SEARCH_RESERVED_02" = 2
    CUBLASLT_SEARCH_RESERVED_03 "CUBLASLT_SEARCH_RESERVED_03" = 3
    CUBLASLT_SEARCH_RESERVED_04 "CUBLASLT_SEARCH_RESERVED_04" = 4
    CUBLASLT_SEARCH_RESERVED_05 "CUBLASLT_SEARCH_RESERVED_05" = 5

ctypedef enum cublasLtMatmulPreferenceAttributes_t "cublasLtMatmulPreferenceAttributes_t":
    CUBLASLT_MATMUL_PREF_SEARCH_MODE "CUBLASLT_MATMUL_PREF_SEARCH_MODE" = 0
    CUBLASLT_MATMUL_PREF_MAX_WORKSPACE_BYTES "CUBLASLT_MATMUL_PREF_MAX_WORKSPACE_BYTES" = 1
    CUBLASLT_MATMUL_PREF_REDUCTION_SCHEME_MASK "CUBLASLT_MATMUL_PREF_REDUCTION_SCHEME_MASK" = 3
    CUBLASLT_MATMUL_PREF_MIN_ALIGNMENT_A_BYTES "CUBLASLT_MATMUL_PREF_MIN_ALIGNMENT_A_BYTES" = 5
    CUBLASLT_MATMUL_PREF_MIN_ALIGNMENT_B_BYTES "CUBLASLT_MATMUL_PREF_MIN_ALIGNMENT_B_BYTES" = 6
    CUBLASLT_MATMUL_PREF_MIN_ALIGNMENT_C_BYTES "CUBLASLT_MATMUL_PREF_MIN_ALIGNMENT_C_BYTES" = 7
    CUBLASLT_MATMUL_PREF_MIN_ALIGNMENT_D_BYTES "CUBLASLT_MATMUL_PREF_MIN_ALIGNMENT_D_BYTES" = 8
    CUBLASLT_MATMUL_PREF_MAX_WAVES_COUNT "CUBLASLT_MATMUL_PREF_MAX_WAVES_COUNT" = 9
    CUBLASLT_MATMUL_PREF_IMPL_MASK "CUBLASLT_MATMUL_PREF_IMPL_MASK" = 12
    CUBLASLT_MATMUL_PREF_MATH_MODE_MASK "CUBLASLT_MATMUL_PREF_MATH_MODE_MASK" = 2
    CUBLASLT_MATMUL_PREF_GAUSSIAN_MODE_MASK "CUBLASLT_MATMUL_PREF_GAUSSIAN_MODE_MASK" = 4
    CUBLASLT_MATMUL_PREF_POINTER_MODE_MASK "CUBLASLT_MATMUL_PREF_POINTER_MODE_MASK" = 10
    CUBLASLT_MATMUL_PREF_EPILOGUE_MASK "CUBLASLT_MATMUL_PREF_EPILOGUE_MASK" = 11
    CUBLASLT_MATMUL_PREF_SM_COUNT_TARGET "CUBLASLT_MATMUL_PREF_SM_COUNT_TARGET" = 13

ctypedef enum cublasLtMatmulAlgoCapAttributes_t "cublasLtMatmulAlgoCapAttributes_t":
    CUBLASLT_ALGO_CAP_SPLITK_SUPPORT "CUBLASLT_ALGO_CAP_SPLITK_SUPPORT" = 0
    CUBLASLT_ALGO_CAP_REDUCTION_SCHEME_MASK "CUBLASLT_ALGO_CAP_REDUCTION_SCHEME_MASK" = 1
    CUBLASLT_ALGO_CAP_CTA_SWIZZLING_SUPPORT "CUBLASLT_ALGO_CAP_CTA_SWIZZLING_SUPPORT" = 2
    CUBLASLT_ALGO_CAP_STRIDED_BATCH_SUPPORT "CUBLASLT_ALGO_CAP_STRIDED_BATCH_SUPPORT" = 3
    CUBLASLT_ALGO_CAP_OUT_OF_PLACE_RESULT_SUPPORT "CUBLASLT_ALGO_CAP_OUT_OF_PLACE_RESULT_SUPPORT" = 4
    CUBLASLT_ALGO_CAP_UPLO_SUPPORT "CUBLASLT_ALGO_CAP_UPLO_SUPPORT" = 5
    CUBLASLT_ALGO_CAP_TILE_IDS "CUBLASLT_ALGO_CAP_TILE_IDS" = 6
    CUBLASLT_ALGO_CAP_CUSTOM_OPTION_MAX "CUBLASLT_ALGO_CAP_CUSTOM_OPTION_MAX" = 7
    CUBLASLT_ALGO_CAP_CUSTOM_MEMORY_ORDER "CUBLASLT_ALGO_CAP_CUSTOM_MEMORY_ORDER" = 10
    CUBLASLT_ALGO_CAP_POINTER_MODE_MASK "CUBLASLT_ALGO_CAP_POINTER_MODE_MASK" = 11
    CUBLASLT_ALGO_CAP_EPILOGUE_MASK "CUBLASLT_ALGO_CAP_EPILOGUE_MASK" = 12
    CUBLASLT_ALGO_CAP_STAGES_IDS "CUBLASLT_ALGO_CAP_STAGES_IDS" = 13
    CUBLASLT_ALGO_CAP_LD_NEGATIVE "CUBLASLT_ALGO_CAP_LD_NEGATIVE" = 14
    CUBLASLT_ALGO_CAP_NUMERICAL_IMPL_FLAGS "CUBLASLT_ALGO_CAP_NUMERICAL_IMPL_FLAGS" = 15
    CUBLASLT_ALGO_CAP_MIN_ALIGNMENT_A_BYTES "CUBLASLT_ALGO_CAP_MIN_ALIGNMENT_A_BYTES" = 16
    CUBLASLT_ALGO_CAP_MIN_ALIGNMENT_B_BYTES "CUBLASLT_ALGO_CAP_MIN_ALIGNMENT_B_BYTES" = 17
    CUBLASLT_ALGO_CAP_MIN_ALIGNMENT_C_BYTES "CUBLASLT_ALGO_CAP_MIN_ALIGNMENT_C_BYTES" = 18
    CUBLASLT_ALGO_CAP_MIN_ALIGNMENT_D_BYTES "CUBLASLT_ALGO_CAP_MIN_ALIGNMENT_D_BYTES" = 19
    CUBLASLT_ALGO_CAP_ATOMIC_SYNC "CUBLASLT_ALGO_CAP_ATOMIC_SYNC" = 20
    CUBLASLT_ALGO_CAP_MATHMODE_IMPL "CUBLASLT_ALGO_CAP_MATHMODE_IMPL" = 8
    CUBLASLT_ALGO_CAP_GAUSSIAN_IMPL "CUBLASLT_ALGO_CAP_GAUSSIAN_IMPL" = 9

ctypedef enum cublasLtMatmulAlgoConfigAttributes_t "cublasLtMatmulAlgoConfigAttributes_t":
    CUBLASLT_ALGO_CONFIG_ID "CUBLASLT_ALGO_CONFIG_ID" = 0
    CUBLASLT_ALGO_CONFIG_TILE_ID "CUBLASLT_ALGO_CONFIG_TILE_ID" = 1
    CUBLASLT_ALGO_CONFIG_SPLITK_NUM "CUBLASLT_ALGO_CONFIG_SPLITK_NUM" = 2
    CUBLASLT_ALGO_CONFIG_REDUCTION_SCHEME "CUBLASLT_ALGO_CONFIG_REDUCTION_SCHEME" = 3
    CUBLASLT_ALGO_CONFIG_CTA_SWIZZLING "CUBLASLT_ALGO_CONFIG_CTA_SWIZZLING" = 4
    CUBLASLT_ALGO_CONFIG_CUSTOM_OPTION "CUBLASLT_ALGO_CONFIG_CUSTOM_OPTION" = 5
    CUBLASLT_ALGO_CONFIG_STAGES_ID "CUBLASLT_ALGO_CONFIG_STAGES_ID" = 6
    CUBLASLT_ALGO_CONFIG_INNER_SHAPE_ID "CUBLASLT_ALGO_CONFIG_INNER_SHAPE_ID" = 7
    CUBLASLT_ALGO_CONFIG_CLUSTER_SHAPE_ID "CUBLASLT_ALGO_CONFIG_CLUSTER_SHAPE_ID" = 8

ctypedef enum cublasLtClusterShape_t "cublasLtClusterShape_t":
    CUBLASLT_CLUSTER_SHAPE_AUTO "CUBLASLT_CLUSTER_SHAPE_AUTO" = 0
    CUBLASLT_CLUSTER_SHAPE_1x1x1 "CUBLASLT_CLUSTER_SHAPE_1x1x1" = 2
    CUBLASLT_CLUSTER_SHAPE_2x1x1 "CUBLASLT_CLUSTER_SHAPE_2x1x1" = 3
    CUBLASLT_CLUSTER_SHAPE_4x1x1 "CUBLASLT_CLUSTER_SHAPE_4x1x1" = 4
    CUBLASLT_CLUSTER_SHAPE_1x2x1 "CUBLASLT_CLUSTER_SHAPE_1x2x1" = 5
    CUBLASLT_CLUSTER_SHAPE_2x2x1 "CUBLASLT_CLUSTER_SHAPE_2x2x1" = 6
    CUBLASLT_CLUSTER_SHAPE_4x2x1 "CUBLASLT_CLUSTER_SHAPE_4x2x1" = 7
    CUBLASLT_CLUSTER_SHAPE_1x4x1 "CUBLASLT_CLUSTER_SHAPE_1x4x1" = 8
    CUBLASLT_CLUSTER_SHAPE_2x4x1 "CUBLASLT_CLUSTER_SHAPE_2x4x1" = 9
    CUBLASLT_CLUSTER_SHAPE_4x4x1 "CUBLASLT_CLUSTER_SHAPE_4x4x1" = 10
    CUBLASLT_CLUSTER_SHAPE_8x1x1 "CUBLASLT_CLUSTER_SHAPE_8x1x1" = 11
    CUBLASLT_CLUSTER_SHAPE_1x8x1 "CUBLASLT_CLUSTER_SHAPE_1x8x1" = 12
    CUBLASLT_CLUSTER_SHAPE_8x2x1 "CUBLASLT_CLUSTER_SHAPE_8x2x1" = 13
    CUBLASLT_CLUSTER_SHAPE_2x8x1 "CUBLASLT_CLUSTER_SHAPE_2x8x1" = 14
    CUBLASLT_CLUSTER_SHAPE_16x1x1 "CUBLASLT_CLUSTER_SHAPE_16x1x1" = 15
    CUBLASLT_CLUSTER_SHAPE_1x16x1 "CUBLASLT_CLUSTER_SHAPE_1x16x1" = 16
    CUBLASLT_CLUSTER_SHAPE_3x1x1 "CUBLASLT_CLUSTER_SHAPE_3x1x1" = 17
    CUBLASLT_CLUSTER_SHAPE_5x1x1 "CUBLASLT_CLUSTER_SHAPE_5x1x1" = 18
    CUBLASLT_CLUSTER_SHAPE_6x1x1 "CUBLASLT_CLUSTER_SHAPE_6x1x1" = 19
    CUBLASLT_CLUSTER_SHAPE_7x1x1 "CUBLASLT_CLUSTER_SHAPE_7x1x1" = 20
    CUBLASLT_CLUSTER_SHAPE_9x1x1 "CUBLASLT_CLUSTER_SHAPE_9x1x1" = 21
    CUBLASLT_CLUSTER_SHAPE_10x1x1 "CUBLASLT_CLUSTER_SHAPE_10x1x1" = 22
    CUBLASLT_CLUSTER_SHAPE_11x1x1 "CUBLASLT_CLUSTER_SHAPE_11x1x1" = 23
    CUBLASLT_CLUSTER_SHAPE_12x1x1 "CUBLASLT_CLUSTER_SHAPE_12x1x1" = 24
    CUBLASLT_CLUSTER_SHAPE_13x1x1 "CUBLASLT_CLUSTER_SHAPE_13x1x1" = 25
    CUBLASLT_CLUSTER_SHAPE_14x1x1 "CUBLASLT_CLUSTER_SHAPE_14x1x1" = 26
    CUBLASLT_CLUSTER_SHAPE_15x1x1 "CUBLASLT_CLUSTER_SHAPE_15x1x1" = 27
    CUBLASLT_CLUSTER_SHAPE_3x2x1 "CUBLASLT_CLUSTER_SHAPE_3x2x1" = 28
    CUBLASLT_CLUSTER_SHAPE_5x2x1 "CUBLASLT_CLUSTER_SHAPE_5x2x1" = 29
    CUBLASLT_CLUSTER_SHAPE_6x2x1 "CUBLASLT_CLUSTER_SHAPE_6x2x1" = 30
    CUBLASLT_CLUSTER_SHAPE_7x2x1 "CUBLASLT_CLUSTER_SHAPE_7x2x1" = 31
    CUBLASLT_CLUSTER_SHAPE_1x3x1 "CUBLASLT_CLUSTER_SHAPE_1x3x1" = 32
    CUBLASLT_CLUSTER_SHAPE_2x3x1 "CUBLASLT_CLUSTER_SHAPE_2x3x1" = 33
    CUBLASLT_CLUSTER_SHAPE_3x3x1 "CUBLASLT_CLUSTER_SHAPE_3x3x1" = 34
    CUBLASLT_CLUSTER_SHAPE_4x3x1 "CUBLASLT_CLUSTER_SHAPE_4x3x1" = 35
    CUBLASLT_CLUSTER_SHAPE_5x3x1 "CUBLASLT_CLUSTER_SHAPE_5x3x1" = 36
    CUBLASLT_CLUSTER_SHAPE_3x4x1 "CUBLASLT_CLUSTER_SHAPE_3x4x1" = 37
    CUBLASLT_CLUSTER_SHAPE_1x5x1 "CUBLASLT_CLUSTER_SHAPE_1x5x1" = 38
    CUBLASLT_CLUSTER_SHAPE_2x5x1 "CUBLASLT_CLUSTER_SHAPE_2x5x1" = 39
    CUBLASLT_CLUSTER_SHAPE_3x5x1 "CUBLASLT_CLUSTER_SHAPE_3x5x1" = 40
    CUBLASLT_CLUSTER_SHAPE_1x6x1 "CUBLASLT_CLUSTER_SHAPE_1x6x1" = 41
    CUBLASLT_CLUSTER_SHAPE_2x6x1 "CUBLASLT_CLUSTER_SHAPE_2x6x1" = 42
    CUBLASLT_CLUSTER_SHAPE_1x7x1 "CUBLASLT_CLUSTER_SHAPE_1x7x1" = 43
    CUBLASLT_CLUSTER_SHAPE_2x7x1 "CUBLASLT_CLUSTER_SHAPE_2x7x1" = 44
    CUBLASLT_CLUSTER_SHAPE_1x9x1 "CUBLASLT_CLUSTER_SHAPE_1x9x1" = 45
    CUBLASLT_CLUSTER_SHAPE_1x10x1 "CUBLASLT_CLUSTER_SHAPE_1x10x1" = 46
    CUBLASLT_CLUSTER_SHAPE_1x11x1 "CUBLASLT_CLUSTER_SHAPE_1x11x1" = 47
    CUBLASLT_CLUSTER_SHAPE_1x12x1 "CUBLASLT_CLUSTER_SHAPE_1x12x1" = 48
    CUBLASLT_CLUSTER_SHAPE_1x13x1 "CUBLASLT_CLUSTER_SHAPE_1x13x1" = 49
    CUBLASLT_CLUSTER_SHAPE_1x14x1 "CUBLASLT_CLUSTER_SHAPE_1x14x1" = 50
    CUBLASLT_CLUSTER_SHAPE_1x15x1 "CUBLASLT_CLUSTER_SHAPE_1x15x1" = 51

ctypedef enum cublasLtMatmulInnerShape_t "cublasLtMatmulInnerShape_t":
    CUBLASLT_MATMUL_INNER_SHAPE_UNDEFINED "CUBLASLT_MATMUL_INNER_SHAPE_UNDEFINED" = 0
    CUBLASLT_MATMUL_INNER_SHAPE_MMA884 "CUBLASLT_MATMUL_INNER_SHAPE_MMA884" = 1
    CUBLASLT_MATMUL_INNER_SHAPE_MMA1684 "CUBLASLT_MATMUL_INNER_SHAPE_MMA1684" = 2
    CUBLASLT_MATMUL_INNER_SHAPE_MMA1688 "CUBLASLT_MATMUL_INNER_SHAPE_MMA1688" = 3
    CUBLASLT_MATMUL_INNER_SHAPE_MMA16816 "CUBLASLT_MATMUL_INNER_SHAPE_MMA16816" = 4


# types
cdef extern from *:
    """
    #include <driver_types.h>
    #include <library_types.h>
    #include <cuComplex.h>
    """
    ctypedef void* cudaStream_t 'cudaStream_t'
    ctypedef int cudaDataType_t 'cudaDataType_t'
    ctypedef int cudaDataType 'cudaDataType'
    ctypedef int libraryPropertyType_t 'libraryPropertyType_t'
    ctypedef int libraryPropertyType 'libraryPropertyType'

    ctypedef struct cuComplex:
        pass
    ctypedef struct cuDoubleComplex:
        pass


ctypedef uint64_t cublasLtNumericalImplFlags_t 'cublasLtNumericalImplFlags_t'
ctypedef void* cublasLtHandle_t 'cublasLtHandle_t'
ctypedef void* cublasLtMatrixLayout_t 'cublasLtMatrixLayout_t'
ctypedef void* cublasLtMatmulDesc_t 'cublasLtMatmulDesc_t'
ctypedef void* cublasLtMatrixTransformDesc_t 'cublasLtMatrixTransformDesc_t'
ctypedef void* cublasLtMatmulPreference_t 'cublasLtMatmulPreference_t'
ctypedef struct cublasLtMatmulAlgo_t 'cublasLtMatmulAlgo_t':
    uint64_t data[8]
ctypedef struct cublasLtMatmulHeuristicResult_t 'cublasLtMatmulHeuristicResult_t':
    cublasLtMatmulAlgo_t algo
    size_t workspaceSize
    cublasStatus_t state
    float wavesCount
    int reserved[4]
ctypedef void (*cublasLtLoggerCallback_t 'cublasLtLoggerCallback_t')(
    int logLevel,
    const char* functionName,
    const char* message
)


###############################################################################
# Functions
###############################################################################

cdef cublasStatus_t cublasLtCreate(cublasLtHandle_t* lightHandle) except* nogil
cdef cublasStatus_t cublasLtDestroy(cublasLtHandle_t lightHandle) except* nogil
cdef size_t cublasLtGetVersion() except* nogil
cdef size_t cublasLtGetCudartVersion() except* nogil
cdef cublasStatus_t cublasLtGetProperty(libraryPropertyType type, int* value) except* nogil
cdef cublasStatus_t cublasLtMatmul(cublasLtHandle_t lightHandle, cublasLtMatmulDesc_t computeDesc, const void* alpha, const void* A, cublasLtMatrixLayout_t Adesc, const void* B, cublasLtMatrixLayout_t Bdesc, const void* beta, const void* C, cublasLtMatrixLayout_t Cdesc, void* D, cublasLtMatrixLayout_t Ddesc, const cublasLtMatmulAlgo_t* algo, void* workspace, size_t workspaceSizeInBytes, cudaStream_t stream) except* nogil
cdef cublasStatus_t cublasLtMatrixTransform(cublasLtHandle_t lightHandle, cublasLtMatrixTransformDesc_t transformDesc, const void* alpha, const void* A, cublasLtMatrixLayout_t Adesc, const void* beta, const void* B, cublasLtMatrixLayout_t Bdesc, void* C, cublasLtMatrixLayout_t Cdesc, cudaStream_t stream) except* nogil
cdef cublasStatus_t cublasLtMatrixLayoutCreate(cublasLtMatrixLayout_t* matLayout, cudaDataType type, uint64_t rows, uint64_t cols, int64_t ld) except* nogil
cdef cublasStatus_t cublasLtMatrixLayoutDestroy(cublasLtMatrixLayout_t matLayout) except* nogil
cdef cublasStatus_t cublasLtMatrixLayoutSetAttribute(cublasLtMatrixLayout_t matLayout, cublasLtMatrixLayoutAttribute_t attr, const void* buf, size_t sizeInBytes) except* nogil
cdef cublasStatus_t cublasLtMatrixLayoutGetAttribute(cublasLtMatrixLayout_t matLayout, cublasLtMatrixLayoutAttribute_t attr, void* buf, size_t sizeInBytes, size_t* sizeWritten) except* nogil
cdef cublasStatus_t cublasLtMatmulDescCreate(cublasLtMatmulDesc_t* matmulDesc, cublasComputeType_t computeType, cudaDataType_t scaleType) except* nogil
cdef cublasStatus_t cublasLtMatmulDescDestroy(cublasLtMatmulDesc_t matmulDesc) except* nogil
cdef cublasStatus_t cublasLtMatmulDescSetAttribute(cublasLtMatmulDesc_t matmulDesc, cublasLtMatmulDescAttributes_t attr, const void* buf, size_t sizeInBytes) except* nogil
cdef cublasStatus_t cublasLtMatmulDescGetAttribute(cublasLtMatmulDesc_t matmulDesc, cublasLtMatmulDescAttributes_t attr, void* buf, size_t sizeInBytes, size_t* sizeWritten) except* nogil
cdef cublasStatus_t cublasLtMatrixTransformDescCreate(cublasLtMatrixTransformDesc_t* transformDesc, cudaDataType scaleType) except* nogil
cdef cublasStatus_t cublasLtMatrixTransformDescDestroy(cublasLtMatrixTransformDesc_t transformDesc) except* nogil
cdef cublasStatus_t cublasLtMatrixTransformDescSetAttribute(cublasLtMatrixTransformDesc_t transformDesc, cublasLtMatrixTransformDescAttributes_t attr, const void* buf, size_t sizeInBytes) except* nogil
cdef cublasStatus_t cublasLtMatrixTransformDescGetAttribute(cublasLtMatrixTransformDesc_t transformDesc, cublasLtMatrixTransformDescAttributes_t attr, void* buf, size_t sizeInBytes, size_t* sizeWritten) except* nogil
cdef cublasStatus_t cublasLtMatmulPreferenceCreate(cublasLtMatmulPreference_t* pref) except* nogil
cdef cublasStatus_t cublasLtMatmulPreferenceDestroy(cublasLtMatmulPreference_t pref) except* nogil
cdef cublasStatus_t cublasLtMatmulPreferenceSetAttribute(cublasLtMatmulPreference_t pref, cublasLtMatmulPreferenceAttributes_t attr, const void* buf, size_t sizeInBytes) except* nogil
cdef cublasStatus_t cublasLtMatmulPreferenceGetAttribute(cublasLtMatmulPreference_t pref, cublasLtMatmulPreferenceAttributes_t attr, void* buf, size_t sizeInBytes, size_t* sizeWritten) except* nogil
cdef cublasStatus_t cublasLtMatmulAlgoGetHeuristic(cublasLtHandle_t lightHandle, cublasLtMatmulDesc_t operationDesc, cublasLtMatrixLayout_t Adesc, cublasLtMatrixLayout_t Bdesc, cublasLtMatrixLayout_t Cdesc, cublasLtMatrixLayout_t Ddesc, cublasLtMatmulPreference_t preference, int requestedAlgoCount, cublasLtMatmulHeuristicResult_t heuristicResultsArray[], int* returnAlgoCount) except* nogil
cdef cublasStatus_t cublasLtMatmulAlgoGetIds(cublasLtHandle_t lightHandle, cublasComputeType_t computeType, cudaDataType_t scaleType, cudaDataType_t Atype, cudaDataType_t Btype, cudaDataType_t Ctype, cudaDataType_t Dtype, int requestedAlgoCount, int algoIdsArray[], int* returnAlgoCount) except* nogil
cdef cublasStatus_t cublasLtMatmulAlgoInit(cublasLtHandle_t lightHandle, cublasComputeType_t computeType, cudaDataType_t scaleType, cudaDataType_t Atype, cudaDataType_t Btype, cudaDataType_t Ctype, cudaDataType_t Dtype, int algoId, cublasLtMatmulAlgo_t* algo) except* nogil
cdef cublasStatus_t cublasLtMatmulAlgoCheck(cublasLtHandle_t lightHandle, cublasLtMatmulDesc_t operationDesc, cublasLtMatrixLayout_t Adesc, cublasLtMatrixLayout_t Bdesc, cublasLtMatrixLayout_t Cdesc, cublasLtMatrixLayout_t Ddesc, const cublasLtMatmulAlgo_t* algo, cublasLtMatmulHeuristicResult_t* result) except* nogil
cdef cublasStatus_t cublasLtMatmulAlgoCapGetAttribute(const cublasLtMatmulAlgo_t* algo, cublasLtMatmulAlgoCapAttributes_t attr, void* buf, size_t sizeInBytes, size_t* sizeWritten) except* nogil
cdef cublasStatus_t cublasLtMatmulAlgoConfigSetAttribute(cublasLtMatmulAlgo_t* algo, cublasLtMatmulAlgoConfigAttributes_t attr, const void* buf, size_t sizeInBytes) except* nogil
cdef cublasStatus_t cublasLtMatmulAlgoConfigGetAttribute(const cublasLtMatmulAlgo_t* algo, cublasLtMatmulAlgoConfigAttributes_t attr, void* buf, size_t sizeInBytes, size_t* sizeWritten) except* nogil
cdef cublasStatus_t cublasLtLoggerSetCallback(cublasLtLoggerCallback_t callback) except* nogil
cdef cublasStatus_t cublasLtLoggerSetFile(FILE* file) except* nogil
cdef cublasStatus_t cublasLtLoggerOpenFile(const char* logFile) except* nogil
cdef cublasStatus_t cublasLtLoggerSetLevel(int level) except* nogil
cdef cublasStatus_t cublasLtLoggerSetMask(int mask) except* nogil
cdef cublasStatus_t cublasLtLoggerForceDisable() except* nogil
cdef const char* cublasLtGetStatusName(cublasStatus_t status) except* nogil
cdef const char* cublasLtGetStatusString(cublasStatus_t status) except* nogil
cdef cublasStatus_t cublasLtHeuristicsCacheGetCapacity(size_t* capacity) except* nogil
cdef cublasStatus_t cublasLtHeuristicsCacheSetCapacity(size_t capacity) except* nogil
cdef unsigned cublasLtDisableCpuInstructionsSetMask(unsigned mask) except* nogil
