# coding: utf-8

"""
    Codabl Community API

    The Codabl API is a collection of analytics tools and data integrations made for blockchain developers. In particular we offer Natural Language Processing and Anomaly detection algorithms that have been fine tune to understand text data and time series in the domain speficic setting of cryptocurrency and blockchain technology. This technology is intended to be use as building blocks to bigger applications, we offer examples on how to use them for Trading Backtesting and Smart Contract anomaly monitoring.  # noqa: E501

    OpenAPI spec version: 0.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from codabl.api_client import ApiClient


class IntegrationsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def crypto_get_candle_data(self, candle_request, **kwargs):  # noqa: E501
        """Downloads candle format market data  # noqa: E501

        Returns a list of candle data from specified market and data range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.crypto_get_candle_data(candle_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CandleRequest candle_request: The Get candles end point return market data in Open High Close Volume format. In order to use this endpoint you need to enter your API keys to your data provider in the console (required)
        :return: CandleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.crypto_get_candle_data_with_http_info(candle_request, **kwargs)  # noqa: E501
        else:
            (data) = self.crypto_get_candle_data_with_http_info(candle_request, **kwargs)  # noqa: E501
            return data

    def crypto_get_candle_data_with_http_info(self, candle_request, **kwargs):  # noqa: E501
        """Downloads candle format market data  # noqa: E501

        Returns a list of candle data from specified market and data range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.crypto_get_candle_data_with_http_info(candle_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CandleRequest candle_request: The Get candles end point return market data in Open High Close Volume format. In order to use this endpoint you need to enter your API keys to your data provider in the console (required)
        :return: CandleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['candle_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method crypto_get_candle_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'candle_request' is set
        if ('candle_request' not in params or
                params['candle_request'] is None):
            raise ValueError("Missing the required parameter `candle_request` when calling `crypto_get_candle_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'candle_request' in params:
            body_params = params['candle_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/get_candles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CandleResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def crypto_get_exchange_assets(self, exchange, **kwargs):  # noqa: E501
        """Gets all coin pairs traded in specified exchange  # noqa: E501

        This endpoint returns all the Available currency pairs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.crypto_get_exchange_assets(exchange, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Exchange exchange: Name of the cryptocurrency exchange (required)
        :return: ExchangeAssetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.crypto_get_exchange_assets_with_http_info(exchange, **kwargs)  # noqa: E501
        else:
            (data) = self.crypto_get_exchange_assets_with_http_info(exchange, **kwargs)  # noqa: E501
            return data

    def crypto_get_exchange_assets_with_http_info(self, exchange, **kwargs):  # noqa: E501
        """Gets all coin pairs traded in specified exchange  # noqa: E501

        This endpoint returns all the Available currency pairs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.crypto_get_exchange_assets_with_http_info(exchange, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Exchange exchange: Name of the cryptocurrency exchange (required)
        :return: ExchangeAssetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['exchange']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method crypto_get_exchange_assets" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'exchange' is set
        if ('exchange' not in params or
                params['exchange'] is None):
            raise ValueError("Missing the required parameter `exchange` when calling `crypto_get_exchange_assets`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'exchange' in params:
            body_params = params['exchange']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/get_exchange_assets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExchangeAssetsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def crypto_get_orderbooks(self, orderbook_request, **kwargs):  # noqa: E501
        """Returns the current state of the orderbook.  # noqa: E501

        This endpoint returns the current state of the ordebook with a limit set by you. The maximun orderbook depth is 25.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.crypto_get_orderbooks(orderbook_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderbookRequest orderbook_request: Exchange, trading pair and date rage for data (required)
        :return: OrderbookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.crypto_get_orderbooks_with_http_info(orderbook_request, **kwargs)  # noqa: E501
        else:
            (data) = self.crypto_get_orderbooks_with_http_info(orderbook_request, **kwargs)  # noqa: E501
            return data

    def crypto_get_orderbooks_with_http_info(self, orderbook_request, **kwargs):  # noqa: E501
        """Returns the current state of the orderbook.  # noqa: E501

        This endpoint returns the current state of the ordebook with a limit set by you. The maximun orderbook depth is 25.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.crypto_get_orderbooks_with_http_info(orderbook_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderbookRequest orderbook_request: Exchange, trading pair and date rage for data (required)
        :return: OrderbookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orderbook_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method crypto_get_orderbooks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orderbook_request' is set
        if ('orderbook_request' not in params or
                params['orderbook_request'] is None):
            raise ValueError("Missing the required parameter `orderbook_request` when calling `crypto_get_orderbooks`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'orderbook_request' in params:
            body_params = params['orderbook_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/get_orderbooks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderbookResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def crypto_get_supported_exchanges(self, **kwargs):  # noqa: E501
        """Gets all cryptocurrency exchanges supported by the Codabl API  # noqa: E501

        Returns a list of candle data from specified market and data range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.crypto_get_supported_exchanges(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SupportedExchanges
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.crypto_get_supported_exchanges_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.crypto_get_supported_exchanges_with_http_info(**kwargs)  # noqa: E501
            return data

    def crypto_get_supported_exchanges_with_http_info(self, **kwargs):  # noqa: E501
        """Gets all cryptocurrency exchanges supported by the Codabl API  # noqa: E501

        Returns a list of candle data from specified market and data range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.crypto_get_supported_exchanges_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SupportedExchanges
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method crypto_get_supported_exchanges" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/get_supported_exchanges', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SupportedExchanges',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def crypto_get_ticker(self, exchange, **kwargs):  # noqa: E501
        """Downloads candle format market data  # noqa: E501

        Returns a list of candle data from specified market and data range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.crypto_get_ticker(exchange, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Exchange exchange: Get ticker data from specified crypto exchange (required)
        :return: TickerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.crypto_get_ticker_with_http_info(exchange, **kwargs)  # noqa: E501
        else:
            (data) = self.crypto_get_ticker_with_http_info(exchange, **kwargs)  # noqa: E501
            return data

    def crypto_get_ticker_with_http_info(self, exchange, **kwargs):  # noqa: E501
        """Downloads candle format market data  # noqa: E501

        Returns a list of candle data from specified market and data range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.crypto_get_ticker_with_http_info(exchange, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Exchange exchange: Get ticker data from specified crypto exchange (required)
        :return: TickerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['exchange']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method crypto_get_ticker" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'exchange' is set
        if ('exchange' not in params or
                params['exchange'] is None):
            raise ValueError("Missing the required parameter `exchange` when calling `crypto_get_ticker`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'exchange' in params:
            body_params = params['exchange']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['APIKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/get_ticker', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TickerResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
