# Generated by Django 3.1 on 2020-08-27 12:23

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ColTaxonNamesView',
            fields=[
                ('name_uuid', models.UUIDField(editable=False, primary_key=True, serialize=False, unique=True)),
                ('name', models.CharField(max_length=255)),
                ('taxon_author', models.CharField(max_length=100, null=True)),
                ('taxon_nuid', models.CharField(max_length=255)),
                ('language', models.CharField(max_length=5, null=True)),
                ('name_type', models.CharField(choices=[('taxontree', 'TaxonTree'), ('synonym', 'TaxonSynonym'), ('locale', 'TaxonLocale')], max_length=100)),
                ('rank', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='ColTaxonTree',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('taxon_latname', models.CharField(max_length=255)),
                ('taxon_author', models.CharField(max_length=255, null=True)),
                ('taxon_nuid', models.CharField(max_length=255, unique=True)),
                ('rank', models.CharField(max_length=255, null=True)),
                ('is_root_taxon', models.BooleanField(default=False)),
                ('slug', models.SlugField(max_length=100, null=True, unique=True)),
                ('source_id', models.CharField(max_length=255, unique=True)),
                ('additional_data', models.JSONField(null=True)),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='col.coltaxontree')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ColTaxonSynonym',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('taxon_latname', models.CharField(max_length=255)),
                ('taxon_author', models.CharField(max_length=255, null=True)),
                ('slug', models.SlugField(max_length=100, null=True, unique=True)),
                ('source_id', models.CharField(max_length=255)),
                ('additional_data', models.JSONField(null=True)),
                ('taxon', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='col.coltaxontree', to_field='name_uuid')),
            ],
            options={
                'unique_together': {('taxon', 'taxon_latname', 'taxon_author')},
            },
        ),
        migrations.CreateModel(
            name='ColTaxonLocale',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('name', models.CharField(max_length=255)),
                ('language', models.CharField(max_length=2)),
                ('iso6392', models.CharField(max_length=3, null=True)),
                ('language_region', models.CharField(max_length=5, null=True)),
                ('preferred', models.BooleanField(default=False)),
                ('slug', models.SlugField(max_length=100, null=True, unique=True)),
                ('additional_data', models.JSONField(null=True)),
                ('taxon', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='col.coltaxontree', to_field='name_uuid')),
            ],
            options={
                'index_together': {('taxon', 'language')},
            },
        ),
    ]
