/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc;

import com.datapps.linkoopdb.jdbc.ColumnBase;
import com.datapps.linkoopdb.jdbc.Expression;
import com.datapps.linkoopdb.jdbc.LdbSqlNameManager;
import com.datapps.linkoopdb.jdbc.NumberSequence;
import com.datapps.linkoopdb.jdbc.SchemaObject;
import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.lib.Iterator;
import com.datapps.linkoopdb.jdbc.lib.OrderedHashSet;
import com.datapps.linkoopdb.jdbc.rights.Grantee;
import com.datapps.linkoopdb.jdbc.types.StructureType;
import com.datapps.linkoopdb.jdbc.types.Type;
import com.datapps.linkoopdb.jdbc.types.Types;

public class ColumnSchema
extends ColumnBase
implements SchemaObject {
    public static final ColumnSchema[] emptyArray = new ColumnSchema[0];
    private LdbSqlNameManager.LdbSqlName columnName;
    private boolean isPrimaryKey;
    private boolean originPK = false;
    private boolean isForVariable = false;
    private Expression defaultExpression;
    private Expression generatingExpression;
    private Expression updateExpression;
    private NumberSequence sequence;
    private OrderedHashSet references;
    private OrderedHashSet generatedColumnReferences;
    private Expression accessor;

    public ColumnSchema(LdbSqlNameManager.LdbSqlName name, Type type) {
        this.columnName = name;
        this.dataType = type;
    }

    public ColumnSchema(LdbSqlNameManager.LdbSqlName name, Type type, boolean isNullable, boolean isPrimaryKey, Expression defaultExpression) {
        this.columnName = name;
        this.nullability = isNullable ? (byte)1 : 0;
        this.dataType = type;
        this.isPrimaryKey = isPrimaryKey;
        this.defaultExpression = defaultExpression;
        this.setReferences();
    }

    @Override
    public int getType() {
        return this.columnName.type;
    }

    public void setType(ColumnSchema other) {
        this.nullability = other.nullability;
        this.dataType = other.dataType;
    }

    @Override
    public LdbSqlNameManager.LdbSqlName getName() {
        return this.columnName;
    }

    public void setName(LdbSqlNameManager.LdbSqlName name) {
        this.columnName = name;
    }

    @Override
    public String getNameString() {
        return this.columnName.name;
    }

    @Override
    public String getTableNameString() {
        return this.columnName.parent == null ? null : this.columnName.parent.name;
    }

    @Override
    public LdbSqlNameManager.LdbSqlName getSchemaName() {
        return this.columnName.schema;
    }

    @Override
    public String getSchemaNameString() {
        return this.columnName.schema == null ? null : this.columnName.schema.name;
    }

    @Override
    public LdbSqlNameManager.LdbSqlName getCatalogName() {
        return this.columnName.schema == null ? null : this.columnName.schema.schema;
    }

    @Override
    public String getCatalogNameString() {
        return this.columnName.schema == null ? null : (this.columnName.schema.schema == null ? null : this.columnName.schema.schema.name);
    }

    @Override
    public Grantee getOwner() {
        return this.columnName.schema == null ? null : this.columnName.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return this.references;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(SessionInterface session, SchemaObject table) {
        if (this.generatingExpression == null) {
            return;
        }
        Type.typeHelper.compile(this, table, session);
        this.setReferences();
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        switch (this.parameterMode) {
            case 1: {
                sb.append("IN").append(' ');
                break;
            }
            case 4: {
                sb.append("OUT").append(' ');
                break;
            }
            case 2: {
                sb.append("INOUT").append(' ');
                break;
            }
        }
        if (this.columnName != null) {
            sb.append(this.columnName.statementName);
            sb.append(' ');
        }
        sb.append(this.dataType.getTypeDefinition());
        return sb.toString();
    }

    public String getStructSQL(boolean hasColon) {
        StringBuffer sb = new StringBuffer();
        switch (this.parameterMode) {
            case 1: {
                sb.append("IN").append(' ');
                break;
            }
            case 4: {
                sb.append("OUT").append(' ');
                break;
            }
            case 2: {
                sb.append("INOUT").append(' ');
                break;
            }
        }
        if (this.columnName != null) {
            sb.append(this.columnName.statementName);
            if (hasColon) {
                sb.append(':');
            } else {
                sb.append(' ');
            }
        }
        if (this.dataType.isStructuredType()) {
            sb.append(((StructureType)this.dataType).getJsonStructDefinition());
        } else {
            sb.append(this.dataType.getTypeDefinition());
        }
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    @Override
    public void setType(Type type) {
        this.dataType = type;
        this.setReferences();
    }

    public void setIdentity(NumberSequence sequence) {
        this.sequence = sequence;
        this.isIdentity = sequence != null;
    }

    public NumberSequence getIdentitySequence() {
        return this.sequence;
    }

    @Override
    public boolean isNullable() {
        boolean isNullable = super.isNullable();
        if (isNullable && this.dataType.isDomainType()) {
            return this.dataType.userTypeModifier.isNullable();
        }
        return isNullable;
    }

    @Override
    public byte getNullability() {
        return this.isPrimaryKey ? (byte)0 : super.getNullability();
    }

    public boolean isGenerated() {
        return this.generatingExpression != null;
    }

    public boolean isAutoUpdate() {
        return this.updateExpression != null;
    }

    public boolean hasDefault() {
        return this.getDefaultExpression() != null;
    }

    public Expression getUpdateExpression() {
        return this.updateExpression;
    }

    public void setUpdateExpression(Expression updateExpression) {
        this.updateExpression = updateExpression;
    }

    @Override
    public boolean isWriteable() {
        return this.isWriteable;
    }

    @Override
    public void setWriteable(boolean value) {
        this.isWriteable = value;
    }

    @Override
    public boolean isSearchable() {
        return Types.isSearchable(this.dataType.typeCode);
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setPrimaryKey(boolean value) {
        this.isPrimaryKey = value;
    }

    public boolean isOriginPK() {
        return this.originPK;
    }

    public void setOriginPK(boolean originPK) {
        this.originPK = originPK;
    }

    public Object getDefaultValue(SessionInterface session) {
        return this.defaultExpression == null ? null : this.defaultExpression.getValue(session, this.dataType);
    }

    public Object getGeneratedValue(SessionInterface session) {
        return this.generatingExpression == null ? null : this.generatingExpression.getValue(session, this.dataType);
    }

    public String getDefaultSQL() {
        String ddl = null;
        ddl = this.defaultExpression == null ? null : this.defaultExpression.getSQL();
        return ddl;
    }

    public Expression getDefaultExpression() {
        if (this.defaultExpression == null) {
            if (this.dataType.isDomainType()) {
                return this.dataType.userTypeModifier.getDefaultClause();
            }
            return null;
        }
        return this.defaultExpression;
    }

    public void setDefaultExpression(Expression expr) {
        this.defaultExpression = expr;
    }

    public Expression getGeneratingExpression() {
        return this.generatingExpression;
    }

    public void setGeneratingExpression(Expression expr) {
        this.generatingExpression = expr;
        this.setWriteable(this.generatingExpression == null);
    }

    public ColumnSchema duplicate() {
        ColumnSchema copy = new ColumnSchema(this.columnName, this.dataType, true, this.isPrimaryKey, this.defaultExpression);
        copy.setNullability(this.nullability);
        copy.setOriginPK(this.originPK);
        copy.setGeneratingExpression(this.generatingExpression);
        copy.setIdentity(this.sequence);
        return copy;
    }

    public Expression getAccessor() {
        if (this.accessor == null) {
            this.accessor = Type.typeHelper.buildAccessor(this);
        }
        return this.accessor;
    }

    public OrderedHashSet getGeneratedColumnReferences() {
        return this.generatedColumnReferences;
    }

    private void setReferences() {
        if (this.references != null) {
            this.references.clear();
        }
        if (this.generatedColumnReferences != null) {
            this.generatedColumnReferences.clear();
        }
        if (this.dataType.isDomainType() || this.dataType.isDistinctType()) {
            LdbSqlNameManager.LdbSqlName name = this.dataType.getName();
            if (this.references == null) {
                this.references = new OrderedHashSet();
            }
            this.references.add(name);
        }
        if (this.generatingExpression != null) {
            OrderedHashSet set = new OrderedHashSet();
            this.generatingExpression.collectObjectNames(set);
            Iterator it = set.iterator();
            while (it.hasNext()) {
                LdbSqlNameManager.LdbSqlName name = (LdbSqlNameManager.LdbSqlName)it.next();
                if (name.type == 9 || name.type == 3) {
                    if (name.type != 9) continue;
                    if (this.generatedColumnReferences == null) {
                        this.generatedColumnReferences = new OrderedHashSet();
                    }
                    this.generatedColumnReferences.add(name);
                    continue;
                }
                if (this.references == null) {
                    this.references = new OrderedHashSet();
                }
                this.references.add(name);
            }
        }
    }

    public boolean isForVariable() {
        return this.isForVariable;
    }

    public void setForVariable(boolean forVariable) {
        this.isForVariable = forVariable;
    }
}

