/*
 * Decompiled with CFR 0.152.
 */
package io.github.slemke.login;

import io.github.slemke.login.LastLoginEventListenerProvider;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventListenerProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class LastLoginEventListenerProviderFactory
implements EventListenerProviderFactory {
    public static final String ID = "last-login";
    private String attribute;
    private String zoneId;
    private DateTimeFormatter dateTimePattern;

    public EventListenerProvider create(KeycloakSession session) {
        return new LastLoginEventListenerProvider(session, this.zoneId, this.dateTimePattern, this.attribute);
    }

    public void init(Config.Scope config) {
        String attribute = config.get("attribute");
        this.attribute = attribute == null || attribute.isBlank() ? "lastLogin" : attribute;
        String zoneId = config.get("zone-id");
        this.zoneId = zoneId == null || zoneId.isBlank() ? "UTC" : zoneId;
        String pattern = config.get("pattern");
        this.dateTimePattern = pattern == null || pattern.isBlank() ? DateTimeFormatter.ISO_OFFSET_DATE_TIME : DateTimeFormatter.ofPattern(pattern);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("attribute").type("string").helpText("The name of the last login user attribute (default ist lastLogin)").defaultValue((Object)"lastLogin").add().property().name("zone-id").type("string").helpText("The zone id for the last login format (default is UTC)").defaultValue((Object)"UTC").add().property().name("pattern").type("string").helpText("Custom date time format pattern (default is the ISO date time format)").add().build();
    }
}

