# AUTOGENERATED! DO NOT EDIT! File to edit: ../../pts/api/controller_app.pct.py.

# %% auto 0
__all__ = ['ControllerApp']

# %% ../../pts/api/controller_app.pct.py 3
from .controller import Controller, ControllerMethodType, ctrl_method, ctrl_cmd_method, ctrl_query_method
import functools
from typing import Type, Callable, Optional
import inspect

# %% ../../pts/api/controller_app.pct.py 4
def _add_method_to_class(func: Callable, controller_cls: Type[Controller], name: Optional[str], pass_self: bool = False):
    if inspect.iscoroutinefunction(func):
        async def method(self, *args, **kwargs):
            if pass_self: return await func(self, *args, **kwargs)
            return await func(*args, **kwargs)
    else:
        def method(self, *args, **kwargs):
            if pass_self: return func(self, *args, **kwargs)
            return func(*args, **kwargs)
        
    # Keep metadata, but fix what inspect sees
    functools.update_wrapper(method, func)

    # Build a signature that excludes `self` since the method will be bound to the instance
    orig_sig = inspect.signature(func)
    params = list(orig_sig.parameters.values())
    
    # Add `self` parameter if not present
    if len(params) == 0 or params[0].name != 'self':
        self_param = inspect.Parameter(
            'self', inspect.Parameter.POSITIONAL_OR_KEYWORD
        )
        params = [self_param] + params
    
    method.__signature__ = inspect.Signature(
        parameters=params,
        return_annotation=orig_sig.return_annotation
    )
        
    method.__name__ = name or func.__name__
    setattr(controller_cls, method.__name__, method)

# %% ../../pts/api/controller_app.pct.py 5
class ControllerApp:
    def __init__(self):
        class _Controller(Controller): pass
        self._controller_cls = _Controller
    
    @property
    def controller_cls(self) -> Type[Controller]:
        return self._controller_cls
    
    def register(self, method_type: ControllerMethodType, group: str, name: Optional[str] = None):
        def decorator(func: Callable):
            _func = ctrl_method(method_type=method_type, group=group)(func)
            _add_method_to_class(_func, self._controller_cls, name)
            return func
        return decorator
    
    def register_cmd(self, name: Optional[str] = None):
        def decorator(func: Callable):
            _func = ctrl_cmd_method(func)
            _add_method_to_class(_func, self._controller_cls, name)
            return func
        return decorator
    
    def register_query(self, name: Optional[str] = None):
        def decorator(func: Callable):
            _func = ctrl_query_method(func)
            _add_method_to_class(_func, self._controller_cls, name)
            return func
        return decorator
    
    def get_controller(self) -> Type[Controller]:
        return self._controller_cls()
