"use strict";
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const alias_1 = require("../lib/alias");
module.exports = {
    'default alias'(test) {
        const app = new cdk_1.App();
        const stack = new cdk_1.Stack(app, 'Test');
        const key = new lib_1.EncryptionKey(stack, 'Key');
        new alias_1.EncryptionKeyAlias(stack, 'Alias', { key, alias: 'alias/foo' });
        test.deepEqual(app.synthesizeStack(stack.name).template.Resources.Alias325C5727, {
            Type: 'AWS::KMS::Alias',
            Properties: {
                AliasName: 'alias/foo',
                TargetKeyId: { 'Fn::GetAtt': ['Key961B73FD', 'Arn'] }
            }
        });
        test.done();
    },
    'fails if alias name does\'t start with "alias/"'(test) {
        const app = new cdk_1.App();
        const stack = new cdk_1.Stack(app, 'Test');
        const key = new lib_1.EncryptionKey(stack, 'MyKey', {
            enableKeyRotation: true,
            enabled: false
        });
        test.throws(() => new alias_1.EncryptionKeyAlias(stack, 'Alias', {
            alias: 'foo',
            key
        }));
        test.done();
    },
    'fails if alias is "alias/" (and nothing more)'(test) {
        const app = new cdk_1.App();
        const stack = new cdk_1.Stack(app, 'Test');
        const key = new lib_1.EncryptionKey(stack, 'MyKey', {
            enableKeyRotation: true,
            enabled: false
        });
        test.throws(() => new alias_1.EncryptionKeyAlias(stack, 'Alias', {
            alias: 'alias/',
            key
        }));
        test.done();
    },
    'fails if alias starts with "alias/AWS"'(test) {
        const app = new cdk_1.App();
        const stack = new cdk_1.Stack(app, 'Test');
        const key = new lib_1.EncryptionKey(stack, 'MyKey', {
            enableKeyRotation: true,
            enabled: false
        });
        test.throws(() => new alias_1.EncryptionKeyAlias(stack, 'Alias', {
            alias: 'alias/AWS',
            key
        }));
        test.throws(() => new alias_1.EncryptionKeyAlias(stack, 'Alias', {
            alias: 'alias/AWSAwesome',
            key
        }));
        test.throws(() => new alias_1.EncryptionKeyAlias(stack, 'Alias', {
            alias: 'alias/AWS/awesome',
            key
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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