# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.agent import Agent
from ..types.agent_attribute import AgentAttribute
from .raw_client import AsyncRawAgentsClient, RawAgentsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AgentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAgentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAgentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAgentsClient
        """
        return self._raw_client

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[Agent]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Agent]
            Success response

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.agents.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        name: str,
        description: str,
        agent_code: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Agent:
        """
        Parameters
        ----------
        name : str

        description : str

        agent_code : typing.Optional[str]

        external_id : typing.Optional[str]

        active : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Agent
            Success response

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.agents.create(
            name="Acme Agent",
            description="Acme Agent is an AI agent that does things.",
            external_id="acme-agent",
        )
        """
        _response = self._raw_client.create(
            name=name,
            description=description,
            agent_code=agent_code,
            external_id=external_id,
            active=active,
            request_options=request_options,
        )
        return _response.data

    def get(self, agent_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Agent:
        """
        Parameters
        ----------
        agent_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Agent
            Success response

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.agents.get(
            agent_id="agentId",
        )
        """
        _response = self._raw_client.get(agent_id, request_options=request_options)
        return _response.data

    def update(
        self,
        agent_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        agent_code: typing.Optional[str] = OMIT,
        agent_attributes: typing.Optional[typing.Sequence[AgentAttribute]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Agent:
        """
        Parameters
        ----------
        agent_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        external_id : typing.Optional[str]

        active : typing.Optional[bool]

        agent_code : typing.Optional[str]

        agent_attributes : typing.Optional[typing.Sequence[AgentAttribute]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Agent
            Success response

        Examples
        --------
        from paid import (
            AgentAttribute,
            AgentPricePoint,
            AgentPricePointTiers,
            Paid,
            Pricing,
        )

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.agents.update(
            agent_id="agentId",
            name="Acme Agent (Updated)",
            agent_attributes=[
                AgentAttribute(
                    name="Emails sent signal",
                    active=True,
                    pricing=Pricing(
                        event_name="emails_sent",
                        taxable=True,
                        charge_type="usage",
                        pricing_model="PerUnit",
                        billing_frequency="monthly",
                        price_points={
                            "USD": AgentPricePoint(
                                tiers=[
                                    AgentPricePointTiers(
                                        min_quantity=0.0,
                                        max_quantity=10.0,
                                        unit_price=100.0,
                                    ),
                                    AgentPricePointTiers(
                                        min_quantity=11.0,
                                        max_quantity=100.0,
                                        unit_price=90.0,
                                    ),
                                    AgentPricePointTiers(
                                        min_quantity=101.0,
                                        unit_price=80.0,
                                    ),
                                ],
                            )
                        },
                    ),
                )
            ],
        )
        """
        _response = self._raw_client.update(
            agent_id,
            name=name,
            description=description,
            external_id=external_id,
            active=active,
            agent_code=agent_code,
            agent_attributes=agent_attributes,
            request_options=request_options,
        )
        return _response.data

    def delete(self, agent_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        agent_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.agents.delete(
            agent_id="agentId",
        )
        """
        _response = self._raw_client.delete(agent_id, request_options=request_options)
        return _response.data

    def get_by_external_id(self, external_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Agent:
        """
        Parameters
        ----------
        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Agent
            Success response

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.agents.get_by_external_id(
            external_id="externalId",
        )
        """
        _response = self._raw_client.get_by_external_id(external_id, request_options=request_options)
        return _response.data

    def update_by_external_id(
        self,
        external_id_: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        agent_code: typing.Optional[str] = OMIT,
        agent_attributes: typing.Optional[typing.Sequence[AgentAttribute]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Agent:
        """
        Parameters
        ----------
        external_id_ : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        external_id : typing.Optional[str]

        active : typing.Optional[bool]

        agent_code : typing.Optional[str]

        agent_attributes : typing.Optional[typing.Sequence[AgentAttribute]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Agent
            Success response

        Examples
        --------
        from paid import AgentAttribute, AgentPricePoint, Paid, Pricing

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.agents.update_by_external_id(
            external_id_="externalId",
            name="Acme Agent (Updated)",
            agent_attributes=[
                AgentAttribute(
                    name="Emails sent signal",
                    active=True,
                    pricing=Pricing(
                        event_name="emails_sent",
                        taxable=True,
                        charge_type="usage",
                        pricing_model="PerUnit",
                        billing_frequency="monthly",
                        price_points={
                            "USD": AgentPricePoint(
                                unit_price=150.0,
                            )
                        },
                    ),
                )
            ],
        )
        """
        _response = self._raw_client.update_by_external_id(
            external_id_,
            name=name,
            description=description,
            external_id=external_id,
            active=active,
            agent_code=agent_code,
            agent_attributes=agent_attributes,
            request_options=request_options,
        )
        return _response.data

    def delete_by_external_id(
        self, external_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from paid import Paid

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.agents.delete_by_external_id(
            external_id="externalId",
        )
        """
        _response = self._raw_client.delete_by_external_id(external_id, request_options=request_options)
        return _response.data


class AsyncAgentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAgentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAgentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAgentsClient
        """
        return self._raw_client

    async def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[Agent]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Agent]
            Success response

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.agents.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        name: str,
        description: str,
        agent_code: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Agent:
        """
        Parameters
        ----------
        name : str

        description : str

        agent_code : typing.Optional[str]

        external_id : typing.Optional[str]

        active : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Agent
            Success response

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.agents.create(
                name="Acme Agent",
                description="Acme Agent is an AI agent that does things.",
                external_id="acme-agent",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            description=description,
            agent_code=agent_code,
            external_id=external_id,
            active=active,
            request_options=request_options,
        )
        return _response.data

    async def get(self, agent_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Agent:
        """
        Parameters
        ----------
        agent_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Agent
            Success response

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.agents.get(
                agent_id="agentId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(agent_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        agent_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        agent_code: typing.Optional[str] = OMIT,
        agent_attributes: typing.Optional[typing.Sequence[AgentAttribute]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Agent:
        """
        Parameters
        ----------
        agent_id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        external_id : typing.Optional[str]

        active : typing.Optional[bool]

        agent_code : typing.Optional[str]

        agent_attributes : typing.Optional[typing.Sequence[AgentAttribute]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Agent
            Success response

        Examples
        --------
        import asyncio

        from paid import (
            AgentAttribute,
            AgentPricePoint,
            AgentPricePointTiers,
            AsyncPaid,
            Pricing,
        )

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.agents.update(
                agent_id="agentId",
                name="Acme Agent (Updated)",
                agent_attributes=[
                    AgentAttribute(
                        name="Emails sent signal",
                        active=True,
                        pricing=Pricing(
                            event_name="emails_sent",
                            taxable=True,
                            charge_type="usage",
                            pricing_model="PerUnit",
                            billing_frequency="monthly",
                            price_points={
                                "USD": AgentPricePoint(
                                    tiers=[
                                        AgentPricePointTiers(
                                            min_quantity=0.0,
                                            max_quantity=10.0,
                                            unit_price=100.0,
                                        ),
                                        AgentPricePointTiers(
                                            min_quantity=11.0,
                                            max_quantity=100.0,
                                            unit_price=90.0,
                                        ),
                                        AgentPricePointTiers(
                                            min_quantity=101.0,
                                            unit_price=80.0,
                                        ),
                                    ],
                                )
                            },
                        ),
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            agent_id,
            name=name,
            description=description,
            external_id=external_id,
            active=active,
            agent_code=agent_code,
            agent_attributes=agent_attributes,
            request_options=request_options,
        )
        return _response.data

    async def delete(self, agent_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        agent_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.agents.delete(
                agent_id="agentId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(agent_id, request_options=request_options)
        return _response.data

    async def get_by_external_id(
        self, external_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Agent:
        """
        Parameters
        ----------
        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Agent
            Success response

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.agents.get_by_external_id(
                external_id="externalId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_external_id(external_id, request_options=request_options)
        return _response.data

    async def update_by_external_id(
        self,
        external_id_: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        agent_code: typing.Optional[str] = OMIT,
        agent_attributes: typing.Optional[typing.Sequence[AgentAttribute]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Agent:
        """
        Parameters
        ----------
        external_id_ : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        external_id : typing.Optional[str]

        active : typing.Optional[bool]

        agent_code : typing.Optional[str]

        agent_attributes : typing.Optional[typing.Sequence[AgentAttribute]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Agent
            Success response

        Examples
        --------
        import asyncio

        from paid import AgentAttribute, AgentPricePoint, AsyncPaid, Pricing

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.agents.update_by_external_id(
                external_id_="externalId",
                name="Acme Agent (Updated)",
                agent_attributes=[
                    AgentAttribute(
                        name="Emails sent signal",
                        active=True,
                        pricing=Pricing(
                            event_name="emails_sent",
                            taxable=True,
                            charge_type="usage",
                            pricing_model="PerUnit",
                            billing_frequency="monthly",
                            price_points={
                                "USD": AgentPricePoint(
                                    unit_price=150.0,
                                )
                            },
                        ),
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_external_id(
            external_id_,
            name=name,
            description=description,
            external_id=external_id,
            active=active,
            agent_code=agent_code,
            agent_attributes=agent_attributes,
            request_options=request_options,
        )
        return _response.data

    async def delete_by_external_id(
        self, external_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from paid import AsyncPaid

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.agents.delete_by_external_id(
                external_id="externalId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_external_id(external_id, request_options=request_options)
        return _response.data
