"""OpenTelemetry instrumented wrapper for Gemini Python SDK.

This file was auto-generated by the AI SDK Wrapper Code Generator:
https://github.com/paid-ai/sdk-wrapper-codegen
"""

from typing import Union

from opentelemetry.trace import Status, StatusCode

from paid.logger import logger
from paid.tracing.tracing import get_paid_tracer

try:
    from google import genai
    from google.genai.types import GenerateContentResponse
except ImportError:
    raise ImportError(
        "google-genai package is a peer-dependency. To use the Paid wrapper around google-genai "
        "you're assumed to already have google-genai package installed."
    )


class PaidGemini:
    """OpenTelemetry instrumented wrapper for Gemini Python SDK SDK."""

    def __init__(self, original_client: genai.Client):
        self._client = original_client

    @property
    def models(self):
        """Access models with OTEL instrumentation."""
        return ModelsWrapper(self._client)


class ModelsWrapper:
    """Wrapper for models with OTEL instrumentation."""

    def __init__(self, original_client: genai.Client):
        self._client = original_client

    def generate_content(self, **kwargs) -> GenerateContentResponse:
        """GenerateContentResponse method with OTEL instrumentation."""
        tracer = get_paid_tracer()

        with tracer.start_as_current_span("gemini.models.generate_content") as span:
            try:
                # Execute the original method
                response = self._client.models.generate_content(**kwargs)
                if response.usage_metadata is None:
                    logger.error("should be unreachable: response.usage_metadata is None, cannot extract usage data")
                    return response

                # Set OTEL attributes (best-effort)
                attributes: dict[str, Union[str, int]] = {}
                attributes["gen_ai.system"] = "gemini"
                attributes["gen_ai.operation.name"] = "generate_content"
                try:
                    value: Union[str, int, None] = response.model_version
                    if value is not None:
                        attributes["gen_ai.response.model"] = value
                except (AttributeError, KeyError, TypeError):
                    pass
                try:
                    value = response.usage_metadata.prompt_token_count
                    if value is not None:
                        attributes["gen_ai.usage.input_tokens"] = value
                except (AttributeError, KeyError, TypeError):
                    pass
                try:
                    value = response.usage_metadata.candidates_token_count
                    if value is not None:
                        attributes["gen_ai.usage.output_tokens"] = value
                except (AttributeError, KeyError, TypeError):
                    pass
                try:
                    value = response.usage_metadata.cached_content_token_count
                    if value is not None:
                        attributes["gen_ai.usage.cached_input_tokens"] = value
                except (AttributeError, KeyError, TypeError):
                    pass
                try:
                    value = response.usage_metadata.thoughts_token_count
                    if value is not None:
                        attributes["gen_ai.usage.reasoning_output_tokens"] = value
                except (AttributeError, KeyError, TypeError):
                    pass

                span.set_attributes(attributes)
                span.set_status(Status(StatusCode.OK))
                return response

            except Exception as e:
                # Record exception in span
                span.record_exception(e)
                span.set_status(Status(StatusCode.ERROR, str(e)))
                raise
