# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .creation_state import CreationState
from .customer import Customer
from .order_line import OrderLine


class Order(UniversalBaseModel):
    id: typing.Optional[str] = None
    name: typing.Optional[str] = None
    description: typing.Optional[str] = None
    customer_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="customerId")] = None
    organization_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="organizationId")] = None
    start_date: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="startDate")] = None
    end_date: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="endDate")] = None
    total_amount: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="totalAmount")] = None
    estimated_tax: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="estimatedTax")] = None
    billed_amount_no_tax: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="billedAmountNoTax")
    ] = None
    billed_tax: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="billedTax")] = None
    total_billed_amount: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="totalBilledAmount")
    ] = None
    pending_billing_amount: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="pendingBillingAmount")
    ] = None
    creation_state: typing_extensions.Annotated[
        typing.Optional[CreationState], FieldMetadata(alias="creationState")
    ] = None
    order_lines: typing_extensions.Annotated[
        typing.Optional[typing.List[OrderLine]], FieldMetadata(alias="orderLines")
    ] = None
    customer: typing.Optional[Customer] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
