# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class PaginationMeta(UniversalBaseModel):
    """
    Pagination metadata for cost traces
    """

    limit: int = pydantic.Field()
    """
    The requested limit
    """

    offset: int = pydantic.Field()
    """
    The requested offset
    """

    count: int = pydantic.Field()
    """
    Number of items returned in this response
    """

    has_more: typing_extensions.Annotated[bool, FieldMetadata(alias="hasMore")] = pydantic.Field()
    """
    Whether there are more results available
    """

    start_time: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="startTime")] = (
        pydantic.Field(default=None)
    )
    """
    The startTime filter that was applied (if any)
    """

    end_time: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="endTime")] = (
        pydantic.Field(default=None)
    )
    """
    The endTime filter that was applied (if any)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
