# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AnnouncementSubscriptionsFilterGroupArgs', 'AnnouncementSubscriptionsFilterGroup']

@pulumi.input_type
class AnnouncementSubscriptionsFilterGroupArgs:
    def __init__(__self__, *,
                 announcement_subscription_id: pulumi.Input[builtins.str],
                 filters: pulumi.Input[Sequence[pulumi.Input['AnnouncementSubscriptionsFilterGroupFilterArgs']]],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AnnouncementSubscriptionsFilterGroup resource.
        :param pulumi.Input[builtins.str] announcement_subscription_id: The OCID of the announcement subscription.
        :param pulumi.Input[Sequence[pulumi.Input['AnnouncementSubscriptionsFilterGroupFilterArgs']]] filters: (Updatable) A list of filters against which the Announcements service will match announcements. You cannot have more than one of any given filter type within a filter group.
        :param pulumi.Input[builtins.str] name: The name of the filter group. The name must be unique and it cannot be changed. Avoid entering confidential information.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "announcement_subscription_id", announcement_subscription_id)
        pulumi.set(__self__, "filters", filters)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="announcementSubscriptionId")
    def announcement_subscription_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the announcement subscription.
        """
        return pulumi.get(self, "announcement_subscription_id")

    @announcement_subscription_id.setter
    def announcement_subscription_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "announcement_subscription_id", value)

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Input[Sequence[pulumi.Input['AnnouncementSubscriptionsFilterGroupFilterArgs']]]:
        """
        (Updatable) A list of filters against which the Announcements service will match announcements. You cannot have more than one of any given filter type within a filter group.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: pulumi.Input[Sequence[pulumi.Input['AnnouncementSubscriptionsFilterGroupFilterArgs']]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the filter group. The name must be unique and it cannot be changed. Avoid entering confidential information.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AnnouncementSubscriptionsFilterGroupState:
    def __init__(__self__, *,
                 announcement_subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['AnnouncementSubscriptionsFilterGroupFilterArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AnnouncementSubscriptionsFilterGroup resources.
        :param pulumi.Input[builtins.str] announcement_subscription_id: The OCID of the announcement subscription.
        :param pulumi.Input[Sequence[pulumi.Input['AnnouncementSubscriptionsFilterGroupFilterArgs']]] filters: (Updatable) A list of filters against which the Announcements service will match announcements. You cannot have more than one of any given filter type within a filter group.
        :param pulumi.Input[builtins.str] name: The name of the filter group. The name must be unique and it cannot be changed. Avoid entering confidential information.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if announcement_subscription_id is not None:
            pulumi.set(__self__, "announcement_subscription_id", announcement_subscription_id)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="announcementSubscriptionId")
    def announcement_subscription_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the announcement subscription.
        """
        return pulumi.get(self, "announcement_subscription_id")

    @announcement_subscription_id.setter
    def announcement_subscription_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "announcement_subscription_id", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AnnouncementSubscriptionsFilterGroupFilterArgs']]]]:
        """
        (Updatable) A list of filters against which the Announcements service will match announcements. You cannot have more than one of any given filter type within a filter group.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AnnouncementSubscriptionsFilterGroupFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the filter group. The name must be unique and it cannot be changed. Avoid entering confidential information.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


class AnnouncementSubscriptionsFilterGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 announcement_subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AnnouncementSubscriptionsFilterGroupFilterArgs', 'AnnouncementSubscriptionsFilterGroupFilterArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Announcement Subscriptions Filter Group resource in Oracle Cloud Infrastructure Announcements Service service.

        Creates a new filter group in the specified announcement subscription.

        This call is subject to an Announcements limit that applies to the total number of requests across all read or write operations. Announcements might throttle this call to reject an otherwise valid request when the total rate of operations exceeds 20 requests per second for a given user. The service might also throttle this call to reject an otherwise valid request when the total rate of operations exceeds 100 requests per second for a given tenancy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_announcement_subscriptions_filter_group = oci.announcements_service.AnnouncementSubscriptionsFilterGroup("test_announcement_subscriptions_filter_group",
            announcement_subscription_id=test_announcement_subscription["id"],
            filters=[{
                "type": announcement_subscriptions_filter_group_filters_type,
                "value": announcement_subscriptions_filter_group_filters_value,
            }],
            name=announcement_subscriptions_filter_group_name)
        ```

        ## Import

        AnnouncementSubscriptionsFilterGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:AnnouncementsService/announcementSubscriptionsFilterGroup:AnnouncementSubscriptionsFilterGroup test_announcement_subscriptions_filter_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] announcement_subscription_id: The OCID of the announcement subscription.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AnnouncementSubscriptionsFilterGroupFilterArgs', 'AnnouncementSubscriptionsFilterGroupFilterArgsDict']]]] filters: (Updatable) A list of filters against which the Announcements service will match announcements. You cannot have more than one of any given filter type within a filter group.
        :param pulumi.Input[builtins.str] name: The name of the filter group. The name must be unique and it cannot be changed. Avoid entering confidential information.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnnouncementSubscriptionsFilterGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Announcement Subscriptions Filter Group resource in Oracle Cloud Infrastructure Announcements Service service.

        Creates a new filter group in the specified announcement subscription.

        This call is subject to an Announcements limit that applies to the total number of requests across all read or write operations. Announcements might throttle this call to reject an otherwise valid request when the total rate of operations exceeds 20 requests per second for a given user. The service might also throttle this call to reject an otherwise valid request when the total rate of operations exceeds 100 requests per second for a given tenancy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_announcement_subscriptions_filter_group = oci.announcements_service.AnnouncementSubscriptionsFilterGroup("test_announcement_subscriptions_filter_group",
            announcement_subscription_id=test_announcement_subscription["id"],
            filters=[{
                "type": announcement_subscriptions_filter_group_filters_type,
                "value": announcement_subscriptions_filter_group_filters_value,
            }],
            name=announcement_subscriptions_filter_group_name)
        ```

        ## Import

        AnnouncementSubscriptionsFilterGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:AnnouncementsService/announcementSubscriptionsFilterGroup:AnnouncementSubscriptionsFilterGroup test_announcement_subscriptions_filter_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param AnnouncementSubscriptionsFilterGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnnouncementSubscriptionsFilterGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 announcement_subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AnnouncementSubscriptionsFilterGroupFilterArgs', 'AnnouncementSubscriptionsFilterGroupFilterArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnnouncementSubscriptionsFilterGroupArgs.__new__(AnnouncementSubscriptionsFilterGroupArgs)

            if announcement_subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'announcement_subscription_id'")
            __props__.__dict__["announcement_subscription_id"] = announcement_subscription_id
            if filters is None and not opts.urn:
                raise TypeError("Missing required property 'filters'")
            __props__.__dict__["filters"] = filters
            __props__.__dict__["name"] = name
        super(AnnouncementSubscriptionsFilterGroup, __self__).__init__(
            'oci:AnnouncementsService/announcementSubscriptionsFilterGroup:AnnouncementSubscriptionsFilterGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            announcement_subscription_id: Optional[pulumi.Input[builtins.str]] = None,
            filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AnnouncementSubscriptionsFilterGroupFilterArgs', 'AnnouncementSubscriptionsFilterGroupFilterArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'AnnouncementSubscriptionsFilterGroup':
        """
        Get an existing AnnouncementSubscriptionsFilterGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] announcement_subscription_id: The OCID of the announcement subscription.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AnnouncementSubscriptionsFilterGroupFilterArgs', 'AnnouncementSubscriptionsFilterGroupFilterArgsDict']]]] filters: (Updatable) A list of filters against which the Announcements service will match announcements. You cannot have more than one of any given filter type within a filter group.
        :param pulumi.Input[builtins.str] name: The name of the filter group. The name must be unique and it cannot be changed. Avoid entering confidential information.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AnnouncementSubscriptionsFilterGroupState.__new__(_AnnouncementSubscriptionsFilterGroupState)

        __props__.__dict__["announcement_subscription_id"] = announcement_subscription_id
        __props__.__dict__["filters"] = filters
        __props__.__dict__["name"] = name
        return AnnouncementSubscriptionsFilterGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="announcementSubscriptionId")
    def announcement_subscription_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the announcement subscription.
        """
        return pulumi.get(self, "announcement_subscription_id")

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Sequence['outputs.AnnouncementSubscriptionsFilterGroupFilter']]:
        """
        (Updatable) A list of filters against which the Announcements service will match announcements. You cannot have more than one of any given filter type within a filter group.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the filter group. The name must be unique and it cannot be changed. Avoid entering confidential information.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

