# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterNetworkResult',
    'AwaitableGetClusterNetworkResult',
    'get_cluster_network',
    'get_cluster_network_output',
]

@pulumi.output_type
class GetClusterNetworkResult:
    """
    A collection of values returned by getClusterNetwork.
    """
    def __init__(__self__, cluster_configurations=None, cluster_network_id=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, hpc_island_id=None, id=None, instance_pools=None, network_block_ids=None, placement_configurations=None, state=None, time_created=None, time_updated=None):
        if cluster_configurations and not isinstance(cluster_configurations, list):
            raise TypeError("Expected argument 'cluster_configurations' to be a list")
        pulumi.set(__self__, "cluster_configurations", cluster_configurations)
        if cluster_network_id and not isinstance(cluster_network_id, str):
            raise TypeError("Expected argument 'cluster_network_id' to be a str")
        pulumi.set(__self__, "cluster_network_id", cluster_network_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hpc_island_id and not isinstance(hpc_island_id, str):
            raise TypeError("Expected argument 'hpc_island_id' to be a str")
        pulumi.set(__self__, "hpc_island_id", hpc_island_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_pools and not isinstance(instance_pools, list):
            raise TypeError("Expected argument 'instance_pools' to be a list")
        pulumi.set(__self__, "instance_pools", instance_pools)
        if network_block_ids and not isinstance(network_block_ids, list):
            raise TypeError("Expected argument 'network_block_ids' to be a list")
        pulumi.set(__self__, "network_block_ids", network_block_ids)
        if placement_configurations and not isinstance(placement_configurations, list):
            raise TypeError("Expected argument 'placement_configurations' to be a list")
        pulumi.set(__self__, "placement_configurations", placement_configurations)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="clusterConfigurations")
    def cluster_configurations(self) -> Sequence['outputs.GetClusterNetworkClusterConfigurationResult']:
        return pulumi.get(self, "cluster_configurations")

    @property
    @pulumi.getter(name="clusterNetworkId")
    def cluster_network_id(self) -> builtins.str:
        return pulumi.get(self, "cluster_network_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance pool.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The display name of the VNIC. This is also used to match against the instance configuration defined secondary VNIC.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hpcIslandId")
    def hpc_island_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the HPC island used by the cluster network.
        """
        return pulumi.get(self, "hpc_island_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer attachment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instancePools")
    def instance_pools(self) -> Sequence['outputs.GetClusterNetworkInstancePoolResult']:
        """
        The instance pools in the cluster network.
        """
        return pulumi.get(self, "instance_pools")

    @property
    @pulumi.getter(name="networkBlockIds")
    def network_block_ids(self) -> Sequence[builtins.str]:
        """
        The list of network block OCIDs of the HPC island.
        """
        return pulumi.get(self, "network_block_ids")

    @property
    @pulumi.getter(name="placementConfigurations")
    def placement_configurations(self) -> Sequence['outputs.GetClusterNetworkPlacementConfigurationResult']:
        """
        The location for where the instance pools in a cluster network will place instances.
        """
        return pulumi.get(self, "placement_configurations")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the cluster network.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the resource was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetClusterNetworkResult(GetClusterNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterNetworkResult(
            cluster_configurations=self.cluster_configurations,
            cluster_network_id=self.cluster_network_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            hpc_island_id=self.hpc_island_id,
            id=self.id,
            instance_pools=self.instance_pools,
            network_block_ids=self.network_block_ids,
            placement_configurations=self.placement_configurations,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_cluster_network(cluster_network_id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterNetworkResult:
    """
    This data source provides details about a specific Cluster Network resource in Oracle Cloud Infrastructure Core service.

    Gets information about a [cluster network with instance pools](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/managingclusternetworks.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster_network = oci.Core.get_cluster_network(cluster_network_id=test_cluster_network_oci_core_cluster_network["id"])
    ```


    :param builtins.str cluster_network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster network.
    """
    __args__ = dict()
    __args__['clusterNetworkId'] = cluster_network_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getClusterNetwork:getClusterNetwork', __args__, opts=opts, typ=GetClusterNetworkResult).value

    return AwaitableGetClusterNetworkResult(
        cluster_configurations=pulumi.get(__ret__, 'cluster_configurations'),
        cluster_network_id=pulumi.get(__ret__, 'cluster_network_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        hpc_island_id=pulumi.get(__ret__, 'hpc_island_id'),
        id=pulumi.get(__ret__, 'id'),
        instance_pools=pulumi.get(__ret__, 'instance_pools'),
        network_block_ids=pulumi.get(__ret__, 'network_block_ids'),
        placement_configurations=pulumi.get(__ret__, 'placement_configurations'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_cluster_network_output(cluster_network_id: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterNetworkResult]:
    """
    This data source provides details about a specific Cluster Network resource in Oracle Cloud Infrastructure Core service.

    Gets information about a [cluster network with instance pools](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/managingclusternetworks.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster_network = oci.Core.get_cluster_network(cluster_network_id=test_cluster_network_oci_core_cluster_network["id"])
    ```


    :param builtins.str cluster_network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster network.
    """
    __args__ = dict()
    __args__['clusterNetworkId'] = cluster_network_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getClusterNetwork:getClusterNetwork', __args__, opts=opts, typ=GetClusterNetworkResult)
    return __ret__.apply(lambda __response__: GetClusterNetworkResult(
        cluster_configurations=pulumi.get(__response__, 'cluster_configurations'),
        cluster_network_id=pulumi.get(__response__, 'cluster_network_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        hpc_island_id=pulumi.get(__response__, 'hpc_island_id'),
        id=pulumi.get(__response__, 'id'),
        instance_pools=pulumi.get(__response__, 'instance_pools'),
        network_block_ids=pulumi.get(__response__, 'network_block_ids'),
        placement_configurations=pulumi.get(__response__, 'placement_configurations'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
