# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ImageArgs', 'Image']

@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 image_source_details: Optional[pulumi.Input['ImageImageSourceDetailsArgs']] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 launch_mode: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Image resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment you want the image to be created in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name for the image. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               You cannot use a platform image name as a custom image name.
               
               Example: `My Oracle Linux image`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] instance_id: The OCID of the instance you want to use as the basis for the image.
        :param pulumi.Input[builtins.str] launch_mode: Specifies the configuration mode for launching virtual machine (VM) instances. The configuration modes are:
               * `NATIVE` - VM instances launch with iSCSI boot and VFIO devices. The default value for platform images.
               * `EMULATED` - VM instances launch with emulated devices, such as the E1000 network driver and emulated SCSI disk controller.
               * `PARAVIRTUALIZED` - VM instances launch with paravirtualized devices using VirtIO drivers.
               * `CUSTOM` - VM instances launch with custom configuration settings specified in the `LaunchOptions` parameter.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if image_source_details is not None:
            pulumi.set(__self__, "image_source_details", image_source_details)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if launch_mode is not None:
            pulumi.set(__self__, "launch_mode", launch_mode)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the compartment you want the image to be created in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name for the image. It does not have to be unique, and it's changeable. Avoid entering confidential information.

        You cannot use a platform image name as a custom image name.

        Example: `My Oracle Linux image`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="imageSourceDetails")
    def image_source_details(self) -> Optional[pulumi.Input['ImageImageSourceDetailsArgs']]:
        return pulumi.get(self, "image_source_details")

    @image_source_details.setter
    def image_source_details(self, value: Optional[pulumi.Input['ImageImageSourceDetailsArgs']]):
        pulumi.set(self, "image_source_details", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the instance you want to use as the basis for the image.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="launchMode")
    def launch_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the configuration mode for launching virtual machine (VM) instances. The configuration modes are:
        * `NATIVE` - VM instances launch with iSCSI boot and VFIO devices. The default value for platform images.
        * `EMULATED` - VM instances launch with emulated devices, such as the E1000 network driver and emulated SCSI disk controller.
        * `PARAVIRTUALIZED` - VM instances launch with paravirtualized devices using VirtIO drivers.
        * `CUSTOM` - VM instances launch with custom configuration settings specified in the `LaunchOptions` parameter.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "launch_mode")

    @launch_mode.setter
    def launch_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "launch_mode", value)


@pulumi.input_type
class _ImageState:
    def __init__(__self__, *,
                 agent_features: Optional[pulumi.Input[Sequence[pulumi.Input['ImageAgentFeatureArgs']]]] = None,
                 base_image_id: Optional[pulumi.Input[builtins.str]] = None,
                 billable_size_in_gbs: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_image_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 image_source_details: Optional[pulumi.Input['ImageImageSourceDetailsArgs']] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 launch_mode: Optional[pulumi.Input[builtins.str]] = None,
                 launch_options: Optional[pulumi.Input[Sequence[pulumi.Input['ImageLaunchOptionArgs']]]] = None,
                 listing_type: Optional[pulumi.Input[builtins.str]] = None,
                 operating_system: Optional[pulumi.Input[builtins.str]] = None,
                 operating_system_version: Optional[pulumi.Input[builtins.str]] = None,
                 size_in_mbs: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Image resources.
        :param pulumi.Input[Sequence[pulumi.Input['ImageAgentFeatureArgs']]] agent_features: Oracle Cloud Agent features supported on the image.
        :param pulumi.Input[builtins.str] base_image_id: The OCID of the image originally used to launch the instance.
        :param pulumi.Input[builtins.str] billable_size_in_gbs: The size of the internal storage for this image that is subject to billing (1 GB = 1,073,741,824 bytes).  Example: `100`
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment you want the image to be created in.
        :param pulumi.Input[builtins.bool] create_image_allowed: Whether instances launched with this image can be used to create new images. For example, you cannot create an image of an Oracle Database instance.  Example: `true`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name for the image. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               You cannot use a platform image name as a custom image name.
               
               Example: `My Oracle Linux image`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] instance_id: The OCID of the instance you want to use as the basis for the image.
        :param pulumi.Input[builtins.str] launch_mode: Specifies the configuration mode for launching virtual machine (VM) instances. The configuration modes are:
               * `NATIVE` - VM instances launch with iSCSI boot and VFIO devices. The default value for platform images.
               * `EMULATED` - VM instances launch with emulated devices, such as the E1000 network driver and emulated SCSI disk controller.
               * `PARAVIRTUALIZED` - VM instances launch with paravirtualized devices using VirtIO drivers.
               * `CUSTOM` - VM instances launch with custom configuration settings specified in the `LaunchOptions` parameter.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['ImageLaunchOptionArgs']]] launch_options: Options for tuning the compatibility and performance of VM shapes. The values that you specify override any default values.
        :param pulumi.Input[builtins.str] listing_type: The listing type of the image. The default value is "NONE".
        :param pulumi.Input[builtins.str] operating_system: The image's operating system.  Example: `Oracle Linux`
        :param pulumi.Input[builtins.str] operating_system_version: The image's operating system version.  Example: `7.2`
        :param pulumi.Input[builtins.str] size_in_mbs: The boot volume size for an instance launched from this image (1 MB = 1,048,576 bytes). Note this is not the same as the size of the image when it was exported or the actual size of the image.  Example: `47694`
        :param pulumi.Input[builtins.str] state: The current state of the image.
        :param pulumi.Input[builtins.str] time_created: The date and time the image was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        if agent_features is not None:
            pulumi.set(__self__, "agent_features", agent_features)
        if base_image_id is not None:
            pulumi.set(__self__, "base_image_id", base_image_id)
        if billable_size_in_gbs is not None:
            pulumi.set(__self__, "billable_size_in_gbs", billable_size_in_gbs)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if create_image_allowed is not None:
            pulumi.set(__self__, "create_image_allowed", create_image_allowed)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if image_source_details is not None:
            pulumi.set(__self__, "image_source_details", image_source_details)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if launch_mode is not None:
            pulumi.set(__self__, "launch_mode", launch_mode)
        if launch_options is not None:
            pulumi.set(__self__, "launch_options", launch_options)
        if listing_type is not None:
            pulumi.set(__self__, "listing_type", listing_type)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if operating_system_version is not None:
            pulumi.set(__self__, "operating_system_version", operating_system_version)
        if size_in_mbs is not None:
            pulumi.set(__self__, "size_in_mbs", size_in_mbs)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="agentFeatures")
    def agent_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageAgentFeatureArgs']]]]:
        """
        Oracle Cloud Agent features supported on the image.
        """
        return pulumi.get(self, "agent_features")

    @agent_features.setter
    def agent_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageAgentFeatureArgs']]]]):
        pulumi.set(self, "agent_features", value)

    @property
    @pulumi.getter(name="baseImageId")
    def base_image_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the image originally used to launch the instance.
        """
        return pulumi.get(self, "base_image_id")

    @base_image_id.setter
    def base_image_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "base_image_id", value)

    @property
    @pulumi.getter(name="billableSizeInGbs")
    def billable_size_in_gbs(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The size of the internal storage for this image that is subject to billing (1 GB = 1,073,741,824 bytes).  Example: `100`
        """
        return pulumi.get(self, "billable_size_in_gbs")

    @billable_size_in_gbs.setter
    def billable_size_in_gbs(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "billable_size_in_gbs", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment you want the image to be created in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="createImageAllowed")
    def create_image_allowed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether instances launched with this image can be used to create new images. For example, you cannot create an image of an Oracle Database instance.  Example: `true`
        """
        return pulumi.get(self, "create_image_allowed")

    @create_image_allowed.setter
    def create_image_allowed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "create_image_allowed", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name for the image. It does not have to be unique, and it's changeable. Avoid entering confidential information.

        You cannot use a platform image name as a custom image name.

        Example: `My Oracle Linux image`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="imageSourceDetails")
    def image_source_details(self) -> Optional[pulumi.Input['ImageImageSourceDetailsArgs']]:
        return pulumi.get(self, "image_source_details")

    @image_source_details.setter
    def image_source_details(self, value: Optional[pulumi.Input['ImageImageSourceDetailsArgs']]):
        pulumi.set(self, "image_source_details", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the instance you want to use as the basis for the image.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="launchMode")
    def launch_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the configuration mode for launching virtual machine (VM) instances. The configuration modes are:
        * `NATIVE` - VM instances launch with iSCSI boot and VFIO devices. The default value for platform images.
        * `EMULATED` - VM instances launch with emulated devices, such as the E1000 network driver and emulated SCSI disk controller.
        * `PARAVIRTUALIZED` - VM instances launch with paravirtualized devices using VirtIO drivers.
        * `CUSTOM` - VM instances launch with custom configuration settings specified in the `LaunchOptions` parameter.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "launch_mode")

    @launch_mode.setter
    def launch_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "launch_mode", value)

    @property
    @pulumi.getter(name="launchOptions")
    def launch_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageLaunchOptionArgs']]]]:
        """
        Options for tuning the compatibility and performance of VM shapes. The values that you specify override any default values.
        """
        return pulumi.get(self, "launch_options")

    @launch_options.setter
    def launch_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageLaunchOptionArgs']]]]):
        pulumi.set(self, "launch_options", value)

    @property
    @pulumi.getter(name="listingType")
    def listing_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The listing type of the image. The default value is "NONE".
        """
        return pulumi.get(self, "listing_type")

    @listing_type.setter
    def listing_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "listing_type", value)

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The image's operating system.  Example: `Oracle Linux`
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operating_system", value)

    @property
    @pulumi.getter(name="operatingSystemVersion")
    def operating_system_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The image's operating system version.  Example: `7.2`
        """
        return pulumi.get(self, "operating_system_version")

    @operating_system_version.setter
    def operating_system_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operating_system_version", value)

    @property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The boot volume size for an instance launched from this image (1 MB = 1,048,576 bytes). Note this is not the same as the size of the image when it was exported or the actual size of the image.  Example: `47694`
        """
        return pulumi.get(self, "size_in_mbs")

    @size_in_mbs.setter
    def size_in_mbs(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "size_in_mbs", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the image.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the image was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)


class Image(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 image_source_details: Optional[pulumi.Input[Union['ImageImageSourceDetailsArgs', 'ImageImageSourceDetailsArgsDict']]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 launch_mode: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Image resource in Oracle Cloud Infrastructure Core service.

        Creates a boot disk image for the specified instance or imports an exported image from the Oracle Cloud Infrastructure Object Storage service.

        When creating a new image, you must provide the OCID of the instance you want to use as the basis for the image, and
        the OCID of the compartment containing that instance. For more information about images,
        see [Managing Custom Images](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/managingcustomimages.htm).

        When importing an exported image from Object Storage, you specify the source information
        in [ImageSourceDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/requests/ImageSourceDetails).

        When importing an image based on the namespace, bucket name, and object name,
        use [ImageSourceViaObjectStorageTupleDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/requests/ImageSourceViaObjectStorageTupleDetails).

        When importing an image based on the Object Storage URL, use
        [ImageSourceViaObjectStorageUriDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/requests/ImageSourceViaObjectStorageUriDetails).
        See [Object Storage URLs](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/imageimportexport.htm#URLs) and [Using Pre-Authenticated Requests](https://docs.cloud.oracle.com/iaas/Content/Object/Tasks/usingpreauthenticatedrequests.htm)
        for constructing URLs for image import/export.

        For more information about importing exported images, see
        [Image Import/Export](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/imageimportexport.htm).

        You may optionally specify a *display name* for the image, which is simply a friendly name or description.
        It does not have to be unique, and you can change it. See [UpdateImage](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Image/UpdateImage).
        Avoid entering confidential information.

        ## Example Usage

        ### Create image from instance in tenancy
        ```python
        import pulumi
        import pulumi_oci as oci

        test_image = oci.core.Image("test_image",
            compartment_id=compartment_id,
            instance_id=test_instance["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=image_display_name,
            launch_mode=image_launch_mode,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ### Create image from exported image via direct access to object store
        ```python
        import pulumi
        import pulumi_oci as oci

        test_image = oci.core.Image("test_image",
            compartment_id=compartment_id,
            display_name=image_display_name,
            launch_mode=image_launch_mode,
            image_source_details={
                "source_type": "objectStorageTuple",
                "bucket_name": bucket_name,
                "namespace_name": namespace,
                "object_name": object_name,
                "operating_system": image_image_source_details_operating_system,
                "operating_system_version": image_image_source_details_operating_system_version,
                "source_image_type": source_image_type,
            })
        ```

        ### Create image from exported image at publicly accessible uri
        ```python
        import pulumi
        import pulumi_oci as oci

        test_image = oci.core.Image("test_image",
            compartment_id=compartment_id,
            display_name=image_display_name,
            launch_mode=image_launch_mode,
            image_source_details={
                "source_type": "objectStorageUri",
                "source_uri": source_uri,
                "operating_system": image_image_source_details_operating_system,
                "operating_system_version": image_image_source_details_operating_system_version,
                "source_image_type": source_image_type,
            })
        ```

        ## Import

        Images can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/image:Image test_image "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment you want the image to be created in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name for the image. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               You cannot use a platform image name as a custom image name.
               
               Example: `My Oracle Linux image`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] instance_id: The OCID of the instance you want to use as the basis for the image.
        :param pulumi.Input[builtins.str] launch_mode: Specifies the configuration mode for launching virtual machine (VM) instances. The configuration modes are:
               * `NATIVE` - VM instances launch with iSCSI boot and VFIO devices. The default value for platform images.
               * `EMULATED` - VM instances launch with emulated devices, such as the E1000 network driver and emulated SCSI disk controller.
               * `PARAVIRTUALIZED` - VM instances launch with paravirtualized devices using VirtIO drivers.
               * `CUSTOM` - VM instances launch with custom configuration settings specified in the `LaunchOptions` parameter.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Image resource in Oracle Cloud Infrastructure Core service.

        Creates a boot disk image for the specified instance or imports an exported image from the Oracle Cloud Infrastructure Object Storage service.

        When creating a new image, you must provide the OCID of the instance you want to use as the basis for the image, and
        the OCID of the compartment containing that instance. For more information about images,
        see [Managing Custom Images](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/managingcustomimages.htm).

        When importing an exported image from Object Storage, you specify the source information
        in [ImageSourceDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/requests/ImageSourceDetails).

        When importing an image based on the namespace, bucket name, and object name,
        use [ImageSourceViaObjectStorageTupleDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/requests/ImageSourceViaObjectStorageTupleDetails).

        When importing an image based on the Object Storage URL, use
        [ImageSourceViaObjectStorageUriDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/requests/ImageSourceViaObjectStorageUriDetails).
        See [Object Storage URLs](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/imageimportexport.htm#URLs) and [Using Pre-Authenticated Requests](https://docs.cloud.oracle.com/iaas/Content/Object/Tasks/usingpreauthenticatedrequests.htm)
        for constructing URLs for image import/export.

        For more information about importing exported images, see
        [Image Import/Export](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/imageimportexport.htm).

        You may optionally specify a *display name* for the image, which is simply a friendly name or description.
        It does not have to be unique, and you can change it. See [UpdateImage](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Image/UpdateImage).
        Avoid entering confidential information.

        ## Example Usage

        ### Create image from instance in tenancy
        ```python
        import pulumi
        import pulumi_oci as oci

        test_image = oci.core.Image("test_image",
            compartment_id=compartment_id,
            instance_id=test_instance["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=image_display_name,
            launch_mode=image_launch_mode,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ### Create image from exported image via direct access to object store
        ```python
        import pulumi
        import pulumi_oci as oci

        test_image = oci.core.Image("test_image",
            compartment_id=compartment_id,
            display_name=image_display_name,
            launch_mode=image_launch_mode,
            image_source_details={
                "source_type": "objectStorageTuple",
                "bucket_name": bucket_name,
                "namespace_name": namespace,
                "object_name": object_name,
                "operating_system": image_image_source_details_operating_system,
                "operating_system_version": image_image_source_details_operating_system_version,
                "source_image_type": source_image_type,
            })
        ```

        ### Create image from exported image at publicly accessible uri
        ```python
        import pulumi
        import pulumi_oci as oci

        test_image = oci.core.Image("test_image",
            compartment_id=compartment_id,
            display_name=image_display_name,
            launch_mode=image_launch_mode,
            image_source_details={
                "source_type": "objectStorageUri",
                "source_uri": source_uri,
                "operating_system": image_image_source_details_operating_system,
                "operating_system_version": image_image_source_details_operating_system_version,
                "source_image_type": source_image_type,
            })
        ```

        ## Import

        Images can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/image:Image test_image "id"
        ```

        :param str resource_name: The name of the resource.
        :param ImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 image_source_details: Optional[pulumi.Input[Union['ImageImageSourceDetailsArgs', 'ImageImageSourceDetailsArgsDict']]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 launch_mode: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageArgs.__new__(ImageArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["image_source_details"] = image_source_details
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["launch_mode"] = launch_mode
            __props__.__dict__["agent_features"] = None
            __props__.__dict__["base_image_id"] = None
            __props__.__dict__["billable_size_in_gbs"] = None
            __props__.__dict__["create_image_allowed"] = None
            __props__.__dict__["launch_options"] = None
            __props__.__dict__["listing_type"] = None
            __props__.__dict__["operating_system"] = None
            __props__.__dict__["operating_system_version"] = None
            __props__.__dict__["size_in_mbs"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(Image, __self__).__init__(
            'oci:Core/image:Image',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageAgentFeatureArgs', 'ImageAgentFeatureArgsDict']]]]] = None,
            base_image_id: Optional[pulumi.Input[builtins.str]] = None,
            billable_size_in_gbs: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            create_image_allowed: Optional[pulumi.Input[builtins.bool]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            image_source_details: Optional[pulumi.Input[Union['ImageImageSourceDetailsArgs', 'ImageImageSourceDetailsArgsDict']]] = None,
            instance_id: Optional[pulumi.Input[builtins.str]] = None,
            launch_mode: Optional[pulumi.Input[builtins.str]] = None,
            launch_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageLaunchOptionArgs', 'ImageLaunchOptionArgsDict']]]]] = None,
            listing_type: Optional[pulumi.Input[builtins.str]] = None,
            operating_system: Optional[pulumi.Input[builtins.str]] = None,
            operating_system_version: Optional[pulumi.Input[builtins.str]] = None,
            size_in_mbs: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None) -> 'Image':
        """
        Get an existing Image resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageAgentFeatureArgs', 'ImageAgentFeatureArgsDict']]]] agent_features: Oracle Cloud Agent features supported on the image.
        :param pulumi.Input[builtins.str] base_image_id: The OCID of the image originally used to launch the instance.
        :param pulumi.Input[builtins.str] billable_size_in_gbs: The size of the internal storage for this image that is subject to billing (1 GB = 1,073,741,824 bytes).  Example: `100`
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment you want the image to be created in.
        :param pulumi.Input[builtins.bool] create_image_allowed: Whether instances launched with this image can be used to create new images. For example, you cannot create an image of an Oracle Database instance.  Example: `true`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name for the image. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               You cannot use a platform image name as a custom image name.
               
               Example: `My Oracle Linux image`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] instance_id: The OCID of the instance you want to use as the basis for the image.
        :param pulumi.Input[builtins.str] launch_mode: Specifies the configuration mode for launching virtual machine (VM) instances. The configuration modes are:
               * `NATIVE` - VM instances launch with iSCSI boot and VFIO devices. The default value for platform images.
               * `EMULATED` - VM instances launch with emulated devices, such as the E1000 network driver and emulated SCSI disk controller.
               * `PARAVIRTUALIZED` - VM instances launch with paravirtualized devices using VirtIO drivers.
               * `CUSTOM` - VM instances launch with custom configuration settings specified in the `LaunchOptions` parameter.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageLaunchOptionArgs', 'ImageLaunchOptionArgsDict']]]] launch_options: Options for tuning the compatibility and performance of VM shapes. The values that you specify override any default values.
        :param pulumi.Input[builtins.str] listing_type: The listing type of the image. The default value is "NONE".
        :param pulumi.Input[builtins.str] operating_system: The image's operating system.  Example: `Oracle Linux`
        :param pulumi.Input[builtins.str] operating_system_version: The image's operating system version.  Example: `7.2`
        :param pulumi.Input[builtins.str] size_in_mbs: The boot volume size for an instance launched from this image (1 MB = 1,048,576 bytes). Note this is not the same as the size of the image when it was exported or the actual size of the image.  Example: `47694`
        :param pulumi.Input[builtins.str] state: The current state of the image.
        :param pulumi.Input[builtins.str] time_created: The date and time the image was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageState.__new__(_ImageState)

        __props__.__dict__["agent_features"] = agent_features
        __props__.__dict__["base_image_id"] = base_image_id
        __props__.__dict__["billable_size_in_gbs"] = billable_size_in_gbs
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["create_image_allowed"] = create_image_allowed
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["image_source_details"] = image_source_details
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["launch_mode"] = launch_mode
        __props__.__dict__["launch_options"] = launch_options
        __props__.__dict__["listing_type"] = listing_type
        __props__.__dict__["operating_system"] = operating_system
        __props__.__dict__["operating_system_version"] = operating_system_version
        __props__.__dict__["size_in_mbs"] = size_in_mbs
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return Image(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentFeatures")
    def agent_features(self) -> pulumi.Output[Sequence['outputs.ImageAgentFeature']]:
        """
        Oracle Cloud Agent features supported on the image.
        """
        return pulumi.get(self, "agent_features")

    @property
    @pulumi.getter(name="baseImageId")
    def base_image_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the image originally used to launch the instance.
        """
        return pulumi.get(self, "base_image_id")

    @property
    @pulumi.getter(name="billableSizeInGbs")
    def billable_size_in_gbs(self) -> pulumi.Output[builtins.str]:
        """
        The size of the internal storage for this image that is subject to billing (1 GB = 1,073,741,824 bytes).  Example: `100`
        """
        return pulumi.get(self, "billable_size_in_gbs")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the compartment you want the image to be created in.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createImageAllowed")
    def create_image_allowed(self) -> pulumi.Output[builtins.bool]:
        """
        Whether instances launched with this image can be used to create new images. For example, you cannot create an image of an Oracle Database instance.  Example: `true`
        """
        return pulumi.get(self, "create_image_allowed")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name for the image. It does not have to be unique, and it's changeable. Avoid entering confidential information.

        You cannot use a platform image name as a custom image name.

        Example: `My Oracle Linux image`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="imageSourceDetails")
    def image_source_details(self) -> pulumi.Output[Optional['outputs.ImageImageSourceDetails']]:
        return pulumi.get(self, "image_source_details")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The OCID of the instance you want to use as the basis for the image.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="launchMode")
    def launch_mode(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the configuration mode for launching virtual machine (VM) instances. The configuration modes are:
        * `NATIVE` - VM instances launch with iSCSI boot and VFIO devices. The default value for platform images.
        * `EMULATED` - VM instances launch with emulated devices, such as the E1000 network driver and emulated SCSI disk controller.
        * `PARAVIRTUALIZED` - VM instances launch with paravirtualized devices using VirtIO drivers.
        * `CUSTOM` - VM instances launch with custom configuration settings specified in the `LaunchOptions` parameter.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "launch_mode")

    @property
    @pulumi.getter(name="launchOptions")
    def launch_options(self) -> pulumi.Output[Sequence['outputs.ImageLaunchOption']]:
        """
        Options for tuning the compatibility and performance of VM shapes. The values that you specify override any default values.
        """
        return pulumi.get(self, "launch_options")

    @property
    @pulumi.getter(name="listingType")
    def listing_type(self) -> pulumi.Output[builtins.str]:
        """
        The listing type of the image. The default value is "NONE".
        """
        return pulumi.get(self, "listing_type")

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> pulumi.Output[builtins.str]:
        """
        The image's operating system.  Example: `Oracle Linux`
        """
        return pulumi.get(self, "operating_system")

    @property
    @pulumi.getter(name="operatingSystemVersion")
    def operating_system_version(self) -> pulumi.Output[builtins.str]:
        """
        The image's operating system version.  Example: `7.2`
        """
        return pulumi.get(self, "operating_system_version")

    @property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> pulumi.Output[builtins.str]:
        """
        The boot volume size for an instance launched from this image (1 MB = 1,048,576 bytes). Note this is not the same as the size of the image when it was exported or the actual size of the image.  Example: `47694`
        """
        return pulumi.get(self, "size_in_mbs")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the image.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the image was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

