# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutonomousContainerDatabaseAddStandbyArgs', 'AutonomousContainerDatabaseAddStandby']

@pulumi.input_type
class AutonomousContainerDatabaseAddStandbyArgs:
    def __init__(__self__, *,
                 autonomous_container_database_id: pulumi.Input[builtins.str],
                 fast_start_fail_over_lag_limit_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 is_automatic_failover_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 peer_autonomous_container_database_backup_config: Optional[pulumi.Input['AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgs']] = None,
                 peer_autonomous_container_database_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_container_database_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_cloud_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_db_unique_name: Optional[pulumi.Input[builtins.str]] = None,
                 protection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 standby_maintenance_buffer_in_days: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a AutonomousContainerDatabaseAddStandby resource.
        :param pulumi.Input[builtins.str] autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.int] fast_start_fail_over_lag_limit_in_seconds: The lag time for my preference based on data loss tolerance in seconds.
        :param pulumi.Input[builtins.bool] is_automatic_failover_enabled: Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association
        :param pulumi.Input['AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgs'] peer_autonomous_container_database_backup_config: Backup options for the standby Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where the standby Autonomous Container Database will be created.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_display_name: The display name for the peer Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] peer_cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] peer_db_unique_name: Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        :param pulumi.Input[builtins.str] protection_mode: The protection mode of this Autonomous Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        :param pulumi.Input[builtins.int] standby_maintenance_buffer_in_days: The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database. This value represents the number of days before scheduled maintenance of the primary database. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "autonomous_container_database_id", autonomous_container_database_id)
        if fast_start_fail_over_lag_limit_in_seconds is not None:
            pulumi.set(__self__, "fast_start_fail_over_lag_limit_in_seconds", fast_start_fail_over_lag_limit_in_seconds)
        if is_automatic_failover_enabled is not None:
            pulumi.set(__self__, "is_automatic_failover_enabled", is_automatic_failover_enabled)
        if peer_autonomous_container_database_backup_config is not None:
            pulumi.set(__self__, "peer_autonomous_container_database_backup_config", peer_autonomous_container_database_backup_config)
        if peer_autonomous_container_database_compartment_id is not None:
            pulumi.set(__self__, "peer_autonomous_container_database_compartment_id", peer_autonomous_container_database_compartment_id)
        if peer_autonomous_container_database_display_name is not None:
            pulumi.set(__self__, "peer_autonomous_container_database_display_name", peer_autonomous_container_database_display_name)
        if peer_autonomous_vm_cluster_id is not None:
            pulumi.set(__self__, "peer_autonomous_vm_cluster_id", peer_autonomous_vm_cluster_id)
        if peer_cloud_autonomous_vm_cluster_id is not None:
            pulumi.set(__self__, "peer_cloud_autonomous_vm_cluster_id", peer_cloud_autonomous_vm_cluster_id)
        if peer_db_unique_name is not None:
            pulumi.set(__self__, "peer_db_unique_name", peer_db_unique_name)
        if protection_mode is not None:
            pulumi.set(__self__, "protection_mode", protection_mode)
        if standby_maintenance_buffer_in_days is not None:
            pulumi.set(__self__, "standby_maintenance_buffer_in_days", standby_maintenance_buffer_in_days)

    @property
    @pulumi.getter(name="autonomousContainerDatabaseId")
    def autonomous_container_database_id(self) -> pulumi.Input[builtins.str]:
        """
        The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_container_database_id")

    @autonomous_container_database_id.setter
    def autonomous_container_database_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "autonomous_container_database_id", value)

    @property
    @pulumi.getter(name="fastStartFailOverLagLimitInSeconds")
    def fast_start_fail_over_lag_limit_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The lag time for my preference based on data loss tolerance in seconds.
        """
        return pulumi.get(self, "fast_start_fail_over_lag_limit_in_seconds")

    @fast_start_fail_over_lag_limit_in_seconds.setter
    def fast_start_fail_over_lag_limit_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "fast_start_fail_over_lag_limit_in_seconds", value)

    @property
    @pulumi.getter(name="isAutomaticFailoverEnabled")
    def is_automatic_failover_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association
        """
        return pulumi.get(self, "is_automatic_failover_enabled")

    @is_automatic_failover_enabled.setter
    def is_automatic_failover_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_automatic_failover_enabled", value)

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseBackupConfig")
    def peer_autonomous_container_database_backup_config(self) -> Optional[pulumi.Input['AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgs']]:
        """
        Backup options for the standby Autonomous Container Database.
        """
        return pulumi.get(self, "peer_autonomous_container_database_backup_config")

    @peer_autonomous_container_database_backup_config.setter
    def peer_autonomous_container_database_backup_config(self, value: Optional[pulumi.Input['AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgs']]):
        pulumi.set(self, "peer_autonomous_container_database_backup_config", value)

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseCompartmentId")
    def peer_autonomous_container_database_compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where the standby Autonomous Container Database will be created.
        """
        return pulumi.get(self, "peer_autonomous_container_database_compartment_id")

    @peer_autonomous_container_database_compartment_id.setter
    def peer_autonomous_container_database_compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_autonomous_container_database_compartment_id", value)

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseDisplayName")
    def peer_autonomous_container_database_display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name for the peer Autonomous Container Database.
        """
        return pulumi.get(self, "peer_autonomous_container_database_display_name")

    @peer_autonomous_container_database_display_name.setter
    def peer_autonomous_container_database_display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_autonomous_container_database_display_name", value)

    @property
    @pulumi.getter(name="peerAutonomousVmClusterId")
    def peer_autonomous_vm_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "peer_autonomous_vm_cluster_id")

    @peer_autonomous_vm_cluster_id.setter
    def peer_autonomous_vm_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_autonomous_vm_cluster_id", value)

    @property
    @pulumi.getter(name="peerCloudAutonomousVmClusterId")
    def peer_cloud_autonomous_vm_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "peer_cloud_autonomous_vm_cluster_id")

    @peer_cloud_autonomous_vm_cluster_id.setter
    def peer_cloud_autonomous_vm_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_cloud_autonomous_vm_cluster_id", value)

    @property
    @pulumi.getter(name="peerDbUniqueName")
    def peer_db_unique_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        """
        return pulumi.get(self, "peer_db_unique_name")

    @peer_db_unique_name.setter
    def peer_db_unique_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_db_unique_name", value)

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The protection mode of this Autonomous Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        """
        return pulumi.get(self, "protection_mode")

    @protection_mode.setter
    def protection_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protection_mode", value)

    @property
    @pulumi.getter(name="standbyMaintenanceBufferInDays")
    def standby_maintenance_buffer_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database. This value represents the number of days before scheduled maintenance of the primary database. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "standby_maintenance_buffer_in_days")

    @standby_maintenance_buffer_in_days.setter
    def standby_maintenance_buffer_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "standby_maintenance_buffer_in_days", value)


@pulumi.input_type
class _AutonomousContainerDatabaseAddStandbyState:
    def __init__(__self__, *,
                 autonomous_container_database_id: Optional[pulumi.Input[builtins.str]] = None,
                 autonomous_exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                 autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 available_cpus: Optional[pulumi.Input[builtins.float]] = None,
                 backup_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyBackupConfigArgs']]]] = None,
                 cloud_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_model: Optional[pulumi.Input[builtins.str]] = None,
                 dataguard_group_members: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyDataguardGroupMemberArgs']]]] = None,
                 dataguards: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyDataguardArgs']]]] = None,
                 db_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_split_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 db_unique_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_version: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 distribution_affinity: Optional[pulumi.Input[builtins.str]] = None,
                 dst_file_version: Optional[pulumi.Input[builtins.str]] = None,
                 fast_start_fail_over_lag_limit_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 infrastructure_type: Optional[pulumi.Input[builtins.str]] = None,
                 is_automatic_failover_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_data_guard_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_dst_file_update_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_multiple_standby: Optional[pulumi.Input[builtins.bool]] = None,
                 key_history_entries: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyKeyHistoryEntryArgs']]]] = None,
                 key_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_store_wallet_name: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_version_id: Optional[pulumi.Input[builtins.str]] = None,
                 largest_provisionable_autonomous_database_in_cpus: Optional[pulumi.Input[builtins.float]] = None,
                 last_maintenance_run_id: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 list_one_off_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyMaintenanceWindowArgs']]]] = None,
                 memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
                 net_services_architecture: Optional[pulumi.Input[builtins.str]] = None,
                 next_maintenance_run_id: Optional[pulumi.Input[builtins.str]] = None,
                 patch_id: Optional[pulumi.Input[builtins.str]] = None,
                 patch_model: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_container_database_backup_config: Optional[pulumi.Input['AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgs']] = None,
                 peer_autonomous_container_database_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_container_database_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_cloud_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_db_unique_name: Optional[pulumi.Input[builtins.str]] = None,
                 protection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 provisionable_cpuses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.float]]]] = None,
                 provisioned_cpus: Optional[pulumi.Input[builtins.float]] = None,
                 reclaimable_cpus: Optional[pulumi.Input[builtins.float]] = None,
                 reserved_cpus: Optional[pulumi.Input[builtins.float]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 service_level_agreement_type: Optional[pulumi.Input[builtins.str]] = None,
                 standby_maintenance_buffer_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_of_last_backup: Optional[pulumi.Input[builtins.str]] = None,
                 time_snapshot_standby_revert: Optional[pulumi.Input[builtins.str]] = None,
                 total_cpus: Optional[pulumi.Input[builtins.int]] = None,
                 vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 version_preference: Optional[pulumi.Input[builtins.str]] = None,
                 vm_failover_reservation: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering AutonomousContainerDatabaseAddStandby resources.
        :param pulumi.Input[builtins.str] autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.str] autonomous_exadata_infrastructure_id: **No longer used.** For Autonomous Database on dedicated Exadata infrastructure, the container database is created within a specified `cloudAutonomousVmCluster`.
        :param pulumi.Input[builtins.str] autonomous_vm_cluster_id: The OCID of the Autonomous VM Cluster.
        :param pulumi.Input[builtins.str] availability_domain: The domain of the Autonomous Container Database
        :param pulumi.Input[builtins.float] available_cpus: Sum of CPUs available on the Autonomous VM Cluster + Sum of reclaimable CPUs available in the Autonomous Container Database.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyBackupConfigArgs']]] backup_configs: Backup options for the Autonomous Container Database.
        :param pulumi.Input[builtins.str] cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[builtins.str] compute_model: The compute model of the Autonomous Container Database. For Autonomous Database on Dedicated Exadata Infrastructure, the CPU type (ECPUs or OCPUs) is determined by the parent Autonomous Exadata VM Cluster's compute model. ECPU compute model is the recommended model and OCPU compute model is legacy. See [Compute Models in Autonomous Database on Dedicated Exadata Infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbak) for more details.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyDataguardGroupMemberArgs']]] dataguard_group_members: Array of Dg associations.
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyDataguardArgs']]] dataguards: The properties that define Autonomous Container Databases Dataguard.
        :param pulumi.Input[builtins.str] db_name: The Database name for the Autonomous Container Database. The name must be unique within the Cloud Autonomous VM Cluster, starting with an alphabetic character, followed by 1 to 7 alphanumeric characters.
        :param pulumi.Input[builtins.int] db_split_threshold: The CPU value beyond which an Autonomous Database will be opened across multiple nodes. The default value of this attribute is 16 for OCPUs and 64 for ECPUs.
        :param pulumi.Input[builtins.str] db_version: Oracle Database version of the Autonomous Container Database.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: The user-provided name for the Autonomous Container Database.
        :param pulumi.Input[builtins.str] distribution_affinity: Determines whether an Autonomous Database must be opened across the maximum number of nodes or the least number of nodes. By default, Minimum nodes is selected.
        :param pulumi.Input[builtins.str] dst_file_version: DST Time-Zone File version of the Autonomous Container Database.
        :param pulumi.Input[builtins.int] fast_start_fail_over_lag_limit_in_seconds: The lag time for my preference based on data loss tolerance in seconds.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] infrastructure_type: The infrastructure type this resource belongs to.
        :param pulumi.Input[builtins.bool] is_automatic_failover_enabled: Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association
        :param pulumi.Input[builtins.bool] is_data_guard_enabled: **Deprecated.** Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        :param pulumi.Input[builtins.bool] is_dst_file_update_enabled: Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.
        :param pulumi.Input[builtins.bool] is_multiple_standby: Whether it is multiple standby Autonomous Dataguard
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyKeyHistoryEntryArgs']]] key_history_entries: Key History Entry.
        :param pulumi.Input[builtins.str] key_store_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        :param pulumi.Input[builtins.str] key_store_wallet_name: The wallet name for Oracle Key Vault.
        :param pulumi.Input[builtins.str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[builtins.str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        :param pulumi.Input[builtins.float] largest_provisionable_autonomous_database_in_cpus: The largest Autonomous Database (CPU) that can be created in a new Autonomous Container Database.
        :param pulumi.Input[builtins.str] last_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] list_one_off_patches: List of One-Off patches that has been successfully applied to Autonomous Container Database
        :param pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyMaintenanceWindowArgs']]] maintenance_windows: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[builtins.int] memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) enabled per ECPU or OCPU in the Autonomous VM Cluster.
        :param pulumi.Input[builtins.str] net_services_architecture: Enabling SHARED server architecture enables a database server to allow many client processes to share very few server processes, thereby increasing the number of supported users.
        :param pulumi.Input[builtins.str] next_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        :param pulumi.Input[builtins.str] patch_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch applied on the system.
        :param pulumi.Input[builtins.str] patch_model: Database patch model preference.
        :param pulumi.Input['AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgs'] peer_autonomous_container_database_backup_config: Backup options for the standby Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where the standby Autonomous Container Database will be created.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_display_name: The display name for the peer Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] peer_cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] peer_db_unique_name: Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        :param pulumi.Input[builtins.str] protection_mode: The protection mode of this Autonomous Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.float]]] provisionable_cpuses: An array of CPU values that can be used to successfully provision a single Autonomous Database.
        :param pulumi.Input[builtins.float] provisioned_cpus: The number of CPUs provisioned in an Autonomous Container Database.
        :param pulumi.Input[builtins.float] reclaimable_cpus: CPUs that continue to be included in the count of CPUs available to the Autonomous Container Database even after one of its Autonomous Database is terminated or scaled down. You can release them to the available CPUs at its parent Autonomous VM Cluster level by restarting the Autonomous Container Database.
        :param pulumi.Input[builtins.float] reserved_cpus: The number of CPUs reserved in an Autonomous Container Database.
        :param pulumi.Input[builtins.str] role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        :param pulumi.Input[builtins.str] service_level_agreement_type: The service level agreement type of the container database. The default is STANDARD.
        :param pulumi.Input[builtins.int] standby_maintenance_buffer_in_days: The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database. This value represents the number of days before scheduled maintenance of the primary database. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current state of the Autonomous Container Database.
        :param pulumi.Input[builtins.str] time_created: The date and time the Autonomous Container Database was created.
        :param pulumi.Input[builtins.str] time_of_last_backup: The timestamp of last successful backup. Here NULL value represents either there are no successful backups or backups are not configured for this Autonomous Container Database.
        :param pulumi.Input[builtins.str] time_snapshot_standby_revert: The date and time the Autonomous Container Database will be reverted to Standby from Snapshot Standby.
        :param pulumi.Input[builtins.int] total_cpus: The number of CPUs allocated to the Autonomous VM cluster.
        :param pulumi.Input[builtins.str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        :param pulumi.Input[builtins.str] version_preference: The next maintenance version preference.
        :param pulumi.Input[builtins.int] vm_failover_reservation: The percentage of CPUs reserved across nodes to support node failover. Allowed values are 0%, 25%, and 50%, with 50% being the default option.
        """
        if autonomous_container_database_id is not None:
            pulumi.set(__self__, "autonomous_container_database_id", autonomous_container_database_id)
        if autonomous_exadata_infrastructure_id is not None:
            pulumi.set(__self__, "autonomous_exadata_infrastructure_id", autonomous_exadata_infrastructure_id)
        if autonomous_vm_cluster_id is not None:
            pulumi.set(__self__, "autonomous_vm_cluster_id", autonomous_vm_cluster_id)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if available_cpus is not None:
            pulumi.set(__self__, "available_cpus", available_cpus)
        if backup_configs is not None:
            pulumi.set(__self__, "backup_configs", backup_configs)
        if cloud_autonomous_vm_cluster_id is not None:
            pulumi.set(__self__, "cloud_autonomous_vm_cluster_id", cloud_autonomous_vm_cluster_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_model is not None:
            pulumi.set(__self__, "compute_model", compute_model)
        if dataguard_group_members is not None:
            pulumi.set(__self__, "dataguard_group_members", dataguard_group_members)
        if dataguards is not None:
            pulumi.set(__self__, "dataguards", dataguards)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_split_threshold is not None:
            pulumi.set(__self__, "db_split_threshold", db_split_threshold)
        if db_unique_name is not None:
            pulumi.set(__self__, "db_unique_name", db_unique_name)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if distribution_affinity is not None:
            pulumi.set(__self__, "distribution_affinity", distribution_affinity)
        if dst_file_version is not None:
            pulumi.set(__self__, "dst_file_version", dst_file_version)
        if fast_start_fail_over_lag_limit_in_seconds is not None:
            pulumi.set(__self__, "fast_start_fail_over_lag_limit_in_seconds", fast_start_fail_over_lag_limit_in_seconds)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if infrastructure_type is not None:
            pulumi.set(__self__, "infrastructure_type", infrastructure_type)
        if is_automatic_failover_enabled is not None:
            pulumi.set(__self__, "is_automatic_failover_enabled", is_automatic_failover_enabled)
        if is_data_guard_enabled is not None:
            pulumi.set(__self__, "is_data_guard_enabled", is_data_guard_enabled)
        if is_dst_file_update_enabled is not None:
            pulumi.set(__self__, "is_dst_file_update_enabled", is_dst_file_update_enabled)
        if is_multiple_standby is not None:
            pulumi.set(__self__, "is_multiple_standby", is_multiple_standby)
        if key_history_entries is not None:
            pulumi.set(__self__, "key_history_entries", key_history_entries)
        if key_store_id is not None:
            pulumi.set(__self__, "key_store_id", key_store_id)
        if key_store_wallet_name is not None:
            pulumi.set(__self__, "key_store_wallet_name", key_store_wallet_name)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_version_id is not None:
            pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if largest_provisionable_autonomous_database_in_cpus is not None:
            pulumi.set(__self__, "largest_provisionable_autonomous_database_in_cpus", largest_provisionable_autonomous_database_in_cpus)
        if last_maintenance_run_id is not None:
            pulumi.set(__self__, "last_maintenance_run_id", last_maintenance_run_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if list_one_off_patches is not None:
            pulumi.set(__self__, "list_one_off_patches", list_one_off_patches)
        if maintenance_windows is not None:
            pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if memory_per_oracle_compute_unit_in_gbs is not None:
            pulumi.set(__self__, "memory_per_oracle_compute_unit_in_gbs", memory_per_oracle_compute_unit_in_gbs)
        if net_services_architecture is not None:
            pulumi.set(__self__, "net_services_architecture", net_services_architecture)
        if next_maintenance_run_id is not None:
            pulumi.set(__self__, "next_maintenance_run_id", next_maintenance_run_id)
        if patch_id is not None:
            pulumi.set(__self__, "patch_id", patch_id)
        if patch_model is not None:
            pulumi.set(__self__, "patch_model", patch_model)
        if peer_autonomous_container_database_backup_config is not None:
            pulumi.set(__self__, "peer_autonomous_container_database_backup_config", peer_autonomous_container_database_backup_config)
        if peer_autonomous_container_database_compartment_id is not None:
            pulumi.set(__self__, "peer_autonomous_container_database_compartment_id", peer_autonomous_container_database_compartment_id)
        if peer_autonomous_container_database_display_name is not None:
            pulumi.set(__self__, "peer_autonomous_container_database_display_name", peer_autonomous_container_database_display_name)
        if peer_autonomous_vm_cluster_id is not None:
            pulumi.set(__self__, "peer_autonomous_vm_cluster_id", peer_autonomous_vm_cluster_id)
        if peer_cloud_autonomous_vm_cluster_id is not None:
            pulumi.set(__self__, "peer_cloud_autonomous_vm_cluster_id", peer_cloud_autonomous_vm_cluster_id)
        if peer_db_unique_name is not None:
            pulumi.set(__self__, "peer_db_unique_name", peer_db_unique_name)
        if protection_mode is not None:
            pulumi.set(__self__, "protection_mode", protection_mode)
        if provisionable_cpuses is not None:
            pulumi.set(__self__, "provisionable_cpuses", provisionable_cpuses)
        if provisioned_cpus is not None:
            pulumi.set(__self__, "provisioned_cpus", provisioned_cpus)
        if reclaimable_cpus is not None:
            pulumi.set(__self__, "reclaimable_cpus", reclaimable_cpus)
        if reserved_cpus is not None:
            pulumi.set(__self__, "reserved_cpus", reserved_cpus)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if service_level_agreement_type is not None:
            pulumi.set(__self__, "service_level_agreement_type", service_level_agreement_type)
        if standby_maintenance_buffer_in_days is not None:
            pulumi.set(__self__, "standby_maintenance_buffer_in_days", standby_maintenance_buffer_in_days)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_of_last_backup is not None:
            pulumi.set(__self__, "time_of_last_backup", time_of_last_backup)
        if time_snapshot_standby_revert is not None:
            pulumi.set(__self__, "time_snapshot_standby_revert", time_snapshot_standby_revert)
        if total_cpus is not None:
            pulumi.set(__self__, "total_cpus", total_cpus)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)
        if version_preference is not None:
            pulumi.set(__self__, "version_preference", version_preference)
        if vm_failover_reservation is not None:
            pulumi.set(__self__, "vm_failover_reservation", vm_failover_reservation)

    @property
    @pulumi.getter(name="autonomousContainerDatabaseId")
    def autonomous_container_database_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_container_database_id")

    @autonomous_container_database_id.setter
    def autonomous_container_database_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "autonomous_container_database_id", value)

    @property
    @pulumi.getter(name="autonomousExadataInfrastructureId")
    def autonomous_exadata_infrastructure_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        **No longer used.** For Autonomous Database on dedicated Exadata infrastructure, the container database is created within a specified `cloudAutonomousVmCluster`.
        """
        return pulumi.get(self, "autonomous_exadata_infrastructure_id")

    @autonomous_exadata_infrastructure_id.setter
    def autonomous_exadata_infrastructure_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "autonomous_exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="autonomousVmClusterId")
    def autonomous_vm_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the Autonomous VM Cluster.
        """
        return pulumi.get(self, "autonomous_vm_cluster_id")

    @autonomous_vm_cluster_id.setter
    def autonomous_vm_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "autonomous_vm_cluster_id", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The domain of the Autonomous Container Database
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="availableCpus")
    def available_cpus(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Sum of CPUs available on the Autonomous VM Cluster + Sum of reclaimable CPUs available in the Autonomous Container Database.
        """
        return pulumi.get(self, "available_cpus")

    @available_cpus.setter
    def available_cpus(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "available_cpus", value)

    @property
    @pulumi.getter(name="backupConfigs")
    def backup_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyBackupConfigArgs']]]]:
        """
        Backup options for the Autonomous Container Database.
        """
        return pulumi.get(self, "backup_configs")

    @backup_configs.setter
    def backup_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyBackupConfigArgs']]]]):
        pulumi.set(self, "backup_configs", value)

    @property
    @pulumi.getter(name="cloudAutonomousVmClusterId")
    def cloud_autonomous_vm_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "cloud_autonomous_vm_cluster_id")

    @cloud_autonomous_vm_cluster_id.setter
    def cloud_autonomous_vm_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud_autonomous_vm_cluster_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The compute model of the Autonomous Container Database. For Autonomous Database on Dedicated Exadata Infrastructure, the CPU type (ECPUs or OCPUs) is determined by the parent Autonomous Exadata VM Cluster's compute model. ECPU compute model is the recommended model and OCPU compute model is legacy. See [Compute Models in Autonomous Database on Dedicated Exadata Infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbak) for more details.
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compute_model", value)

    @property
    @pulumi.getter(name="dataguardGroupMembers")
    def dataguard_group_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyDataguardGroupMemberArgs']]]]:
        """
        Array of Dg associations.
        """
        return pulumi.get(self, "dataguard_group_members")

    @dataguard_group_members.setter
    def dataguard_group_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyDataguardGroupMemberArgs']]]]):
        pulumi.set(self, "dataguard_group_members", value)

    @property
    @pulumi.getter
    def dataguards(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyDataguardArgs']]]]:
        """
        The properties that define Autonomous Container Databases Dataguard.
        """
        return pulumi.get(self, "dataguards")

    @dataguards.setter
    def dataguards(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyDataguardArgs']]]]):
        pulumi.set(self, "dataguards", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Database name for the Autonomous Container Database. The name must be unique within the Cloud Autonomous VM Cluster, starting with an alphabetic character, followed by 1 to 7 alphanumeric characters.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="dbSplitThreshold")
    def db_split_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The CPU value beyond which an Autonomous Database will be opened across multiple nodes. The default value of this attribute is 16 for OCPUs and 64 for ECPUs.
        """
        return pulumi.get(self, "db_split_threshold")

    @db_split_threshold.setter
    def db_split_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "db_split_threshold", value)

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "db_unique_name")

    @db_unique_name.setter
    def db_unique_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_unique_name", value)

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Oracle Database version of the Autonomous Container Database.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_version", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user-provided name for the Autonomous Container Database.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="distributionAffinity")
    def distribution_affinity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Determines whether an Autonomous Database must be opened across the maximum number of nodes or the least number of nodes. By default, Minimum nodes is selected.
        """
        return pulumi.get(self, "distribution_affinity")

    @distribution_affinity.setter
    def distribution_affinity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "distribution_affinity", value)

    @property
    @pulumi.getter(name="dstFileVersion")
    def dst_file_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DST Time-Zone File version of the Autonomous Container Database.
        """
        return pulumi.get(self, "dst_file_version")

    @dst_file_version.setter
    def dst_file_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dst_file_version", value)

    @property
    @pulumi.getter(name="fastStartFailOverLagLimitInSeconds")
    def fast_start_fail_over_lag_limit_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The lag time for my preference based on data loss tolerance in seconds.
        """
        return pulumi.get(self, "fast_start_fail_over_lag_limit_in_seconds")

    @fast_start_fail_over_lag_limit_in_seconds.setter
    def fast_start_fail_over_lag_limit_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "fast_start_fail_over_lag_limit_in_seconds", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="infrastructureType")
    def infrastructure_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The infrastructure type this resource belongs to.
        """
        return pulumi.get(self, "infrastructure_type")

    @infrastructure_type.setter
    def infrastructure_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "infrastructure_type", value)

    @property
    @pulumi.getter(name="isAutomaticFailoverEnabled")
    def is_automatic_failover_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association
        """
        return pulumi.get(self, "is_automatic_failover_enabled")

    @is_automatic_failover_enabled.setter
    def is_automatic_failover_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_automatic_failover_enabled", value)

    @property
    @pulumi.getter(name="isDataGuardEnabled")
    def is_data_guard_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        **Deprecated.** Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "is_data_guard_enabled")

    @is_data_guard_enabled.setter
    def is_data_guard_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_data_guard_enabled", value)

    @property
    @pulumi.getter(name="isDstFileUpdateEnabled")
    def is_dst_file_update_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.
        """
        return pulumi.get(self, "is_dst_file_update_enabled")

    @is_dst_file_update_enabled.setter
    def is_dst_file_update_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_dst_file_update_enabled", value)

    @property
    @pulumi.getter(name="isMultipleStandby")
    def is_multiple_standby(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether it is multiple standby Autonomous Dataguard
        """
        return pulumi.get(self, "is_multiple_standby")

    @is_multiple_standby.setter
    def is_multiple_standby(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_multiple_standby", value)

    @property
    @pulumi.getter(name="keyHistoryEntries")
    def key_history_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyKeyHistoryEntryArgs']]]]:
        """
        Key History Entry.
        """
        return pulumi.get(self, "key_history_entries")

    @key_history_entries.setter
    def key_history_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyKeyHistoryEntryArgs']]]]):
        pulumi.set(self, "key_history_entries", value)

    @property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        """
        return pulumi.get(self, "key_store_id")

    @key_store_id.setter
    def key_store_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_store_id", value)

    @property
    @pulumi.getter(name="keyStoreWalletName")
    def key_store_wallet_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The wallet name for Oracle Key Vault.
        """
        return pulumi.get(self, "key_store_wallet_name")

    @key_store_wallet_name.setter
    def key_store_wallet_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_store_wallet_name", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        """
        return pulumi.get(self, "kms_key_version_id")

    @kms_key_version_id.setter
    def kms_key_version_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_version_id", value)

    @property
    @pulumi.getter(name="largestProvisionableAutonomousDatabaseInCpus")
    def largest_provisionable_autonomous_database_in_cpus(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The largest Autonomous Database (CPU) that can be created in a new Autonomous Container Database.
        """
        return pulumi.get(self, "largest_provisionable_autonomous_database_in_cpus")

    @largest_provisionable_autonomous_database_in_cpus.setter
    def largest_provisionable_autonomous_database_in_cpus(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "largest_provisionable_autonomous_database_in_cpus", value)

    @property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @last_maintenance_run_id.setter
    def last_maintenance_run_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_maintenance_run_id", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="listOneOffPatches")
    def list_one_off_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of One-Off patches that has been successfully applied to Autonomous Container Database
        """
        return pulumi.get(self, "list_one_off_patches")

    @list_one_off_patches.setter
    def list_one_off_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "list_one_off_patches", value)

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyMaintenanceWindowArgs']]]]:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @maintenance_windows.setter
    def maintenance_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutonomousContainerDatabaseAddStandbyMaintenanceWindowArgs']]]]):
        pulumi.set(self, "maintenance_windows", value)

    @property
    @pulumi.getter(name="memoryPerOracleComputeUnitInGbs")
    def memory_per_oracle_compute_unit_in_gbs(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of memory (in GBs) enabled per ECPU or OCPU in the Autonomous VM Cluster.
        """
        return pulumi.get(self, "memory_per_oracle_compute_unit_in_gbs")

    @memory_per_oracle_compute_unit_in_gbs.setter
    def memory_per_oracle_compute_unit_in_gbs(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_per_oracle_compute_unit_in_gbs", value)

    @property
    @pulumi.getter(name="netServicesArchitecture")
    def net_services_architecture(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enabling SHARED server architecture enables a database server to allow many client processes to share very few server processes, thereby increasing the number of supported users.
        """
        return pulumi.get(self, "net_services_architecture")

    @net_services_architecture.setter
    def net_services_architecture(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "net_services_architecture", value)

    @property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @next_maintenance_run_id.setter
    def next_maintenance_run_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_maintenance_run_id", value)

    @property
    @pulumi.getter(name="patchId")
    def patch_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch applied on the system.
        """
        return pulumi.get(self, "patch_id")

    @patch_id.setter
    def patch_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "patch_id", value)

    @property
    @pulumi.getter(name="patchModel")
    def patch_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Database patch model preference.
        """
        return pulumi.get(self, "patch_model")

    @patch_model.setter
    def patch_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "patch_model", value)

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseBackupConfig")
    def peer_autonomous_container_database_backup_config(self) -> Optional[pulumi.Input['AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgs']]:
        """
        Backup options for the standby Autonomous Container Database.
        """
        return pulumi.get(self, "peer_autonomous_container_database_backup_config")

    @peer_autonomous_container_database_backup_config.setter
    def peer_autonomous_container_database_backup_config(self, value: Optional[pulumi.Input['AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgs']]):
        pulumi.set(self, "peer_autonomous_container_database_backup_config", value)

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseCompartmentId")
    def peer_autonomous_container_database_compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where the standby Autonomous Container Database will be created.
        """
        return pulumi.get(self, "peer_autonomous_container_database_compartment_id")

    @peer_autonomous_container_database_compartment_id.setter
    def peer_autonomous_container_database_compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_autonomous_container_database_compartment_id", value)

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseDisplayName")
    def peer_autonomous_container_database_display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name for the peer Autonomous Container Database.
        """
        return pulumi.get(self, "peer_autonomous_container_database_display_name")

    @peer_autonomous_container_database_display_name.setter
    def peer_autonomous_container_database_display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_autonomous_container_database_display_name", value)

    @property
    @pulumi.getter(name="peerAutonomousVmClusterId")
    def peer_autonomous_vm_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "peer_autonomous_vm_cluster_id")

    @peer_autonomous_vm_cluster_id.setter
    def peer_autonomous_vm_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_autonomous_vm_cluster_id", value)

    @property
    @pulumi.getter(name="peerCloudAutonomousVmClusterId")
    def peer_cloud_autonomous_vm_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "peer_cloud_autonomous_vm_cluster_id")

    @peer_cloud_autonomous_vm_cluster_id.setter
    def peer_cloud_autonomous_vm_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_cloud_autonomous_vm_cluster_id", value)

    @property
    @pulumi.getter(name="peerDbUniqueName")
    def peer_db_unique_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        """
        return pulumi.get(self, "peer_db_unique_name")

    @peer_db_unique_name.setter
    def peer_db_unique_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_db_unique_name", value)

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The protection mode of this Autonomous Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        """
        return pulumi.get(self, "protection_mode")

    @protection_mode.setter
    def protection_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protection_mode", value)

    @property
    @pulumi.getter(name="provisionableCpuses")
    def provisionable_cpuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.float]]]]:
        """
        An array of CPU values that can be used to successfully provision a single Autonomous Database.
        """
        return pulumi.get(self, "provisionable_cpuses")

    @provisionable_cpuses.setter
    def provisionable_cpuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.float]]]]):
        pulumi.set(self, "provisionable_cpuses", value)

    @property
    @pulumi.getter(name="provisionedCpus")
    def provisioned_cpus(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of CPUs provisioned in an Autonomous Container Database.
        """
        return pulumi.get(self, "provisioned_cpus")

    @provisioned_cpus.setter
    def provisioned_cpus(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "provisioned_cpus", value)

    @property
    @pulumi.getter(name="reclaimableCpus")
    def reclaimable_cpus(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        CPUs that continue to be included in the count of CPUs available to the Autonomous Container Database even after one of its Autonomous Database is terminated or scaled down. You can release them to the available CPUs at its parent Autonomous VM Cluster level by restarting the Autonomous Container Database.
        """
        return pulumi.get(self, "reclaimable_cpus")

    @reclaimable_cpus.setter
    def reclaimable_cpus(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "reclaimable_cpus", value)

    @property
    @pulumi.getter(name="reservedCpus")
    def reserved_cpus(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of CPUs reserved in an Autonomous Container Database.
        """
        return pulumi.get(self, "reserved_cpus")

    @reserved_cpus.setter
    def reserved_cpus(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "reserved_cpus", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="serviceLevelAgreementType")
    def service_level_agreement_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service level agreement type of the container database. The default is STANDARD.
        """
        return pulumi.get(self, "service_level_agreement_type")

    @service_level_agreement_type.setter
    def service_level_agreement_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_level_agreement_type", value)

    @property
    @pulumi.getter(name="standbyMaintenanceBufferInDays")
    def standby_maintenance_buffer_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database. This value represents the number of days before scheduled maintenance of the primary database. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "standby_maintenance_buffer_in_days")

    @standby_maintenance_buffer_in_days.setter
    def standby_maintenance_buffer_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "standby_maintenance_buffer_in_days", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the Autonomous Container Database.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the Autonomous Container Database was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeOfLastBackup")
    def time_of_last_backup(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp of last successful backup. Here NULL value represents either there are no successful backups or backups are not configured for this Autonomous Container Database.
        """
        return pulumi.get(self, "time_of_last_backup")

    @time_of_last_backup.setter
    def time_of_last_backup(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_of_last_backup", value)

    @property
    @pulumi.getter(name="timeSnapshotStandbyRevert")
    def time_snapshot_standby_revert(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the Autonomous Container Database will be reverted to Standby from Snapshot Standby.
        """
        return pulumi.get(self, "time_snapshot_standby_revert")

    @time_snapshot_standby_revert.setter
    def time_snapshot_standby_revert(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_snapshot_standby_revert", value)

    @property
    @pulumi.getter(name="totalCpus")
    def total_cpus(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of CPUs allocated to the Autonomous VM cluster.
        """
        return pulumi.get(self, "total_cpus")

    @total_cpus.setter
    def total_cpus(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "total_cpus", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vault_id", value)

    @property
    @pulumi.getter(name="versionPreference")
    def version_preference(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The next maintenance version preference.
        """
        return pulumi.get(self, "version_preference")

    @version_preference.setter
    def version_preference(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_preference", value)

    @property
    @pulumi.getter(name="vmFailoverReservation")
    def vm_failover_reservation(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The percentage of CPUs reserved across nodes to support node failover. Allowed values are 0%, 25%, and 50%, with 50% being the default option.
        """
        return pulumi.get(self, "vm_failover_reservation")

    @vm_failover_reservation.setter
    def vm_failover_reservation(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vm_failover_reservation", value)


class AutonomousContainerDatabaseAddStandby(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_container_database_id: Optional[pulumi.Input[builtins.str]] = None,
                 fast_start_fail_over_lag_limit_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 is_automatic_failover_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 peer_autonomous_container_database_backup_config: Optional[pulumi.Input[Union['AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgs', 'AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgsDict']]] = None,
                 peer_autonomous_container_database_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_container_database_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_cloud_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_db_unique_name: Optional[pulumi.Input[builtins.str]] = None,
                 protection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 standby_maintenance_buffer_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        This resource provides the Autonomous Container Database Add Standby resource in Oracle Cloud Infrastructure Database service.

        Create Standby Autonomous Container Database.
        For more information about changing Autonomous Container Databases Add Standby, see
        [Create Standby Autonomous Container Database](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbcl/index.html#ADBCL-GUID-D3B503F1-0032-4B0D-9F00-ACAE8151AB80) and [Convert Snapshot Standby to Physical Standby](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbcl/index.html#ADBCL-GUID-E8D7E0EE-8244-467D-B33A-1BC6F969A0A4).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_container_database_add_standby = oci.database.AutonomousContainerDatabaseAddStandby("test_autonomous_container_database_add_standby",
            autonomous_container_database_id=test_autonomous_container_database["id"],
            fast_start_fail_over_lag_limit_in_seconds=autonomous_container_database_add_standby_fast_start_fail_over_lag_limit_in_seconds,
            is_automatic_failover_enabled=autonomous_container_database_add_standby_is_automatic_failover_enabled,
            peer_autonomous_container_database_backup_config={
                "backup_destination_details": [{
                    "type": autonomous_container_database_add_standby_peer_autonomous_container_database_backup_config_backup_destination_details_type,
                    "dbrs_policy_id": test_policy["id"],
                    "id": autonomous_container_database_add_standby_peer_autonomous_container_database_backup_config_backup_destination_details_id,
                    "internet_proxy": autonomous_container_database_add_standby_peer_autonomous_container_database_backup_config_backup_destination_details_internet_proxy,
                    "vpc_password": autonomous_container_database_add_standby_peer_autonomous_container_database_backup_config_backup_destination_details_vpc_password,
                    "vpc_user": autonomous_container_database_add_standby_peer_autonomous_container_database_backup_config_backup_destination_details_vpc_user,
                }],
                "recovery_window_in_days": autonomous_container_database_add_standby_peer_autonomous_container_database_backup_config_recovery_window_in_days,
            },
            peer_autonomous_container_database_compartment_id=test_compartment["id"],
            peer_autonomous_container_database_display_name=autonomous_container_database_add_standby_peer_autonomous_container_database_display_name,
            peer_autonomous_vm_cluster_id=test_autonomous_vm_cluster["id"],
            peer_cloud_autonomous_vm_cluster_id=test_cloud_autonomous_vm_cluster["id"],
            peer_db_unique_name=autonomous_container_database_add_standby_peer_db_unique_name,
            protection_mode=autonomous_container_database_add_standby_protection_mode,
            standby_maintenance_buffer_in_days=autonomous_container_database_add_standby_standby_maintenance_buffer_in_days)
        ```

        ## Import

        AutonomousContainerDatabaseAddStandby can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/autonomousContainerDatabaseAddStandby:AutonomousContainerDatabaseAddStandby test_autonomous_container_database_add_standby "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.int] fast_start_fail_over_lag_limit_in_seconds: The lag time for my preference based on data loss tolerance in seconds.
        :param pulumi.Input[builtins.bool] is_automatic_failover_enabled: Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association
        :param pulumi.Input[Union['AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgs', 'AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgsDict']] peer_autonomous_container_database_backup_config: Backup options for the standby Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where the standby Autonomous Container Database will be created.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_display_name: The display name for the peer Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] peer_cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] peer_db_unique_name: Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        :param pulumi.Input[builtins.str] protection_mode: The protection mode of this Autonomous Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        :param pulumi.Input[builtins.int] standby_maintenance_buffer_in_days: The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database. This value represents the number of days before scheduled maintenance of the primary database. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutonomousContainerDatabaseAddStandbyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Autonomous Container Database Add Standby resource in Oracle Cloud Infrastructure Database service.

        Create Standby Autonomous Container Database.
        For more information about changing Autonomous Container Databases Add Standby, see
        [Create Standby Autonomous Container Database](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbcl/index.html#ADBCL-GUID-D3B503F1-0032-4B0D-9F00-ACAE8151AB80) and [Convert Snapshot Standby to Physical Standby](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbcl/index.html#ADBCL-GUID-E8D7E0EE-8244-467D-B33A-1BC6F969A0A4).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_container_database_add_standby = oci.database.AutonomousContainerDatabaseAddStandby("test_autonomous_container_database_add_standby",
            autonomous_container_database_id=test_autonomous_container_database["id"],
            fast_start_fail_over_lag_limit_in_seconds=autonomous_container_database_add_standby_fast_start_fail_over_lag_limit_in_seconds,
            is_automatic_failover_enabled=autonomous_container_database_add_standby_is_automatic_failover_enabled,
            peer_autonomous_container_database_backup_config={
                "backup_destination_details": [{
                    "type": autonomous_container_database_add_standby_peer_autonomous_container_database_backup_config_backup_destination_details_type,
                    "dbrs_policy_id": test_policy["id"],
                    "id": autonomous_container_database_add_standby_peer_autonomous_container_database_backup_config_backup_destination_details_id,
                    "internet_proxy": autonomous_container_database_add_standby_peer_autonomous_container_database_backup_config_backup_destination_details_internet_proxy,
                    "vpc_password": autonomous_container_database_add_standby_peer_autonomous_container_database_backup_config_backup_destination_details_vpc_password,
                    "vpc_user": autonomous_container_database_add_standby_peer_autonomous_container_database_backup_config_backup_destination_details_vpc_user,
                }],
                "recovery_window_in_days": autonomous_container_database_add_standby_peer_autonomous_container_database_backup_config_recovery_window_in_days,
            },
            peer_autonomous_container_database_compartment_id=test_compartment["id"],
            peer_autonomous_container_database_display_name=autonomous_container_database_add_standby_peer_autonomous_container_database_display_name,
            peer_autonomous_vm_cluster_id=test_autonomous_vm_cluster["id"],
            peer_cloud_autonomous_vm_cluster_id=test_cloud_autonomous_vm_cluster["id"],
            peer_db_unique_name=autonomous_container_database_add_standby_peer_db_unique_name,
            protection_mode=autonomous_container_database_add_standby_protection_mode,
            standby_maintenance_buffer_in_days=autonomous_container_database_add_standby_standby_maintenance_buffer_in_days)
        ```

        ## Import

        AutonomousContainerDatabaseAddStandby can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/autonomousContainerDatabaseAddStandby:AutonomousContainerDatabaseAddStandby test_autonomous_container_database_add_standby "id"
        ```

        :param str resource_name: The name of the resource.
        :param AutonomousContainerDatabaseAddStandbyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutonomousContainerDatabaseAddStandbyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_container_database_id: Optional[pulumi.Input[builtins.str]] = None,
                 fast_start_fail_over_lag_limit_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 is_automatic_failover_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 peer_autonomous_container_database_backup_config: Optional[pulumi.Input[Union['AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgs', 'AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgsDict']]] = None,
                 peer_autonomous_container_database_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_container_database_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 peer_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_cloud_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 peer_db_unique_name: Optional[pulumi.Input[builtins.str]] = None,
                 protection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 standby_maintenance_buffer_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutonomousContainerDatabaseAddStandbyArgs.__new__(AutonomousContainerDatabaseAddStandbyArgs)

            if autonomous_container_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'autonomous_container_database_id'")
            __props__.__dict__["autonomous_container_database_id"] = autonomous_container_database_id
            __props__.__dict__["fast_start_fail_over_lag_limit_in_seconds"] = fast_start_fail_over_lag_limit_in_seconds
            __props__.__dict__["is_automatic_failover_enabled"] = is_automatic_failover_enabled
            __props__.__dict__["peer_autonomous_container_database_backup_config"] = peer_autonomous_container_database_backup_config
            __props__.__dict__["peer_autonomous_container_database_compartment_id"] = peer_autonomous_container_database_compartment_id
            __props__.__dict__["peer_autonomous_container_database_display_name"] = peer_autonomous_container_database_display_name
            __props__.__dict__["peer_autonomous_vm_cluster_id"] = peer_autonomous_vm_cluster_id
            __props__.__dict__["peer_cloud_autonomous_vm_cluster_id"] = peer_cloud_autonomous_vm_cluster_id
            __props__.__dict__["peer_db_unique_name"] = peer_db_unique_name
            __props__.__dict__["protection_mode"] = protection_mode
            __props__.__dict__["standby_maintenance_buffer_in_days"] = standby_maintenance_buffer_in_days
            __props__.__dict__["autonomous_exadata_infrastructure_id"] = None
            __props__.__dict__["autonomous_vm_cluster_id"] = None
            __props__.__dict__["availability_domain"] = None
            __props__.__dict__["available_cpus"] = None
            __props__.__dict__["backup_configs"] = None
            __props__.__dict__["cloud_autonomous_vm_cluster_id"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["compute_model"] = None
            __props__.__dict__["dataguard_group_members"] = None
            __props__.__dict__["dataguards"] = None
            __props__.__dict__["db_name"] = None
            __props__.__dict__["db_split_threshold"] = None
            __props__.__dict__["db_unique_name"] = None
            __props__.__dict__["db_version"] = None
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["distribution_affinity"] = None
            __props__.__dict__["dst_file_version"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["infrastructure_type"] = None
            __props__.__dict__["is_data_guard_enabled"] = None
            __props__.__dict__["is_dst_file_update_enabled"] = None
            __props__.__dict__["is_multiple_standby"] = None
            __props__.__dict__["key_history_entries"] = None
            __props__.__dict__["key_store_id"] = None
            __props__.__dict__["key_store_wallet_name"] = None
            __props__.__dict__["kms_key_id"] = None
            __props__.__dict__["kms_key_version_id"] = None
            __props__.__dict__["largest_provisionable_autonomous_database_in_cpus"] = None
            __props__.__dict__["last_maintenance_run_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["list_one_off_patches"] = None
            __props__.__dict__["maintenance_windows"] = None
            __props__.__dict__["memory_per_oracle_compute_unit_in_gbs"] = None
            __props__.__dict__["net_services_architecture"] = None
            __props__.__dict__["next_maintenance_run_id"] = None
            __props__.__dict__["patch_id"] = None
            __props__.__dict__["patch_model"] = None
            __props__.__dict__["provisionable_cpuses"] = None
            __props__.__dict__["provisioned_cpus"] = None
            __props__.__dict__["reclaimable_cpus"] = None
            __props__.__dict__["reserved_cpus"] = None
            __props__.__dict__["role"] = None
            __props__.__dict__["service_level_agreement_type"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_of_last_backup"] = None
            __props__.__dict__["time_snapshot_standby_revert"] = None
            __props__.__dict__["total_cpus"] = None
            __props__.__dict__["vault_id"] = None
            __props__.__dict__["version_preference"] = None
            __props__.__dict__["vm_failover_reservation"] = None
        super(AutonomousContainerDatabaseAddStandby, __self__).__init__(
            'oci:Database/autonomousContainerDatabaseAddStandby:AutonomousContainerDatabaseAddStandby',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autonomous_container_database_id: Optional[pulumi.Input[builtins.str]] = None,
            autonomous_exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
            autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            availability_domain: Optional[pulumi.Input[builtins.str]] = None,
            available_cpus: Optional[pulumi.Input[builtins.float]] = None,
            backup_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousContainerDatabaseAddStandbyBackupConfigArgs', 'AutonomousContainerDatabaseAddStandbyBackupConfigArgsDict']]]]] = None,
            cloud_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            compute_model: Optional[pulumi.Input[builtins.str]] = None,
            dataguard_group_members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousContainerDatabaseAddStandbyDataguardGroupMemberArgs', 'AutonomousContainerDatabaseAddStandbyDataguardGroupMemberArgsDict']]]]] = None,
            dataguards: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousContainerDatabaseAddStandbyDataguardArgs', 'AutonomousContainerDatabaseAddStandbyDataguardArgsDict']]]]] = None,
            db_name: Optional[pulumi.Input[builtins.str]] = None,
            db_split_threshold: Optional[pulumi.Input[builtins.int]] = None,
            db_unique_name: Optional[pulumi.Input[builtins.str]] = None,
            db_version: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            distribution_affinity: Optional[pulumi.Input[builtins.str]] = None,
            dst_file_version: Optional[pulumi.Input[builtins.str]] = None,
            fast_start_fail_over_lag_limit_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            infrastructure_type: Optional[pulumi.Input[builtins.str]] = None,
            is_automatic_failover_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_data_guard_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_dst_file_update_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_multiple_standby: Optional[pulumi.Input[builtins.bool]] = None,
            key_history_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousContainerDatabaseAddStandbyKeyHistoryEntryArgs', 'AutonomousContainerDatabaseAddStandbyKeyHistoryEntryArgsDict']]]]] = None,
            key_store_id: Optional[pulumi.Input[builtins.str]] = None,
            key_store_wallet_name: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_version_id: Optional[pulumi.Input[builtins.str]] = None,
            largest_provisionable_autonomous_database_in_cpus: Optional[pulumi.Input[builtins.float]] = None,
            last_maintenance_run_id: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            list_one_off_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutonomousContainerDatabaseAddStandbyMaintenanceWindowArgs', 'AutonomousContainerDatabaseAddStandbyMaintenanceWindowArgsDict']]]]] = None,
            memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[builtins.int]] = None,
            net_services_architecture: Optional[pulumi.Input[builtins.str]] = None,
            next_maintenance_run_id: Optional[pulumi.Input[builtins.str]] = None,
            patch_id: Optional[pulumi.Input[builtins.str]] = None,
            patch_model: Optional[pulumi.Input[builtins.str]] = None,
            peer_autonomous_container_database_backup_config: Optional[pulumi.Input[Union['AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgs', 'AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgsDict']]] = None,
            peer_autonomous_container_database_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            peer_autonomous_container_database_display_name: Optional[pulumi.Input[builtins.str]] = None,
            peer_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            peer_cloud_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            peer_db_unique_name: Optional[pulumi.Input[builtins.str]] = None,
            protection_mode: Optional[pulumi.Input[builtins.str]] = None,
            provisionable_cpuses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.float]]]] = None,
            provisioned_cpus: Optional[pulumi.Input[builtins.float]] = None,
            reclaimable_cpus: Optional[pulumi.Input[builtins.float]] = None,
            reserved_cpus: Optional[pulumi.Input[builtins.float]] = None,
            role: Optional[pulumi.Input[builtins.str]] = None,
            service_level_agreement_type: Optional[pulumi.Input[builtins.str]] = None,
            standby_maintenance_buffer_in_days: Optional[pulumi.Input[builtins.int]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_of_last_backup: Optional[pulumi.Input[builtins.str]] = None,
            time_snapshot_standby_revert: Optional[pulumi.Input[builtins.str]] = None,
            total_cpus: Optional[pulumi.Input[builtins.int]] = None,
            vault_id: Optional[pulumi.Input[builtins.str]] = None,
            version_preference: Optional[pulumi.Input[builtins.str]] = None,
            vm_failover_reservation: Optional[pulumi.Input[builtins.int]] = None) -> 'AutonomousContainerDatabaseAddStandby':
        """
        Get an existing AutonomousContainerDatabaseAddStandby resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.str] autonomous_exadata_infrastructure_id: **No longer used.** For Autonomous Database on dedicated Exadata infrastructure, the container database is created within a specified `cloudAutonomousVmCluster`.
        :param pulumi.Input[builtins.str] autonomous_vm_cluster_id: The OCID of the Autonomous VM Cluster.
        :param pulumi.Input[builtins.str] availability_domain: The domain of the Autonomous Container Database
        :param pulumi.Input[builtins.float] available_cpus: Sum of CPUs available on the Autonomous VM Cluster + Sum of reclaimable CPUs available in the Autonomous Container Database.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousContainerDatabaseAddStandbyBackupConfigArgs', 'AutonomousContainerDatabaseAddStandbyBackupConfigArgsDict']]]] backup_configs: Backup options for the Autonomous Container Database.
        :param pulumi.Input[builtins.str] cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[builtins.str] compute_model: The compute model of the Autonomous Container Database. For Autonomous Database on Dedicated Exadata Infrastructure, the CPU type (ECPUs or OCPUs) is determined by the parent Autonomous Exadata VM Cluster's compute model. ECPU compute model is the recommended model and OCPU compute model is legacy. See [Compute Models in Autonomous Database on Dedicated Exadata Infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbak) for more details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousContainerDatabaseAddStandbyDataguardGroupMemberArgs', 'AutonomousContainerDatabaseAddStandbyDataguardGroupMemberArgsDict']]]] dataguard_group_members: Array of Dg associations.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousContainerDatabaseAddStandbyDataguardArgs', 'AutonomousContainerDatabaseAddStandbyDataguardArgsDict']]]] dataguards: The properties that define Autonomous Container Databases Dataguard.
        :param pulumi.Input[builtins.str] db_name: The Database name for the Autonomous Container Database. The name must be unique within the Cloud Autonomous VM Cluster, starting with an alphabetic character, followed by 1 to 7 alphanumeric characters.
        :param pulumi.Input[builtins.int] db_split_threshold: The CPU value beyond which an Autonomous Database will be opened across multiple nodes. The default value of this attribute is 16 for OCPUs and 64 for ECPUs.
        :param pulumi.Input[builtins.str] db_version: Oracle Database version of the Autonomous Container Database.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: The user-provided name for the Autonomous Container Database.
        :param pulumi.Input[builtins.str] distribution_affinity: Determines whether an Autonomous Database must be opened across the maximum number of nodes or the least number of nodes. By default, Minimum nodes is selected.
        :param pulumi.Input[builtins.str] dst_file_version: DST Time-Zone File version of the Autonomous Container Database.
        :param pulumi.Input[builtins.int] fast_start_fail_over_lag_limit_in_seconds: The lag time for my preference based on data loss tolerance in seconds.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] infrastructure_type: The infrastructure type this resource belongs to.
        :param pulumi.Input[builtins.bool] is_automatic_failover_enabled: Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association
        :param pulumi.Input[builtins.bool] is_data_guard_enabled: **Deprecated.** Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        :param pulumi.Input[builtins.bool] is_dst_file_update_enabled: Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.
        :param pulumi.Input[builtins.bool] is_multiple_standby: Whether it is multiple standby Autonomous Dataguard
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousContainerDatabaseAddStandbyKeyHistoryEntryArgs', 'AutonomousContainerDatabaseAddStandbyKeyHistoryEntryArgsDict']]]] key_history_entries: Key History Entry.
        :param pulumi.Input[builtins.str] key_store_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        :param pulumi.Input[builtins.str] key_store_wallet_name: The wallet name for Oracle Key Vault.
        :param pulumi.Input[builtins.str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[builtins.str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        :param pulumi.Input[builtins.float] largest_provisionable_autonomous_database_in_cpus: The largest Autonomous Database (CPU) that can be created in a new Autonomous Container Database.
        :param pulumi.Input[builtins.str] last_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] list_one_off_patches: List of One-Off patches that has been successfully applied to Autonomous Container Database
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutonomousContainerDatabaseAddStandbyMaintenanceWindowArgs', 'AutonomousContainerDatabaseAddStandbyMaintenanceWindowArgsDict']]]] maintenance_windows: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[builtins.int] memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) enabled per ECPU or OCPU in the Autonomous VM Cluster.
        :param pulumi.Input[builtins.str] net_services_architecture: Enabling SHARED server architecture enables a database server to allow many client processes to share very few server processes, thereby increasing the number of supported users.
        :param pulumi.Input[builtins.str] next_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        :param pulumi.Input[builtins.str] patch_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch applied on the system.
        :param pulumi.Input[builtins.str] patch_model: Database patch model preference.
        :param pulumi.Input[Union['AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgs', 'AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfigArgsDict']] peer_autonomous_container_database_backup_config: Backup options for the standby Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where the standby Autonomous Container Database will be created.
        :param pulumi.Input[builtins.str] peer_autonomous_container_database_display_name: The display name for the peer Autonomous Container Database.
        :param pulumi.Input[builtins.str] peer_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] peer_cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        :param pulumi.Input[builtins.str] peer_db_unique_name: Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        :param pulumi.Input[builtins.str] protection_mode: The protection mode of this Autonomous Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.float]]] provisionable_cpuses: An array of CPU values that can be used to successfully provision a single Autonomous Database.
        :param pulumi.Input[builtins.float] provisioned_cpus: The number of CPUs provisioned in an Autonomous Container Database.
        :param pulumi.Input[builtins.float] reclaimable_cpus: CPUs that continue to be included in the count of CPUs available to the Autonomous Container Database even after one of its Autonomous Database is terminated or scaled down. You can release them to the available CPUs at its parent Autonomous VM Cluster level by restarting the Autonomous Container Database.
        :param pulumi.Input[builtins.float] reserved_cpus: The number of CPUs reserved in an Autonomous Container Database.
        :param pulumi.Input[builtins.str] role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        :param pulumi.Input[builtins.str] service_level_agreement_type: The service level agreement type of the container database. The default is STANDARD.
        :param pulumi.Input[builtins.int] standby_maintenance_buffer_in_days: The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database. This value represents the number of days before scheduled maintenance of the primary database. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current state of the Autonomous Container Database.
        :param pulumi.Input[builtins.str] time_created: The date and time the Autonomous Container Database was created.
        :param pulumi.Input[builtins.str] time_of_last_backup: The timestamp of last successful backup. Here NULL value represents either there are no successful backups or backups are not configured for this Autonomous Container Database.
        :param pulumi.Input[builtins.str] time_snapshot_standby_revert: The date and time the Autonomous Container Database will be reverted to Standby from Snapshot Standby.
        :param pulumi.Input[builtins.int] total_cpus: The number of CPUs allocated to the Autonomous VM cluster.
        :param pulumi.Input[builtins.str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        :param pulumi.Input[builtins.str] version_preference: The next maintenance version preference.
        :param pulumi.Input[builtins.int] vm_failover_reservation: The percentage of CPUs reserved across nodes to support node failover. Allowed values are 0%, 25%, and 50%, with 50% being the default option.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutonomousContainerDatabaseAddStandbyState.__new__(_AutonomousContainerDatabaseAddStandbyState)

        __props__.__dict__["autonomous_container_database_id"] = autonomous_container_database_id
        __props__.__dict__["autonomous_exadata_infrastructure_id"] = autonomous_exadata_infrastructure_id
        __props__.__dict__["autonomous_vm_cluster_id"] = autonomous_vm_cluster_id
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["available_cpus"] = available_cpus
        __props__.__dict__["backup_configs"] = backup_configs
        __props__.__dict__["cloud_autonomous_vm_cluster_id"] = cloud_autonomous_vm_cluster_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_model"] = compute_model
        __props__.__dict__["dataguard_group_members"] = dataguard_group_members
        __props__.__dict__["dataguards"] = dataguards
        __props__.__dict__["db_name"] = db_name
        __props__.__dict__["db_split_threshold"] = db_split_threshold
        __props__.__dict__["db_unique_name"] = db_unique_name
        __props__.__dict__["db_version"] = db_version
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["distribution_affinity"] = distribution_affinity
        __props__.__dict__["dst_file_version"] = dst_file_version
        __props__.__dict__["fast_start_fail_over_lag_limit_in_seconds"] = fast_start_fail_over_lag_limit_in_seconds
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["infrastructure_type"] = infrastructure_type
        __props__.__dict__["is_automatic_failover_enabled"] = is_automatic_failover_enabled
        __props__.__dict__["is_data_guard_enabled"] = is_data_guard_enabled
        __props__.__dict__["is_dst_file_update_enabled"] = is_dst_file_update_enabled
        __props__.__dict__["is_multiple_standby"] = is_multiple_standby
        __props__.__dict__["key_history_entries"] = key_history_entries
        __props__.__dict__["key_store_id"] = key_store_id
        __props__.__dict__["key_store_wallet_name"] = key_store_wallet_name
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["kms_key_version_id"] = kms_key_version_id
        __props__.__dict__["largest_provisionable_autonomous_database_in_cpus"] = largest_provisionable_autonomous_database_in_cpus
        __props__.__dict__["last_maintenance_run_id"] = last_maintenance_run_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["list_one_off_patches"] = list_one_off_patches
        __props__.__dict__["maintenance_windows"] = maintenance_windows
        __props__.__dict__["memory_per_oracle_compute_unit_in_gbs"] = memory_per_oracle_compute_unit_in_gbs
        __props__.__dict__["net_services_architecture"] = net_services_architecture
        __props__.__dict__["next_maintenance_run_id"] = next_maintenance_run_id
        __props__.__dict__["patch_id"] = patch_id
        __props__.__dict__["patch_model"] = patch_model
        __props__.__dict__["peer_autonomous_container_database_backup_config"] = peer_autonomous_container_database_backup_config
        __props__.__dict__["peer_autonomous_container_database_compartment_id"] = peer_autonomous_container_database_compartment_id
        __props__.__dict__["peer_autonomous_container_database_display_name"] = peer_autonomous_container_database_display_name
        __props__.__dict__["peer_autonomous_vm_cluster_id"] = peer_autonomous_vm_cluster_id
        __props__.__dict__["peer_cloud_autonomous_vm_cluster_id"] = peer_cloud_autonomous_vm_cluster_id
        __props__.__dict__["peer_db_unique_name"] = peer_db_unique_name
        __props__.__dict__["protection_mode"] = protection_mode
        __props__.__dict__["provisionable_cpuses"] = provisionable_cpuses
        __props__.__dict__["provisioned_cpus"] = provisioned_cpus
        __props__.__dict__["reclaimable_cpus"] = reclaimable_cpus
        __props__.__dict__["reserved_cpus"] = reserved_cpus
        __props__.__dict__["role"] = role
        __props__.__dict__["service_level_agreement_type"] = service_level_agreement_type
        __props__.__dict__["standby_maintenance_buffer_in_days"] = standby_maintenance_buffer_in_days
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_of_last_backup"] = time_of_last_backup
        __props__.__dict__["time_snapshot_standby_revert"] = time_snapshot_standby_revert
        __props__.__dict__["total_cpus"] = total_cpus
        __props__.__dict__["vault_id"] = vault_id
        __props__.__dict__["version_preference"] = version_preference
        __props__.__dict__["vm_failover_reservation"] = vm_failover_reservation
        return AutonomousContainerDatabaseAddStandby(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autonomousContainerDatabaseId")
    def autonomous_container_database_id(self) -> pulumi.Output[builtins.str]:
        """
        The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_container_database_id")

    @property
    @pulumi.getter(name="autonomousExadataInfrastructureId")
    def autonomous_exadata_infrastructure_id(self) -> pulumi.Output[builtins.str]:
        """
        **No longer used.** For Autonomous Database on dedicated Exadata infrastructure, the container database is created within a specified `cloudAutonomousVmCluster`.
        """
        return pulumi.get(self, "autonomous_exadata_infrastructure_id")

    @property
    @pulumi.getter(name="autonomousVmClusterId")
    def autonomous_vm_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the Autonomous VM Cluster.
        """
        return pulumi.get(self, "autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[builtins.str]:
        """
        The domain of the Autonomous Container Database
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="availableCpus")
    def available_cpus(self) -> pulumi.Output[builtins.float]:
        """
        Sum of CPUs available on the Autonomous VM Cluster + Sum of reclaimable CPUs available in the Autonomous Container Database.
        """
        return pulumi.get(self, "available_cpus")

    @property
    @pulumi.getter(name="backupConfigs")
    def backup_configs(self) -> pulumi.Output[Sequence['outputs.AutonomousContainerDatabaseAddStandbyBackupConfig']]:
        """
        Backup options for the Autonomous Container Database.
        """
        return pulumi.get(self, "backup_configs")

    @property
    @pulumi.getter(name="cloudAutonomousVmClusterId")
    def cloud_autonomous_vm_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "cloud_autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> pulumi.Output[builtins.str]:
        """
        The compute model of the Autonomous Container Database. For Autonomous Database on Dedicated Exadata Infrastructure, the CPU type (ECPUs or OCPUs) is determined by the parent Autonomous Exadata VM Cluster's compute model. ECPU compute model is the recommended model and OCPU compute model is legacy. See [Compute Models in Autonomous Database on Dedicated Exadata Infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbak) for more details.
        """
        return pulumi.get(self, "compute_model")

    @property
    @pulumi.getter(name="dataguardGroupMembers")
    def dataguard_group_members(self) -> pulumi.Output[Sequence['outputs.AutonomousContainerDatabaseAddStandbyDataguardGroupMember']]:
        """
        Array of Dg associations.
        """
        return pulumi.get(self, "dataguard_group_members")

    @property
    @pulumi.getter
    def dataguards(self) -> pulumi.Output[Sequence['outputs.AutonomousContainerDatabaseAddStandbyDataguard']]:
        """
        The properties that define Autonomous Container Databases Dataguard.
        """
        return pulumi.get(self, "dataguards")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[builtins.str]:
        """
        The Database name for the Autonomous Container Database. The name must be unique within the Cloud Autonomous VM Cluster, starting with an alphabetic character, followed by 1 to 7 alphanumeric characters.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbSplitThreshold")
    def db_split_threshold(self) -> pulumi.Output[builtins.int]:
        """
        The CPU value beyond which an Autonomous Database will be opened across multiple nodes. The default value of this attribute is 16 for OCPUs and 64 for ECPUs.
        """
        return pulumi.get(self, "db_split_threshold")

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "db_unique_name")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Output[builtins.str]:
        """
        Oracle Database version of the Autonomous Container Database.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The user-provided name for the Autonomous Container Database.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="distributionAffinity")
    def distribution_affinity(self) -> pulumi.Output[builtins.str]:
        """
        Determines whether an Autonomous Database must be opened across the maximum number of nodes or the least number of nodes. By default, Minimum nodes is selected.
        """
        return pulumi.get(self, "distribution_affinity")

    @property
    @pulumi.getter(name="dstFileVersion")
    def dst_file_version(self) -> pulumi.Output[builtins.str]:
        """
        DST Time-Zone File version of the Autonomous Container Database.
        """
        return pulumi.get(self, "dst_file_version")

    @property
    @pulumi.getter(name="fastStartFailOverLagLimitInSeconds")
    def fast_start_fail_over_lag_limit_in_seconds(self) -> pulumi.Output[builtins.int]:
        """
        The lag time for my preference based on data loss tolerance in seconds.
        """
        return pulumi.get(self, "fast_start_fail_over_lag_limit_in_seconds")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="infrastructureType")
    def infrastructure_type(self) -> pulumi.Output[builtins.str]:
        """
        The infrastructure type this resource belongs to.
        """
        return pulumi.get(self, "infrastructure_type")

    @property
    @pulumi.getter(name="isAutomaticFailoverEnabled")
    def is_automatic_failover_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association
        """
        return pulumi.get(self, "is_automatic_failover_enabled")

    @property
    @pulumi.getter(name="isDataGuardEnabled")
    def is_data_guard_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        **Deprecated.** Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "is_data_guard_enabled")

    @property
    @pulumi.getter(name="isDstFileUpdateEnabled")
    def is_dst_file_update_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.
        """
        return pulumi.get(self, "is_dst_file_update_enabled")

    @property
    @pulumi.getter(name="isMultipleStandby")
    def is_multiple_standby(self) -> pulumi.Output[builtins.bool]:
        """
        Whether it is multiple standby Autonomous Dataguard
        """
        return pulumi.get(self, "is_multiple_standby")

    @property
    @pulumi.getter(name="keyHistoryEntries")
    def key_history_entries(self) -> pulumi.Output[Sequence['outputs.AutonomousContainerDatabaseAddStandbyKeyHistoryEntry']]:
        """
        Key History Entry.
        """
        return pulumi.get(self, "key_history_entries")

    @property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        """
        return pulumi.get(self, "key_store_id")

    @property
    @pulumi.getter(name="keyStoreWalletName")
    def key_store_wallet_name(self) -> pulumi.Output[builtins.str]:
        """
        The wallet name for Oracle Key Vault.
        """
        return pulumi.get(self, "key_store_wallet_name")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        """
        return pulumi.get(self, "kms_key_version_id")

    @property
    @pulumi.getter(name="largestProvisionableAutonomousDatabaseInCpus")
    def largest_provisionable_autonomous_database_in_cpus(self) -> pulumi.Output[builtins.float]:
        """
        The largest Autonomous Database (CPU) that can be created in a new Autonomous Container Database.
        """
        return pulumi.get(self, "largest_provisionable_autonomous_database_in_cpus")

    @property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="listOneOffPatches")
    def list_one_off_patches(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of One-Off patches that has been successfully applied to Autonomous Container Database
        """
        return pulumi.get(self, "list_one_off_patches")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> pulumi.Output[Sequence['outputs.AutonomousContainerDatabaseAddStandbyMaintenanceWindow']]:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="memoryPerOracleComputeUnitInGbs")
    def memory_per_oracle_compute_unit_in_gbs(self) -> pulumi.Output[builtins.int]:
        """
        The amount of memory (in GBs) enabled per ECPU or OCPU in the Autonomous VM Cluster.
        """
        return pulumi.get(self, "memory_per_oracle_compute_unit_in_gbs")

    @property
    @pulumi.getter(name="netServicesArchitecture")
    def net_services_architecture(self) -> pulumi.Output[builtins.str]:
        """
        Enabling SHARED server architecture enables a database server to allow many client processes to share very few server processes, thereby increasing the number of supported users.
        """
        return pulumi.get(self, "net_services_architecture")

    @property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @property
    @pulumi.getter(name="patchId")
    def patch_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch applied on the system.
        """
        return pulumi.get(self, "patch_id")

    @property
    @pulumi.getter(name="patchModel")
    def patch_model(self) -> pulumi.Output[builtins.str]:
        """
        Database patch model preference.
        """
        return pulumi.get(self, "patch_model")

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseBackupConfig")
    def peer_autonomous_container_database_backup_config(self) -> pulumi.Output['outputs.AutonomousContainerDatabaseAddStandbyPeerAutonomousContainerDatabaseBackupConfig']:
        """
        Backup options for the standby Autonomous Container Database.
        """
        return pulumi.get(self, "peer_autonomous_container_database_backup_config")

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseCompartmentId")
    def peer_autonomous_container_database_compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where the standby Autonomous Container Database will be created.
        """
        return pulumi.get(self, "peer_autonomous_container_database_compartment_id")

    @property
    @pulumi.getter(name="peerAutonomousContainerDatabaseDisplayName")
    def peer_autonomous_container_database_display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name for the peer Autonomous Container Database.
        """
        return pulumi.get(self, "peer_autonomous_container_database_display_name")

    @property
    @pulumi.getter(name="peerAutonomousVmClusterId")
    def peer_autonomous_vm_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "peer_autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="peerCloudAutonomousVmClusterId")
    def peer_cloud_autonomous_vm_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "peer_cloud_autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="peerDbUniqueName")
    def peer_db_unique_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        """
        return pulumi.get(self, "peer_db_unique_name")

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> pulumi.Output[builtins.str]:
        """
        The protection mode of this Autonomous Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        """
        return pulumi.get(self, "protection_mode")

    @property
    @pulumi.getter(name="provisionableCpuses")
    def provisionable_cpuses(self) -> pulumi.Output[Sequence[builtins.float]]:
        """
        An array of CPU values that can be used to successfully provision a single Autonomous Database.
        """
        return pulumi.get(self, "provisionable_cpuses")

    @property
    @pulumi.getter(name="provisionedCpus")
    def provisioned_cpus(self) -> pulumi.Output[builtins.float]:
        """
        The number of CPUs provisioned in an Autonomous Container Database.
        """
        return pulumi.get(self, "provisioned_cpus")

    @property
    @pulumi.getter(name="reclaimableCpus")
    def reclaimable_cpus(self) -> pulumi.Output[builtins.float]:
        """
        CPUs that continue to be included in the count of CPUs available to the Autonomous Container Database even after one of its Autonomous Database is terminated or scaled down. You can release them to the available CPUs at its parent Autonomous VM Cluster level by restarting the Autonomous Container Database.
        """
        return pulumi.get(self, "reclaimable_cpus")

    @property
    @pulumi.getter(name="reservedCpus")
    def reserved_cpus(self) -> pulumi.Output[builtins.float]:
        """
        The number of CPUs reserved in an Autonomous Container Database.
        """
        return pulumi.get(self, "reserved_cpus")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[builtins.str]:
        """
        The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="serviceLevelAgreementType")
    def service_level_agreement_type(self) -> pulumi.Output[builtins.str]:
        """
        The service level agreement type of the container database. The default is STANDARD.
        """
        return pulumi.get(self, "service_level_agreement_type")

    @property
    @pulumi.getter(name="standbyMaintenanceBufferInDays")
    def standby_maintenance_buffer_in_days(self) -> pulumi.Output[builtins.int]:
        """
        The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database. This value represents the number of days before scheduled maintenance of the primary database. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "standby_maintenance_buffer_in_days")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the Autonomous Container Database.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the Autonomous Container Database was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfLastBackup")
    def time_of_last_backup(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp of last successful backup. Here NULL value represents either there are no successful backups or backups are not configured for this Autonomous Container Database.
        """
        return pulumi.get(self, "time_of_last_backup")

    @property
    @pulumi.getter(name="timeSnapshotStandbyRevert")
    def time_snapshot_standby_revert(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the Autonomous Container Database will be reverted to Standby from Snapshot Standby.
        """
        return pulumi.get(self, "time_snapshot_standby_revert")

    @property
    @pulumi.getter(name="totalCpus")
    def total_cpus(self) -> pulumi.Output[builtins.int]:
        """
        The number of CPUs allocated to the Autonomous VM cluster.
        """
        return pulumi.get(self, "total_cpus")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        """
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter(name="versionPreference")
    def version_preference(self) -> pulumi.Output[builtins.str]:
        """
        The next maintenance version preference.
        """
        return pulumi.get(self, "version_preference")

    @property
    @pulumi.getter(name="vmFailoverReservation")
    def vm_failover_reservation(self) -> pulumi.Output[builtins.int]:
        """
        The percentage of CPUs reserved across nodes to support node failover. Allowed values are 0%, 25%, and 50%, with 50% being the default option.
        """
        return pulumi.get(self, "vm_failover_reservation")

