# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousVmClusterAcdResourceUsagesResult',
    'AwaitableGetAutonomousVmClusterAcdResourceUsagesResult',
    'get_autonomous_vm_cluster_acd_resource_usages',
    'get_autonomous_vm_cluster_acd_resource_usages_output',
]

@pulumi.output_type
class GetAutonomousVmClusterAcdResourceUsagesResult:
    """
    A collection of values returned by getAutonomousVmClusterAcdResourceUsages.
    """
    def __init__(__self__, autonomous_container_database_resource_usages=None, autonomous_vm_cluster_id=None, compartment_id=None, filters=None, id=None):
        if autonomous_container_database_resource_usages and not isinstance(autonomous_container_database_resource_usages, list):
            raise TypeError("Expected argument 'autonomous_container_database_resource_usages' to be a list")
        pulumi.set(__self__, "autonomous_container_database_resource_usages", autonomous_container_database_resource_usages)
        if autonomous_vm_cluster_id and not isinstance(autonomous_vm_cluster_id, str):
            raise TypeError("Expected argument 'autonomous_vm_cluster_id' to be a str")
        pulumi.set(__self__, "autonomous_vm_cluster_id", autonomous_vm_cluster_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="autonomousContainerDatabaseResourceUsages")
    def autonomous_container_database_resource_usages(self) -> Sequence['outputs.GetAutonomousVmClusterAcdResourceUsagesAutonomousContainerDatabaseResourceUsageResult']:
        """
        The list of autonomous_container_database_resource_usages.
        """
        return pulumi.get(self, "autonomous_container_database_resource_usages")

    @property
    @pulumi.getter(name="autonomousVmClusterId")
    def autonomous_vm_cluster_id(self) -> builtins.str:
        return pulumi.get(self, "autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousVmClusterAcdResourceUsagesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetAutonomousVmClusterAcdResourceUsagesResult(GetAutonomousVmClusterAcdResourceUsagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousVmClusterAcdResourceUsagesResult(
            autonomous_container_database_resource_usages=self.autonomous_container_database_resource_usages,
            autonomous_vm_cluster_id=self.autonomous_vm_cluster_id,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id)


def get_autonomous_vm_cluster_acd_resource_usages(autonomous_vm_cluster_id: Optional[builtins.str] = None,
                                                  compartment_id: Optional[builtins.str] = None,
                                                  filters: Optional[Sequence[Union['GetAutonomousVmClusterAcdResourceUsagesFilterArgs', 'GetAutonomousVmClusterAcdResourceUsagesFilterArgsDict']]] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousVmClusterAcdResourceUsagesResult:
    """
    This data source provides the list of Autonomous Vm Cluster Acd Resource Usages in Oracle Cloud Infrastructure Database service.

    Gets the list of resource usage details for all the Autonomous Container Database in the specified Autonomous Exadata VM cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_vm_cluster_acd_resource_usages = oci.Database.get_autonomous_vm_cluster_acd_resource_usages(autonomous_vm_cluster_id=test_autonomous_vm_cluster["id"],
        compartment_id=compartment_id)
    ```


    :param builtins.str autonomous_vm_cluster_id: The autonomous VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousVmClusterId'] = autonomous_vm_cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousVmClusterAcdResourceUsages:getAutonomousVmClusterAcdResourceUsages', __args__, opts=opts, typ=GetAutonomousVmClusterAcdResourceUsagesResult).value

    return AwaitableGetAutonomousVmClusterAcdResourceUsagesResult(
        autonomous_container_database_resource_usages=pulumi.get(__ret__, 'autonomous_container_database_resource_usages'),
        autonomous_vm_cluster_id=pulumi.get(__ret__, 'autonomous_vm_cluster_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_autonomous_vm_cluster_acd_resource_usages_output(autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                                                         compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAutonomousVmClusterAcdResourceUsagesFilterArgs', 'GetAutonomousVmClusterAcdResourceUsagesFilterArgsDict']]]]] = None,
                                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousVmClusterAcdResourceUsagesResult]:
    """
    This data source provides the list of Autonomous Vm Cluster Acd Resource Usages in Oracle Cloud Infrastructure Database service.

    Gets the list of resource usage details for all the Autonomous Container Database in the specified Autonomous Exadata VM cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_vm_cluster_acd_resource_usages = oci.Database.get_autonomous_vm_cluster_acd_resource_usages(autonomous_vm_cluster_id=test_autonomous_vm_cluster["id"],
        compartment_id=compartment_id)
    ```


    :param builtins.str autonomous_vm_cluster_id: The autonomous VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousVmClusterId'] = autonomous_vm_cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousVmClusterAcdResourceUsages:getAutonomousVmClusterAcdResourceUsages', __args__, opts=opts, typ=GetAutonomousVmClusterAcdResourceUsagesResult)
    return __ret__.apply(lambda __response__: GetAutonomousVmClusterAcdResourceUsagesResult(
        autonomous_container_database_resource_usages=pulumi.get(__response__, 'autonomous_container_database_resource_usages'),
        autonomous_vm_cluster_id=pulumi.get(__response__, 'autonomous_vm_cluster_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
