# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExadbVmClusterUpdateHistoryEntriesResult',
    'AwaitableGetExadbVmClusterUpdateHistoryEntriesResult',
    'get_exadb_vm_cluster_update_history_entries',
    'get_exadb_vm_cluster_update_history_entries_output',
]

@pulumi.output_type
class GetExadbVmClusterUpdateHistoryEntriesResult:
    """
    A collection of values returned by getExadbVmClusterUpdateHistoryEntries.
    """
    def __init__(__self__, exadb_vm_cluster_id=None, exadb_vm_cluster_update_history_entries=None, filters=None, id=None, update_type=None):
        if exadb_vm_cluster_id and not isinstance(exadb_vm_cluster_id, str):
            raise TypeError("Expected argument 'exadb_vm_cluster_id' to be a str")
        pulumi.set(__self__, "exadb_vm_cluster_id", exadb_vm_cluster_id)
        if exadb_vm_cluster_update_history_entries and not isinstance(exadb_vm_cluster_update_history_entries, list):
            raise TypeError("Expected argument 'exadb_vm_cluster_update_history_entries' to be a list")
        pulumi.set(__self__, "exadb_vm_cluster_update_history_entries", exadb_vm_cluster_update_history_entries)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if update_type and not isinstance(update_type, str):
            raise TypeError("Expected argument 'update_type' to be a str")
        pulumi.set(__self__, "update_type", update_type)

    @property
    @pulumi.getter(name="exadbVmClusterId")
    def exadb_vm_cluster_id(self) -> builtins.str:
        return pulumi.get(self, "exadb_vm_cluster_id")

    @property
    @pulumi.getter(name="exadbVmClusterUpdateHistoryEntries")
    def exadb_vm_cluster_update_history_entries(self) -> Sequence['outputs.GetExadbVmClusterUpdateHistoryEntriesExadbVmClusterUpdateHistoryEntryResult']:
        """
        The list of exadb_vm_cluster_update_history_entries.
        """
        return pulumi.get(self, "exadb_vm_cluster_update_history_entries")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetExadbVmClusterUpdateHistoryEntriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="updateType")
    def update_type(self) -> Optional[builtins.str]:
        """
        The type of cloud VM cluster maintenance update.
        """
        return pulumi.get(self, "update_type")


class AwaitableGetExadbVmClusterUpdateHistoryEntriesResult(GetExadbVmClusterUpdateHistoryEntriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExadbVmClusterUpdateHistoryEntriesResult(
            exadb_vm_cluster_id=self.exadb_vm_cluster_id,
            exadb_vm_cluster_update_history_entries=self.exadb_vm_cluster_update_history_entries,
            filters=self.filters,
            id=self.id,
            update_type=self.update_type)


def get_exadb_vm_cluster_update_history_entries(exadb_vm_cluster_id: Optional[builtins.str] = None,
                                                filters: Optional[Sequence[Union['GetExadbVmClusterUpdateHistoryEntriesFilterArgs', 'GetExadbVmClusterUpdateHistoryEntriesFilterArgsDict']]] = None,
                                                update_type: Optional[builtins.str] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExadbVmClusterUpdateHistoryEntriesResult:
    """
    This data source provides the list of Exadb Vm Cluster Update History Entries in Oracle Cloud Infrastructure Database service.

    Gets the history of the maintenance update actions performed on the specified Exadata VM cluster on Exascale Infrastructure.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exadb_vm_cluster_update_history_entries = oci.Database.get_exadb_vm_cluster_update_history_entries(exadb_vm_cluster_id=test_exadb_vm_cluster["id"],
        update_type=exadb_vm_cluster_update_history_entry_update_type)
    ```


    :param builtins.str exadb_vm_cluster_id: The Exadata VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) on Exascale Infrastructure.
    :param builtins.str update_type: A filter to return only resources that match the given update type exactly.
    """
    __args__ = dict()
    __args__['exadbVmClusterId'] = exadb_vm_cluster_id
    __args__['filters'] = filters
    __args__['updateType'] = update_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getExadbVmClusterUpdateHistoryEntries:getExadbVmClusterUpdateHistoryEntries', __args__, opts=opts, typ=GetExadbVmClusterUpdateHistoryEntriesResult).value

    return AwaitableGetExadbVmClusterUpdateHistoryEntriesResult(
        exadb_vm_cluster_id=pulumi.get(__ret__, 'exadb_vm_cluster_id'),
        exadb_vm_cluster_update_history_entries=pulumi.get(__ret__, 'exadb_vm_cluster_update_history_entries'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        update_type=pulumi.get(__ret__, 'update_type'))
def get_exadb_vm_cluster_update_history_entries_output(exadb_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetExadbVmClusterUpdateHistoryEntriesFilterArgs', 'GetExadbVmClusterUpdateHistoryEntriesFilterArgsDict']]]]] = None,
                                                       update_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExadbVmClusterUpdateHistoryEntriesResult]:
    """
    This data source provides the list of Exadb Vm Cluster Update History Entries in Oracle Cloud Infrastructure Database service.

    Gets the history of the maintenance update actions performed on the specified Exadata VM cluster on Exascale Infrastructure.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exadb_vm_cluster_update_history_entries = oci.Database.get_exadb_vm_cluster_update_history_entries(exadb_vm_cluster_id=test_exadb_vm_cluster["id"],
        update_type=exadb_vm_cluster_update_history_entry_update_type)
    ```


    :param builtins.str exadb_vm_cluster_id: The Exadata VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) on Exascale Infrastructure.
    :param builtins.str update_type: A filter to return only resources that match the given update type exactly.
    """
    __args__ = dict()
    __args__['exadbVmClusterId'] = exadb_vm_cluster_id
    __args__['filters'] = filters
    __args__['updateType'] = update_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getExadbVmClusterUpdateHistoryEntries:getExadbVmClusterUpdateHistoryEntries', __args__, opts=opts, typ=GetExadbVmClusterUpdateHistoryEntriesResult)
    return __ret__.apply(lambda __response__: GetExadbVmClusterUpdateHistoryEntriesResult(
        exadb_vm_cluster_id=pulumi.get(__response__, 'exadb_vm_cluster_id'),
        exadb_vm_cluster_update_history_entries=pulumi.get(__response__, 'exadb_vm_cluster_update_history_entries'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        update_type=pulumi.get(__response__, 'update_type')))
