# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetKeyStoresResult',
    'AwaitableGetKeyStoresResult',
    'get_key_stores',
    'get_key_stores_output',
]

@pulumi.output_type
class GetKeyStoresResult:
    """
    A collection of values returned by getKeyStores.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, key_stores=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_stores and not isinstance(key_stores, list):
            raise TypeError("Expected argument 'key_stores' to be a list")
        pulumi.set(__self__, "key_stores", key_stores)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetKeyStoresFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyStores")
    def key_stores(self) -> Sequence['outputs.GetKeyStoresKeyStoreResult']:
        """
        The list of key_stores.
        """
        return pulumi.get(self, "key_stores")


class AwaitableGetKeyStoresResult(GetKeyStoresResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyStoresResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            key_stores=self.key_stores)


def get_key_stores(compartment_id: Optional[builtins.str] = None,
                   filters: Optional[Sequence[Union['GetKeyStoresFilterArgs', 'GetKeyStoresFilterArgsDict']]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyStoresResult:
    """
    This data source provides the list of Key Stores in Oracle Cloud Infrastructure Database service.

    Gets a list of key stores in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_key_stores = oci.Database.get_key_stores(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getKeyStores:getKeyStores', __args__, opts=opts, typ=GetKeyStoresResult).value

    return AwaitableGetKeyStoresResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        key_stores=pulumi.get(__ret__, 'key_stores'))
def get_key_stores_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetKeyStoresFilterArgs', 'GetKeyStoresFilterArgsDict']]]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeyStoresResult]:
    """
    This data source provides the list of Key Stores in Oracle Cloud Infrastructure Database service.

    Gets a list of key stores in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_key_stores = oci.Database.get_key_stores(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getKeyStores:getKeyStores', __args__, opts=opts, typ=GetKeyStoresResult)
    return __ret__.apply(lambda __response__: GetKeyStoresResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        key_stores=pulumi.get(__response__, 'key_stores')))
