# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScheduledActionArgs', 'ScheduledAction']

@pulumi.input_type
class ScheduledActionArgs:
    def __init__(__self__, *,
                 action_type: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 scheduling_plan_id: pulumi.Input[builtins.str],
                 scheduling_window_id: pulumi.Input[builtins.str],
                 action_members: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledActionActionMemberArgs']]]] = None,
                 action_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ScheduledAction resource.
        :param pulumi.Input[builtins.str] action_type: The type of the scheduled action being performed
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] scheduling_plan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Plan.
        :param pulumi.Input[builtins.str] scheduling_window_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Window.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['ScheduledActionActionMemberArgs']]] action_members: (Updatable) The list of action members in a scheduled action.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] action_params: (Updatable) Map<ParamName, ParamValue> where a key value pair describes the specific action parameter. Example: `{"count": "3"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "action_type", action_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "scheduling_plan_id", scheduling_plan_id)
        pulumi.set(__self__, "scheduling_window_id", scheduling_window_id)
        if action_members is not None:
            pulumi.set(__self__, "action_members", action_members)
        if action_params is not None:
            pulumi.set(__self__, "action_params", action_params)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the scheduled action being performed
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="schedulingPlanId")
    def scheduling_plan_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Plan.
        """
        return pulumi.get(self, "scheduling_plan_id")

    @scheduling_plan_id.setter
    def scheduling_plan_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "scheduling_plan_id", value)

    @property
    @pulumi.getter(name="schedulingWindowId")
    def scheduling_window_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Window.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scheduling_window_id")

    @scheduling_window_id.setter
    def scheduling_window_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "scheduling_window_id", value)

    @property
    @pulumi.getter(name="actionMembers")
    def action_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledActionActionMemberArgs']]]]:
        """
        (Updatable) The list of action members in a scheduled action.
        """
        return pulumi.get(self, "action_members")

    @action_members.setter
    def action_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledActionActionMemberArgs']]]]):
        pulumi.set(self, "action_members", value)

    @property
    @pulumi.getter(name="actionParams")
    def action_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Map<ParamName, ParamValue> where a key value pair describes the specific action parameter. Example: `{"count": "3"}`
        """
        return pulumi.get(self, "action_params")

    @action_params.setter
    def action_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "action_params", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _ScheduledActionState:
    def __init__(__self__, *,
                 action_members: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledActionActionMemberArgs']]]] = None,
                 action_order: Optional[pulumi.Input[builtins.int]] = None,
                 action_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 action_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 estimated_time_in_mins: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 scheduling_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling_window_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ScheduledAction resources.
        :param pulumi.Input[Sequence[pulumi.Input['ScheduledActionActionMemberArgs']]] action_members: (Updatable) The list of action members in a scheduled action.
        :param pulumi.Input[builtins.int] action_order: The order of the scheduled action.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] action_params: (Updatable) Map<ParamName, ParamValue> where a key value pair describes the specific action parameter. Example: `{"count": "3"}`
        :param pulumi.Input[builtins.str] action_type: The type of the scheduled action being performed
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: The display name of the Scheduled Action.
        :param pulumi.Input[builtins.int] estimated_time_in_mins: The estimated patching time for the scheduled action.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] scheduling_plan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Plan.
        :param pulumi.Input[builtins.str] scheduling_window_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Window.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current state of the Scheduled Action. Valid states are CREATING, NEEDS_ATTENTION, AVAILABLE, UPDATING, FAILED, DELETING and DELETED.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] time_created: The date and time the Scheduled Action Resource was created.
        :param pulumi.Input[builtins.str] time_updated: The date and time the Scheduled Action Resource was updated.
        """
        if action_members is not None:
            pulumi.set(__self__, "action_members", action_members)
        if action_order is not None:
            pulumi.set(__self__, "action_order", action_order)
        if action_params is not None:
            pulumi.set(__self__, "action_params", action_params)
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if estimated_time_in_mins is not None:
            pulumi.set(__self__, "estimated_time_in_mins", estimated_time_in_mins)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if scheduling_plan_id is not None:
            pulumi.set(__self__, "scheduling_plan_id", scheduling_plan_id)
        if scheduling_window_id is not None:
            pulumi.set(__self__, "scheduling_window_id", scheduling_window_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="actionMembers")
    def action_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledActionActionMemberArgs']]]]:
        """
        (Updatable) The list of action members in a scheduled action.
        """
        return pulumi.get(self, "action_members")

    @action_members.setter
    def action_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduledActionActionMemberArgs']]]]):
        pulumi.set(self, "action_members", value)

    @property
    @pulumi.getter(name="actionOrder")
    def action_order(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The order of the scheduled action.
        """
        return pulumi.get(self, "action_order")

    @action_order.setter
    def action_order(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "action_order", value)

    @property
    @pulumi.getter(name="actionParams")
    def action_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Map<ParamName, ParamValue> where a key value pair describes the specific action parameter. Example: `{"count": "3"}`
        """
        return pulumi.get(self, "action_params")

    @action_params.setter
    def action_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "action_params", value)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the scheduled action being performed
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of the Scheduled Action.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="estimatedTimeInMins")
    def estimated_time_in_mins(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The estimated patching time for the scheduled action.
        """
        return pulumi.get(self, "estimated_time_in_mins")

    @estimated_time_in_mins.setter
    def estimated_time_in_mins(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "estimated_time_in_mins", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="schedulingPlanId")
    def scheduling_plan_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Plan.
        """
        return pulumi.get(self, "scheduling_plan_id")

    @scheduling_plan_id.setter
    def scheduling_plan_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scheduling_plan_id", value)

    @property
    @pulumi.getter(name="schedulingWindowId")
    def scheduling_window_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Window.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scheduling_window_id")

    @scheduling_window_id.setter
    def scheduling_window_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scheduling_window_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the Scheduled Action. Valid states are CREATING, NEEDS_ATTENTION, AVAILABLE, UPDATING, FAILED, DELETING and DELETED.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the Scheduled Action Resource was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the Scheduled Action Resource was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class ScheduledAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScheduledActionActionMemberArgs', 'ScheduledActionActionMemberArgsDict']]]]] = None,
                 action_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 action_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 scheduling_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling_window_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Scheduled Action resource in Oracle Cloud Infrastructure Database service.

        Creates a Scheduled Action resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_scheduled_action = oci.database.ScheduledAction("test_scheduled_action",
            action_type=scheduled_action_action_type,
            compartment_id=compartment_id,
            scheduling_plan_id=test_scheduling_plan["id"],
            scheduling_window_id=test_scheduling_window["id"],
            action_members=[{
                "member_id": test_member["id"],
                "member_order": scheduled_action_action_members_member_order,
                "estimated_time_in_mins": scheduled_action_action_members_estimated_time_in_mins,
            }],
            action_params=scheduled_action_action_params,
            defined_tags=scheduled_action_defined_tags,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        ScheduledActions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/scheduledAction:ScheduledAction test_scheduled_action "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScheduledActionActionMemberArgs', 'ScheduledActionActionMemberArgsDict']]]] action_members: (Updatable) The list of action members in a scheduled action.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] action_params: (Updatable) Map<ParamName, ParamValue> where a key value pair describes the specific action parameter. Example: `{"count": "3"}`
        :param pulumi.Input[builtins.str] action_type: The type of the scheduled action being performed
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] scheduling_plan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Plan.
        :param pulumi.Input[builtins.str] scheduling_window_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Window.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduledActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Scheduled Action resource in Oracle Cloud Infrastructure Database service.

        Creates a Scheduled Action resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_scheduled_action = oci.database.ScheduledAction("test_scheduled_action",
            action_type=scheduled_action_action_type,
            compartment_id=compartment_id,
            scheduling_plan_id=test_scheduling_plan["id"],
            scheduling_window_id=test_scheduling_window["id"],
            action_members=[{
                "member_id": test_member["id"],
                "member_order": scheduled_action_action_members_member_order,
                "estimated_time_in_mins": scheduled_action_action_members_estimated_time_in_mins,
            }],
            action_params=scheduled_action_action_params,
            defined_tags=scheduled_action_defined_tags,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        ScheduledActions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/scheduledAction:ScheduledAction test_scheduled_action "id"
        ```

        :param str resource_name: The name of the resource.
        :param ScheduledActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduledActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScheduledActionActionMemberArgs', 'ScheduledActionActionMemberArgsDict']]]]] = None,
                 action_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 action_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 scheduling_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling_window_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduledActionArgs.__new__(ScheduledActionArgs)

            __props__.__dict__["action_members"] = action_members
            __props__.__dict__["action_params"] = action_params
            if action_type is None and not opts.urn:
                raise TypeError("Missing required property 'action_type'")
            __props__.__dict__["action_type"] = action_type
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            if scheduling_plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'scheduling_plan_id'")
            __props__.__dict__["scheduling_plan_id"] = scheduling_plan_id
            if scheduling_window_id is None and not opts.urn:
                raise TypeError("Missing required property 'scheduling_window_id'")
            __props__.__dict__["scheduling_window_id"] = scheduling_window_id
            __props__.__dict__["action_order"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["estimated_time_in_mins"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(ScheduledAction, __self__).__init__(
            'oci:Database/scheduledAction:ScheduledAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action_members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScheduledActionActionMemberArgs', 'ScheduledActionActionMemberArgsDict']]]]] = None,
            action_order: Optional[pulumi.Input[builtins.int]] = None,
            action_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            action_type: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            estimated_time_in_mins: Optional[pulumi.Input[builtins.int]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            scheduling_plan_id: Optional[pulumi.Input[builtins.str]] = None,
            scheduling_window_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'ScheduledAction':
        """
        Get an existing ScheduledAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScheduledActionActionMemberArgs', 'ScheduledActionActionMemberArgsDict']]]] action_members: (Updatable) The list of action members in a scheduled action.
        :param pulumi.Input[builtins.int] action_order: The order of the scheduled action.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] action_params: (Updatable) Map<ParamName, ParamValue> where a key value pair describes the specific action parameter. Example: `{"count": "3"}`
        :param pulumi.Input[builtins.str] action_type: The type of the scheduled action being performed
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: The display name of the Scheduled Action.
        :param pulumi.Input[builtins.int] estimated_time_in_mins: The estimated patching time for the scheduled action.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] scheduling_plan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Plan.
        :param pulumi.Input[builtins.str] scheduling_window_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Window.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current state of the Scheduled Action. Valid states are CREATING, NEEDS_ATTENTION, AVAILABLE, UPDATING, FAILED, DELETING and DELETED.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] time_created: The date and time the Scheduled Action Resource was created.
        :param pulumi.Input[builtins.str] time_updated: The date and time the Scheduled Action Resource was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScheduledActionState.__new__(_ScheduledActionState)

        __props__.__dict__["action_members"] = action_members
        __props__.__dict__["action_order"] = action_order
        __props__.__dict__["action_params"] = action_params
        __props__.__dict__["action_type"] = action_type
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["estimated_time_in_mins"] = estimated_time_in_mins
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["scheduling_plan_id"] = scheduling_plan_id
        __props__.__dict__["scheduling_window_id"] = scheduling_window_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return ScheduledAction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actionMembers")
    def action_members(self) -> pulumi.Output[Sequence['outputs.ScheduledActionActionMember']]:
        """
        (Updatable) The list of action members in a scheduled action.
        """
        return pulumi.get(self, "action_members")

    @property
    @pulumi.getter(name="actionOrder")
    def action_order(self) -> pulumi.Output[builtins.int]:
        """
        The order of the scheduled action.
        """
        return pulumi.get(self, "action_order")

    @property
    @pulumi.getter(name="actionParams")
    def action_params(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Map<ParamName, ParamValue> where a key value pair describes the specific action parameter. Example: `{"count": "3"}`
        """
        return pulumi.get(self, "action_params")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the scheduled action being performed
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name of the Scheduled Action.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="estimatedTimeInMins")
    def estimated_time_in_mins(self) -> pulumi.Output[builtins.int]:
        """
        The estimated patching time for the scheduled action.
        """
        return pulumi.get(self, "estimated_time_in_mins")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="schedulingPlanId")
    def scheduling_plan_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Plan.
        """
        return pulumi.get(self, "scheduling_plan_id")

    @property
    @pulumi.getter(name="schedulingWindowId")
    def scheduling_window_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Window.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scheduling_window_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the Scheduled Action. Valid states are CREATING, NEEDS_ATTENTION, AVAILABLE, UPDATING, FAILED, DELETING and DELETED.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the Scheduled Action Resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the Scheduled Action Resource was updated.
        """
        return pulumi.get(self, "time_updated")

