# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExternalMySqlDatabaseConnectorsResult',
    'AwaitableGetExternalMySqlDatabaseConnectorsResult',
    'get_external_my_sql_database_connectors',
    'get_external_my_sql_database_connectors_output',
]

@pulumi.output_type
class GetExternalMySqlDatabaseConnectorsResult:
    """
    A collection of values returned by getExternalMySqlDatabaseConnectors.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, my_sql_connector_collections=None, name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if my_sql_connector_collections and not isinstance(my_sql_connector_collections, list):
            raise TypeError("Expected argument 'my_sql_connector_collections' to be a list")
        pulumi.set(__self__, "my_sql_connector_collections", my_sql_connector_collections)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        OCID of compartment for the External MySQL connector.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetExternalMySqlDatabaseConnectorsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mySqlConnectorCollections")
    def my_sql_connector_collections(self) -> Sequence['outputs.GetExternalMySqlDatabaseConnectorsMySqlConnectorCollectionResult']:
        """
        The list of my_sql_connector_collection.
        """
        return pulumi.get(self, "my_sql_connector_collections")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        External MySQL Database Connector Name.
        """
        return pulumi.get(self, "name")


class AwaitableGetExternalMySqlDatabaseConnectorsResult(GetExternalMySqlDatabaseConnectorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalMySqlDatabaseConnectorsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            my_sql_connector_collections=self.my_sql_connector_collections,
            name=self.name)


def get_external_my_sql_database_connectors(compartment_id: Optional[builtins.str] = None,
                                            filters: Optional[Sequence[Union['GetExternalMySqlDatabaseConnectorsFilterArgs', 'GetExternalMySqlDatabaseConnectorsFilterArgsDict']]] = None,
                                            name: Optional[builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalMySqlDatabaseConnectorsResult:
    """
    This data source provides the list of External My Sql Database Connectors in Oracle Cloud Infrastructure Database Management service.

    Gets the list of External MySQL Database connectors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_my_sql_database_connectors = oci.DatabaseManagement.get_external_my_sql_database_connectors(compartment_id=compartment_id,
        name=external_my_sql_database_connector_name)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str name: The parameter to filter by MySQL Database System type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalMySqlDatabaseConnectors:getExternalMySqlDatabaseConnectors', __args__, opts=opts, typ=GetExternalMySqlDatabaseConnectorsResult).value

    return AwaitableGetExternalMySqlDatabaseConnectorsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        my_sql_connector_collections=pulumi.get(__ret__, 'my_sql_connector_collections'),
        name=pulumi.get(__ret__, 'name'))
def get_external_my_sql_database_connectors_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetExternalMySqlDatabaseConnectorsFilterArgs', 'GetExternalMySqlDatabaseConnectorsFilterArgsDict']]]]] = None,
                                                   name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExternalMySqlDatabaseConnectorsResult]:
    """
    This data source provides the list of External My Sql Database Connectors in Oracle Cloud Infrastructure Database Management service.

    Gets the list of External MySQL Database connectors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_my_sql_database_connectors = oci.DatabaseManagement.get_external_my_sql_database_connectors(compartment_id=compartment_id,
        name=external_my_sql_database_connector_name)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str name: The parameter to filter by MySQL Database System type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getExternalMySqlDatabaseConnectors:getExternalMySqlDatabaseConnectors', __args__, opts=opts, typ=GetExternalMySqlDatabaseConnectorsResult)
    return __ret__.apply(lambda __response__: GetExternalMySqlDatabaseConnectorsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        my_sql_connector_collections=pulumi.get(__response__, 'my_sql_connector_collections'),
        name=pulumi.get(__response__, 'name')))
