# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUserAssessmentResult',
    'AwaitableGetUserAssessmentResult',
    'get_user_assessment',
    'get_user_assessment_output',
]

@pulumi.output_type
class GetUserAssessmentResult:
    """
    A collection of values returned by getUserAssessment.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, ignored_assessment_ids=None, ignored_targets=None, is_assessment_scheduled=None, is_baseline=None, is_deviated_from_baseline=None, last_compared_baseline_id=None, lifecycle_details=None, schedule=None, schedule_assessment_id=None, state=None, statistics=None, system_tags=None, target_id=None, target_ids=None, time_created=None, time_last_assessed=None, time_updated=None, triggered_by=None, type=None, user_assessment_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ignored_assessment_ids and not isinstance(ignored_assessment_ids, list):
            raise TypeError("Expected argument 'ignored_assessment_ids' to be a list")
        pulumi.set(__self__, "ignored_assessment_ids", ignored_assessment_ids)
        if ignored_targets and not isinstance(ignored_targets, list):
            raise TypeError("Expected argument 'ignored_targets' to be a list")
        pulumi.set(__self__, "ignored_targets", ignored_targets)
        if is_assessment_scheduled and not isinstance(is_assessment_scheduled, bool):
            raise TypeError("Expected argument 'is_assessment_scheduled' to be a bool")
        pulumi.set(__self__, "is_assessment_scheduled", is_assessment_scheduled)
        if is_baseline and not isinstance(is_baseline, bool):
            raise TypeError("Expected argument 'is_baseline' to be a bool")
        pulumi.set(__self__, "is_baseline", is_baseline)
        if is_deviated_from_baseline and not isinstance(is_deviated_from_baseline, bool):
            raise TypeError("Expected argument 'is_deviated_from_baseline' to be a bool")
        pulumi.set(__self__, "is_deviated_from_baseline", is_deviated_from_baseline)
        if last_compared_baseline_id and not isinstance(last_compared_baseline_id, str):
            raise TypeError("Expected argument 'last_compared_baseline_id' to be a str")
        pulumi.set(__self__, "last_compared_baseline_id", last_compared_baseline_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if schedule and not isinstance(schedule, str):
            raise TypeError("Expected argument 'schedule' to be a str")
        pulumi.set(__self__, "schedule", schedule)
        if schedule_assessment_id and not isinstance(schedule_assessment_id, str):
            raise TypeError("Expected argument 'schedule_assessment_id' to be a str")
        pulumi.set(__self__, "schedule_assessment_id", schedule_assessment_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if statistics and not isinstance(statistics, str):
            raise TypeError("Expected argument 'statistics' to be a str")
        pulumi.set(__self__, "statistics", statistics)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if target_ids and not isinstance(target_ids, list):
            raise TypeError("Expected argument 'target_ids' to be a list")
        pulumi.set(__self__, "target_ids", target_ids)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_assessed and not isinstance(time_last_assessed, str):
            raise TypeError("Expected argument 'time_last_assessed' to be a str")
        pulumi.set(__self__, "time_last_assessed", time_last_assessed)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if triggered_by and not isinstance(triggered_by, str):
            raise TypeError("Expected argument 'triggered_by' to be a str")
        pulumi.set(__self__, "triggered_by", triggered_by)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if user_assessment_id and not isinstance(user_assessment_id, str):
            raise TypeError("Expected argument 'user_assessment_id' to be a str")
        pulumi.set(__self__, "user_assessment_id", user_assessment_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment that contains the user assessment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the user assessment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The display name of the user assessment.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the user assessment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ignoredAssessmentIds")
    def ignored_assessment_ids(self) -> Sequence[builtins.str]:
        """
        List containing maps as values. Example: `{"Operations": [ {"CostCenter": "42"} ] }`
        """
        return pulumi.get(self, "ignored_assessment_ids")

    @property
    @pulumi.getter(name="ignoredTargets")
    def ignored_targets(self) -> Sequence['outputs.GetUserAssessmentIgnoredTargetResult']:
        """
        List containing maps as values. Example: `{"Operations": [ {"CostCenter": "42"} ] }`
        """
        return pulumi.get(self, "ignored_targets")

    @property
    @pulumi.getter(name="isAssessmentScheduled")
    def is_assessment_scheduled(self) -> builtins.bool:
        """
        Indicates whether the assessment is scheduled to run.
        """
        return pulumi.get(self, "is_assessment_scheduled")

    @property
    @pulumi.getter(name="isBaseline")
    def is_baseline(self) -> builtins.bool:
        """
        Indicates if the user assessment is set as a baseline. This is applicable only to saved user assessments.
        """
        return pulumi.get(self, "is_baseline")

    @property
    @pulumi.getter(name="isDeviatedFromBaseline")
    def is_deviated_from_baseline(self) -> builtins.bool:
        """
        Indicates if the user assessment deviates from the baseline.
        """
        return pulumi.get(self, "is_deviated_from_baseline")

    @property
    @pulumi.getter(name="lastComparedBaselineId")
    def last_compared_baseline_id(self) -> builtins.str:
        """
        The OCID of the last user assessment baseline against which the latest assessment was compared.
        """
        return pulumi.get(self, "last_compared_baseline_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Details about the current state of the user assessment.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def schedule(self) -> builtins.str:
        """
        Schedule of the assessment that runs periodically in this specified format: <version-string>;<version-specific-schedule>
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="scheduleAssessmentId")
    def schedule_assessment_id(self) -> builtins.str:
        """
        The OCID of the user assessment that is responsible for creating this scheduled save assessment.
        """
        return pulumi.get(self, "schedule_assessment_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the user assessment.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def statistics(self) -> builtins.str:
        """
        Map that contains maps of values. Example: `{"Operations": {"CostCenter": "42"}}`
        """
        return pulumi.get(self, "statistics")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> builtins.str:
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetIds")
    def target_ids(self) -> Sequence[builtins.str]:
        """
        Array of database target OCIDs.
        """
        return pulumi.get(self, "target_ids")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the user assessment was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastAssessed")
    def time_last_assessed(self) -> builtins.str:
        """
        The date and time the user assessment was last executed, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_last_assessed")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the user assessment was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="triggeredBy")
    def triggered_by(self) -> builtins.str:
        """
        Indicates whether the user assessment was created by the system or the user.
        """
        return pulumi.get(self, "triggered_by")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the user assessment. The possible types are:
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssessmentId")
    def user_assessment_id(self) -> builtins.str:
        return pulumi.get(self, "user_assessment_id")


class AwaitableGetUserAssessmentResult(GetUserAssessmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserAssessmentResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            ignored_assessment_ids=self.ignored_assessment_ids,
            ignored_targets=self.ignored_targets,
            is_assessment_scheduled=self.is_assessment_scheduled,
            is_baseline=self.is_baseline,
            is_deviated_from_baseline=self.is_deviated_from_baseline,
            last_compared_baseline_id=self.last_compared_baseline_id,
            lifecycle_details=self.lifecycle_details,
            schedule=self.schedule,
            schedule_assessment_id=self.schedule_assessment_id,
            state=self.state,
            statistics=self.statistics,
            system_tags=self.system_tags,
            target_id=self.target_id,
            target_ids=self.target_ids,
            time_created=self.time_created,
            time_last_assessed=self.time_last_assessed,
            time_updated=self.time_updated,
            triggered_by=self.triggered_by,
            type=self.type,
            user_assessment_id=self.user_assessment_id)


def get_user_assessment(user_assessment_id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserAssessmentResult:
    """
    This data source provides details about a specific User Assessment resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a user assessment by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_user_assessment = oci.DataSafe.get_user_assessment(user_assessment_id=test_user_assessment_oci_data_safe_user_assessment["id"])
    ```


    :param builtins.str user_assessment_id: The OCID of the user assessment.
    """
    __args__ = dict()
    __args__['userAssessmentId'] = user_assessment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getUserAssessment:getUserAssessment', __args__, opts=opts, typ=GetUserAssessmentResult).value

    return AwaitableGetUserAssessmentResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        ignored_assessment_ids=pulumi.get(__ret__, 'ignored_assessment_ids'),
        ignored_targets=pulumi.get(__ret__, 'ignored_targets'),
        is_assessment_scheduled=pulumi.get(__ret__, 'is_assessment_scheduled'),
        is_baseline=pulumi.get(__ret__, 'is_baseline'),
        is_deviated_from_baseline=pulumi.get(__ret__, 'is_deviated_from_baseline'),
        last_compared_baseline_id=pulumi.get(__ret__, 'last_compared_baseline_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        schedule=pulumi.get(__ret__, 'schedule'),
        schedule_assessment_id=pulumi.get(__ret__, 'schedule_assessment_id'),
        state=pulumi.get(__ret__, 'state'),
        statistics=pulumi.get(__ret__, 'statistics'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_id=pulumi.get(__ret__, 'target_id'),
        target_ids=pulumi.get(__ret__, 'target_ids'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_assessed=pulumi.get(__ret__, 'time_last_assessed'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        triggered_by=pulumi.get(__ret__, 'triggered_by'),
        type=pulumi.get(__ret__, 'type'),
        user_assessment_id=pulumi.get(__ret__, 'user_assessment_id'))
def get_user_assessment_output(user_assessment_id: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserAssessmentResult]:
    """
    This data source provides details about a specific User Assessment resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a user assessment by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_user_assessment = oci.DataSafe.get_user_assessment(user_assessment_id=test_user_assessment_oci_data_safe_user_assessment["id"])
    ```


    :param builtins.str user_assessment_id: The OCID of the user assessment.
    """
    __args__ = dict()
    __args__['userAssessmentId'] = user_assessment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getUserAssessment:getUserAssessment', __args__, opts=opts, typ=GetUserAssessmentResult)
    return __ret__.apply(lambda __response__: GetUserAssessmentResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        ignored_assessment_ids=pulumi.get(__response__, 'ignored_assessment_ids'),
        ignored_targets=pulumi.get(__response__, 'ignored_targets'),
        is_assessment_scheduled=pulumi.get(__response__, 'is_assessment_scheduled'),
        is_baseline=pulumi.get(__response__, 'is_baseline'),
        is_deviated_from_baseline=pulumi.get(__response__, 'is_deviated_from_baseline'),
        last_compared_baseline_id=pulumi.get(__response__, 'last_compared_baseline_id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        schedule=pulumi.get(__response__, 'schedule'),
        schedule_assessment_id=pulumi.get(__response__, 'schedule_assessment_id'),
        state=pulumi.get(__response__, 'state'),
        statistics=pulumi.get(__response__, 'statistics'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        target_id=pulumi.get(__response__, 'target_id'),
        target_ids=pulumi.get(__response__, 'target_ids'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_last_assessed=pulumi.get(__response__, 'time_last_assessed'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        triggered_by=pulumi.get(__response__, 'triggered_by'),
        type=pulumi.get(__response__, 'type'),
        user_assessment_id=pulumi.get(__response__, 'user_assessment_id')))
