# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUserAssessmentUsersResult',
    'AwaitableGetUserAssessmentUsersResult',
    'get_user_assessment_users',
    'get_user_assessment_users_output',
]

@pulumi.output_type
class GetUserAssessmentUsersResult:
    """
    A collection of values returned by getUserAssessmentUsers.
    """
    def __init__(__self__, access_level=None, account_status=None, are_all_schemas_accessible=None, authentication_type=None, compartment_id_in_subtree=None, filters=None, id=None, schema_lists=None, target_id=None, time_last_login_greater_than_or_equal_to=None, time_last_login_less_than=None, time_password_expiry_greater_than_or_equal_to=None, time_password_expiry_less_than=None, time_password_last_changed_greater_than_or_equal_to=None, time_password_last_changed_less_than=None, time_user_created_greater_than_or_equal_to=None, time_user_created_less_than=None, user_assessment_id=None, user_category=None, user_key=None, user_name=None, user_profile=None, user_role=None, user_type=None, users=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if account_status and not isinstance(account_status, str):
            raise TypeError("Expected argument 'account_status' to be a str")
        pulumi.set(__self__, "account_status", account_status)
        if are_all_schemas_accessible and not isinstance(are_all_schemas_accessible, bool):
            raise TypeError("Expected argument 'are_all_schemas_accessible' to be a bool")
        pulumi.set(__self__, "are_all_schemas_accessible", are_all_schemas_accessible)
        if authentication_type and not isinstance(authentication_type, str):
            raise TypeError("Expected argument 'authentication_type' to be a str")
        pulumi.set(__self__, "authentication_type", authentication_type)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if schema_lists and not isinstance(schema_lists, list):
            raise TypeError("Expected argument 'schema_lists' to be a list")
        pulumi.set(__self__, "schema_lists", schema_lists)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if time_last_login_greater_than_or_equal_to and not isinstance(time_last_login_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_last_login_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_last_login_greater_than_or_equal_to", time_last_login_greater_than_or_equal_to)
        if time_last_login_less_than and not isinstance(time_last_login_less_than, str):
            raise TypeError("Expected argument 'time_last_login_less_than' to be a str")
        pulumi.set(__self__, "time_last_login_less_than", time_last_login_less_than)
        if time_password_expiry_greater_than_or_equal_to and not isinstance(time_password_expiry_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_password_expiry_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_password_expiry_greater_than_or_equal_to", time_password_expiry_greater_than_or_equal_to)
        if time_password_expiry_less_than and not isinstance(time_password_expiry_less_than, str):
            raise TypeError("Expected argument 'time_password_expiry_less_than' to be a str")
        pulumi.set(__self__, "time_password_expiry_less_than", time_password_expiry_less_than)
        if time_password_last_changed_greater_than_or_equal_to and not isinstance(time_password_last_changed_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_password_last_changed_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_password_last_changed_greater_than_or_equal_to", time_password_last_changed_greater_than_or_equal_to)
        if time_password_last_changed_less_than and not isinstance(time_password_last_changed_less_than, str):
            raise TypeError("Expected argument 'time_password_last_changed_less_than' to be a str")
        pulumi.set(__self__, "time_password_last_changed_less_than", time_password_last_changed_less_than)
        if time_user_created_greater_than_or_equal_to and not isinstance(time_user_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_user_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_user_created_greater_than_or_equal_to", time_user_created_greater_than_or_equal_to)
        if time_user_created_less_than and not isinstance(time_user_created_less_than, str):
            raise TypeError("Expected argument 'time_user_created_less_than' to be a str")
        pulumi.set(__self__, "time_user_created_less_than", time_user_created_less_than)
        if user_assessment_id and not isinstance(user_assessment_id, str):
            raise TypeError("Expected argument 'user_assessment_id' to be a str")
        pulumi.set(__self__, "user_assessment_id", user_assessment_id)
        if user_category and not isinstance(user_category, str):
            raise TypeError("Expected argument 'user_category' to be a str")
        pulumi.set(__self__, "user_category", user_category)
        if user_key and not isinstance(user_key, str):
            raise TypeError("Expected argument 'user_key' to be a str")
        pulumi.set(__self__, "user_key", user_key)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)
        if user_profile and not isinstance(user_profile, str):
            raise TypeError("Expected argument 'user_profile' to be a str")
        pulumi.set(__self__, "user_profile", user_profile)
        if user_role and not isinstance(user_role, str):
            raise TypeError("Expected argument 'user_role' to be a str")
        pulumi.set(__self__, "user_role", user_role)
        if user_type and not isinstance(user_type, str):
            raise TypeError("Expected argument 'user_type' to be a str")
        pulumi.set(__self__, "user_type", user_type)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[builtins.str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="accountStatus")
    def account_status(self) -> Optional[builtins.str]:
        """
        The status of the user account.
        """
        return pulumi.get(self, "account_status")

    @property
    @pulumi.getter(name="areAllSchemasAccessible")
    def are_all_schemas_accessible(self) -> Optional[builtins.bool]:
        """
        Indicates whether the user has access to all the schemas.
        """
        return pulumi.get(self, "are_all_schemas_accessible")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[builtins.str]:
        """
        The user authentication method.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetUserAssessmentUsersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="schemaLists")
    def schema_lists(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of database schemas current user can access.
        """
        return pulumi.get(self, "schema_lists")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[builtins.str]:
        """
        The OCID of the target database.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeLastLoginGreaterThanOrEqualTo")
    def time_last_login_greater_than_or_equal_to(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_last_login_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeLastLoginLessThan")
    def time_last_login_less_than(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_last_login_less_than")

    @property
    @pulumi.getter(name="timePasswordExpiryGreaterThanOrEqualTo")
    def time_password_expiry_greater_than_or_equal_to(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_password_expiry_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timePasswordExpiryLessThan")
    def time_password_expiry_less_than(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_password_expiry_less_than")

    @property
    @pulumi.getter(name="timePasswordLastChangedGreaterThanOrEqualTo")
    def time_password_last_changed_greater_than_or_equal_to(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_password_last_changed_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timePasswordLastChangedLessThan")
    def time_password_last_changed_less_than(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_password_last_changed_less_than")

    @property
    @pulumi.getter(name="timeUserCreatedGreaterThanOrEqualTo")
    def time_user_created_greater_than_or_equal_to(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_user_created_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeUserCreatedLessThan")
    def time_user_created_less_than(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_user_created_less_than")

    @property
    @pulumi.getter(name="userAssessmentId")
    def user_assessment_id(self) -> builtins.str:
        return pulumi.get(self, "user_assessment_id")

    @property
    @pulumi.getter(name="userCategory")
    def user_category(self) -> Optional[builtins.str]:
        """
        The user category based on the privileges and other details of the user.
        """
        return pulumi.get(self, "user_category")

    @property
    @pulumi.getter(name="userKey")
    def user_key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "user_key")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[builtins.str]:
        """
        The database user name.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="userProfile")
    def user_profile(self) -> Optional[builtins.str]:
        """
        The user profile name.
        """
        return pulumi.get(self, "user_profile")

    @property
    @pulumi.getter(name="userRole")
    def user_role(self) -> Optional[builtins.str]:
        return pulumi.get(self, "user_role")

    @property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "user_type")

    @property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetUserAssessmentUsersUserResult']:
        """
        The list of users.
        """
        return pulumi.get(self, "users")


class AwaitableGetUserAssessmentUsersResult(GetUserAssessmentUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserAssessmentUsersResult(
            access_level=self.access_level,
            account_status=self.account_status,
            are_all_schemas_accessible=self.are_all_schemas_accessible,
            authentication_type=self.authentication_type,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            schema_lists=self.schema_lists,
            target_id=self.target_id,
            time_last_login_greater_than_or_equal_to=self.time_last_login_greater_than_or_equal_to,
            time_last_login_less_than=self.time_last_login_less_than,
            time_password_expiry_greater_than_or_equal_to=self.time_password_expiry_greater_than_or_equal_to,
            time_password_expiry_less_than=self.time_password_expiry_less_than,
            time_password_last_changed_greater_than_or_equal_to=self.time_password_last_changed_greater_than_or_equal_to,
            time_password_last_changed_less_than=self.time_password_last_changed_less_than,
            time_user_created_greater_than_or_equal_to=self.time_user_created_greater_than_or_equal_to,
            time_user_created_less_than=self.time_user_created_less_than,
            user_assessment_id=self.user_assessment_id,
            user_category=self.user_category,
            user_key=self.user_key,
            user_name=self.user_name,
            user_profile=self.user_profile,
            user_role=self.user_role,
            user_type=self.user_type,
            users=self.users)


def get_user_assessment_users(access_level: Optional[builtins.str] = None,
                              account_status: Optional[builtins.str] = None,
                              are_all_schemas_accessible: Optional[builtins.bool] = None,
                              authentication_type: Optional[builtins.str] = None,
                              compartment_id_in_subtree: Optional[builtins.bool] = None,
                              filters: Optional[Sequence[Union['GetUserAssessmentUsersFilterArgs', 'GetUserAssessmentUsersFilterArgsDict']]] = None,
                              schema_lists: Optional[Sequence[builtins.str]] = None,
                              target_id: Optional[builtins.str] = None,
                              time_last_login_greater_than_or_equal_to: Optional[builtins.str] = None,
                              time_last_login_less_than: Optional[builtins.str] = None,
                              time_password_expiry_greater_than_or_equal_to: Optional[builtins.str] = None,
                              time_password_expiry_less_than: Optional[builtins.str] = None,
                              time_password_last_changed_greater_than_or_equal_to: Optional[builtins.str] = None,
                              time_password_last_changed_less_than: Optional[builtins.str] = None,
                              time_user_created_greater_than_or_equal_to: Optional[builtins.str] = None,
                              time_user_created_less_than: Optional[builtins.str] = None,
                              user_assessment_id: Optional[builtins.str] = None,
                              user_category: Optional[builtins.str] = None,
                              user_key: Optional[builtins.str] = None,
                              user_name: Optional[builtins.str] = None,
                              user_profile: Optional[builtins.str] = None,
                              user_role: Optional[builtins.str] = None,
                              user_type: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserAssessmentUsersResult:
    """
    This data source provides the list of User Assessment Users in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of users of the specified user assessment. The result contains the database user details for each user, such
    as user type, account status, last login time, user creation time, authentication type, user profile, and the date and time
    of the latest password change. It also contains the user category derived from these user details as well as privileges
    granted to each user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_user_assessment_users = oci.DataSafe.get_user_assessment_users(user_assessment_id=test_user_assessment["id"],
        access_level=user_assessment_user_access_level,
        account_status=user_assessment_user_account_status,
        are_all_schemas_accessible=user_assessment_user_are_all_schemas_accessible,
        authentication_type=user_assessment_user_authentication_type,
        compartment_id_in_subtree=user_assessment_user_compartment_id_in_subtree,
        schema_lists=user_assessment_user_schema_list,
        target_id=test_target["id"],
        time_last_login_greater_than_or_equal_to=user_assessment_user_time_last_login_greater_than_or_equal_to,
        time_last_login_less_than=user_assessment_user_time_last_login_less_than,
        time_password_expiry_greater_than_or_equal_to=user_assessment_user_time_password_expiry_greater_than_or_equal_to,
        time_password_expiry_less_than=user_assessment_user_time_password_expiry_less_than,
        time_password_last_changed_greater_than_or_equal_to=user_assessment_user_time_password_last_changed_greater_than_or_equal_to,
        time_password_last_changed_less_than=user_assessment_user_time_password_last_changed_less_than,
        time_user_created_greater_than_or_equal_to=user_assessment_user_time_user_created_greater_than_or_equal_to,
        time_user_created_less_than=user_assessment_user_time_user_created_less_than,
        user_category=user_assessment_user_user_category,
        user_key=user_assessment_user_user_key,
        user_name=test_user["name"],
        user_profile=user_assessment_user_user_profile,
        user_role=user_assessment_user_user_role,
        user_type=user_assessment_user_user_type)
    ```


    :param builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param builtins.str account_status: A filter to return only items that match the specified account status.
    :param builtins.bool are_all_schemas_accessible: A filter to return only items that match the criteria that all schemas can be accessed by a user.
    :param builtins.str authentication_type: A filter to return only items that match the specified authentication type.
    :param builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param Sequence[builtins.str] schema_lists: A filter to return items that contain the specified schema list.
    :param builtins.str target_id: A filter to return only items related to a specific target OCID.
    :param builtins.str time_last_login_greater_than_or_equal_to: A filter to return users whose last login time in the database is greater than or equal to the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param builtins.str time_last_login_less_than: A filter to return users whose last login time in the database is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). **Example:** 2016-12-19T16:39:57.600Z
    :param builtins.str time_password_expiry_greater_than_or_equal_to: A filter to return users whose password expiry date in the database is greater than or equal to the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). **Example:** 2016-12-19T16:39:57.600Z
    :param builtins.str time_password_expiry_less_than: A filter to return users whose password expiry date in the database is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). **Example:** 2016-12-19T16:39:57.600Z
    :param builtins.str time_password_last_changed_greater_than_or_equal_to: A filter to return users whose last password change in the database is greater than or equal to the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param builtins.str time_password_last_changed_less_than: A filter to return users whose last password change in the database is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param builtins.str time_user_created_greater_than_or_equal_to: A filter to return users whose creation time in the database is greater than or equal to the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). **Example:** 2016-12-19T16:39:57.600Z
    :param builtins.str time_user_created_less_than: A filter to return users whose creation time in the database is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). **Example:** 2016-12-19T16:39:57.600Z
    :param builtins.str user_assessment_id: The OCID of the user assessment.
    :param builtins.str user_category: A filter to return only items that match the specified user category.
    :param builtins.str user_key: A filter to return only items that match the specified user key.
    :param builtins.str user_name: A filter to return only items that match the specified user name.
    :param builtins.str user_profile: A filter to return only items that match the specified user profile.
    :param builtins.str user_role: A filter to return only items that match the specified user role.
    :param builtins.str user_type: A filter to return only items that match the specified user type. The possible values can be
           * ADMIN_PRIVILEGED
           * APPLICATION
           * PRIVILEGED
           * SCHEMA
           * NON_PRIVILEGED as specified by '#/definitions/userTypes'.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['accountStatus'] = account_status
    __args__['areAllSchemasAccessible'] = are_all_schemas_accessible
    __args__['authenticationType'] = authentication_type
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['schemaLists'] = schema_lists
    __args__['targetId'] = target_id
    __args__['timeLastLoginGreaterThanOrEqualTo'] = time_last_login_greater_than_or_equal_to
    __args__['timeLastLoginLessThan'] = time_last_login_less_than
    __args__['timePasswordExpiryGreaterThanOrEqualTo'] = time_password_expiry_greater_than_or_equal_to
    __args__['timePasswordExpiryLessThan'] = time_password_expiry_less_than
    __args__['timePasswordLastChangedGreaterThanOrEqualTo'] = time_password_last_changed_greater_than_or_equal_to
    __args__['timePasswordLastChangedLessThan'] = time_password_last_changed_less_than
    __args__['timeUserCreatedGreaterThanOrEqualTo'] = time_user_created_greater_than_or_equal_to
    __args__['timeUserCreatedLessThan'] = time_user_created_less_than
    __args__['userAssessmentId'] = user_assessment_id
    __args__['userCategory'] = user_category
    __args__['userKey'] = user_key
    __args__['userName'] = user_name
    __args__['userProfile'] = user_profile
    __args__['userRole'] = user_role
    __args__['userType'] = user_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getUserAssessmentUsers:getUserAssessmentUsers', __args__, opts=opts, typ=GetUserAssessmentUsersResult).value

    return AwaitableGetUserAssessmentUsersResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        account_status=pulumi.get(__ret__, 'account_status'),
        are_all_schemas_accessible=pulumi.get(__ret__, 'are_all_schemas_accessible'),
        authentication_type=pulumi.get(__ret__, 'authentication_type'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        schema_lists=pulumi.get(__ret__, 'schema_lists'),
        target_id=pulumi.get(__ret__, 'target_id'),
        time_last_login_greater_than_or_equal_to=pulumi.get(__ret__, 'time_last_login_greater_than_or_equal_to'),
        time_last_login_less_than=pulumi.get(__ret__, 'time_last_login_less_than'),
        time_password_expiry_greater_than_or_equal_to=pulumi.get(__ret__, 'time_password_expiry_greater_than_or_equal_to'),
        time_password_expiry_less_than=pulumi.get(__ret__, 'time_password_expiry_less_than'),
        time_password_last_changed_greater_than_or_equal_to=pulumi.get(__ret__, 'time_password_last_changed_greater_than_or_equal_to'),
        time_password_last_changed_less_than=pulumi.get(__ret__, 'time_password_last_changed_less_than'),
        time_user_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_user_created_greater_than_or_equal_to'),
        time_user_created_less_than=pulumi.get(__ret__, 'time_user_created_less_than'),
        user_assessment_id=pulumi.get(__ret__, 'user_assessment_id'),
        user_category=pulumi.get(__ret__, 'user_category'),
        user_key=pulumi.get(__ret__, 'user_key'),
        user_name=pulumi.get(__ret__, 'user_name'),
        user_profile=pulumi.get(__ret__, 'user_profile'),
        user_role=pulumi.get(__ret__, 'user_role'),
        user_type=pulumi.get(__ret__, 'user_type'),
        users=pulumi.get(__ret__, 'users'))
def get_user_assessment_users_output(access_level: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     account_status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     are_all_schemas_accessible: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                     authentication_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     compartment_id_in_subtree: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetUserAssessmentUsersFilterArgs', 'GetUserAssessmentUsersFilterArgsDict']]]]] = None,
                                     schema_lists: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                     target_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     time_last_login_greater_than_or_equal_to: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     time_last_login_less_than: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     time_password_expiry_greater_than_or_equal_to: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     time_password_expiry_less_than: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     time_password_last_changed_greater_than_or_equal_to: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     time_password_last_changed_less_than: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     time_user_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     time_user_created_less_than: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     user_assessment_id: Optional[pulumi.Input[builtins.str]] = None,
                                     user_category: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     user_key: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     user_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     user_profile: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     user_role: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     user_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserAssessmentUsersResult]:
    """
    This data source provides the list of User Assessment Users in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of users of the specified user assessment. The result contains the database user details for each user, such
    as user type, account status, last login time, user creation time, authentication type, user profile, and the date and time
    of the latest password change. It also contains the user category derived from these user details as well as privileges
    granted to each user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_user_assessment_users = oci.DataSafe.get_user_assessment_users(user_assessment_id=test_user_assessment["id"],
        access_level=user_assessment_user_access_level,
        account_status=user_assessment_user_account_status,
        are_all_schemas_accessible=user_assessment_user_are_all_schemas_accessible,
        authentication_type=user_assessment_user_authentication_type,
        compartment_id_in_subtree=user_assessment_user_compartment_id_in_subtree,
        schema_lists=user_assessment_user_schema_list,
        target_id=test_target["id"],
        time_last_login_greater_than_or_equal_to=user_assessment_user_time_last_login_greater_than_or_equal_to,
        time_last_login_less_than=user_assessment_user_time_last_login_less_than,
        time_password_expiry_greater_than_or_equal_to=user_assessment_user_time_password_expiry_greater_than_or_equal_to,
        time_password_expiry_less_than=user_assessment_user_time_password_expiry_less_than,
        time_password_last_changed_greater_than_or_equal_to=user_assessment_user_time_password_last_changed_greater_than_or_equal_to,
        time_password_last_changed_less_than=user_assessment_user_time_password_last_changed_less_than,
        time_user_created_greater_than_or_equal_to=user_assessment_user_time_user_created_greater_than_or_equal_to,
        time_user_created_less_than=user_assessment_user_time_user_created_less_than,
        user_category=user_assessment_user_user_category,
        user_key=user_assessment_user_user_key,
        user_name=test_user["name"],
        user_profile=user_assessment_user_user_profile,
        user_role=user_assessment_user_user_role,
        user_type=user_assessment_user_user_type)
    ```


    :param builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param builtins.str account_status: A filter to return only items that match the specified account status.
    :param builtins.bool are_all_schemas_accessible: A filter to return only items that match the criteria that all schemas can be accessed by a user.
    :param builtins.str authentication_type: A filter to return only items that match the specified authentication type.
    :param builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param Sequence[builtins.str] schema_lists: A filter to return items that contain the specified schema list.
    :param builtins.str target_id: A filter to return only items related to a specific target OCID.
    :param builtins.str time_last_login_greater_than_or_equal_to: A filter to return users whose last login time in the database is greater than or equal to the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param builtins.str time_last_login_less_than: A filter to return users whose last login time in the database is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). **Example:** 2016-12-19T16:39:57.600Z
    :param builtins.str time_password_expiry_greater_than_or_equal_to: A filter to return users whose password expiry date in the database is greater than or equal to the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). **Example:** 2016-12-19T16:39:57.600Z
    :param builtins.str time_password_expiry_less_than: A filter to return users whose password expiry date in the database is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). **Example:** 2016-12-19T16:39:57.600Z
    :param builtins.str time_password_last_changed_greater_than_or_equal_to: A filter to return users whose last password change in the database is greater than or equal to the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param builtins.str time_password_last_changed_less_than: A filter to return users whose last password change in the database is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param builtins.str time_user_created_greater_than_or_equal_to: A filter to return users whose creation time in the database is greater than or equal to the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). **Example:** 2016-12-19T16:39:57.600Z
    :param builtins.str time_user_created_less_than: A filter to return users whose creation time in the database is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). **Example:** 2016-12-19T16:39:57.600Z
    :param builtins.str user_assessment_id: The OCID of the user assessment.
    :param builtins.str user_category: A filter to return only items that match the specified user category.
    :param builtins.str user_key: A filter to return only items that match the specified user key.
    :param builtins.str user_name: A filter to return only items that match the specified user name.
    :param builtins.str user_profile: A filter to return only items that match the specified user profile.
    :param builtins.str user_role: A filter to return only items that match the specified user role.
    :param builtins.str user_type: A filter to return only items that match the specified user type. The possible values can be
           * ADMIN_PRIVILEGED
           * APPLICATION
           * PRIVILEGED
           * SCHEMA
           * NON_PRIVILEGED as specified by '#/definitions/userTypes'.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['accountStatus'] = account_status
    __args__['areAllSchemasAccessible'] = are_all_schemas_accessible
    __args__['authenticationType'] = authentication_type
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['schemaLists'] = schema_lists
    __args__['targetId'] = target_id
    __args__['timeLastLoginGreaterThanOrEqualTo'] = time_last_login_greater_than_or_equal_to
    __args__['timeLastLoginLessThan'] = time_last_login_less_than
    __args__['timePasswordExpiryGreaterThanOrEqualTo'] = time_password_expiry_greater_than_or_equal_to
    __args__['timePasswordExpiryLessThan'] = time_password_expiry_less_than
    __args__['timePasswordLastChangedGreaterThanOrEqualTo'] = time_password_last_changed_greater_than_or_equal_to
    __args__['timePasswordLastChangedLessThan'] = time_password_last_changed_less_than
    __args__['timeUserCreatedGreaterThanOrEqualTo'] = time_user_created_greater_than_or_equal_to
    __args__['timeUserCreatedLessThan'] = time_user_created_less_than
    __args__['userAssessmentId'] = user_assessment_id
    __args__['userCategory'] = user_category
    __args__['userKey'] = user_key
    __args__['userName'] = user_name
    __args__['userProfile'] = user_profile
    __args__['userRole'] = user_role
    __args__['userType'] = user_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getUserAssessmentUsers:getUserAssessmentUsers', __args__, opts=opts, typ=GetUserAssessmentUsersResult)
    return __ret__.apply(lambda __response__: GetUserAssessmentUsersResult(
        access_level=pulumi.get(__response__, 'access_level'),
        account_status=pulumi.get(__response__, 'account_status'),
        are_all_schemas_accessible=pulumi.get(__response__, 'are_all_schemas_accessible'),
        authentication_type=pulumi.get(__response__, 'authentication_type'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        schema_lists=pulumi.get(__response__, 'schema_lists'),
        target_id=pulumi.get(__response__, 'target_id'),
        time_last_login_greater_than_or_equal_to=pulumi.get(__response__, 'time_last_login_greater_than_or_equal_to'),
        time_last_login_less_than=pulumi.get(__response__, 'time_last_login_less_than'),
        time_password_expiry_greater_than_or_equal_to=pulumi.get(__response__, 'time_password_expiry_greater_than_or_equal_to'),
        time_password_expiry_less_than=pulumi.get(__response__, 'time_password_expiry_less_than'),
        time_password_last_changed_greater_than_or_equal_to=pulumi.get(__response__, 'time_password_last_changed_greater_than_or_equal_to'),
        time_password_last_changed_less_than=pulumi.get(__response__, 'time_password_last_changed_less_than'),
        time_user_created_greater_than_or_equal_to=pulumi.get(__response__, 'time_user_created_greater_than_or_equal_to'),
        time_user_created_less_than=pulumi.get(__response__, 'time_user_created_less_than'),
        user_assessment_id=pulumi.get(__response__, 'user_assessment_id'),
        user_category=pulumi.get(__response__, 'user_category'),
        user_key=pulumi.get(__response__, 'user_key'),
        user_name=pulumi.get(__response__, 'user_name'),
        user_profile=pulumi.get(__response__, 'user_profile'),
        user_role=pulumi.get(__response__, 'user_role'),
        user_type=pulumi.get(__response__, 'user_type'),
        users=pulumi.get(__response__, 'users')))
