# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectRepositorySettingArgs', 'ProjectRepositorySetting']

@pulumi.input_type
class ProjectRepositorySettingArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[builtins.str],
                 approval_rules: Optional[pulumi.Input['ProjectRepositorySettingApprovalRulesArgs']] = None,
                 merge_settings: Optional[pulumi.Input['ProjectRepositorySettingMergeSettingsArgs']] = None):
        """
        The set of arguments for constructing a ProjectRepositorySetting resource.
        :param pulumi.Input[builtins.str] project_id: Unique project identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['ProjectRepositorySettingApprovalRulesArgs'] approval_rules: (Updatable) List of approval rules which must be statisfied before pull requests which match the rules can be merged
        :param pulumi.Input['ProjectRepositorySettingMergeSettingsArgs'] merge_settings: (Updatable) Enabled and disabled merge strategies for a project or repository, also contains a default strategy.
        """
        pulumi.set(__self__, "project_id", project_id)
        if approval_rules is not None:
            pulumi.set(__self__, "approval_rules", approval_rules)
        if merge_settings is not None:
            pulumi.set(__self__, "merge_settings", merge_settings)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.str]:
        """
        Unique project identifier.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="approvalRules")
    def approval_rules(self) -> Optional[pulumi.Input['ProjectRepositorySettingApprovalRulesArgs']]:
        """
        (Updatable) List of approval rules which must be statisfied before pull requests which match the rules can be merged
        """
        return pulumi.get(self, "approval_rules")

    @approval_rules.setter
    def approval_rules(self, value: Optional[pulumi.Input['ProjectRepositorySettingApprovalRulesArgs']]):
        pulumi.set(self, "approval_rules", value)

    @property
    @pulumi.getter(name="mergeSettings")
    def merge_settings(self) -> Optional[pulumi.Input['ProjectRepositorySettingMergeSettingsArgs']]:
        """
        (Updatable) Enabled and disabled merge strategies for a project or repository, also contains a default strategy.
        """
        return pulumi.get(self, "merge_settings")

    @merge_settings.setter
    def merge_settings(self, value: Optional[pulumi.Input['ProjectRepositorySettingMergeSettingsArgs']]):
        pulumi.set(self, "merge_settings", value)


@pulumi.input_type
class _ProjectRepositorySettingState:
    def __init__(__self__, *,
                 approval_rules: Optional[pulumi.Input['ProjectRepositorySettingApprovalRulesArgs']] = None,
                 merge_settings: Optional[pulumi.Input['ProjectRepositorySettingMergeSettingsArgs']] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProjectRepositorySetting resources.
        :param pulumi.Input['ProjectRepositorySettingApprovalRulesArgs'] approval_rules: (Updatable) List of approval rules which must be statisfied before pull requests which match the rules can be merged
        :param pulumi.Input['ProjectRepositorySettingMergeSettingsArgs'] merge_settings: (Updatable) Enabled and disabled merge strategies for a project or repository, also contains a default strategy.
        :param pulumi.Input[builtins.str] project_id: Unique project identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if approval_rules is not None:
            pulumi.set(__self__, "approval_rules", approval_rules)
        if merge_settings is not None:
            pulumi.set(__self__, "merge_settings", merge_settings)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="approvalRules")
    def approval_rules(self) -> Optional[pulumi.Input['ProjectRepositorySettingApprovalRulesArgs']]:
        """
        (Updatable) List of approval rules which must be statisfied before pull requests which match the rules can be merged
        """
        return pulumi.get(self, "approval_rules")

    @approval_rules.setter
    def approval_rules(self, value: Optional[pulumi.Input['ProjectRepositorySettingApprovalRulesArgs']]):
        pulumi.set(self, "approval_rules", value)

    @property
    @pulumi.getter(name="mergeSettings")
    def merge_settings(self) -> Optional[pulumi.Input['ProjectRepositorySettingMergeSettingsArgs']]:
        """
        (Updatable) Enabled and disabled merge strategies for a project or repository, also contains a default strategy.
        """
        return pulumi.get(self, "merge_settings")

    @merge_settings.setter
    def merge_settings(self, value: Optional[pulumi.Input['ProjectRepositorySettingMergeSettingsArgs']]):
        pulumi.set(self, "merge_settings", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique project identifier.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)


class ProjectRepositorySetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_rules: Optional[pulumi.Input[Union['ProjectRepositorySettingApprovalRulesArgs', 'ProjectRepositorySettingApprovalRulesArgsDict']]] = None,
                 merge_settings: Optional[pulumi.Input[Union['ProjectRepositorySettingMergeSettingsArgs', 'ProjectRepositorySettingMergeSettingsArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Project Repository Setting resource in Oracle Cloud Infrastructure Devops service.

        Updates the repository settings for a project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_project_repository_setting = oci.dev_ops.ProjectRepositorySetting("test_project_repository_setting",
            project_id=test_project["id"],
            approval_rules={
                "items": [{
                    "min_approvals_count": project_repository_setting_approval_rules_items_min_approvals_count,
                    "name": project_repository_setting_approval_rules_items_name,
                    "destination_branch": project_repository_setting_approval_rules_items_destination_branch,
                    "reviewers": [{
                        "principal_id": test_principal["id"],
                    }],
                }],
            },
            merge_settings={
                "allowed_merge_strategies": project_repository_setting_merge_settings_allowed_merge_strategies,
                "default_merge_strategy": project_repository_setting_merge_settings_default_merge_strategy,
            })
        ```

        ## Import

        ProjectRepositorySettings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/projectRepositorySetting:ProjectRepositorySetting test_project_repository_setting "projects/{projectId}/repositorySettings"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ProjectRepositorySettingApprovalRulesArgs', 'ProjectRepositorySettingApprovalRulesArgsDict']] approval_rules: (Updatable) List of approval rules which must be statisfied before pull requests which match the rules can be merged
        :param pulumi.Input[Union['ProjectRepositorySettingMergeSettingsArgs', 'ProjectRepositorySettingMergeSettingsArgsDict']] merge_settings: (Updatable) Enabled and disabled merge strategies for a project or repository, also contains a default strategy.
        :param pulumi.Input[builtins.str] project_id: Unique project identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectRepositorySettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Project Repository Setting resource in Oracle Cloud Infrastructure Devops service.

        Updates the repository settings for a project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_project_repository_setting = oci.dev_ops.ProjectRepositorySetting("test_project_repository_setting",
            project_id=test_project["id"],
            approval_rules={
                "items": [{
                    "min_approvals_count": project_repository_setting_approval_rules_items_min_approvals_count,
                    "name": project_repository_setting_approval_rules_items_name,
                    "destination_branch": project_repository_setting_approval_rules_items_destination_branch,
                    "reviewers": [{
                        "principal_id": test_principal["id"],
                    }],
                }],
            },
            merge_settings={
                "allowed_merge_strategies": project_repository_setting_merge_settings_allowed_merge_strategies,
                "default_merge_strategy": project_repository_setting_merge_settings_default_merge_strategy,
            })
        ```

        ## Import

        ProjectRepositorySettings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/projectRepositorySetting:ProjectRepositorySetting test_project_repository_setting "projects/{projectId}/repositorySettings"
        ```

        :param str resource_name: The name of the resource.
        :param ProjectRepositorySettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectRepositorySettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_rules: Optional[pulumi.Input[Union['ProjectRepositorySettingApprovalRulesArgs', 'ProjectRepositorySettingApprovalRulesArgsDict']]] = None,
                 merge_settings: Optional[pulumi.Input[Union['ProjectRepositorySettingMergeSettingsArgs', 'ProjectRepositorySettingMergeSettingsArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectRepositorySettingArgs.__new__(ProjectRepositorySettingArgs)

            __props__.__dict__["approval_rules"] = approval_rules
            __props__.__dict__["merge_settings"] = merge_settings
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
        super(ProjectRepositorySetting, __self__).__init__(
            'oci:DevOps/projectRepositorySetting:ProjectRepositorySetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approval_rules: Optional[pulumi.Input[Union['ProjectRepositorySettingApprovalRulesArgs', 'ProjectRepositorySettingApprovalRulesArgsDict']]] = None,
            merge_settings: Optional[pulumi.Input[Union['ProjectRepositorySettingMergeSettingsArgs', 'ProjectRepositorySettingMergeSettingsArgsDict']]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ProjectRepositorySetting':
        """
        Get an existing ProjectRepositorySetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ProjectRepositorySettingApprovalRulesArgs', 'ProjectRepositorySettingApprovalRulesArgsDict']] approval_rules: (Updatable) List of approval rules which must be statisfied before pull requests which match the rules can be merged
        :param pulumi.Input[Union['ProjectRepositorySettingMergeSettingsArgs', 'ProjectRepositorySettingMergeSettingsArgsDict']] merge_settings: (Updatable) Enabled and disabled merge strategies for a project or repository, also contains a default strategy.
        :param pulumi.Input[builtins.str] project_id: Unique project identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectRepositorySettingState.__new__(_ProjectRepositorySettingState)

        __props__.__dict__["approval_rules"] = approval_rules
        __props__.__dict__["merge_settings"] = merge_settings
        __props__.__dict__["project_id"] = project_id
        return ProjectRepositorySetting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="approvalRules")
    def approval_rules(self) -> pulumi.Output['outputs.ProjectRepositorySettingApprovalRules']:
        """
        (Updatable) List of approval rules which must be statisfied before pull requests which match the rules can be merged
        """
        return pulumi.get(self, "approval_rules")

    @property
    @pulumi.getter(name="mergeSettings")
    def merge_settings(self) -> pulumi.Output['outputs.ProjectRepositorySettingMergeSettings']:
        """
        (Updatable) Enabled and disabled merge strategies for a project or repository, also contains a default strategy.
        """
        return pulumi.get(self, "merge_settings")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique project identifier.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "project_id")

