# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagementAgentInstallKeysResult',
    'AwaitableGetManagementAgentInstallKeysResult',
    'get_management_agent_install_keys',
    'get_management_agent_install_keys_output',
]

@pulumi.output_type
class GetManagementAgentInstallKeysResult:
    """
    A collection of values returned by getManagementAgentInstallKeys.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, filters=None, id=None, management_agent_install_keys=None, state=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if management_agent_install_keys and not isinstance(management_agent_install_keys, list):
            raise TypeError("Expected argument 'management_agent_install_keys' to be a list")
        pulumi.set(__self__, "management_agent_install_keys", management_agent_install_keys)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[builtins.str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Management Agent Install Key Name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagementAgentInstallKeysFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managementAgentInstallKeys")
    def management_agent_install_keys(self) -> Sequence['outputs.GetManagementAgentInstallKeysManagementAgentInstallKeyResult']:
        """
        The list of management_agent_install_keys.
        """
        return pulumi.get(self, "management_agent_install_keys")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        Status of Key
        """
        return pulumi.get(self, "state")


class AwaitableGetManagementAgentInstallKeysResult(GetManagementAgentInstallKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagementAgentInstallKeysResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            management_agent_install_keys=self.management_agent_install_keys,
            state=self.state)


def get_management_agent_install_keys(access_level: Optional[builtins.str] = None,
                                      compartment_id: Optional[builtins.str] = None,
                                      compartment_id_in_subtree: Optional[builtins.bool] = None,
                                      display_name: Optional[builtins.str] = None,
                                      filters: Optional[Sequence[Union['GetManagementAgentInstallKeysFilterArgs', 'GetManagementAgentInstallKeysFilterArgsDict']]] = None,
                                      state: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagementAgentInstallKeysResult:
    """
    This data source provides the list of Management Agent Install Keys in Oracle Cloud Infrastructure Management Agent service.

    Returns a list of Management Agent installed Keys.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agent_install_keys = oci.ManagementAgent.get_management_agent_install_keys(compartment_id=compartment_id,
        access_level=management_agent_install_key_access_level,
        compartment_id_in_subtree=management_agent_install_key_compartment_id_in_subtree,
        display_name=management_agent_install_key_display_name,
        state=management_agent_install_key_state)
    ```


    :param builtins.str access_level: Value of this is always "ACCESSIBLE" and any other value is not supported.
    :param builtins.str compartment_id: The OCID of the compartment to which a request will be scoped.
    :param builtins.bool compartment_id_in_subtree: if set to true then it fetches resources for all compartments where user has access to else only on the compartment specified.
    :param builtins.str display_name: The display name for which the Key needs to be listed.
    :param builtins.str state: Filter to return only Management Agents in the particular lifecycle state.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ManagementAgent/getManagementAgentInstallKeys:getManagementAgentInstallKeys', __args__, opts=opts, typ=GetManagementAgentInstallKeysResult).value

    return AwaitableGetManagementAgentInstallKeysResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        management_agent_install_keys=pulumi.get(__ret__, 'management_agent_install_keys'),
        state=pulumi.get(__ret__, 'state'))
def get_management_agent_install_keys_output(access_level: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                             compartment_id_in_subtree: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                             display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetManagementAgentInstallKeysFilterArgs', 'GetManagementAgentInstallKeysFilterArgsDict']]]]] = None,
                                             state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagementAgentInstallKeysResult]:
    """
    This data source provides the list of Management Agent Install Keys in Oracle Cloud Infrastructure Management Agent service.

    Returns a list of Management Agent installed Keys.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agent_install_keys = oci.ManagementAgent.get_management_agent_install_keys(compartment_id=compartment_id,
        access_level=management_agent_install_key_access_level,
        compartment_id_in_subtree=management_agent_install_key_compartment_id_in_subtree,
        display_name=management_agent_install_key_display_name,
        state=management_agent_install_key_state)
    ```


    :param builtins.str access_level: Value of this is always "ACCESSIBLE" and any other value is not supported.
    :param builtins.str compartment_id: The OCID of the compartment to which a request will be scoped.
    :param builtins.bool compartment_id_in_subtree: if set to true then it fetches resources for all compartments where user has access to else only on the compartment specified.
    :param builtins.str display_name: The display name for which the Key needs to be listed.
    :param builtins.str state: Filter to return only Management Agents in the particular lifecycle state.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ManagementAgent/getManagementAgentInstallKeys:getManagementAgentInstallKeys', __args__, opts=opts, typ=GetManagementAgentInstallKeysResult)
    return __ret__.apply(lambda __response__: GetManagementAgentInstallKeysResult(
        access_level=pulumi.get(__response__, 'access_level'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        management_agent_install_keys=pulumi.get(__response__, 'management_agent_install_keys'),
        state=pulumi.get(__response__, 'state')))
