# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetClustersResult',
    'AwaitableGetClustersResult',
    'get_clusters',
    'get_clusters_output',
]

@pulumi.output_type
class GetClustersResult:
    """
    A collection of values returned by getClusters.
    """
    def __init__(__self__, cluster_collections=None, compartment_id=None, display_name=None, filters=None, id=None, sddc_id=None, state=None):
        if cluster_collections and not isinstance(cluster_collections, list):
            raise TypeError("Expected argument 'cluster_collections' to be a list")
        pulumi.set(__self__, "cluster_collections", cluster_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if sddc_id and not isinstance(sddc_id, str):
            raise TypeError("Expected argument 'sddc_id' to be a str")
        pulumi.set(__self__, "sddc_id", sddc_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="clusterCollections")
    def cluster_collections(self) -> Sequence['outputs.GetClustersClusterCollectionResult']:
        """
        The list of cluster_collection.
        """
        return pulumi.get(self, "cluster_collections")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Cluster.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A descriptive name for the Cluster. It must be unique, start with a letter, and contain only letters, digits, whitespaces, dashes and underscores. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetClustersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="sddcId")
    def sddc_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC that the Cluster belongs to.
        """
        return pulumi.get(self, "sddc_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Cluster.
        """
        return pulumi.get(self, "state")


class AwaitableGetClustersResult(GetClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClustersResult(
            cluster_collections=self.cluster_collections,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            sddc_id=self.sddc_id,
            state=self.state)


def get_clusters(compartment_id: Optional[builtins.str] = None,
                 display_name: Optional[builtins.str] = None,
                 filters: Optional[Sequence[Union['GetClustersFilterArgs', 'GetClustersFilterArgsDict']]] = None,
                 sddc_id: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClustersResult:
    """
    This data source provides the list of Clusters in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    Lists the Clusters in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_clusters = oci.Ocvp.get_clusters(compartment_id=compartment_id,
        display_name=cluster_display_name,
        sddc_id=test_sddc["id"],
        state=cluster_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment as optional parameter.
    :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param builtins.str sddc_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC.
    :param builtins.str state: The lifecycle state of the resource.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['sddcId'] = sddc_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Ocvp/getClusters:getClusters', __args__, opts=opts, typ=GetClustersResult).value

    return AwaitableGetClustersResult(
        cluster_collections=pulumi.get(__ret__, 'cluster_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        sddc_id=pulumi.get(__ret__, 'sddc_id'),
        state=pulumi.get(__ret__, 'state'))
def get_clusters_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetClustersFilterArgs', 'GetClustersFilterArgsDict']]]]] = None,
                        sddc_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClustersResult]:
    """
    This data source provides the list of Clusters in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    Lists the Clusters in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_clusters = oci.Ocvp.get_clusters(compartment_id=compartment_id,
        display_name=cluster_display_name,
        sddc_id=test_sddc["id"],
        state=cluster_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment as optional parameter.
    :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param builtins.str sddc_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC.
    :param builtins.str state: The lifecycle state of the resource.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['sddcId'] = sddc_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Ocvp/getClusters:getClusters', __args__, opts=opts, typ=GetClustersResult)
    return __ret__.apply(lambda __response__: GetClustersResult(
        cluster_collections=pulumi.get(__response__, 'cluster_collections'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        sddc_id=pulumi.get(__response__, 'sddc_id'),
        state=pulumi.get(__response__, 'state')))
