# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNewsReportsResult',
    'AwaitableGetNewsReportsResult',
    'get_news_reports',
    'get_news_reports_output',
]

@pulumi.output_type
class GetNewsReportsResult:
    """
    A collection of values returned by getNewsReports.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, filters=None, id=None, news_report_collections=None, news_report_id=None, states=None, statuses=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if news_report_collections and not isinstance(news_report_collections, list):
            raise TypeError("Expected argument 'news_report_collections' to be a list")
        pulumi.set(__self__, "news_report_collections", news_report_collections)
        if news_report_id and not isinstance(news_report_id, str):
            raise TypeError("Expected argument 'news_report_id' to be a str")
        pulumi.set(__self__, "news_report_id", news_report_id)
        if states and not isinstance(states, list):
            raise TypeError("Expected argument 'states' to be a list")
        pulumi.set(__self__, "states", states)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNewsReportsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="newsReportCollections")
    def news_report_collections(self) -> Sequence['outputs.GetNewsReportsNewsReportCollectionResult']:
        """
        The list of news_report_collection.
        """
        return pulumi.get(self, "news_report_collections")

    @property
    @pulumi.getter(name="newsReportId")
    def news_report_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "news_report_id")

    @property
    @pulumi.getter
    def states(self) -> Optional[Sequence[builtins.str]]:
        """
        The current state of the news report.
        """
        return pulumi.get(self, "states")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence[builtins.str]]:
        """
        Indicates the status of a news report in Ops Insights.
        """
        return pulumi.get(self, "statuses")


class AwaitableGetNewsReportsResult(GetNewsReportsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNewsReportsResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            news_report_collections=self.news_report_collections,
            news_report_id=self.news_report_id,
            states=self.states,
            statuses=self.statuses)


def get_news_reports(compartment_id: Optional[builtins.str] = None,
                     compartment_id_in_subtree: Optional[builtins.bool] = None,
                     filters: Optional[Sequence[Union['GetNewsReportsFilterArgs', 'GetNewsReportsFilterArgsDict']]] = None,
                     news_report_id: Optional[builtins.str] = None,
                     states: Optional[Sequence[builtins.str]] = None,
                     statuses: Optional[Sequence[builtins.str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNewsReportsResult:
    """
    This data source provides the list of News Reports in Oracle Cloud Infrastructure Opsi service.

    Gets a list of news reports based on the query parameters specified. Either compartmentId or id query parameter must be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_news_reports = oci.Opsi.get_news_reports(compartment_id=compartment_id,
        compartment_id_in_subtree=news_report_compartment_id_in_subtree,
        news_report_id=test_news_report["id"],
        states=news_report_state,
        statuses=news_report_status)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.bool compartment_id_in_subtree: A flag to search all resources within a given compartment and all sub-compartments.
    :param builtins.str news_report_id: Unique Ops Insights news report identifier
    :param Sequence[builtins.str] states: Lifecycle states
    :param Sequence[builtins.str] statuses: Resource Status
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['newsReportId'] = news_report_id
    __args__['states'] = states
    __args__['statuses'] = statuses
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getNewsReports:getNewsReports', __args__, opts=opts, typ=GetNewsReportsResult).value

    return AwaitableGetNewsReportsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        news_report_collections=pulumi.get(__ret__, 'news_report_collections'),
        news_report_id=pulumi.get(__ret__, 'news_report_id'),
        states=pulumi.get(__ret__, 'states'),
        statuses=pulumi.get(__ret__, 'statuses'))
def get_news_reports_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            compartment_id_in_subtree: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetNewsReportsFilterArgs', 'GetNewsReportsFilterArgsDict']]]]] = None,
                            news_report_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            states: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                            statuses: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNewsReportsResult]:
    """
    This data source provides the list of News Reports in Oracle Cloud Infrastructure Opsi service.

    Gets a list of news reports based on the query parameters specified. Either compartmentId or id query parameter must be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_news_reports = oci.Opsi.get_news_reports(compartment_id=compartment_id,
        compartment_id_in_subtree=news_report_compartment_id_in_subtree,
        news_report_id=test_news_report["id"],
        states=news_report_state,
        statuses=news_report_status)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.bool compartment_id_in_subtree: A flag to search all resources within a given compartment and all sub-compartments.
    :param builtins.str news_report_id: Unique Ops Insights news report identifier
    :param Sequence[builtins.str] states: Lifecycle states
    :param Sequence[builtins.str] statuses: Resource Status
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['newsReportId'] = news_report_id
    __args__['states'] = states
    __args__['statuses'] = statuses
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Opsi/getNewsReports:getNewsReports', __args__, opts=opts, typ=GetNewsReportsResult)
    return __ret__.apply(lambda __response__: GetNewsReportsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        news_report_collections=pulumi.get(__response__, 'news_report_collections'),
        news_report_id=pulumi.get(__response__, 'news_report_id'),
        states=pulumi.get(__response__, 'states'),
        statuses=pulumi.get(__response__, 'statuses')))
