# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ScheduleResource',
    'ScheduleResourceFilter',
    'ScheduleResourceFilterValue',
    'GetScheduleResourceResult',
    'GetScheduleResourceFilterResult',
    'GetScheduleResourceFilterValueResult',
    'GetSchedulesFilterResult',
    'GetSchedulesScheduleCollectionResult',
    'GetSchedulesScheduleCollectionItemResult',
    'GetSchedulesScheduleCollectionItemResourceResult',
    'GetSchedulesScheduleCollectionItemResourceFilterResult',
    'GetSchedulesScheduleCollectionItemResourceFilterValueResult',
]

@pulumi.output_type
class ScheduleResource(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 metadata: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str id: (Updatable) This is the resource OCID.
        :param Mapping[str, builtins.str] metadata: (Updatable) This is additional information that helps to identity the resource for the schedule.
               
               { "id": "<OCID_of_bucket>" "metadata": { "namespaceName": "sampleNamespace", "bucketName": "sampleBucket" } }
        """
        pulumi.set(__self__, "id", id)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        (Updatable) This is the resource OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, builtins.str]]:
        """
        (Updatable) This is additional information that helps to identity the resource for the schedule.

        { "id": "<OCID_of_bucket>" "metadata": { "namespaceName": "sampleNamespace", "bucketName": "sampleBucket" } }
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class ScheduleResourceFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shouldIncludeChildCompartments":
            suggest = "should_include_child_compartments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleResourceFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleResourceFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleResourceFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute: builtins.str,
                 condition: Optional[builtins.str] = None,
                 should_include_child_compartments: Optional[builtins.bool] = None,
                 values: Optional[Sequence['outputs.ScheduleResourceFilterValue']] = None):
        """
        :param builtins.str attribute: (Updatable) This is the resource attribute on which the threshold is defined. We support 5 different types of attributes: `DEFINED_TAGS`, `COMPARTMENT_ID`, `TIME_CREATED`, `LIFECYCLE_STATE` and `RESOURCE_TYPE`.
        :param builtins.str condition: This is the condition for the filter in comparison to its creation time.
        :param builtins.bool should_include_child_compartments: This sets whether to include child compartments.
        :param Sequence['ScheduleResourceFilterValueArgs'] values: (Updatable) This is a collection of resource filter values, different types of filter has different value format, see below:
               * When `attribute="DEFINED_TAGS"`:
        """
        pulumi.set(__self__, "attribute", attribute)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if should_include_child_compartments is not None:
            pulumi.set(__self__, "should_include_child_compartments", should_include_child_compartments)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def attribute(self) -> builtins.str:
        """
        (Updatable) This is the resource attribute on which the threshold is defined. We support 5 different types of attributes: `DEFINED_TAGS`, `COMPARTMENT_ID`, `TIME_CREATED`, `LIFECYCLE_STATE` and `RESOURCE_TYPE`.
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def condition(self) -> Optional[builtins.str]:
        """
        This is the condition for the filter in comparison to its creation time.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="shouldIncludeChildCompartments")
    def should_include_child_compartments(self) -> Optional[builtins.bool]:
        """
        This sets whether to include child compartments.
        """
        return pulumi.get(self, "should_include_child_compartments")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence['outputs.ScheduleResourceFilterValue']]:
        """
        (Updatable) This is a collection of resource filter values, different types of filter has different value format, see below:
        * When `attribute="DEFINED_TAGS"`:
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ScheduleResourceFilterValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagKey":
            suggest = "tag_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleResourceFilterValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleResourceFilterValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleResourceFilterValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace: Optional[builtins.str] = None,
                 tag_key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str namespace: This is the namespace of the defined tag.
        :param builtins.str tag_key: This is the key of the defined tag.
        :param builtins.str value: This is the lifecycle state value used for filtering.
        """
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if tag_key is not None:
            pulumi.set(__self__, "tag_key", tag_key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        This is the namespace of the defined tag.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> Optional[builtins.str]:
        """
        This is the key of the defined tag.
        """
        return pulumi.get(self, "tag_key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        This is the lifecycle state value used for filtering.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetScheduleResourceResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 metadata: Mapping[str, builtins.str]):
        """
        :param builtins.str id: This is the resource OCID.
        :param Mapping[str, builtins.str] metadata: This is additional information that helps to identity the resource for the schedule.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        This is the resource OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, builtins.str]:
        """
        This is additional information that helps to identity the resource for the schedule.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class GetScheduleResourceFilterResult(dict):
    def __init__(__self__, *,
                 attribute: builtins.str,
                 condition: builtins.str,
                 should_include_child_compartments: builtins.bool,
                 values: Sequence['outputs.GetScheduleResourceFilterValueResult']):
        """
        :param builtins.str attribute: This is the resource attribute on which the threshold is defined.
        :param builtins.str condition: This is the condition for the filter in comparison to its creation time.
        :param builtins.bool should_include_child_compartments: This sets whether to include child compartments.
        :param Sequence['GetScheduleResourceFilterValueArgs'] values: This is the value of the defined tag.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "should_include_child_compartments", should_include_child_compartments)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def attribute(self) -> builtins.str:
        """
        This is the resource attribute on which the threshold is defined.
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def condition(self) -> builtins.str:
        """
        This is the condition for the filter in comparison to its creation time.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="shouldIncludeChildCompartments")
    def should_include_child_compartments(self) -> builtins.bool:
        """
        This sets whether to include child compartments.
        """
        return pulumi.get(self, "should_include_child_compartments")

    @property
    @pulumi.getter
    def values(self) -> Sequence['outputs.GetScheduleResourceFilterValueResult']:
        """
        This is the value of the defined tag.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetScheduleResourceFilterValueResult(dict):
    def __init__(__self__, *,
                 namespace: builtins.str,
                 tag_key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str namespace: This is the namespace of the defined tag.
        :param builtins.str tag_key: This is the key of the defined tag.
        :param builtins.str value: This is the value of the defined tag.
        """
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "tag_key", tag_key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        This is the namespace of the defined tag.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> builtins.str:
        """
        This is the key of the defined tag.
        """
        return pulumi.get(self, "tag_key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        This is the value of the defined tag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetSchedulesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSchedulesScheduleCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSchedulesScheduleCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSchedulesScheduleCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSchedulesScheduleCollectionItemResult(dict):
    def __init__(__self__, *,
                 action: builtins.str,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 recurrence_details: builtins.str,
                 recurrence_type: builtins.str,
                 resource_filters: Sequence['outputs.GetSchedulesScheduleCollectionItemResourceFilterResult'],
                 resources: Sequence['outputs.GetSchedulesScheduleCollectionItemResourceResult'],
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_ends: builtins.str,
                 time_last_run: builtins.str,
                 time_next_run: builtins.str,
                 time_starts: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str action: This is the action that will be executed by the schedule.
        :param builtins.str compartment_id: This is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources. You need to at least provide either `compartment_id` or `schedule_id` or both.
        :param Mapping[str, builtins.str] defined_tags: These are defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str description: This is the description of the schedule.
        :param builtins.str display_name: This is a filter to return only resources that match the given display name exactly.
        :param Mapping[str, builtins.str] freeform_tags: These are free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param builtins.str id: This is the resource OCID.
        :param builtins.str recurrence_details: This is the frequency of recurrence of a schedule. The frequency field can either conform to RFC-5545 formatting or UNIX cron formatting for recurrences, based on the value specified by the recurrenceType field.
        :param builtins.str recurrence_type: Type of recurrence of a schedule
        :param Sequence['GetSchedulesScheduleCollectionItemResourceFilterArgs'] resource_filters: This is a list of resources filters.  The schedule will be applied to resources matching all of them.
        :param Sequence['GetSchedulesScheduleCollectionItemResourceArgs'] resources: This is the list of resources to which the scheduled operation is applied.
        :param builtins.str state: This is a filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
        :param Mapping[str, builtins.str] system_tags: These are system tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: This is the date and time the schedule was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_ends: This is the date and time the schedule ends, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339)  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_last_run: This is the date and time the schedule runs last time, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_next_run: This is the date and time the schedule run the next time, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_starts: This is the date and time the schedule starts, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339)  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_updated: This is the date and time the schedule was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "recurrence_details", recurrence_details)
        pulumi.set(__self__, "recurrence_type", recurrence_type)
        pulumi.set(__self__, "resource_filters", resource_filters)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_ends", time_ends)
        pulumi.set(__self__, "time_last_run", time_last_run)
        pulumi.set(__self__, "time_next_run", time_next_run)
        pulumi.set(__self__, "time_starts", time_starts)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        This is the action that will be executed by the schedule.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        This is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources. You need to at least provide either `compartment_id` or `schedule_id` or both.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        These are defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        This is the description of the schedule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        This is a filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        These are free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        This is the resource OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="recurrenceDetails")
    def recurrence_details(self) -> builtins.str:
        """
        This is the frequency of recurrence of a schedule. The frequency field can either conform to RFC-5545 formatting or UNIX cron formatting for recurrences, based on the value specified by the recurrenceType field.
        """
        return pulumi.get(self, "recurrence_details")

    @property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> builtins.str:
        """
        Type of recurrence of a schedule
        """
        return pulumi.get(self, "recurrence_type")

    @property
    @pulumi.getter(name="resourceFilters")
    def resource_filters(self) -> Sequence['outputs.GetSchedulesScheduleCollectionItemResourceFilterResult']:
        """
        This is a list of resources filters.  The schedule will be applied to resources matching all of them.
        """
        return pulumi.get(self, "resource_filters")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetSchedulesScheduleCollectionItemResourceResult']:
        """
        This is the list of resources to which the scheduled operation is applied.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        This is a filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        These are system tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        This is the date and time the schedule was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeEnds")
    def time_ends(self) -> builtins.str:
        """
        This is the date and time the schedule ends, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339)  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_ends")

    @property
    @pulumi.getter(name="timeLastRun")
    def time_last_run(self) -> builtins.str:
        """
        This is the date and time the schedule runs last time, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_last_run")

    @property
    @pulumi.getter(name="timeNextRun")
    def time_next_run(self) -> builtins.str:
        """
        This is the date and time the schedule run the next time, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_next_run")

    @property
    @pulumi.getter(name="timeStarts")
    def time_starts(self) -> builtins.str:
        """
        This is the date and time the schedule starts, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339)  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_starts")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        This is the date and time the schedule was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetSchedulesScheduleCollectionItemResourceResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 metadata: Mapping[str, builtins.str]):
        """
        :param builtins.str id: This is the resource OCID.
        :param Mapping[str, builtins.str] metadata: This is additional information that helps to identity the resource for the schedule.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        This is the resource OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, builtins.str]:
        """
        This is additional information that helps to identity the resource for the schedule.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class GetSchedulesScheduleCollectionItemResourceFilterResult(dict):
    def __init__(__self__, *,
                 attribute: builtins.str,
                 condition: builtins.str,
                 should_include_child_compartments: builtins.bool,
                 values: Sequence['outputs.GetSchedulesScheduleCollectionItemResourceFilterValueResult']):
        """
        :param builtins.str attribute: This is the resource attribute on which the threshold is defined.
        :param builtins.str condition: This is the condition for the filter in comparison to its creation time.
        :param builtins.bool should_include_child_compartments: This sets whether to include child compartments.
        :param Sequence['GetSchedulesScheduleCollectionItemResourceFilterValueArgs'] values: This is the value of the defined tag.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "should_include_child_compartments", should_include_child_compartments)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def attribute(self) -> builtins.str:
        """
        This is the resource attribute on which the threshold is defined.
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def condition(self) -> builtins.str:
        """
        This is the condition for the filter in comparison to its creation time.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="shouldIncludeChildCompartments")
    def should_include_child_compartments(self) -> builtins.bool:
        """
        This sets whether to include child compartments.
        """
        return pulumi.get(self, "should_include_child_compartments")

    @property
    @pulumi.getter
    def values(self) -> Sequence['outputs.GetSchedulesScheduleCollectionItemResourceFilterValueResult']:
        """
        This is the value of the defined tag.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetSchedulesScheduleCollectionItemResourceFilterValueResult(dict):
    def __init__(__self__, *,
                 namespace: builtins.str,
                 tag_key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str namespace: This is the namespace of the defined tag.
        :param builtins.str tag_key: This is the key of the defined tag.
        :param builtins.str value: This is the value of the defined tag.
        """
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "tag_key", tag_key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        This is the namespace of the defined tag.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> builtins.str:
        """
        This is the key of the defined tag.
        """
        return pulumi.get(self, "tag_key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        This is the value of the defined tag.
        """
        return pulumi.get(self, "value")


