# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOrganizationsResult',
    'AwaitableGetOrganizationsResult',
    'get_organizations',
    'get_organizations_output',
]

@pulumi.output_type
class GetOrganizationsResult:
    """
    A collection of values returned by getOrganizations.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, organization_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if organization_collections and not isinstance(organization_collections, list):
            raise TypeError("Expected argument 'organization_collections' to be a list")
        pulumi.set(__self__, "organization_collections", organization_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        OCID of the compartment containing the organization. Always a tenancy OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOrganizationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="organizationCollections")
    def organization_collections(self) -> Sequence['outputs.GetOrganizationsOrganizationCollectionResult']:
        """
        The list of organization_collection.
        """
        return pulumi.get(self, "organization_collections")


class AwaitableGetOrganizationsResult(GetOrganizationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            organization_collections=self.organization_collections)


def get_organizations(compartment_id: Optional[builtins.str] = None,
                      filters: Optional[Sequence[Union['GetOrganizationsFilterArgs', 'GetOrganizationsFilterArgsDict']]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationsResult:
    """
    This data source provides the list of Organizations in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Lists organizations associated with the caller.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_organizations = oci.Tenantmanagercontrolplane.get_organizations(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Tenantmanagercontrolplane/getOrganizations:getOrganizations', __args__, opts=opts, typ=GetOrganizationsResult).value

    return AwaitableGetOrganizationsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        organization_collections=pulumi.get(__ret__, 'organization_collections'))
def get_organizations_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetOrganizationsFilterArgs', 'GetOrganizationsFilterArgsDict']]]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrganizationsResult]:
    """
    This data source provides the list of Organizations in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Lists organizations associated with the caller.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_organizations = oci.Tenantmanagercontrolplane.get_organizations(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Tenantmanagercontrolplane/getOrganizations:getOrganizations', __args__, opts=opts, typ=GetOrganizationsResult)
    return __ret__.apply(lambda __response__: GetOrganizationsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        organization_collections=pulumi.get(__response__, 'organization_collections')))
