import pandas as pd, requests, os

class API_Call:
    def __init__(self, base_url, header):
        self.base_url = base_url
        self.header = header

    def getrecords(self, endpoint, no_of_records=100, limit=30, offset=0):
        """Fetch the no_of_records from the API. Returns the fetched data in list

        Args:
            base_url (str): Base url of the API
            endpoint (str): Specific Endpoint of the API
            headers (dict, optional): headers of the API. Defaults to None.
            no_of_records (int, optional): number of records to fetch. Defaults to 100.

        Returns:
            final_data (list): Appends the data to list and returns it
        """

        final_data = []
        offset = 0
        while no_of_records > 0:
            if no_of_records < limit:
                response = requests.get(self.base_url+endpoint+f'?offset={offset}&limit={no_of_records}', headers=headers)
                response_data = response.json()
                final_data.extend(response_data['data'])
                return final_data
            
            response = requests.get(self.base_url+endpoint+f'?offset={offset}&limit={limit}', headers=headers)
            response_data = response.json()
            next_endpoint = response_data['next'] # /mentorskool/v1/sales?offset=101&limit=100
            params = next_endpoint.split("?")[1]  # offset=101&limit=100
            offset = params.split('&')[0].split('=')[1] # 101
            final_data.extend(response_data['data']) # len(final_data) = 100
            no_of_records = no_of_records - limit # 500 - 100 = 400

        return final_data

    def jsonToDataframe(self, json_inp):
        '''
        Returns the sum of two decimal numbers in binary digits.

                Parameters:
                        json_inp (python dict): response of the API in form of json

                Returns:
                        df (Pandas dataframe): This is the dataframe that got generated by parsing the json
                        response from the API
        '''
        df = pd.json_normalize(json_inp)
        cleaned_column_names = [x if(len(x.split('.')) == 1) else x.split('.')[-1] for x in df.columns]
        df.columns = cleaned_column_names
        return df
    

class Order:
    def __init__(self, df) -> None:
        self.df = df

    def calculate_total(self, order_id):
        return self.df[self.df["order_id"] == order_id]["sales_amt"].sum().round(2)
    

class Order_discount(Order):
    def __init__(self, df) -> None:
        super().__init__(df)

    def calculate_total(self, order_id):
        self.df = self.df.assign(
            sales_amt_updated = lambda x: x["sales_amt"]*(1-x["discount"])
        )
        filtered_df = self.df[self.df["order_id"] == order_id]
        return filtered_df["sales_amt_updated"].sum().round(2)

    
base_url = "https://zucwflxqsxrsmwseehqvjmnx2u0cdigp.lambda-url.ap-south-1.on.aws"
endpoint = "/mentorskool/v1/sales"
headers = {"access_token": "fe66583bfe5185048c66571293e0d358"}

# Initialize the object for globalmart API
api_obj = API_Call(base_url=base_url, header=headers)

# Call the API
data = api_obj.getrecords(endpoint=endpoint, no_of_records=500, limit=100)

# Now create the dataframe
sales_df = api_obj.jsonToDataframe(data)
    

# let's instantiate the Order object
order = Order(sales_df)

# Calculate the total amount of order
order.calculate_total('US-2014-106992')

# let's instantiate the Order_discoun object
order_discount = Order_discount(sales_df)

order_discount.calculate_total('CA-2017-100111')

